/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.codegen;

import io.confluent.ksql.codegen.SqlToJavaVisitor;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.KsqlFunction;
import io.confluent.ksql.function.udf.Kudf;
import io.confluent.ksql.parser.tree.ArithmeticBinaryExpression;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Cast;
import io.confluent.ksql.parser.tree.ComparisonExpression;
import io.confluent.ksql.parser.tree.DereferenceExpression;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.FunctionCall;
import io.confluent.ksql.parser.tree.IsNotNullPredicate;
import io.confluent.ksql.parser.tree.IsNullPredicate;
import io.confluent.ksql.parser.tree.LikePredicate;
import io.confluent.ksql.parser.tree.LogicalBinaryExpression;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.NotExpression;
import io.confluent.ksql.parser.tree.QualifiedNameReference;
import io.confluent.ksql.parser.tree.SubscriptExpression;
import io.confluent.ksql.util.ExpressionMetadata;
import io.confluent.ksql.util.ExpressionTypeManager;
import io.confluent.ksql.util.SchemaUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IExpressionEvaluator;

public class CodeGenRunner {
    private final Schema schema;
    private final FunctionRegistry functionRegistry;

    public CodeGenRunner(Schema schema, FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
        this.schema = schema;
    }

    public Map<String, Class> getParameterInfo(Expression expression) {
        Visitor visitor = new Visitor(this.schema, this.functionRegistry);
        visitor.process((Node)expression, null);
        return visitor.parameterMap;
    }

    public ExpressionMetadata buildCodeGenFromParseTree(Expression expression) throws Exception {
        Map<String, Class> parameterMap = this.getParameterInfo(expression);
        String[] parameterNames = new String[parameterMap.size()];
        Class[] parameterTypes = new Class[parameterMap.size()];
        int[] columnIndexes = new int[parameterMap.size()];
        Kudf[] kudfObjects = new Kudf[parameterMap.size()];
        int index = 0;
        for (Map.Entry<String, Class> entry : parameterMap.entrySet()) {
            parameterNames[index] = entry.getKey();
            parameterTypes[index] = entry.getValue();
            columnIndexes[index] = SchemaUtil.getFieldIndexByName((Schema)this.schema, (String)entry.getKey());
            kudfObjects[index] = columnIndexes[index] < 0 ? (Kudf)entry.getValue().newInstance() : null;
            ++index;
        }
        String javaCode = new SqlToJavaVisitor(this.schema, this.functionRegistry).process(expression);
        IExpressionEvaluator ee = CompilerFactoryFactory.getDefaultCompilerFactory().newExpressionEvaluator();
        ee.setParameters(parameterNames, parameterTypes);
        ExpressionTypeManager expressionTypeManager = new ExpressionTypeManager(this.schema, this.functionRegistry);
        Schema expressionType = expressionTypeManager.getExpressionType(expression);
        ee.setExpressionType(SchemaUtil.getJavaType((Schema)expressionType));
        ee.cook(javaCode);
        return new ExpressionMetadata(ee, columnIndexes, kudfObjects, expressionType);
    }

    private static class Visitor
    extends AstVisitor<Object, Object> {
        final Schema schema;
        final Map<String, Class> parameterMap;
        final FunctionRegistry functionRegistry;

        Visitor(Schema schema, FunctionRegistry functionRegistry) {
            this.schema = schema;
            this.parameterMap = new HashMap<String, Class>();
            this.functionRegistry = functionRegistry;
        }

        protected Object visitLikePredicate(LikePredicate node, Object context) {
            this.process((Node)node.getValue(), null);
            return null;
        }

        protected Object visitFunctionCall(FunctionCall node, Object context) {
            String functionName = node.getName().getSuffix();
            KsqlFunction ksqlFunction = this.functionRegistry.getFunction(functionName);
            this.parameterMap.put(node.getName().getSuffix(), ksqlFunction.getKudfClass());
            for (Expression argExpr : node.getArguments()) {
                this.process((Node)argExpr, null);
            }
            return null;
        }

        protected Object visitArithmeticBinary(ArithmeticBinaryExpression node, Object context) {
            this.process((Node)node.getLeft(), null);
            this.process((Node)node.getRight(), null);
            return null;
        }

        protected Object visitIsNotNullPredicate(IsNotNullPredicate node, Object context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Object visitIsNullPredicate(IsNullPredicate node, Object context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Object visitLogicalBinaryExpression(LogicalBinaryExpression node, Object context) {
            this.process((Node)node.getLeft(), null);
            this.process((Node)node.getRight(), null);
            return null;
        }

        protected Object visitComparisonExpression(ComparisonExpression node, Object context) {
            this.process((Node)node.getLeft(), null);
            this.process((Node)node.getRight(), null);
            return null;
        }

        protected Object visitNotExpression(NotExpression node, Object context) {
            return this.process((Node)node.getValue(), null);
        }

        protected Object visitDereferenceExpression(DereferenceExpression node, Object context) {
            Optional schemaField = SchemaUtil.getFieldByName((Schema)this.schema, (String)node.toString());
            if (!schemaField.isPresent()) {
                throw new RuntimeException("Cannot find the select field in the available fields: " + node.toString());
            }
            this.parameterMap.put(((Field)schemaField.get()).name().replace(".", "_"), SchemaUtil.getJavaType((Schema)((Field)schemaField.get()).schema()));
            return null;
        }

        protected Object visitCast(Cast node, Object context) {
            this.process((Node)node.getExpression(), context);
            return null;
        }

        protected Object visitSubscriptExpression(SubscriptExpression node, Object context) {
            String arrayBaseName = node.getBase().toString();
            Optional schemaField = SchemaUtil.getFieldByName((Schema)this.schema, (String)arrayBaseName);
            if (!schemaField.isPresent()) {
                throw new RuntimeException("Cannot find the select field in the available fields: " + arrayBaseName);
            }
            this.parameterMap.put(((Field)schemaField.get()).name().replace(".", "_"), SchemaUtil.getJavaType((Schema)((Field)schemaField.get()).schema()));
            this.process((Node)node.getIndex(), context);
            return null;
        }

        protected Object visitQualifiedNameReference(QualifiedNameReference node, Object context) {
            Optional schemaField = SchemaUtil.getFieldByName((Schema)this.schema, (String)node.getName().getSuffix());
            if (!schemaField.isPresent()) {
                throw new RuntimeException("Cannot find the select field in the available fields: " + node.getName().getSuffix());
            }
            this.parameterMap.put(((Field)schemaField.get()).name().replace(".", "_"), SchemaUtil.getJavaType((Schema)((Field)schemaField.get()).schema()));
            return null;
        }
    }
}

