/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import io.confluent.ksql.parser.tree.ArithmeticBinaryExpression;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Cast;
import io.confluent.ksql.parser.tree.ComparisonExpression;
import io.confluent.ksql.parser.tree.DereferenceExpression;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.FunctionCall;
import io.confluent.ksql.parser.tree.IsNotNullPredicate;
import io.confluent.ksql.parser.tree.IsNullPredicate;
import io.confluent.ksql.parser.tree.LikePredicate;
import io.confluent.ksql.parser.tree.LogicalBinaryExpression;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.NotExpression;
import io.confluent.ksql.parser.tree.QualifiedNameReference;
import io.confluent.ksql.util.SchemaUtil;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;

public class ExpressionAnalyzer {
    private final Schema schema;
    private final boolean isJoinSchema;

    ExpressionAnalyzer(Schema schema, boolean isJoinSchema) {
        this.schema = schema;
        this.isJoinSchema = isJoinSchema;
    }

    void analyzeExpression(Expression expression) {
        Visitor visitor = new Visitor(this.schema);
        visitor.process((Node)expression, null);
    }

    private class Visitor
    extends AstVisitor<Object, Object> {
        final Schema schema;

        Visitor(Schema schema) {
            this.schema = schema;
        }

        protected Object visitLikePredicate(LikePredicate node, Object context) {
            this.process((Node)node.getValue(), null);
            return null;
        }

        protected Object visitFunctionCall(FunctionCall node, Object context) {
            for (Expression argExpr : node.getArguments()) {
                this.process((Node)argExpr, null);
            }
            return null;
        }

        protected Object visitArithmeticBinary(ArithmeticBinaryExpression node, Object context) {
            this.process((Node)node.getLeft(), null);
            this.process((Node)node.getRight(), null);
            return null;
        }

        protected Object visitIsNotNullPredicate(IsNotNullPredicate node, Object context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Object visitIsNullPredicate(IsNullPredicate node, Object context) {
            return this.process((Node)node.getValue(), context);
        }

        protected Object visitLogicalBinaryExpression(LogicalBinaryExpression node, Object context) {
            this.process((Node)node.getLeft(), null);
            this.process((Node)node.getRight(), null);
            return null;
        }

        protected Object visitComparisonExpression(ComparisonExpression node, Object context) {
            this.process((Node)node.getLeft(), null);
            this.process((Node)node.getRight(), null);
            return null;
        }

        protected Object visitNotExpression(NotExpression node, Object context) {
            return this.process((Node)node.getValue(), null);
        }

        protected Object visitDereferenceExpression(DereferenceExpression node, Object context) {
            Optional schemaField;
            String columnName = node.getFieldName();
            if (ExpressionAnalyzer.this.isJoinSchema) {
                columnName = node.toString();
            }
            if (!(schemaField = SchemaUtil.getFieldByName((Schema)this.schema, (String)columnName)).isPresent()) {
                throw new RuntimeException(String.format("Column %s cannot be resolved.", columnName));
            }
            return null;
        }

        protected Object visitCast(Cast node, Object context) {
            this.process((Node)node.getExpression(), context);
            return null;
        }

        protected Object visitQualifiedNameReference(QualifiedNameReference node, Object context) {
            String columnName = node.getName().getSuffix();
            Optional schemaField = SchemaUtil.getFieldByName((Schema)this.schema, (String)columnName);
            if (!schemaField.isPresent()) {
                throw new RuntimeException(String.format("Column %s cannot be resolved.", columnName));
            }
            return null;
        }
    }
}

