/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.analyzer.AnalysisContext;
import io.confluent.ksql.analyzer.ExpressionAnalyzer;
import io.confluent.ksql.metastore.KsqlStdOut;
import io.confluent.ksql.metastore.KsqlStream;
import io.confluent.ksql.metastore.KsqlTopic;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.StructuredDataSource;
import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.AllColumns;
import io.confluent.ksql.parser.tree.Cast;
import io.confluent.ksql.parser.tree.ComparisonExpression;
import io.confluent.ksql.parser.tree.DereferenceExpression;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.GroupingElement;
import io.confluent.ksql.parser.tree.Join;
import io.confluent.ksql.parser.tree.JoinOn;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.QualifiedNameReference;
import io.confluent.ksql.parser.tree.QuerySpecification;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.Table;
import io.confluent.ksql.parser.tree.WindowExpression;
import io.confluent.ksql.planner.DefaultTraversalVisitor;
import io.confluent.ksql.planner.plan.JoinNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.StructuredDataSourceNode;
import io.confluent.ksql.serde.DataSource;
import io.confluent.ksql.serde.KsqlTopicSerDe;
import io.confluent.ksql.serde.avro.KsqlAvroTopicSerDe;
import io.confluent.ksql.serde.delimited.KsqlDelimitedTopicSerDe;
import io.confluent.ksql.serde.json.KsqlJsonTopicSerDe;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Pair;
import io.confluent.ksql.util.SchemaUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class Analyzer
extends DefaultTraversalVisitor<Node, AnalysisContext> {
    private final String sqlExpression;
    private final Analysis analysis;
    private final MetaStore metaStore;

    public Analyzer(String sqlExpression, Analysis analysis, MetaStore metaStore) {
        this.sqlExpression = sqlExpression;
        this.analysis = analysis;
        this.metaStore = metaStore;
    }

    @Override
    protected Node visitQuerySpecification(QuerySpecification node, AnalysisContext context) {
        this.process((Node)node.getFrom(), new AnalysisContext(AnalysisContext.ParentType.FROM));
        this.process((Node)node.getInto(), new AnalysisContext(AnalysisContext.ParentType.INTO));
        if (!(this.analysis.getInto() instanceof KsqlStdOut)) {
            this.analyzeNonStdOutSink();
        }
        this.process((Node)node.getSelect(), new AnalysisContext(AnalysisContext.ParentType.SELECT));
        if (node.getWhere().isPresent()) {
            this.analyzeWhere((Node)node.getWhere().get());
        }
        if (node.getGroupBy().isPresent()) {
            this.analyzeGroupBy((GroupBy)node.getGroupBy().get());
        }
        if (node.getWindowExpression().isPresent()) {
            this.analyzeWindowExpression((WindowExpression)node.getWindowExpression().get());
        }
        if (node.getHaving().isPresent()) {
            this.analyzeHaving((Node)node.getHaving().get());
        }
        if (node.getLimit().isPresent()) {
            String limitStr = (String)node.getLimit().get();
            this.analysis.setLimitClause(Integer.parseInt(limitStr));
        }
        this.analyzeExpressions();
        return null;
    }

    private void analyzeNonStdOutSink() {
        List<Pair<StructuredDataSource, String>> fromDataSources = this.analysis.getFromDataSources();
        StructuredDataSource intoStructuredDataSource = this.analysis.getInto();
        String intoKafkaTopicName = this.analysis.getIntoKafkaTopicName();
        if (intoKafkaTopicName == null) {
            intoKafkaTopicName = intoStructuredDataSource.getName();
        }
        KsqlTopicSerDe intoTopicSerde = ((StructuredDataSource)fromDataSources.get(0).getLeft()).getKsqlTopic().getKsqlTopicSerDe();
        if (this.analysis.getIntoFormat() != null) {
            switch (this.analysis.getIntoFormat().toUpperCase()) {
                case "AVRO": {
                    intoTopicSerde = new KsqlAvroTopicSerDe();
                    break;
                }
                case "JSON": {
                    intoTopicSerde = new KsqlJsonTopicSerDe();
                    break;
                }
                case "DELIMITED": {
                    intoTopicSerde = new KsqlDelimitedTopicSerDe();
                    break;
                }
                default: {
                    throw new KsqlException(String.format("Unsupported format: %s", this.analysis.getIntoFormat()));
                }
            }
        } else if (intoTopicSerde instanceof KsqlAvroTopicSerDe) {
            intoTopicSerde = new KsqlAvroTopicSerDe();
        }
        KsqlTopic newIntoKsqlTopic = new KsqlTopic(intoKafkaTopicName, intoKafkaTopicName, intoTopicSerde);
        KsqlStream intoKsqlStream = new KsqlStream(this.sqlExpression, intoStructuredDataSource.getName(), null, null, null, newIntoKsqlTopic);
        this.analysis.setInto((StructuredDataSource)intoKsqlStream);
    }

    private void analyzeExpressions() {
        Schema schema = ((StructuredDataSource)this.analysis.getFromDataSources().get(0).getLeft()).getSchema();
        boolean isJoinSchema = false;
        if (this.analysis.getJoin() != null) {
            schema = this.analysis.getJoin().getSchema();
            isJoinSchema = true;
        }
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(schema, isJoinSchema);
        for (Expression selectExpression : this.analysis.getSelectExpressions()) {
            expressionAnalyzer.analyzeExpression(selectExpression);
        }
        if (this.analysis.getWhereExpression() != null) {
            expressionAnalyzer.analyzeExpression(this.analysis.getWhereExpression());
        }
        if (!this.analysis.getGroupByExpressions().isEmpty()) {
            for (Expression expression : this.analysis.getGroupByExpressions()) {
                expressionAnalyzer.analyzeExpression(expression);
            }
        }
        if (this.analysis.getHavingExpression() != null) {
            expressionAnalyzer.analyzeExpression(this.analysis.getHavingExpression());
        }
    }

    @Override
    protected Node visitJoin(Join node, AnalysisContext context) {
        JoinNode.Type joinType;
        AliasedRelation left = (AliasedRelation)this.process((Node)node.getLeft(), context);
        AliasedRelation right = (AliasedRelation)this.process((Node)node.getRight(), context);
        String leftSideName = ((Table)left.getRelation()).getName().getSuffix();
        StructuredDataSource leftDataSource = this.metaStore.getSource(leftSideName);
        if (leftDataSource == null) {
            throw new KsqlException(String.format("Resource %s does not exist.", leftSideName));
        }
        leftDataSource = this.timestampColumn(left, leftDataSource);
        String rightSideName = ((Table)right.getRelation()).getName().getSuffix();
        StructuredDataSource rightDataSource = this.metaStore.getSource(rightSideName);
        if (rightDataSource == null) {
            throw new KsqlException(String.format("Resource %s does not exist.", rightSideName));
        }
        rightDataSource = this.timestampColumn(right, rightDataSource);
        String leftAlias = left.getAlias();
        String rightAlias = right.getAlias();
        switch (node.getType()) {
            case INNER: {
                joinType = JoinNode.Type.INNER;
                break;
            }
            case LEFT: {
                joinType = JoinNode.Type.LEFT;
                break;
            }
            case RIGHT: {
                joinType = JoinNode.Type.RIGHT;
                break;
            }
            case CROSS: {
                joinType = JoinNode.Type.CROSS;
                break;
            }
            case FULL: {
                joinType = JoinNode.Type.FULL;
                break;
            }
            default: {
                throw new KsqlException("Join type is not supported: " + node.getType().name());
            }
        }
        if (!node.getCriteria().isPresent()) {
            throw new KsqlException(String.format("%s Join criteria is not set.", node.getLocation().isPresent() ? ((NodeLocation)node.getLocation().get()).toString() : ""));
        }
        JoinOn joinOn = (JoinOn)node.getCriteria().get();
        ComparisonExpression comparisonExpression = (ComparisonExpression)joinOn.getExpression();
        Pair<String, String> leftSide = this.fetchKeyFieldName(comparisonExpression, leftAlias, leftDataSource.getSchema());
        Pair<String, String> rightSide = this.fetchKeyFieldName(comparisonExpression, rightAlias, rightDataSource.getSchema());
        String leftKeyFieldName = (String)leftSide.getRight();
        String rightKeyFieldName = (String)rightSide.getRight();
        if (comparisonExpression.getType() != ComparisonExpression.Type.EQUAL) {
            throw new KsqlException("Only equality join criteria is supported.");
        }
        StructuredDataSourceNode leftSourceKafkaTopicNode = new StructuredDataSourceNode(new PlanNodeId("KafkaTopic_Left"), leftDataSource, leftDataSource.getSchema());
        StructuredDataSourceNode rightSourceKafkaTopicNode = new StructuredDataSourceNode(new PlanNodeId("KafkaTopic_Right"), rightDataSource, rightDataSource.getSchema());
        JoinNode joinNode = new JoinNode(new PlanNodeId("Join"), joinType, leftSourceKafkaTopicNode, rightSourceKafkaTopicNode, leftKeyFieldName, rightKeyFieldName, leftAlias, rightAlias);
        this.analysis.setJoin(joinNode);
        return null;
    }

    private Pair<String, String> fetchKeyFieldName(ComparisonExpression comparisonExpression, String sourceAlias, Schema sourceSchema) {
        Pair<String, String> keyInfo = this.fetchKeyFieldNameFromExpr(comparisonExpression.getLeft(), sourceAlias, sourceSchema);
        if (keyInfo == null) {
            keyInfo = this.fetchKeyFieldNameFromExpr(comparisonExpression.getRight(), sourceAlias, sourceSchema);
        }
        if (keyInfo == null) {
            throw new KsqlException(String.format("%s : Invalid join criteria %s. Key for %s is not set correctly. ", comparisonExpression.getLocation().isPresent() ? ((NodeLocation)comparisonExpression.getLocation().get()).toString() : "", comparisonExpression, sourceAlias));
        }
        return keyInfo;
    }

    private Pair<String, String> fetchKeyFieldNameFromExpr(Expression expression, String sourceAlias, Schema sourceSchema) {
        QualifiedNameReference qualifiedNameReference;
        String keyFieldName;
        if (expression instanceof DereferenceExpression) {
            String keyFieldName2;
            DereferenceExpression dereferenceExpression = (DereferenceExpression)expression;
            String sourceAliasVal = dereferenceExpression.getBase().toString();
            if (sourceAliasVal.equalsIgnoreCase(sourceAlias) && SchemaUtil.getFieldByName((Schema)sourceSchema, (String)(keyFieldName2 = dereferenceExpression.getFieldName())).isPresent()) {
                return new Pair((Object)sourceAliasVal, (Object)keyFieldName2);
            }
        } else if (expression instanceof QualifiedNameReference && SchemaUtil.getFieldByName((Schema)sourceSchema, (String)(keyFieldName = (qualifiedNameReference = (QualifiedNameReference)expression).getName().getSuffix())).isPresent()) {
            return new Pair((Object)sourceAlias, (Object)keyFieldName);
        }
        return null;
    }

    private StructuredDataSource timestampColumn(AliasedRelation aliasedRelation, StructuredDataSource structuredDataSource) {
        if (((Table)aliasedRelation.getRelation()).getProperties() != null && ((Table)aliasedRelation.getRelation()).getProperties().get("TIMESTAMP") != null) {
            String timestampFieldName = ((Expression)((Table)aliasedRelation.getRelation()).getProperties().get("TIMESTAMP")).toString().toUpperCase();
            if (!timestampFieldName.startsWith("'") || !timestampFieldName.endsWith("'")) {
                throw new KsqlException("Property name should be String with single qoute.");
            }
            timestampFieldName = timestampFieldName.substring(1, timestampFieldName.length() - 1);
            structuredDataSource = structuredDataSource.cloneWithTimeField(timestampFieldName);
        }
        return structuredDataSource;
    }

    @Override
    protected Node visitAliasedRelation(AliasedRelation node, AnalysisContext context) {
        String structuredDataSourceName = ((Table)node.getRelation()).getName().getSuffix();
        if (this.metaStore.getSource(structuredDataSourceName) == null) {
            throw new KsqlException(structuredDataSourceName + " does not exist.");
        }
        StructuredDataSource structuredDataSource = this.metaStore.getSource(structuredDataSourceName);
        if (((Table)node.getRelation()).getProperties() != null && ((Table)node.getRelation()).getProperties().get("TIMESTAMP") != null) {
            String timestampFieldName = ((Expression)((Table)node.getRelation()).getProperties().get("TIMESTAMP")).toString().toUpperCase();
            if (!timestampFieldName.startsWith("'") && !timestampFieldName.endsWith("'")) {
                throw new KsqlException("Property name should be String with single qoute.");
            }
            timestampFieldName = timestampFieldName.substring(1, timestampFieldName.length() - 1);
            structuredDataSource = structuredDataSource.cloneWithTimeField(timestampFieldName);
        }
        Pair fromDataSource = new Pair((Object)structuredDataSource, (Object)node.getAlias());
        this.analysis.addDataSource((Pair<StructuredDataSource, String>)fromDataSource);
        return node;
    }

    protected Node visitTable(Table node, AnalysisContext context) {
        StructuredDataSource into;
        if (node.isStdOut) {
            into = new KsqlStdOut("KSQL_STDOUT_NAME", null, null, null, DataSource.DataSourceType.KSTREAM);
        } else if (context.getParentType() == AnalysisContext.ParentType.INTO) {
            into = this.analyzeNonStdOutTable(node);
        } else {
            throw new KsqlException("INTO clause is not set correctly!");
        }
        this.analysis.setInto(into);
        return null;
    }

    @Override
    protected Node visitCast(Cast node, AnalysisContext context) {
        return (Node)this.process((Node)node.getExpression(), context);
    }

    @Override
    protected Node visitSelect(Select node, AnalysisContext context) {
        for (SelectItem selectItem : node.getSelectItems()) {
            if (selectItem instanceof AllColumns) {
                AllColumns allColumns = (AllColumns)selectItem;
                if (this.analysis.getFromDataSources() == null || this.analysis.getFromDataSources().isEmpty()) {
                    throw new KsqlException("FROM clause was not resolved!");
                }
                if (this.analysis.getJoin() != null) {
                    QualifiedNameReference qualifiedNameReference;
                    JoinNode joinNode = this.analysis.getJoin();
                    for (Field field : joinNode.getLeft().getSchema().fields()) {
                        qualifiedNameReference = new QualifiedNameReference((NodeLocation)allColumns.getLocation().get(), QualifiedName.of((String)(joinNode.getLeftAlias() + "." + field.name())));
                        this.analysis.addSelectItem((Expression)qualifiedNameReference, joinNode.getLeftAlias() + "_" + field.name());
                    }
                    for (Field field : joinNode.getRight().getSchema().fields()) {
                        qualifiedNameReference = new QualifiedNameReference((NodeLocation)allColumns.getLocation().get(), QualifiedName.of((String)(joinNode.getRightAlias() + "." + field.name())));
                        this.analysis.addSelectItem((Expression)qualifiedNameReference, joinNode.getRightAlias() + "_" + field.name());
                    }
                    continue;
                }
                for (Field field : ((StructuredDataSource)this.analysis.getFromDataSources().get(0).getLeft()).getSchema().fields()) {
                    QualifiedNameReference qualifiedNameReference = new QualifiedNameReference((NodeLocation)allColumns.getLocation().get(), QualifiedName.of((String)((String)this.analysis.getFromDataSources().get(0).getRight() + "." + field.name())));
                    this.analysis.addSelectItem((Expression)qualifiedNameReference, field.name());
                }
                continue;
            }
            if (selectItem instanceof SingleColumn) {
                SingleColumn column = (SingleColumn)selectItem;
                this.analysis.addSelectItem(column.getExpression(), (String)column.getAlias().get());
                continue;
            }
            throw new IllegalArgumentException("Unsupported SelectItem type: " + selectItem.getClass().getName());
        }
        return null;
    }

    protected Node visitQualifiedNameReference(QualifiedNameReference node, AnalysisContext context) {
        return (Node)this.visitExpression((Expression)node, context);
    }

    @Override
    protected Node visitGroupBy(GroupBy node, AnalysisContext context) {
        return null;
    }

    private void analyzeWhere(Node node) {
        this.analysis.setWhereExpression((Expression)node);
    }

    private void analyzeGroupBy(GroupBy groupBy) {
        for (GroupingElement groupingElement : groupBy.getGroupingElements()) {
            Set groupingSet = (Set)groupingElement.enumerateGroupingSets().get(0);
            this.analysis.getGroupByExpressions().addAll(groupingSet);
        }
    }

    private void analyzeWindowExpression(WindowExpression windowExpression) {
        this.analysis.setWindowExpression(windowExpression);
    }

    private void analyzeHaving(Node node) {
        this.analysis.setHavingExpression((Expression)node);
    }

    private StructuredDataSource analyzeNonStdOutTable(Table node) {
        KsqlStream into = new KsqlStream(this.sqlExpression, node.getName().getSuffix(), null, null, null, null);
        this.setIntoProperties((StructuredDataSource)into, node);
        return into;
    }

    private void setIntoProperties(StructuredDataSource into, Table node) {
        this.validateWithClause(node.getProperties().keySet());
        if (node.getProperties().get("VALUE_FORMAT") != null) {
            this.setIntoTopicFormat(into, node);
        }
        if (node.getProperties().get("KAFKA_TOPIC") != null) {
            this.setIntoTopicName(node);
        }
        if (node.getProperties().get("PARTITION_BY") != null) {
            String intoPartitionByColumnName = ((Expression)node.getProperties().get("PARTITION_BY")).toString().toUpperCase();
            this.analysis.getIntoProperties().put("PARTITION_BY", intoPartitionByColumnName);
        }
        if (node.getProperties().get("TIMESTAMP") != null) {
            this.setIntoTimestampColumn(node);
        }
        if (node.getProperties().get("PARTITIONS") != null) {
            try {
                int numberOfPartitions = Integer.parseInt(((Expression)node.getProperties().get("PARTITIONS")).toString());
                this.analysis.getIntoProperties().put("ksql.sink.partitions", numberOfPartitions);
            }
            catch (NumberFormatException e) {
                throw new KsqlException("Invalid number of partitions in WITH clause: " + ((Expression)node.getProperties().get("PARTITIONS")).toString());
            }
        }
        if (node.getProperties().get("REPLICAS") != null) {
            try {
                short numberOfReplications = Short.parseShort(((Expression)node.getProperties().get("REPLICAS")).toString());
                this.analysis.getIntoProperties().put("ksql.sink.replicas", numberOfReplications);
            }
            catch (NumberFormatException e) {
                throw new KsqlException("Invalid number of replications in WITH clause: " + ((Expression)node.getProperties().get("REPLICAS")).toString());
            }
        }
    }

    private void setIntoTopicName(Table node) {
        String intoKafkaTopicName = ((Expression)node.getProperties().get("KAFKA_TOPIC")).toString();
        if (!intoKafkaTopicName.startsWith("'") && !intoKafkaTopicName.endsWith("'")) {
            throw new KsqlException(intoKafkaTopicName + " value is string and should be enclosed between " + "\"'\".");
        }
        intoKafkaTopicName = intoKafkaTopicName.substring(1, intoKafkaTopicName.length() - 1);
        this.analysis.setIntoKafkaTopicName(intoKafkaTopicName);
        this.analysis.getIntoProperties().put("KAFKA_TOPIC", intoKafkaTopicName);
    }

    private void setIntoTopicFormat(StructuredDataSource into, Table node) {
        String serde = ((Expression)node.getProperties().get("VALUE_FORMAT")).toString();
        if (!serde.startsWith("'") && !serde.endsWith("'")) {
            throw new KsqlException(serde + " value is string and should be enclosed between " + "\"'\".");
        }
        serde = serde.substring(1, serde.length() - 1);
        this.analysis.setIntoFormat(serde);
        this.analysis.getIntoProperties().put("VALUE_FORMAT", serde);
        if ("AVRO".equals(serde)) {
            String avroSchemaFilePath = "/tmp/" + into.getName() + ".avro";
            if (node.getProperties().get("AVROSCHEMAFILE") != null) {
                avroSchemaFilePath = ((Expression)node.getProperties().get("AVROSCHEMAFILE")).toString();
                if (!avroSchemaFilePath.startsWith("'") && !avroSchemaFilePath.endsWith("'")) {
                    throw new KsqlException(avroSchemaFilePath + " value is string and should be enclosed between " + "\"'\".");
                }
                avroSchemaFilePath = avroSchemaFilePath.substring(1, avroSchemaFilePath.length() - 1);
            }
            this.analysis.getIntoProperties().put("AVROSCHEMAFILE", avroSchemaFilePath);
        }
    }

    private void setIntoTimestampColumn(Table node) {
        String intoTimestampColumnName = ((Expression)node.getProperties().get("TIMESTAMP")).toString().toUpperCase();
        if (!intoTimestampColumnName.startsWith("'") && !intoTimestampColumnName.endsWith("'")) {
            throw new KsqlException(intoTimestampColumnName + " value is string and should be enclosed between " + "\"'\".");
        }
        intoTimestampColumnName = intoTimestampColumnName.substring(1, intoTimestampColumnName.length() - 1);
        this.analysis.getIntoProperties().put("TIMESTAMP", intoTimestampColumnName);
    }

    private void validateWithClause(Set<String> withClauseVariables) {
        HashSet<String> validSet = new HashSet<String>();
        validSet.add("VALUE_FORMAT".toUpperCase());
        validSet.add("KAFKA_TOPIC".toUpperCase());
        validSet.add("PARTITION_BY".toUpperCase());
        validSet.add("TIMESTAMP".toUpperCase());
        validSet.add("PARTITIONS".toUpperCase());
        validSet.add("REPLICAS".toUpperCase());
        for (String withVariable : withClauseVariables) {
            if (validSet.contains(withVariable.toUpperCase())) continue;
            throw new KsqlException("Invalid config variable in the WITH clause: " + withVariable);
        }
    }
}

