/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import io.confluent.ksql.analyzer.AggregateAnalysis;
import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.analyzer.AnalysisContext;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.parser.tree.DereferenceExpression;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.FunctionCall;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.QualifiedNameReference;
import io.confluent.ksql.planner.DefaultTraversalVisitor;

public class AggregateAnalyzer
extends DefaultTraversalVisitor<Node, AnalysisContext> {
    private AggregateAnalysis aggregateAnalysis;
    private Analysis analysis;
    private FunctionRegistry functionRegistry;
    private boolean hasAggregateFunction = false;

    public boolean isHasAggregateFunction() {
        return this.hasAggregateFunction;
    }

    public void setHasAggregateFunction(boolean hasAggregateFunction) {
        this.hasAggregateFunction = hasAggregateFunction;
    }

    public AggregateAnalyzer(AggregateAnalysis aggregateAnalysis, Analysis analysis, FunctionRegistry functionRegistry) {
        this.aggregateAnalysis = aggregateAnalysis;
        this.analysis = analysis;
        this.functionRegistry = functionRegistry;
    }

    @Override
    protected Node visitFunctionCall(FunctionCall node, AnalysisContext context) {
        String functionName = node.getName().getSuffix();
        if (this.functionRegistry.isAnAggregateFunction(functionName)) {
            if (node.getArguments().isEmpty()) {
                DereferenceExpression argExpression;
                QualifiedNameReference baseExpression;
                if (this.analysis.getJoin() != null) {
                    baseExpression = new QualifiedNameReference(QualifiedName.of((String)this.analysis.getJoin().getLeftAlias()));
                    argExpression = new DereferenceExpression((Expression)baseExpression, "ROWTIME");
                } else {
                    baseExpression = new QualifiedNameReference(QualifiedName.of((String)((String)this.analysis.getFromDataSources().get(0).getRight())));
                    argExpression = new DereferenceExpression((Expression)baseExpression, "ROWTIME");
                }
                this.aggregateAnalysis.addAggregateFunctionArgument((Expression)argExpression);
                node.getArguments().add(argExpression);
            } else {
                this.aggregateAnalysis.addAggregateFunctionArgument((Expression)node.getArguments().get(0));
            }
            this.aggregateAnalysis.addFunction(node);
            this.hasAggregateFunction = true;
        }
        for (Expression argExp : node.getArguments()) {
            this.process((Node)argExp, context);
        }
        return null;
    }

    @Override
    protected Node visitDereferenceExpression(DereferenceExpression node, AnalysisContext context) {
        String name = node.toString();
        if (!this.aggregateAnalysis.hasRequiredColumn(name)) {
            this.aggregateAnalysis.addRequiredColumn(name, (Expression)node);
        }
        return null;
    }
}

