/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.FunctionCall;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AggregateAnalysis {
    private final Map<String, Expression> requiredColumnsMap = new LinkedHashMap<String, Expression>();
    private final List<Expression> nonAggResultColumns = new ArrayList<Expression>();
    private final List<Expression> finalSelectExpressions = new ArrayList<Expression>();
    private final List<Expression> aggregateFunctionArguments = new ArrayList<Expression>();
    private final List<FunctionCall> functionList = new ArrayList<FunctionCall>();
    private Expression havingExpression = null;

    public List<Expression> getAggregateFunctionArguments() {
        return Collections.unmodifiableList(this.aggregateFunctionArguments);
    }

    public List<Expression> getRequiredColumnsList() {
        return new ArrayList<Expression>(this.requiredColumnsMap.values());
    }

    public Map<String, Expression> getRequiredColumnsMap() {
        return Collections.unmodifiableMap(this.requiredColumnsMap);
    }

    public List<FunctionCall> getFunctionList() {
        return Collections.unmodifiableList(this.functionList);
    }

    public List<Expression> getNonAggResultColumns() {
        return Collections.unmodifiableList(this.nonAggResultColumns);
    }

    public List<Expression> getFinalSelectExpressions() {
        return Collections.unmodifiableList(this.finalSelectExpressions);
    }

    public Expression getHavingExpression() {
        return this.havingExpression;
    }

    public void setHavingExpression(Expression havingExpression) {
        this.havingExpression = havingExpression;
    }

    public void addAggregateFunctionArgument(Expression argument) {
        this.aggregateFunctionArguments.add(argument);
    }

    public void addFunction(FunctionCall functionCall) {
        this.functionList.add(functionCall);
    }

    public boolean hasRequiredColumn(String column) {
        return this.requiredColumnsMap.containsKey(column);
    }

    public void addRequiredColumn(String name, Expression node) {
        this.requiredColumnsMap.put(name, node);
    }

    public void addNonAggResultColumns(Expression expression) {
        this.nonAggResultColumns.add(expression);
    }

    public void addFinalSelectExpression(Expression expression) {
        this.finalSelectExpressions.add(expression);
    }
}

