/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.util.KsqlException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class SchemaUtil {
    public static final String ARRAY = "ARRAY";
    public static final String MAP = "MAP";
    public static final String ROWKEY_NAME = "ROWKEY";
    public static final String ROWTIME_NAME = "ROWTIME";
    public static final int ROWKEY_NAME_INDEX = 1;
    private static final ImmutableMap<String, String> TYPE_MAP = new ImmutableMap.Builder().put((Object)"STRING", (Object)"VARCHAR(STRING)").put((Object)"INT64", (Object)"BIGINT").put((Object)"INT32", (Object)"INTEGER").put((Object)"FLOAT64", (Object)"DOUBLE").put((Object)"BOOLEAN", (Object)"BOOLEAN").put((Object)"ARRAY", (Object)"ARRAY").put((Object)"MAP", (Object)"MAP").build();

    public static Class getJavaType(org.apache.kafka.connect.data.Schema schema) {
        switch (schema.type()) {
            case STRING: {
                return String.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case INT32: {
                return Integer.class;
            }
            case INT64: {
                return Long.class;
            }
            case FLOAT64: {
                return Double.class;
            }
            case ARRAY: {
                Class elementClass = SchemaUtil.getJavaType(schema.valueSchema());
                return Array.newInstance(elementClass, 0).getClass();
            }
            case MAP: {
                return HashMap.class;
            }
        }
        throw new KsqlException("Type is not supported: " + schema.type());
    }

    public static Optional<Field> getFieldByName(org.apache.kafka.connect.data.Schema schema, String fieldName) {
        if (schema.fields() != null) {
            for (Field field : schema.fields()) {
                if (field.name().equals(fieldName)) {
                    return Optional.of(field);
                }
                if (!field.name().equals(fieldName.substring(fieldName.indexOf(".") + 1))) continue;
                return Optional.of(field);
            }
        }
        return Optional.empty();
    }

    public static org.apache.kafka.connect.data.Schema getTypeSchema(String sqlType) {
        switch (sqlType) {
            case "VARCHAR": 
            case "STRING": {
                return org.apache.kafka.connect.data.Schema.STRING_SCHEMA;
            }
            case "BOOLEAN": 
            case "BOOL": {
                return org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA;
            }
            case "INTEGER": 
            case "INT": {
                return org.apache.kafka.connect.data.Schema.INT32_SCHEMA;
            }
            case "BIGINT": 
            case "LONG": {
                return org.apache.kafka.connect.data.Schema.INT64_SCHEMA;
            }
            case "DOUBLE": {
                return org.apache.kafka.connect.data.Schema.FLOAT64_SCHEMA;
            }
        }
        return SchemaUtil.getKsqlComplexType(sqlType);
    }

    private static org.apache.kafka.connect.data.Schema getKsqlComplexType(String sqlType) {
        if (sqlType.startsWith(ARRAY)) {
            return SchemaBuilder.array((org.apache.kafka.connect.data.Schema)SchemaUtil.getTypeSchema(sqlType.substring(ARRAY.length() + 1, sqlType.length() - 1)));
        }
        if (sqlType.startsWith(MAP)) {
            String[] mapTypesStrs = sqlType.substring(MAP.length() + 1, sqlType.length() - 1).trim().split(",");
            if (mapTypesStrs.length != 2) {
                throw new KsqlException("Map type is not defined correctly.: " + sqlType);
            }
            String keyType = mapTypesStrs[0].trim();
            String valueType = mapTypesStrs[1].trim();
            return SchemaBuilder.map((org.apache.kafka.connect.data.Schema)SchemaUtil.getTypeSchema(keyType), (org.apache.kafka.connect.data.Schema)SchemaUtil.getTypeSchema(valueType));
        }
        throw new KsqlException("Unsupported type: " + sqlType);
    }

    public static int getFieldIndexByName(org.apache.kafka.connect.data.Schema schema, String fieldName) {
        if (schema.fields() == null) {
            return -1;
        }
        for (int i = 0; i < schema.fields().size(); ++i) {
            Field field = (Field)schema.fields().get(i);
            int dotIndex = field.name().indexOf(46);
            if (dotIndex == -1) {
                if (!field.name().equals(fieldName)) continue;
                return i;
            }
            if (dotIndex >= fieldName.length()) continue;
            String fieldNameWithDot = fieldName.substring(0, dotIndex) + "." + fieldName.substring(dotIndex + 1);
            if (!field.name().equals(fieldNameWithDot)) continue;
            return i;
        }
        return -1;
    }

    public static org.apache.kafka.connect.data.Schema buildSchemaWithAlias(org.apache.kafka.connect.data.Schema schema, String alias) {
        SchemaBuilder newSchema = SchemaBuilder.struct().name(schema.name());
        for (Field field : schema.fields()) {
            newSchema.field(alias + "." + field.name(), field.schema());
        }
        return newSchema;
    }

    public static String getSchemaFieldName(Field field) {
        if (field.schema().type() == Schema.Type.ARRAY) {
            return "ARRAY[" + (String)TYPE_MAP.get((Object)field.schema().valueSchema().type().name()) + "]";
        }
        if (field.schema().type() == Schema.Type.MAP) {
            return "MAP[" + (String)TYPE_MAP.get((Object)field.schema().keySchema().type().name()) + "," + (String)TYPE_MAP.get((Object)field.schema().valueSchema().type().name()) + "]";
        }
        return (String)TYPE_MAP.get((Object)field.schema().type().name());
    }

    public static String getJavaCastString(org.apache.kafka.connect.data.Schema schema) {
        switch (schema.type()) {
            case INT32: {
                return "(Integer)";
            }
            case INT64: {
                return "(Long)";
            }
            case FLOAT64: {
                return "(Double)";
            }
            case STRING: {
                return "(String)";
            }
            case BOOLEAN: {
                return "(Boolean)";
            }
        }
        return "";
    }

    public static org.apache.kafka.connect.data.Schema addImplicitRowTimeRowKeyToSchema(org.apache.kafka.connect.data.Schema schema) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        schemaBuilder.field(ROWTIME_NAME, org.apache.kafka.connect.data.Schema.INT64_SCHEMA);
        schemaBuilder.field(ROWKEY_NAME, org.apache.kafka.connect.data.Schema.STRING_SCHEMA);
        for (Field field : schema.fields()) {
            if (field.name().equals(ROWKEY_NAME) || field.name().equals(ROWTIME_NAME)) continue;
            schemaBuilder.field(field.name(), field.schema());
        }
        return schemaBuilder.build();
    }

    public static org.apache.kafka.connect.data.Schema removeImplicitRowTimeRowKeyFromSchema(org.apache.kafka.connect.data.Schema schema) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        for (Field field : schema.fields()) {
            String fieldName = field.name();
            if ((fieldName = fieldName.substring(fieldName.indexOf(46) + 1)).equalsIgnoreCase(ROWTIME_NAME) || fieldName.equalsIgnoreCase(ROWKEY_NAME)) continue;
            schemaBuilder.field(fieldName, field.schema());
        }
        return schemaBuilder.build();
    }

    public static Set<Integer> getRowTimeRowKeyIndexes(org.apache.kafka.connect.data.Schema schema) {
        HashSet<Integer> indexSet = new HashSet<Integer>();
        for (int i = 0; i < schema.fields().size(); ++i) {
            Field field = (Field)schema.fields().get(i);
            if (!field.name().equalsIgnoreCase(ROWTIME_NAME) && !field.name().equalsIgnoreCase(ROWKEY_NAME)) continue;
            indexSet.add(i);
        }
        return indexSet;
    }

    public static String getSchemaDefinitionString(org.apache.kafka.connect.data.Schema schema) {
        StringBuilder stringBuilder = new StringBuilder("[");
        boolean addComma = false;
        for (Field field : schema.fields()) {
            if (addComma) {
                stringBuilder.append(" , ");
            } else {
                addComma = true;
            }
            stringBuilder.append(field.name()).append(" : ").append(field.schema().type());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String getSQLTypeName(org.apache.kafka.connect.data.Schema schema) {
        switch (schema.type()) {
            case INT32: {
                return "INT";
            }
            case INT64: {
                return "BIGINT";
            }
            case FLOAT64: 
            case FLOAT32: {
                return "DOUBLE";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case STRING: {
                return "VARCHAR";
            }
            case ARRAY: {
                return "ARRAY<" + SchemaUtil.getSQLTypeName(schema.valueSchema()) + ">";
            }
            case MAP: {
                return "MAP<" + SchemaUtil.getSQLTypeName(schema.keySchema()) + "," + SchemaUtil.getSQLTypeName(schema.valueSchema()) + ">";
            }
        }
        throw new KsqlException(String.format("Invalid type in schema: %s.", schema.toString()));
    }

    public static String buildAvroSchema(org.apache.kafka.connect.data.Schema schema, String name) {
        SchemaBuilder.FieldAssembler fieldAssembler = ((SchemaBuilder.RecordBuilder)org.apache.avro.SchemaBuilder.record((String)name).namespace("ksql")).fields();
        for (Field field : schema.fields()) {
            fieldAssembler.name(field.name().replace(".", "_")).type(SchemaUtil.getAvroSchemaForField(field.schema())).withDefault(null);
        }
        return fieldAssembler.endRecord().toString();
    }

    private static Schema getAvroSchemaForField(org.apache.kafka.connect.data.Schema fieldSchema) {
        switch (fieldSchema.type()) {
            case STRING: {
                return SchemaUtil.unionWithNull(Schema.create((Schema.Type)Schema.Type.STRING));
            }
            case BOOLEAN: {
                return SchemaUtil.unionWithNull(Schema.create((Schema.Type)Schema.Type.BOOLEAN));
            }
            case INT32: {
                return SchemaUtil.unionWithNull(Schema.create((Schema.Type)Schema.Type.INT));
            }
            case INT64: {
                return SchemaUtil.unionWithNull(Schema.create((Schema.Type)Schema.Type.LONG));
            }
            case FLOAT64: {
                return SchemaUtil.unionWithNull(Schema.create((Schema.Type)Schema.Type.DOUBLE));
            }
        }
        if (fieldSchema.type() == Schema.Type.ARRAY) {
            return SchemaUtil.unionWithNull(Schema.createArray((Schema)SchemaUtil.getAvroSchemaForField(fieldSchema.valueSchema())));
        }
        if (fieldSchema.type() == Schema.Type.MAP) {
            return SchemaUtil.unionWithNull(Schema.createMap((Schema)SchemaUtil.getAvroSchemaForField(fieldSchema.valueSchema())));
        }
        throw new KsqlException("Unsupported AVRO type: " + fieldSchema.type().name());
    }

    private static Schema unionWithNull(Schema schema) {
        return Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), schema});
    }

    public static org.apache.kafka.connect.data.Schema getAvroSerdeKsqlSchema(org.apache.kafka.connect.data.Schema schema) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        for (Field field : schema.fields()) {
            schemaBuilder.field(field.name().replace(".", "_"), field.schema());
        }
        return schemaBuilder.build();
    }

    public static String getFieldNameWithNoAlias(Field field) {
        String name = field.name();
        if (name.contains(".")) {
            return name.substring(name.indexOf(".") + 1);
        }
        return name;
    }

    public static org.apache.kafka.connect.data.Schema getSchemaWithNoAlias(org.apache.kafka.connect.data.Schema schema) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        for (Field field : schema.fields()) {
            String name = SchemaUtil.getFieldNameWithNoAlias(field);
            schemaBuilder.field(name, field.schema());
        }
        return schemaBuilder.build();
    }

    public static int getIndexInSchema(String fieldName, org.apache.kafka.connect.data.Schema schema) {
        List fields = schema.fields();
        for (int i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.get(i);
            if (!field.name().equals(fieldName)) continue;
            return i;
        }
        throw new KsqlException("Couldn't find field with name=" + fieldName + " in schema. fields=" + fields);
    }
}

