/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.errors.LogMetricAndContinueExceptionHandler;
import io.confluent.ksql.util.CommonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class KsqlConfig
extends AbstractConfig
implements Cloneable {
    public static final String KSQL_SERVICES_COMMON_FOLDER = "/apps/ksql/";
    private final String commandsStreamFolder;
    private final String commandsStream;
    public static final String KSQL_CONFIG_PROPERTY_PREFIX = "ksql.";
    public static final String KSQL_TIMESTAMP_COLUMN_INDEX = "ksql.timestamp.column.index";
    public static final String SINK_NUMBER_OF_PARTITIONS_PROPERTY = "ksql.sink.partitions";
    public static final String SINK_NUMBER_OF_REPLICAS_PROPERTY = "ksql.sink.replicas";
    public static final String SCHEMA_REGISTRY_URL_PROPERTY = "ksql.schema.registry.url";
    public static final String SINK_WINDOW_CHANGE_LOG_ADDITIONAL_RETENTION_MS_PROPERTY = "ksql.sink.window.change.log.additional.retention";
    public static final String STREAM_INTERNAL_CHANGELOG_TOPIC_SUFFIX = "-changelog";
    public static final String STREAM_INTERNAL_REPARTITION_TOPIC_SUFFIX = "-repartition";
    public static final String FAIL_ON_DESERIALIZATION_ERROR_CONFIG = "ksql.fail.on.deserialization.error";
    public static final String KSQL_SERVICE_ID_CONFIG = "ksql.service.id";
    public static final String KSQL_SERVICE_ID_DEFAULT = "default_";
    public static final String KSQL_PERSISTENT_QUERY_NAME_PREFIX_CONFIG = "ksql.persistent.prefix";
    public static final String KSQL_PERSISTENT_QUERY_NAME_PREFIX_DEFAULT = "query_";
    public static final String KSQL_TRANSIENT_QUERY_NAME_PREFIX_CONFIG = "ksql.transient.prefix";
    public static final String KSQL_TRANSIENT_QUERY_NAME_PREFIX_DEFAULT = "transient_";
    public static final String KSQL_TABLE_STATESTORE_NAME_SUFFIX_CONFIG = "ksql.statestore.suffix";
    public static final String KSQL_TABLE_STATESTORE_NAME_SUFFIX_DEFAULT = "_ksql_statestore";
    public static final String defaultSchemaRegistryUrl = "http://localhost:8081";
    public static final boolean defaultAvroSchemaUnionNull = true;
    public static final String KSQL_STREAMS_PREFIX = "ksql.streams.";
    public static final String KSQL_DEFAULT_STREAM_CONFIG = "ksql.default.stream";
    private static final String KSQL_DEFAULT_STREAM_DOC = "The stream that is used in case if topic is used without stream name.";
    Map<String, Object> ksqlConfigProps = new HashMap<String, Object>();
    Map<String, Object> ksqlStreamConfigProps = new HashMap<String, Object>();
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("ksql.service.id", ConfigDef.Type.STRING, (Object)"default_", ConfigDef.Importance.MEDIUM, "Indicates the ID of the ksql service. It will be used as prefix for all KSQL queries in this service.").define("ksql.persistent.prefix", ConfigDef.Type.STRING, (Object)"query_", ConfigDef.Importance.MEDIUM, "Second part of the prefix for persitent queries. For instance if the prefix is query_ the query name will be ksql_query_1.").define("ksql.transient.prefix", ConfigDef.Type.STRING, (Object)"transient_", ConfigDef.Importance.MEDIUM, "Second part of the prefix for transient queries. For instance if the prefix is transient_ the query name would be ksql_transient_4120896722607083946_1509389010601 where 'ksql_' is the first prefix and '_transient' is the second part of the prefix for the query id the third and 4th parts are a random long value and the current timestamp. ").define("ksql.statestore.suffix", ConfigDef.Type.STRING, (Object)"_ksql_statestore", ConfigDef.Importance.MEDIUM, "Suffix for state store names in Tables. For instance if the suffix is _ksql_statestore the state store name would be ksql_query_1_ksql_statestore _ksql_statestore ").define("ksql.sink.partitions", ConfigDef.Type.INT, (Object)4, ConfigDef.Importance.MEDIUM, "The default number of partitions for the topics created by KSQL.").define("ksql.sink.replicas", ConfigDef.Type.SHORT, (Object)1, ConfigDef.Importance.MEDIUM, "The default number of replicas for the topics created by KSQL.").define("ksql.sink.window.change.log.additional.retention", ConfigDef.Type.LONG, (Object)1000000L, ConfigDef.Importance.MEDIUM, "The default window change log additional retention time. This is a streams config value which will be added to a windows maintainMs to ensure data is not deleted from the log prematurely. Allows for clock drift. Default is 1 day").define("ksql.schema.registry.url", ConfigDef.Type.STRING, (Object)"http://localhost:8081", ConfigDef.Importance.MEDIUM, "The URL for the schema registry, defaults to http://localhost:8081").define("ksql.default.stream", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "The stream that is used in case if topic is used without stream name.");

    private static Map<String, Object> commonConfigs(Map<String, Object> props) {
        return CommonUtils.getPropertiesWithoutPrefix(KSQL_CONFIG_PROPERTY_PREFIX, props);
    }

    private static Map<String, Object> propertiesWithPrefix(Map<String, Object> props, String prefix) {
        AbstractConfig abstractConfig = new AbstractConfig(new ConfigDef(), props);
        return abstractConfig.originalsWithPrefix(prefix);
    }

    private void applyStreamsConfig(Map<String, Object> props) {
        this.ksqlStreamConfigProps.putAll(KsqlConfig.commonConfigs(props));
        this.ksqlStreamConfigProps.putAll(KsqlConfig.propertiesWithPrefix(props, KSQL_STREAMS_PREFIX));
    }

    public KsqlConfig(Map<?, ?> props) {
        super(CONFIG_DEF, props);
        this.ksqlConfigProps.putAll(this.values());
        this.ksqlConfigProps.put("bootstrap.servers", "localhost:0000");
        this.ksqlStreamConfigProps.put("bootstrap.servers", "localhost:0000");
        this.ksqlStreamConfigProps.put("auto.offset.reset", "latest");
        this.ksqlStreamConfigProps.put("commit.interval.ms", 2000L);
        this.ksqlStreamConfigProps.put("cache.max.bytes.buffering", 10000000L);
        this.ksqlStreamConfigProps.put("num.stream.threads", 4);
        this.ksqlStreamConfigProps.put("streams.default.stream", this.getString(KSQL_DEFAULT_STREAM_CONFIG));
        Object fail = this.originals().get(FAIL_ON_DESERIALIZATION_ERROR_CONFIG);
        if (fail == null || !Boolean.parseBoolean(fail.toString())) {
            this.ksqlStreamConfigProps.put("default.deserialization.exception.handler", LogMetricAndContinueExceptionHandler.class);
        }
        this.applyStreamsConfig(this.originals());
        this.commandsStreamFolder = KSQL_SERVICES_COMMON_FOLDER + this.getString(KSQL_SERVICE_ID_CONFIG) + "/";
        this.commandsStream = this.commandsStreamFolder + "ksql-commands";
    }

    public Map<String, Object> getKsqlConfigProps() {
        return this.ksqlConfigProps;
    }

    public Map<String, Object> getKsqlStreamConfigProps() {
        return this.ksqlStreamConfigProps;
    }

    public Map<String, Object> getKsqlAdminClientConfigProps() {
        Set adminClientConfigProperties = AdminClientConfig.configNames();
        HashMap<String, Object> adminClientConfigs = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.ksqlStreamConfigProps.entrySet()) {
            if (!adminClientConfigProperties.contains(entry.getKey())) continue;
            adminClientConfigs.put(entry.getKey(), entry.getValue());
        }
        return adminClientConfigs;
    }

    public String getKsqlDefaultStream() {
        return this.getString(KSQL_DEFAULT_STREAM_CONFIG);
    }

    public String getCommandsStreamFolder() {
        return this.commandsStreamFolder;
    }

    public String getCommandsStream() {
        return this.commandsStream;
    }

    public Object get(String propertyName) {
        if (propertyName.toLowerCase().startsWith(KSQL_CONFIG_PROPERTY_PREFIX)) {
            return this.ksqlConfigProps.get(propertyName);
        }
        return this.ksqlStreamConfigProps.get(propertyName);
    }

    public void put(String propertyName, Object propertyValue) {
        if (propertyName.toLowerCase().startsWith(KSQL_CONFIG_PROPERTY_PREFIX)) {
            this.ksqlConfigProps.put(propertyName, propertyValue);
        } else if (propertyName.startsWith(KSQL_STREAMS_PREFIX)) {
            this.ksqlStreamConfigProps.put(propertyName.substring(KSQL_STREAMS_PREFIX.length()), propertyValue);
        } else {
            this.ksqlStreamConfigProps.put(propertyName, propertyValue);
        }
    }

    public KsqlConfig clone() {
        HashMap clonedProperties = new HashMap();
        clonedProperties.putAll(this.originals());
        return new KsqlConfig(clonedProperties);
    }

    public KsqlConfig cloneWithPropertyOverwrite(Map<String, Object> props) {
        HashMap<String, Object> clonedProperties = new HashMap<String, Object>();
        clonedProperties.putAll(this.ksqlConfigProps);
        clonedProperties.putAll(this.ksqlStreamConfigProps.entrySet().stream().collect(Collectors.toMap(e -> KSQL_STREAMS_PREFIX + (String)e.getKey(), e -> e.getValue())));
        clonedProperties.putAll(props);
        KsqlConfig clone = new KsqlConfig(clonedProperties);
        clone.applyStreamsConfig(props);
        return clone;
    }
}

