/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.streams.serdes.avro;

import io.confluent.kafka.example.User;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.streams.serdes.avro.SpecificAvroSerde;
import java.util.HashMap;
import org.apache.avro.specific.SpecificRecord;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SpecificAvroSerdeTest {
    private static final String ANY_TOPIC = "any-topic";

    private static <T extends SpecificRecord> SpecificAvroSerde<T> createConfiguredSerdeForRecordValues() {
        MockSchemaRegistryClient schemaRegistryClient = new MockSchemaRegistryClient();
        SpecificAvroSerde serde = new SpecificAvroSerde((SchemaRegistryClient)schemaRegistryClient);
        HashMap<String, String> serdeConfig = new HashMap<String, String>();
        serdeConfig.put("schema.registry.url", "fake");
        serde.configure(serdeConfig, false);
        return serde;
    }

    @Test
    public void shouldRoundTripRecords() {
        SpecificAvroSerde serde = SpecificAvroSerdeTest.createConfiguredSerdeForRecordValues();
        User record = User.newBuilder().setName("alice").build();
        User roundtrippedRecord = (User)((Object)serde.deserializer().deserialize(ANY_TOPIC, serde.serializer().serialize(ANY_TOPIC, (Object)record)));
        Assert.assertThat((Object)((Object)roundtrippedRecord), (Matcher)CoreMatchers.equalTo((Object)((Object)record)));
        serde.close();
    }

    @Test
    public void shouldRoundTripNullRecordsToNull() {
        SpecificAvroSerde serde = SpecificAvroSerdeTest.createConfiguredSerdeForRecordValues();
        User roundtrippedRecord = (User)((Object)serde.deserializer().deserialize(ANY_TOPIC, serde.serializer().serialize(ANY_TOPIC, null)));
        Assert.assertThat((Object)((Object)roundtrippedRecord), (Matcher)CoreMatchers.nullValue());
        serde.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenInstantiatedWithNullSchemaRegistryClient() {
        new SpecificAvroSerde(null);
    }

    @Test
    public void shouldRoundTripRecordsEvenWhenConfiguredToDisableSpecificAvro() {
        SpecificAvroSerde serde = SpecificAvroSerdeTest.createConfiguredSerdeForRecordValues();
        User record = User.newBuilder().setName("alice").build();
        HashMap<String, Object> serdeConfig = new HashMap<String, Object>();
        serdeConfig.put("schema.registry.url", "fake-to-satisfy-checks");
        serdeConfig.put("specific.avro.reader", false);
        serde.configure(serdeConfig, true);
        User roundtrippedRecordForKeySerde = (User)((Object)serde.deserializer().deserialize(ANY_TOPIC, serde.serializer().serialize(ANY_TOPIC, (Object)record)));
        Assert.assertThat((Object)((Object)roundtrippedRecordForKeySerde), (Matcher)CoreMatchers.equalTo((Object)((Object)record)));
        serde.configure(serdeConfig, true);
        User roundtrippedRecordForValueSerde = (User)((Object)serde.deserializer().deserialize(ANY_TOPIC, serde.serializer().serialize(ANY_TOPIC, (Object)record)));
        Assert.assertThat((Object)((Object)roundtrippedRecordForValueSerde), (Matcher)CoreMatchers.equalTo((Object)((Object)record)));
        serde.close();
    }
}

