/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class RestApiMetadataEncoderTest
extends ClusterTestHarness {
    private static String SCHEMA_STRING = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();

    public RestApiMetadataEncoderTest() {
        super(1, true, CompatibilityLevel.BACKWARD.name);
    }

    @Test
    public void testRegisterSchemaWithSensitiveMetadata() throws Exception {
        String subject = "testSubject";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("nonsensitive", "foo");
        properties.put("sensitive", "foo");
        Metadata metadata = new Metadata(null, properties, Collections.singleton("sensitive"));
        Schema schema = new Schema(subject, null, null, null, null, metadata, null, SCHEMA_STRING);
        RegisterSchemaRequest request = new RegisterSchemaRequest(schema);
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering without id should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(request, subject, false).getId());
        SchemaString schemaString = this.restApp.restClient.getId(expectedIdSchema1);
        Assert.assertEquals(properties, (Object)schemaString.getMetadata().getProperties());
    }
}

