/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.filter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import io.confluent.kafka.schemaregistry.filter.AuthorizationFilter;
import io.confluent.kafka.schemaregistry.filter.AuthorizationTestResource;
import io.confluent.kafka.schemaregistry.filter.Permission;
import io.confluent.kafka.schemaregistry.util.ByteConsumerPool;
import io.confluent.kafka.schemaregistry.util.ByteProducerPool;
import io.confluent.kafka.schemaregistry.util.MaprFSUtils;
import io.confluent.kafka.schemaregistry.utils.UserGroupInformationMockPolicy;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.glassfish.jersey.server.ContainerRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.MockPolicy;
import org.powermock.core.classloader.annotations.PrepareOnlyThisForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@MockPolicy(value={UserGroupInformationMockPolicy.class})
@PrepareOnlyThisForTest(value={MaprFSUtils.class})
public class AuthorizationFilterTest
extends EasyMockSupport {
    private static final String AUXILIARY_TOPIC = "/any-internal-topic:aux-topic";
    private static final String IMPERSONATED_USER = "user";
    private static final String ADMIN_USER = System.getProperty("user.name");
    private ByteConsumerPool byteConsumerPool;
    private ByteProducerPool byteProducerPool;
    private AuthorizationFilter authorizationFilter;

    @Before
    public void setUp() {
        this.byteConsumerPool = (ByteConsumerPool)this.mock(ByteConsumerPool.class);
        this.byteProducerPool = (ByteProducerPool)this.mock(ByteProducerPool.class);
        this.authorizationFilter = new AuthorizationFilter(this.byteConsumerPool, this.byteProducerPool, AUXILIARY_TOPIC);
    }

    @Test
    public void dummyRecordIsSent() {
        this.expectUserSendsRecordToAuxiliaryTopicSucceeds(ADMIN_USER);
        this.replayAll();
        this.authorizationFilter.initialize();
        this.verifyAll();
    }

    @Test
    public void handlesFutureExecutionExceptionOnInitialization() {
        RuntimeException exception = new RuntimeException();
        EasyMock.expect((Object)this.byteProducerPool.send(new ProducerRecord(AUXILIARY_TOPIC, (Object)((byte[])EasyMock.anyObject(byte[].class))))).andReturn((Object)Futures.immediateFailedFuture((Throwable)exception));
        this.replayAll();
        try {
            this.authorizationFilter.initialize();
            Assert.fail((String)"No exception was thrown");
        }
        catch (KafkaException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(ExecutionException.class));
            Assert.assertThat((Object)e.getCause().getCause(), (Matcher)CoreMatchers.is((Object)exception));
        }
        this.verifyAll();
    }

    @Test
    public void unauthenticatedRequestIsForbidden() {
        ContainerRequest request = (ContainerRequest)this.mock(ContainerRequest.class);
        EasyMock.expect((Object)request.getSecurityContext()).andStubReturn(null);
        Capture capturedResponse = Capture.newInstance();
        this.expectAbortWith(request, (Response)EasyMock.capture((Capture)capturedResponse));
        this.replayAll();
        this.authorizationFilter.filter((ContainerRequestContext)request);
        this.verifyAll();
        Assert.assertThat((Object)((Response)capturedResponse.getValue()).getStatusInfo().toEnum(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN));
    }

    @Test
    public void authenticatedRequestSucceeds() {
        ContainerRequest request = this.createAuthenticatedRequest();
        this.authorizationFilter.resourceInfo = AuthorizationTestResource.resourceInfo(Permission.READ);
        this.expectUserPollsRecordsToAuxiliaryTopicSucceeds(IMPERSONATED_USER);
        this.replayAll();
        this.authorizationFilter.filter((ContainerRequestContext)request);
        this.verifyAll();
    }

    @Test
    public void writeCommandIsForbiddenWithoutWritePermission() {
        ContainerRequest request = this.createAuthenticatedRequest();
        this.authorizationFilter.resourceInfo = AuthorizationTestResource.resourceInfo(Permission.MODIFY);
        Capture captured = Capture.newInstance();
        this.expectAbortWith(request, (Response)EasyMock.capture((Capture)captured));
        this.expectUserSendsRecordToAuxiliaryTopicFails(IMPERSONATED_USER);
        this.replayAll();
        this.authorizationFilter.filter((ContainerRequestContext)request);
        this.verifyAll();
        Assert.assertThat((Object)((Response)captured.getValue()).getStatusInfo().toEnum(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN));
        Assert.assertThat((Object)((Response)captured.getValue()).getEntity().toString(), (Matcher)CoreMatchers.containsString((String)"denied"));
    }

    @Test
    public void writeCommandSucceedsWithWritePermission() {
        ContainerRequest request = this.createAuthenticatedRequest();
        this.authorizationFilter.resourceInfo = AuthorizationTestResource.resourceInfo(Permission.MODIFY);
        this.expectUserSendsRecordToAuxiliaryTopicSucceeds(IMPERSONATED_USER);
        this.replayAll();
        this.authorizationFilter.filter((ContainerRequestContext)request);
        this.verifyAll();
    }

    @Test
    public void readCommandIsForbiddenWithoutReadPermission() {
        ContainerRequest request = this.createAuthenticatedRequest();
        this.authorizationFilter.resourceInfo = AuthorizationTestResource.resourceInfo(Permission.READ);
        Capture captured = Capture.newInstance();
        this.expectAbortWith(request, (Response)EasyMock.capture((Capture)captured));
        this.expectUserPollsRecordsToAuxiliaryTopicFails(IMPERSONATED_USER);
        this.replayAll();
        this.authorizationFilter.filter((ContainerRequestContext)request);
        this.verifyAll();
        Assert.assertThat((Object)((Response)captured.getValue()).getStatusInfo().toEnum(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN));
        Assert.assertThat((Object)((Response)captured.getValue()).getEntity().toString(), (Matcher)CoreMatchers.containsString((String)"denied"));
    }

    @Test
    public void readCommandSucceedsWithReadPermission() {
        ContainerRequest request = this.createAuthenticatedRequest();
        this.authorizationFilter.resourceInfo = AuthorizationTestResource.resourceInfo(Permission.READ);
        this.expectUserPollsRecordsToAuxiliaryTopicSucceeds(IMPERSONATED_USER);
        this.replayAll();
        this.authorizationFilter.filter((ContainerRequestContext)request);
        this.verifyAll();
    }

    @Test
    public void readCommandIsForbiddenOnEmptyRecordsWithReadPermission() {
        ContainerRequest request = this.createAuthenticatedRequest();
        this.authorizationFilter.resourceInfo = AuthorizationTestResource.resourceInfo(Permission.READ);
        Capture captured = Capture.newInstance();
        this.expectAbortWith(request, (Response)EasyMock.capture((Capture)captured));
        EasyMock.expect((Object)this.byteConsumerPool.poll(AUXILIARY_TOPIC)).andAnswer(() -> {
            this.assertUserIs(IMPERSONATED_USER);
            return new ConsumerRecords((Map)ImmutableMap.of());
        });
        this.replayAll();
        this.authorizationFilter.filter((ContainerRequestContext)request);
        this.verifyAll();
        Assert.assertThat((Object)((Response)captured.getValue()).getStatusInfo().toEnum(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN));
        Assert.assertThat((Object)((Response)captured.getValue()).getEntity().toString(), (Matcher)CoreMatchers.containsString((String)"denied"));
    }

    @Test
    public void otherCommandsSucceedWithoutAnyPermissions() {
        ContainerRequest request = this.createAuthenticatedRequest();
        this.authorizationFilter.resourceInfo = AuthorizationTestResource.resourceInfo(Permission.NONE);
        this.replayAll();
        this.authorizationFilter.filter((ContainerRequestContext)request);
        this.verifyAll();
    }

    private ContainerRequest createAuthenticatedRequest() {
        Principal principal = (Principal)this.mock(Principal.class);
        EasyMock.expect((Object)principal.getName()).andReturn((Object)IMPERSONATED_USER);
        SecurityContext securityContext = (SecurityContext)this.mock(SecurityContext.class);
        EasyMock.expect((Object)securityContext.getUserPrincipal()).andReturn((Object)principal);
        ContainerRequest request = (ContainerRequest)this.mock(ContainerRequest.class);
        EasyMock.expect((Object)request.getSecurityContext()).andReturn((Object)securityContext);
        return request;
    }

    private void expectAbortWith(ContainerRequest request, Response response) {
        request.abortWith(response);
        EasyMock.expectLastCall().once();
    }

    private void expectUserSendsRecordToAuxiliaryTopicSucceeds(String user) {
        EasyMock.expect((Object)this.byteProducerPool.send(new ProducerRecord(AUXILIARY_TOPIC, (Object)((byte[])EasyMock.anyObject(byte[].class))))).andAnswer(() -> {
            this.assertUserIs(user);
            TopicPartition partition = new TopicPartition(AUXILIARY_TOPIC, 1);
            return CompletableFuture.completedFuture(new RecordMetadata(partition, 0L, 0, -1L, -1, -1));
        });
    }

    private void expectUserSendsRecordToAuxiliaryTopicFails(String user) {
        EasyMock.expect((Object)this.byteProducerPool.send(new ProducerRecord(AUXILIARY_TOPIC, (Object)((byte[])EasyMock.anyObject(byte[].class))))).andAnswer(() -> {
            this.assertUserIs(user);
            return CompletableFuture.supplyAsync(() -> {
                throw new RuntimeException();
            });
        });
    }

    private void expectUserPollsRecordsToAuxiliaryTopicSucceeds(String user) {
        EasyMock.expect((Object)this.byteConsumerPool.poll(AUXILIARY_TOPIC)).andAnswer(() -> {
            this.assertUserIs(user);
            return new ConsumerRecords((Map)ImmutableMap.of((Object)new TopicPartition("topic", 0), (Object)ImmutableList.of((Object)new ConsumerRecord("topic", 0, 0L, (Object)"key".getBytes(), (Object)"value".getBytes()))));
        });
    }

    private void expectUserPollsRecordsToAuxiliaryTopicFails(String user) {
        EasyMock.expect((Object)this.byteConsumerPool.poll(AUXILIARY_TOPIC)).andAnswer(() -> {
            this.assertUserIs(user);
            throw new ExecutionException(new RuntimeException());
        });
    }

    private void assertUserIs(String user) throws IOException {
        String actualUser = UserGroupInformation.getCurrentUser().getUserName();
        String msg = String.format("Expected user is %s while actual is %s", user, actualUser);
        Assert.assertEquals((String)msg, (Object)user, (Object)actualUser);
    }
}

