/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class SchemaIdAndSubjects {
    private int id;
    private Map<String, Integer> subjectsAndVersions;

    public SchemaIdAndSubjects(int id) {
        this.subjectsAndVersions = new ConcurrentHashMap<String, Integer>();
        this.id = id;
    }

    public SchemaIdAndSubjects(int id, Map<String, Integer> subjectsAndVersions) {
        this.subjectsAndVersions = subjectsAndVersions;
        this.id = id;
    }

    public void addSubjectAndVersion(String subject, int version) {
        this.subjectsAndVersions.put(subject, version);
    }

    public boolean hasSubject(String subject) {
        return this.subjectsAndVersions.keySet().contains(subject);
    }

    public int getVersion(String subject) {
        return this.subjectsAndVersions.get(subject);
    }

    public int getSchemaId() {
        return this.id;
    }

    public boolean isEmpty() {
        return this.subjectsAndVersions.isEmpty();
    }

    public SchemaKey findAny(Predicate<SchemaKey> filter) {
        return this.subjectsAndVersions.entrySet().stream().map(e -> new SchemaKey((String)e.getKey(), (Integer)e.getValue())).filter(key -> filter.test((SchemaKey)key)).findAny().orElse(null);
    }

    public Set<String> allSubjects() {
        return this.subjectsAndVersions.keySet();
    }

    public Map<String, Integer> allSubjectVersions() {
        return this.subjectsAndVersions;
    }

    public void removeIf(Predicate<SchemaKey> filter) {
        this.subjectsAndVersions.entrySet().removeIf((? super E e) -> filter.test(new SchemaKey((String)e.getKey(), (Integer)e.getValue())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaIdAndSubjects that = (SchemaIdAndSubjects)o;
        if (this.id != that.id) {
            return false;
        }
        return this.subjectsAndVersions.equals(that.subjectsAndVersions);
    }

    public int hashCode() {
        int result = 31 * this.id;
        result = 31 * result + this.subjectsAndVersions.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id=" + this.id + ",");
        sb.append("subjectsAndVersions=" + this.subjectsAndVersions.toString() + "}");
        return sb.toString();
    }
}

