/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.annotations.Schema;
import io.confluent.kafka.schemaregistry.annotations.SchemaReference;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class RestApiTest
extends ClusterTestHarness {
    private static final Random random = new Random();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public RestApiTest() {
        super(1, true);
    }

    @Override
    protected Properties getSchemaRegistryProperties() {
        Properties props = new Properties();
        props.setProperty("schema.providers", JsonSchemaProvider.class.getName());
        return props;
    }

    @Test
    public void testBasic() throws Exception {
        int i;
        String subject1 = "testTopic1";
        String subject2 = "testTopic2";
        int schemasInSubject1 = 10;
        ArrayList<Integer> allVersionsInSubject1 = new ArrayList<Integer>();
        List<String> allSchemasInSubject1 = RestApiTest.getRandomJsonSchemas(schemasInSubject1);
        int schemasInSubject2 = 5;
        ArrayList<Integer> allVersionsInSubject2 = new ArrayList<Integer>();
        List<String> allSchemasInSubject2 = RestApiTest.getRandomJsonSchemas(schemasInSubject2);
        ArrayList<String> allSubjects = new ArrayList<String>();
        Assert.assertEquals((String)"Getting all subjects should return empty", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
        int schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject1; ++i) {
            String schema = allSchemasInSubject1.get(i);
            int expectedVersion = i + 1;
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject1);
            ++schemaIdCounter;
            allVersionsInSubject1.add(expectedVersion);
        }
        allSubjects.add(subject1);
        for (i = 0; i < schemasInSubject1; ++i) {
            int expectedId = i + 1;
            String schemaString = allSchemasInSubject1.get(i);
            int foundId = this.restApp.restClient.registerSchema(schemaString, "JSON", Collections.emptyList(), subject1).getId();
            Assert.assertEquals((String)"Re-registering an existing schema should return the existing version", (long)expectedId, (long)foundId);
        }
        for (i = 0; i < schemasInSubject2; ++i) {
            String schema = allSchemasInSubject2.get(i);
            int expectedVersion = i + 1;
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject2);
            ++schemaIdCounter;
            allVersionsInSubject2.add(expectedVersion);
        }
        allSubjects.add(subject2);
        Assert.assertEquals((String)"Getting all versions from subject1 should match all registered versions", allVersionsInSubject1, (Object)this.restApp.restClient.getAllVersions(subject1));
        Assert.assertEquals((String)"Getting all versions from subject2 should match all registered versions", allVersionsInSubject2, (Object)this.restApp.restClient.getAllVersions(subject2));
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
    }

    @Test
    public void testSchemaReferences() throws Exception {
        Map<String, String> schemas = RestApiTest.getJsonSchemaWithReferences();
        String subject = "reference";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, schemas.get("ref.json"), 1, subject);
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemas.get("main.json"));
        request.setSchemaType("JSON");
        io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference ref = new io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference("ref.json", "reference", Integer.valueOf(1));
        request.setReferences(Collections.singletonList(ref));
        int registeredId = this.restApp.restClient.registerSchema(request, "referrer", false).getId();
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)2L, (long)registeredId);
        SchemaString schemaString = this.restApp.restClient.getId(2);
        Assert.assertEquals((String)"Registered schema should be found", (Object)MAPPER.readTree(schemas.get("main.json")), (Object)MAPPER.readTree(schemaString.getSchemaString()));
        Assert.assertEquals((String)"Schema references should be found", Collections.singletonList(ref), (Object)schemaString.getReferences());
        List refs = this.restApp.restClient.getReferencedBy("reference", 1);
        Assert.assertEquals((long)2L, (long)((Integer)refs.get(0)).intValue());
        CachedSchemaRegistryClient schemaRegistryClient = new CachedSchemaRegistryClient(this.restApp.restClient, 10, Collections.singletonList(new JsonSchemaProvider()), new HashMap(), null);
        SchemaHolder holder = new SchemaHolder();
        JsonSchema schema = JsonSchemaUtils.getSchema((Object)holder, (SchemaRegistryClient)schemaRegistryClient);
        io.confluent.kafka.schemaregistry.client.rest.entities.Schema registeredSchema = this.restApp.restClient.lookUpSubjectVersion(schema.canonicalString(), "JSON", schema.references(), "referrer", false);
        Assert.assertEquals((String)"Registered schema should be found", (long)2L, (long)registeredSchema.getId().intValue());
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, "reference", String.valueOf(1));
            Assert.fail((String)"Deleting reference should fail with 42206");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Reference found", (long)42206L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, "referrer", "1"));
        refs = this.restApp.restClient.getReferencedBy("reference", 1);
        Assert.assertTrue((boolean)refs.isEmpty());
        Assert.assertEquals((Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, "reference", "1"));
    }

    @Test(expected=RestClientException.class)
    public void testSchemaMissingReferences() throws Exception {
        Map<String, String> schemas = RestApiTest.getJsonSchemaWithReferences();
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemas.get("main.json"));
        request.setSchemaType("JSON");
        request.setReferences(Collections.emptyList());
        this.restApp.restClient.registerSchema(request, "referrer", false);
    }

    @Test
    public void testSchemaNormalization() throws Exception {
        String subject1 = "testSubject1";
        String reference1 = "{\"type\":\"object\",\"additionalProperties\":false,\"definitions\":{\"ExternalType\":{\"type\":\"object\",\"properties\":{\"name\":{\"type\":\"string\"}},\"additionalProperties\":false}}}";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, reference1, 1, "ref1");
        String reference2 = "{\"type\":\"object\",\"additionalProperties\":false,\"definitions\":{\"ExternalType2\":{\"type\":\"object\",\"properties\":{\"name2\":{\"type\":\"string\"}},\"additionalProperties\":false}}}";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, reference2, 2, "ref2");
        io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference ref1 = new io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference("ref1.json", "ref1", Integer.valueOf(1));
        io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference ref2 = new io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference("ref2.json", "ref2", Integer.valueOf(1));
        String schemaString1 = "{\"$id\": \"https://acme.com/referrer.json\",\"$schema\": \"http://json-schema.org/draft-07/schema#\",\"type\":\"object\",\"properties\":{\"Ref1\": {\"$ref\":\"ref1.json#/definitions/ExternalType\"},\"Ref2\": {\"$ref\":\"ref2.json#/definitions/ExternalType2\"}},\"additionalProperties\":false}";
        String schemaString2 = "{\"$schema\": \"http://json-schema.org/draft-07/schema#\",\"$id\": \"https://acme.com/referrer.json\",\"type\":\"object\",\"properties\":{\"Ref2\": {\"$ref\":\"ref2.json#/definitions/ExternalType2\"},\"Ref1\": {\"$ref\":\"ref1.json#/definitions/ExternalType\"}},\"additionalProperties\":false}";
        RegisterSchemaRequest registerRequest = new RegisterSchemaRequest();
        registerRequest.setSchema(schemaString1);
        registerRequest.setSchemaType("JSON");
        registerRequest.setReferences(Arrays.asList(ref1, ref2));
        int idOfRegisteredSchema1Subject1 = this.restApp.restClient.registerSchema(registerRequest, subject1, true).getId();
        RegisterSchemaRequest lookUpRequest = new RegisterSchemaRequest();
        lookUpRequest.setSchema(schemaString2);
        lookUpRequest.setSchemaType("JSON");
        lookUpRequest.setReferences(Arrays.asList(ref2, ref1));
        int versionOfRegisteredSchema1Subject1 = this.restApp.restClient.lookUpSubjectVersion(lookUpRequest, subject1, true, false).getVersion();
        Assert.assertEquals((String)"1st schema under subject1 should have version 1", (long)1L, (long)versionOfRegisteredSchema1Subject1);
        Assert.assertEquals((String)"1st schema registered globally should have id 3", (long)3L, (long)idOfRegisteredSchema1Subject1);
    }

    @Test
    public void testBad() throws Exception {
        String subject1 = "testTopic1";
        ArrayList allSubjects = new ArrayList();
        Assert.assertEquals((String)"Getting all subjects should return empty", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
        try {
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, RestApiTest.getBadSchema(), 1, subject1);
            Assert.fail((String)"Registering bad schema should fail with 42201");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
        try {
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, RestApiTest.getRandomJsonSchemas(1).get(0), Arrays.asList(new io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference("bad", "bad", Integer.valueOf(100))), 1, subject1);
            Assert.fail((String)"Registering bad reference should fail with 42201");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
    }

    @Test
    public void testIncompatibleSchema() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"$schema\": \"http://json-schema.org/draft-07/schema#\",\"$id\": \"https://acme.com/referrer.json\",\"type\":\"object\",\"properties\":{\"myField1\": {\"type\":\"string\"},\"myField2\": {\"type\":\"number\"}},\"additionalProperties\":false}";
        RegisterSchemaRequest registerRequest = new RegisterSchemaRequest();
        registerRequest.setSchema(schema1String);
        registerRequest.setSchemaType("JSON");
        String schema2String = "{\"$schema\": \"http://json-schema.org/draft-07/schema#\",\"$id\": \"https://acme.com/referrer.json\",\"type\":\"object\",\"properties\":{\"myField1\": {\"type\":\"string\"},\"myField2\": {\"type\":\"string\"}},\"additionalProperties\":false}";
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FULL.name, subject);
        int idOfRegisteredSchema1Subject1 = this.restApp.restClient.registerSchema(registerRequest, subject, true).getId();
        try {
            registerRequest.setSchema(schema2String);
            registerRequest.setSchemaType("JSON");
            this.restApp.restClient.registerSchema(registerRequest, subject, true);
            Assert.fail((String)("Registering incompatible schema should fail with " + Errors.INCOMPATIBLE_SCHEMA_ERROR_CODE));
        }
        catch (RestClientException e) {
            Assert.assertTrue((e.getMessage().length() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)e.getMessage().contains("oldSchemaVersion:"));
            Assert.assertTrue((boolean)e.getMessage().contains("oldSchema:"));
            Assert.assertTrue((boolean)e.getMessage().contains("compatibility:"));
        }
        List response = this.restApp.restClient.testCompatibility(registerRequest, subject, String.valueOf(idOfRegisteredSchema1Subject1), false, true);
        Assert.assertTrue((response.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)response.get(2)).contains("oldSchemaVersion:"));
        Assert.assertTrue((boolean)((String)response.get(3)).contains("oldSchema:"));
        Assert.assertTrue((boolean)((String)response.get(4)).contains("compatibility:"));
    }

    public static void registerAndVerifySchema(RestService restService, String schemaString, int expectedId, String subject) throws IOException, RestClientException {
        RestApiTest.registerAndVerifySchema(restService, schemaString, Collections.emptyList(), expectedId, subject);
    }

    public static void registerAndVerifySchema(RestService restService, String schemaString, List<io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference> references, int expectedId, String subject) throws IOException, RestClientException {
        int registeredId = restService.registerSchema(schemaString, "JSON", references, subject).getId();
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)expectedId, (long)registeredId);
        Assert.assertEquals((String)"Registered schema should be found", (Object)MAPPER.readTree(schemaString), (Object)MAPPER.readTree(restService.getId(expectedId).getSchemaString()));
    }

    public static List<String> getRandomJsonSchemas(int num) {
        ArrayList<String> schemas = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            String schema = "{\"type\":\"object\",\"properties\":{\"f" + random.nextInt(Integer.MAX_VALUE) + "\":{\"type\":\"string\"}},\"additionalProperties\":false}";
            schemas.add(schema);
        }
        return schemas;
    }

    public static Map<String, String> getJsonSchemaWithReferences() {
        HashMap<String, String> schemas = new HashMap<String, String>();
        String reference = "{\"type\":\"object\",\"additionalProperties\":false,\"definitions\":{\"ExternalType\":{\"type\":\"object\",\"properties\":{\"name\":{\"type\":\"string\"}},\"additionalProperties\":false}}}";
        schemas.put("ref.json", new JsonSchema(reference).canonicalString());
        String schemaString = "{\"$id\": \"https://acme.com/referrer.json\",\"$schema\": \"http://json-schema.org/draft-07/schema#\",\"type\":\"object\",\"properties\":{\"Ref\":{\"$ref\":\"ref.json#/definitions/ExternalType\"}},\"additionalProperties\":false}";
        schemas.put("main.json", schemaString);
        return schemas;
    }

    public static String getBadSchema() {
        String schema = "{\"type\":\"bad-object\",\"properties\":{\"f" + random.nextInt(Integer.MAX_VALUE) + "\":{\"type\":\"string\"}},\"additionalProperties\":false}";
        return schema;
    }

    @Schema(value="{\"$id\": \"https://acme.com/referrer.json\",\"$schema\": \"http://json-schema.org/draft-07/schema#\",\"type\":\"object\",\"properties\":{\"Ref\":{\"$ref\":\"ref.json#/definitions/ExternalType\"}},\"additionalProperties\":false}", refs={@SchemaReference(name="ref.json", subject="reference")})
    static class SchemaHolder {
        SchemaHolder() {
        }
    }
}

