/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.rest.exceptions.RestIncompatibleSchemaException;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.RuleSetHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.SchemaCompatibility;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RestApiCompatibilityTest
extends ClusterTestHarness {
    public RestApiCompatibilityTest() {
        super(1, true, CompatibilityLevel.BACKWARD.name);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ((KafkaSchemaRegistry)this.restApp.schemaRegistry()).setRuleSetHandler(new RuleSetHandler(){

            public void handle(String subject, ConfigUpdateRequest request) {
            }

            public void handle(String subject, boolean normalize, RegisterSchemaRequest request) {
            }

            public io.confluent.kafka.schemaregistry.storage.RuleSet transform(RuleSet ruleSet) {
                return ruleSet != null ? new io.confluent.kafka.schemaregistry.storage.RuleSet(ruleSet) : null;
            }
        });
    }

    @Test
    public void testCompatibility() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(schemaString1, subject));
        String incompatibleSchemaString = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}").canonicalString();
        try {
            this.restApp.restClient.registerSchema(incompatibleSchemaString, subject);
            Assert.fail((String)"Registering an incompatible schema should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a conflict status", (long)RestIncompatibleSchemaException.DEFAULT_ERROR_CODE, (long)e.getStatus());
            Assert.assertTrue((String)"Verifying error message verbosity", (boolean)e.getMessage().contains(SchemaCompatibility.SchemaIncompatibilityType.READER_FIELD_MISSING_DEFAULT_VALUE.toString()));
        }
        String nonAvroSchemaString = "non-avro schema string";
        try {
            this.restApp.restClient.registerSchema(nonAvroSchemaString, subject);
            Assert.fail((String)"Registering a non-avro schema should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a bad request status", (long)42201L, (long)e.getErrorCode());
        }
        String schemaString2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}").canonicalString();
        int expectedIdSchema2 = 2;
        Assert.assertEquals((String)"Registering a compatible schema should succeed", (long)expectedIdSchema2, (long)this.restApp.restClient.registerSchema(schemaString2, subject));
    }

    @Test
    public void testCompatibilityLevelChangeToNone() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(schemaString1, subject));
        String incompatibleSchemaString = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}").canonicalString();
        try {
            this.restApp.restClient.registerSchema(incompatibleSchemaString, subject);
            Assert.fail((String)"Registering an incompatible schema should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a conflict status", (long)RestIncompatibleSchemaException.DEFAULT_ERROR_CODE, (long)e.getStatus());
        }
        Assert.assertEquals((String)"Changing compatibility level should succeed", (Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, null).getCompatibilityLevel());
        try {
            this.restApp.restClient.registerSchema(incompatibleSchemaString, subject);
        }
        catch (RestClientException e) {
            Assert.fail((String)"Registering an incompatible schema should succeed after bumping down the compatibility level to none");
        }
    }

    @Test
    public void testCompatibilityLevelChangeToBackward() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(schemaString1, subject));
        Assert.assertEquals((String)"Default compatibility level should be backward", (Object)new Config(CompatibilityLevel.BACKWARD.name), (Object)this.restApp.restClient.getConfig(null));
        Assert.assertEquals((String)"Changing compatibility level should succeed", (Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, null).getCompatibilityLevel());
        Assert.assertEquals((String)"New compatibility level should be forward", (Object)new Config(CompatibilityLevel.FORWARD.name), (Object)this.restApp.restClient.getConfig(null));
        String schemaString2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}").canonicalString();
        int expectedIdSchema2 = 2;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema2, (long)this.restApp.restClient.registerSchema(schemaString2, subject));
        Assert.assertEquals((String)"Changing compatibility level should succeed", (Object)CompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.updateCompatibility(CompatibilityLevel.BACKWARD.name, null).getCompatibilityLevel());
        Assert.assertEquals((String)"Updated compatibility level should be backward", (Object)new Config(CompatibilityLevel.BACKWARD.name), (Object)this.restApp.restClient.getConfig(null));
        String schemaString3 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}, {\"type\":\"string\",\"name\":\"f3\"}]}").canonicalString();
        try {
            this.restApp.restClient.registerSchema(schemaString3, subject);
            Assert.fail((String)"Registering a forward compatible schema should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a conflict status", (long)RestIncompatibleSchemaException.DEFAULT_ERROR_CODE, (long)e.getStatus());
        }
        String schemaString4 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}, {\"type\":\"string\",\"name\":\"f3\", \"default\": \"foo\"}]}").canonicalString();
        int expectedIdSchema4 = 3;
        Assert.assertEquals((String)"Registering should succeed with backwards compatible schema", (long)expectedIdSchema4, (long)this.restApp.restClient.registerSchema(schemaString4, subject));
    }

    @Test
    public void testCompatibilityGroup() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setCompatibilityGroup("application.version");
        config.setValidateFields(Boolean.valueOf(false));
        Assert.assertEquals((String)"Adding compatibility group should succeed", (Object)config, (Object)this.restApp.restClient.updateConfig(config, null));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("application.version", "1");
        Metadata metadata1 = new Metadata(null, properties, null);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setMetadata(metadata1);
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(request1, subject, false).getId());
        Assert.assertEquals((String)"Default compatibility level should be backward", (Object)CompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        AvroSchema schema2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}");
        RegisterSchemaRequest request2 = new RegisterSchemaRequest((ParsedSchema)schema2);
        try {
            this.restApp.restClient.registerSchema(request2, subject, false);
            Assert.fail((String)"Registering a forward compatible schema should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a conflict status", (long)RestIncompatibleSchemaException.DEFAULT_ERROR_CODE, (long)e.getStatus());
        }
        properties = new HashMap();
        properties.put("application.version", "2");
        Metadata metadata2 = new Metadata(null, properties, null);
        request2.setMetadata(metadata2);
        int expectedIdSchema2 = 2;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema2, (long)this.restApp.restClient.registerSchema(request2, subject, false).getId());
    }

    @Test
    public void testAddCompatibilityGroup() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        HashMap<String, String> properties = new HashMap<String, String>();
        Metadata metadata1 = new Metadata(null, properties, null);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setMetadata(metadata1);
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(request1, subject, false).getId());
        Assert.assertEquals((String)"Default compatibility level should be backward", (Object)CompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        AvroSchema schema2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}");
        RegisterSchemaRequest request2 = new RegisterSchemaRequest((ParsedSchema)schema2);
        try {
            this.restApp.restClient.registerSchema(request2, subject, false);
            Assert.fail((String)"Registering a forward compatible schema should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a conflict status", (long)RestIncompatibleSchemaException.DEFAULT_ERROR_CODE, (long)e.getStatus());
        }
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setCompatibilityGroup("application.version");
        config.setValidateFields(Boolean.valueOf(false));
        Assert.assertEquals((String)"Adding compatibility group should succeed", (Object)config, (Object)this.restApp.restClient.updateConfig(config, null));
        properties = new HashMap();
        properties.put("application.version", "2");
        Metadata metadata2 = new Metadata(null, properties, null);
        request2.setMetadata(metadata2);
        int expectedIdSchema2 = 2;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema2, (long)this.restApp.restClient.registerSchema(request2, subject, false).getId());
        AvroSchema schema3 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":[\"null\", \"int\"],\"name\":\"f2\",\"default\":null}]}");
        properties = new HashMap();
        Metadata metadata3 = new Metadata(null, properties, null);
        RegisterSchemaRequest request3 = new RegisterSchemaRequest((ParsedSchema)schema3);
        request3.setMetadata(metadata3);
        int expectedIdSchema3 = 3;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema3, (long)this.restApp.restClient.registerSchema(request3, subject, false).getId());
    }

    @Test
    public void testConfigMetadata() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("configKey", "configValue");
        Metadata metadata = new Metadata(null, properties, null);
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setDefaultMetadata(metadata);
        config.setValidateFields(Boolean.valueOf(false));
        Assert.assertEquals((String)"Adding config with initial metadata should succeed", (Object)config, (Object)this.restApp.restClient.updateConfig(config, null));
        properties = new HashMap();
        properties.put("subjectKey", "subjectValue");
        Metadata metadata1 = new Metadata(null, properties, null);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setMetadata(metadata1);
        int expectedIdSchema1 = 1;
        RegisterSchemaResponse response = this.restApp.restClient.registerSchema(request1, subject, false);
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)response.getId());
        Metadata metadata2 = response.getMetadata();
        Assert.assertEquals((Object)"configValue", metadata2.getProperties().get("configKey"));
        Assert.assertEquals((Object)"subjectValue", metadata2.getProperties().get("subjectKey"));
        Assert.assertEquals((String)"Version should match", (Object)response.getVersion(), (Object)this.restApp.restClient.lookUpSubjectVersion(new RegisterSchemaRequest(new Schema(subject, response)), subject, false, false).getVersion());
        Assert.assertEquals((String)"Default compatibility level should be backward", (Object)CompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        Assert.assertEquals((String)"Changing compatibility level should succeed", (Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, null).getCompatibilityLevel());
        Assert.assertEquals((String)"New compatibility level should be forward", (Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        AvroSchema schema2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}");
        RegisterSchemaRequest request2 = new RegisterSchemaRequest((ParsedSchema)schema2);
        int expectedIdSchema2 = 2;
        response = this.restApp.restClient.registerSchema(request2, subject, false);
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema2, (long)response.getId());
        metadata2 = response.getMetadata();
        Assert.assertEquals((Object)"configValue", metadata2.getProperties().get("configKey"));
        Assert.assertEquals((Object)"subjectValue", metadata2.getProperties().get("subjectKey"));
        Assert.assertEquals((String)"Version should match", (Object)response.getVersion(), (Object)this.restApp.restClient.lookUpSubjectVersion(new RegisterSchemaRequest(new Schema(subject, response)), subject, false, false).getVersion());
        SchemaString schemaString = this.restApp.restClient.getId(expectedIdSchema2, subject);
        metadata2 = schemaString.getMetadata();
        Assert.assertEquals((Object)"configValue", metadata2.getProperties().get("configKey"));
        Assert.assertEquals((Object)"subjectValue", metadata2.getProperties().get("subjectKey"));
        response = this.restApp.restClient.registerSchema(request2, subject, false);
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema2, (long)response.getId());
        metadata2 = response.getMetadata();
        Assert.assertEquals((Object)"configValue", metadata2.getProperties().get("configKey"));
        Assert.assertEquals((Object)"subjectValue", metadata2.getProperties().get("subjectKey"));
        AvroSchema schema3 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}, {\"type\":\"string\",\"name\":\"f3\"}]}");
        properties = new HashMap();
        properties.put("newSubjectKey", "newSubjectValue");
        Metadata metadata3 = new Metadata(null, properties, null);
        RegisterSchemaRequest request3 = new RegisterSchemaRequest((ParsedSchema)schema3);
        request3.setMetadata(metadata3);
        int expectedIdSchema3 = 3;
        response = this.restApp.restClient.registerSchema(request3, subject, false);
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema3, (long)response.getId());
        Metadata metadata4 = response.getMetadata();
        Assert.assertEquals((Object)"configValue", metadata4.getProperties().get("configKey"));
        Assert.assertNull(metadata4.getProperties().get("subjectKey"));
        Assert.assertEquals((Object)"newSubjectValue", metadata4.getProperties().get("newSubjectKey"));
        Assert.assertEquals((String)"Version should match", (Object)response.getVersion(), (Object)this.restApp.restClient.lookUpSubjectVersion(new RegisterSchemaRequest(new Schema(subject, response)), subject, false, false).getVersion());
        schemaString = this.restApp.restClient.getId(expectedIdSchema3, subject);
        metadata4 = schemaString.getMetadata();
        Assert.assertEquals((Object)"configValue", metadata4.getProperties().get("configKey"));
        Assert.assertNull(metadata4.getProperties().get("subjectKey"));
        Assert.assertEquals((Object)"newSubjectValue", metadata4.getProperties().get("newSubjectKey"));
    }

    @Test
    public void testConfigRuleSet() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        Rule r1 = new Rule("foo", null, null, RuleMode.UPGRADE, "IGNORE", null, null, null, null, null, false);
        List<Rule> rules = Collections.singletonList(r1);
        RuleSet ruleSet = new RuleSet(rules, null);
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setDefaultRuleSet(ruleSet);
        config.setValidateFields(Boolean.valueOf(false));
        Assert.assertEquals((String)"Adding config with initial ruleSet should succeed", (Object)config, (Object)this.restApp.restClient.updateConfig(config, null));
        Rule r2 = new Rule("bar", null, null, RuleMode.UPGRADE, "type1", null, null, null, null, null, false);
        rules = Collections.singletonList(r2);
        ruleSet = new RuleSet(rules, null);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setRuleSet(ruleSet);
        int expectedIdSchema1 = 1;
        RegisterSchemaResponse response = this.restApp.restClient.registerSchema(request1, subject, false);
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)response.getId());
        RuleSet ruleSet2 = response.getRuleSet();
        Assert.assertEquals((Object)"foo", (Object)((Rule)ruleSet2.getMigrationRules().get(0)).getName());
        Assert.assertEquals((Object)"bar", (Object)((Rule)ruleSet2.getMigrationRules().get(1)).getName());
        Assert.assertEquals((String)"Version should match", (Object)response.getVersion(), (Object)this.restApp.restClient.lookUpSubjectVersion(new RegisterSchemaRequest(new Schema(subject, response)), subject, false, false).getVersion());
        List schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, false, "type1", null, null);
        Assert.assertEquals((long)1L, (long)schemas.size());
        schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, true, "type1", null, null);
        Assert.assertEquals((long)1L, (long)schemas.size());
        Assert.assertEquals((String)"Default compatibility level should be backward", (Object)CompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        Assert.assertEquals((String)"Changing compatibility level should succeed", (Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, null).getCompatibilityLevel());
        Assert.assertEquals((String)"New compatibility level should be forward", (Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        AvroSchema schema2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}");
        RegisterSchemaRequest request2 = new RegisterSchemaRequest((ParsedSchema)schema2);
        int expectedIdSchema2 = 2;
        response = this.restApp.restClient.registerSchema(request2, subject, false);
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema2, (long)response.getId());
        ruleSet2 = response.getRuleSet();
        Assert.assertEquals((Object)"foo", (Object)((Rule)ruleSet2.getMigrationRules().get(0)).getName());
        Assert.assertEquals((Object)"bar", (Object)((Rule)ruleSet2.getMigrationRules().get(1)).getName());
        Assert.assertEquals((String)"Version should match", (Object)response.getVersion(), (Object)this.restApp.restClient.lookUpSubjectVersion(new RegisterSchemaRequest(new Schema(subject, response)), subject, false, false).getVersion());
        SchemaString schemaString = this.restApp.restClient.getId(expectedIdSchema2, subject);
        ruleSet2 = schemaString.getRuleSet();
        Assert.assertEquals((Object)"foo", (Object)((Rule)ruleSet2.getMigrationRules().get(0)).getName());
        Assert.assertEquals((Object)"bar", (Object)((Rule)ruleSet2.getMigrationRules().get(1)).getName());
        schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, false, "type1", null, null);
        Assert.assertEquals((long)2L, (long)schemas.size());
        schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, true, "type1", null, null);
        Assert.assertEquals((long)1L, (long)schemas.size());
        response = this.restApp.restClient.registerSchema(request2, subject, false);
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema2, (long)response.getId());
        ruleSet2 = schemaString.getRuleSet();
        Assert.assertEquals((Object)"foo", (Object)((Rule)ruleSet2.getMigrationRules().get(0)).getName());
        Assert.assertEquals((Object)"bar", (Object)((Rule)ruleSet2.getMigrationRules().get(1)).getName());
        AvroSchema schema3 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}, {\"type\":\"string\",\"name\":\"f3\"}]}");
        Rule r3 = new Rule("zap", null, null, RuleMode.UPGRADE, "type2", null, null, null, null, null, false);
        rules = Collections.singletonList(r3);
        ruleSet = new RuleSet(rules, null);
        RegisterSchemaRequest request3 = new RegisterSchemaRequest((ParsedSchema)schema3);
        request3.setRuleSet(ruleSet);
        int expectedIdSchema3 = 3;
        response = this.restApp.restClient.registerSchema(request3, subject, false);
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema3, (long)response.getId());
        RuleSet ruleSet3 = response.getRuleSet();
        Assert.assertEquals((Object)"foo", (Object)((Rule)ruleSet3.getMigrationRules().get(0)).getName());
        Assert.assertEquals((Object)"zap", (Object)((Rule)ruleSet3.getMigrationRules().get(1)).getName());
        Assert.assertEquals((String)"Version should match", (Object)response.getVersion(), (Object)this.restApp.restClient.lookUpSubjectVersion(new RegisterSchemaRequest(new Schema(subject, response)), subject, false, false).getVersion());
        schemaString = this.restApp.restClient.getId(expectedIdSchema3, subject);
        ruleSet3 = schemaString.getRuleSet();
        Assert.assertEquals((Object)"foo", (Object)((Rule)ruleSet3.getMigrationRules().get(0)).getName());
        Assert.assertEquals((Object)"zap", (Object)((Rule)ruleSet3.getMigrationRules().get(1)).getName());
        schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, false, "type1", null, null);
        Assert.assertEquals((long)2L, (long)schemas.size());
        schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, false, "type2", null, null);
        Assert.assertEquals((long)1L, (long)schemas.size());
        schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, true, "type1", null, null);
        Assert.assertEquals((long)0L, (long)schemas.size());
        schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, true, "type2", null, null);
        Assert.assertEquals((long)1L, (long)schemas.size());
    }

    @Test
    public void testSchemaMetadata() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(request1, subject, false).getId());
        RegisterSchemaRequest request2 = new RegisterSchemaRequest();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("subjectKey", "subjectValue");
        Metadata metadata = new Metadata(null, properties, null);
        request2.setMetadata(metadata);
        int expectedIdSchema2 = 2;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema2, (long)this.restApp.restClient.registerSchema(request2, subject, false).getId());
        SchemaString schemaString = this.restApp.restClient.getId(expectedIdSchema2, subject);
        Assert.assertEquals((Object)schema1.canonicalString(), (Object)schemaString.getSchemaString());
        Assert.assertEquals((Object)metadata, (Object)schemaString.getMetadata());
    }

    @Test
    public void testSchemaRuleSet() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(request1, subject, false).getId());
        RegisterSchemaRequest request2 = new RegisterSchemaRequest();
        Rule r1 = new Rule("foo", null, null, RuleMode.UPGRADE, "IGNORE", null, null, null, null, null, false);
        List<Rule> rules = Collections.singletonList(r1);
        RuleSet ruleSet = new RuleSet(rules, null);
        request2.setRuleSet(ruleSet);
        int expectedIdSchema2 = 2;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema2, (long)this.restApp.restClient.registerSchema(request2, subject, false).getId());
        SchemaString schemaString = this.restApp.restClient.getId(expectedIdSchema2, subject);
        Assert.assertEquals((Object)schema1.canonicalString(), (Object)schemaString.getSchemaString());
        Assert.assertEquals((Object)ruleSet, (Object)schemaString.getRuleSet());
    }

    @Test
    public void testCompareAndSetVersion() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(schemaString1, subject));
        AvroSchema schema2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}");
        RegisterSchemaRequest request2 = new RegisterSchemaRequest((ParsedSchema)schema2);
        request2.setVersion(Integer.valueOf(3));
        try {
            this.restApp.restClient.registerSchema(request2, subject, false);
            Assert.fail((String)"Registering a wrong version should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a bad request status", (long)42201L, (long)e.getErrorCode());
        }
        request2.setVersion(Integer.valueOf(2));
        int expectedIdSchema2 = 2;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema2, (long)this.restApp.restClient.registerSchema(request2, subject, false).getId());
    }

    @Test
    public void testConfigInvalidRuleSet() throws Exception {
        Rule r1 = new Rule("foo", null, null, RuleMode.READ, "IGNORE", null, null, null, null, null, false);
        ImmutableList rules = Collections.singletonList(r1);
        RuleSet ruleSet = new RuleSet(rules, null);
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setDefaultRuleSet(ruleSet);
        try {
            this.restApp.restClient.updateConfig(config, null);
            Assert.fail((String)"Registering an invalid ruleSet should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a bad request status", (long)422L, (long)e.getStatus());
        }
        Rule r2 = new Rule("foo", null, null, RuleMode.READ, "IGNORE", null, null, null, null, null, false);
        rules = ImmutableList.of((Object)r1, (Object)r2);
        ruleSet = new RuleSet(null, (List)rules);
        config = new ConfigUpdateRequest();
        config.setDefaultRuleSet(ruleSet);
        try {
            this.restApp.restClient.updateConfig(config, null);
            Assert.fail((String)"Registering an invalid ruleSet should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a bad request status", (long)422L, (long)e.getStatus());
        }
    }

    @Test
    public void testRegisterInvalidRuleSet() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        Rule r1 = new Rule("foo", null, null, RuleMode.READ, null, null, null, null, null, null, false);
        List<Rule> rules = Collections.singletonList(r1);
        RuleSet ruleSet = new RuleSet(rules, null);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setRuleSet(ruleSet);
        try {
            this.restApp.restClient.registerSchema(request1, subject, false);
            Assert.fail((String)"Registering an invalid ruleSet should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a bad request status", (long)422L, (long)e.getStatus());
        }
    }

    @Test
    public void testRegisterBadDefaultWithNormalizeConfig() throws Exception {
        String subject = "testSubject";
        String schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"int\",\"default\":\"foo\",\"name\":\"f\"}]}";
        String schema = AvroUtils.parseSchema((String)schemaString).canonicalString();
        List errors = this.restApp.restClient.testCompatibility(schema, subject, "latest");
        Assert.assertTrue((boolean)errors.isEmpty());
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setNormalize(Boolean.valueOf(true));
        config.setValidateFields(Boolean.valueOf(false));
        Assert.assertEquals((String)"Setting normalize config should succeed", (Object)config, (Object)this.restApp.restClient.updateConfig(config, null));
        try {
            this.restApp.restClient.testCompatibility(schema, subject, "latest");
            Assert.fail((String)"Testing compatibility for schema with invalid default should fail with 42201 (invalid schema)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
        try {
            this.restApp.restClient.registerSchema(schema, subject);
            Assert.fail((String)"Registering schema with invalid default should fail with 42201 (invalid schema)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testSubjectAlias() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(schemaString1, subject));
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setAlias("testSubject");
        Assert.assertEquals((String)"Setting alias config should succeed", (Object)config, (Object)this.restApp.restClient.updateConfig(config, "testAlias"));
        Schema schema = this.restApp.restClient.getVersion("testAlias", 1);
        Assert.assertEquals((Object)schemaString1, (Object)schema.getSchema());
    }

    @Test
    public void testSubjectAliasWithSlash() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(schemaString1, subject));
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setAlias("testSubject");
        Assert.assertEquals((String)"Setting alias config should succeed", (Object)config, (Object)this.restApp.restClient.updateConfig(config, "test/Alias"));
        Schema schema = this.restApp.restClient.getVersion("test/Alias", 1);
        Assert.assertEquals((Object)schemaString1, (Object)schema.getSchema());
    }

    @Test
    public void testSubjectAliasWithContext() throws Exception {
        RestService restClient1 = new RestService(this.restApp.restConnect + "/contexts/.mycontext");
        RestService restClient2 = new RestService(this.restApp.restConnect + "/contexts/.mycontext2");
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)restClient1.registerSchema(schemaString1, "testSubject"));
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setAlias(":.mycontext:testSubject");
        Assert.assertEquals((String)"Setting alias config should succeed", (Object)config, (Object)this.restApp.restClient.updateConfig(config, ":.mycontext2:testAlias"));
        Schema schema = restClient2.getVersion("testAlias", 1);
        Assert.assertEquals((Object)schemaString1, (Object)schema.getSchema());
    }

    @Test
    public void testGlobalAliasNotUsed() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(schemaString1, subject));
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setAlias("badSubject");
        config.setValidateFields(Boolean.valueOf(false));
        Assert.assertEquals((String)"Setting alias config should succeed", (Object)config, (Object)this.restApp.restClient.updateConfig(config, null));
        Schema schema = this.restApp.restClient.getVersion("testSubject", 1);
        Assert.assertEquals((Object)schemaString1, (Object)schema.getSchema());
    }
}

