/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.filter;

import io.confluent.kafka.schemaregistry.filter.Permission;
import io.confluent.kafka.schemaregistry.filter.RequirePermission;
import java.lang.reflect.Method;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.junit.Assert;
import org.junit.Test;

public class PermissionTest {
    @Test
    public void takesPermissionFromMethodWhenBothClassAndMethodAreAnnotated() {
        Method method = MethodUtils.getAccessibleMethod(ModifyOperations.class, (String)"read", (Class[])new Class[0]);
        Permission actual = Permission.at(ModifyOperations.class, (Method)method);
        Assert.assertEquals((Object)Permission.READ, (Object)actual);
    }

    @Test
    public void takesPermissionFromClassWhenOnlyClassIsAnnotated() {
        Method method = MethodUtils.getAccessibleMethod(ModifyOperations.class, (String)"unannotated", (Class[])new Class[0]);
        Permission actual = Permission.at(ModifyOperations.class, (Method)method);
        Assert.assertEquals((Object)Permission.MODIFY, (Object)actual);
    }

    @Test
    public void takesNonePermissionWhenNeitherClassNorMethodAreAnnotated() {
        Method method = MethodUtils.getAccessibleMethod(Unannotated.class, (String)"unannotated", (Class[])new Class[0]);
        Permission actual = Permission.at(Unannotated.class, (Method)method);
        Assert.assertEquals((Object)Permission.NONE, (Object)actual);
    }

    public static class Unannotated {
        public void unannotated() {
        }
    }

    @RequirePermission(value=Permission.MODIFY)
    public static class ModifyOperations {
        @RequirePermission(value=Permission.READ)
        public void read() {
        }

        public void unannotated() {
        }
    }
}

