/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.leaderelector.kafka;

import com.google.protobuf.ByteString;
import com.mapr.fs.proto.Marlinserver;
import com.mapr.kafka.eventstreams.impl.MarlinCoordinator;
import com.mapr.kafka.eventstreams.impl.listener.MarlinListener;
import io.confluent.kafka.schemaregistry.leaderelector.kafka.GenericSRCoordinator;
import io.confluent.kafka.schemaregistry.leaderelector.kafka.SchemaRegistryProtocol;
import io.confluent.kafka.schemaregistry.leaderelector.kafka.SchemaRegistryRebalanceListener;
import io.confluent.kafka.schemaregistry.metrics.SchemaRegistryMetric;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryIdentity;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarlinSRCoordinator
extends MarlinCoordinator
implements Closeable,
GenericSRCoordinator {
    private static final Logger log = LoggerFactory.getLogger(MarlinSRCoordinator.class);
    public static final String SR_SUBPROTOCOL_V0 = "v0";
    private final SchemaRegistryIdentity identity;
    private SchemaRegistryProtocol.Assignment assignmentSnapshot;
    private final SchemaRegistryRebalanceListener listener;
    private final SchemaRegistryMetric nodeCountMetric;
    private final boolean stickyLeaderElection;
    private final SchemaRegistryConfig config;

    public MarlinSRCoordinator(String groupId, SchemaRegistryConfig config, SchemaRegistryIdentity identity, SchemaRegistryRebalanceListener listener, SchemaRegistryMetric nodeCountMetric, boolean stickyLeaderElection) {
        super(groupId);
        this.config = config;
        this.identity = identity;
        this.listener = listener;
        this.stickyLeaderElection = stickyLeaderElection;
        this.nodeCountMetric = nodeCountMetric;
        this.init();
        log.debug("MarlinSchemaRegistryCoordinator constructor");
    }

    protected Logger getLogger() {
        return log;
    }

    protected MarlinListener.MarlinJoinCallback getJoinerCallback() {
        return new MarlinSchemaRegistryJoinCallback();
    }

    protected String generateSyncTopic(String groupId) {
        return "__mapr__" + groupId + "_assignment";
    }

    protected String generateCoordStream() {
        return this.config.getKafkaStoreStream();
    }

    protected Marlinserver.JoinGroupDesc generateJoinDesc() {
        ByteBuffer metadata = SchemaRegistryProtocol.serializeMetadata(this.identity);
        return Marlinserver.JoinGroupDesc.newBuilder().setProtocolType(SR_SUBPROTOCOL_V0).setMemberId(this.memberId).addMemberProtocols(Marlinserver.MemberProtocol.newBuilder().setProtocol("default").setMemberMetadata(ByteString.copyFrom((ByteBuffer)metadata)).build()).build();
    }

    protected void revokeAssignments() {
        if (this.assignmentSnapshot != null) {
            this.listener.onRevoked();
        }
    }

    protected void protocolOnSyncComplete(Marlinserver.MemberState memberState, long generation) {
        this.assignmentSnapshot = SchemaRegistryProtocol.deserializeAssignment(ByteBuffer.wrap(memberState.getMemberAssignment().toByteArray()));
        if (this.stickyLeaderElection && this.assignmentSnapshot != null && this.assignmentSnapshot.leaderIdentity() != null) {
            log.info("assignmentLeaderIdentity: {}, myIdentity: {}", (Object)this.assignmentSnapshot.leaderIdentity(), (Object)this.identity);
            this.identity.setLeader(this.assignmentSnapshot.leaderIdentity().equals(this.identity));
        }
        this.listener.onAssigned(this.assignmentSnapshot, (int)generation);
    }

    protected Map<String, ByteBuffer> performProtocolAssignment(String leaderId, List<Marlinserver.Member> members) {
        log.info("Performing assignment");
        HashMap<String, SchemaRegistryIdentity> memberConfigs = new HashMap<String, SchemaRegistryIdentity>();
        for (Marlinserver.Member entry : members) {
            SchemaRegistryIdentity identity = SchemaRegistryProtocol.deserializeMetadata(ByteBuffer.wrap(entry.getMemberMetadata().toByteArray()));
            memberConfigs.put(entry.getMemberId(), identity);
        }
        log.info("Member information: {}", memberConfigs);
        if (this.nodeCountMetric != null) {
            this.nodeCountMetric.record(memberConfigs.size());
        }
        SchemaRegistryIdentity leaderIdentity = null;
        String leaderKafkaId = null;
        SchemaRegistryIdentity existingLeaderIdentity = null;
        String existingLeaderKafkaId = null;
        boolean multipleLeadersFound = false;
        HashSet<String> urls = new HashSet<String>();
        for (Map.Entry entry : memberConfigs.entrySet()) {
            boolean smallerIdentity;
            String kafkaMemberId = (String)entry.getKey();
            SchemaRegistryIdentity memberIdentity = (SchemaRegistryIdentity)entry.getValue();
            urls.add(memberIdentity.getUrl());
            boolean eligible = memberIdentity.getLeaderEligibility();
            boolean bl = smallerIdentity = leaderIdentity == null || memberIdentity.getUrl().compareTo(leaderIdentity.getUrl()) < 0;
            if (eligible && smallerIdentity) {
                leaderKafkaId = kafkaMemberId;
                leaderIdentity = memberIdentity;
            }
            if (!this.stickyLeaderElection || !eligible || !memberIdentity.isLeader().booleanValue() || multipleLeadersFound) continue;
            if (existingLeaderIdentity != null) {
                log.warn("Multiple leaders found in group [{}, {}].", (Object)existingLeaderIdentity, (Object)memberIdentity);
                multipleLeadersFound = true;
                existingLeaderKafkaId = null;
                existingLeaderIdentity = null;
                continue;
            }
            existingLeaderKafkaId = kafkaMemberId;
            existingLeaderIdentity = memberIdentity;
        }
        short error = 0;
        if (urls.size() != memberConfigs.size()) {
            log.error("Found duplicate URLs for schema registry group members. This indicates a misconfiguration and is common when executing in containers. Use the host.name configuration to set each instance's advertised host name to a value that is routable from all other schema registry instances.");
            error = 1;
        }
        HashMap<String, ByteBuffer> groupAssignment = new HashMap<String, ByteBuffer>();
        if (this.stickyLeaderElection && existingLeaderKafkaId != null) {
            leaderKafkaId = existingLeaderKafkaId;
            leaderIdentity = existingLeaderIdentity;
            if (!this.identity.equals(leaderIdentity) && this.identity.isLeader().booleanValue()) {
                this.identity.setLeader(false);
            }
        }
        SchemaRegistryProtocol.Assignment assignment = new SchemaRegistryProtocol.Assignment(error, leaderKafkaId, leaderIdentity);
        log.info("Assignment: {}", (Object)assignment);
        for (String member : memberConfigs.keySet()) {
            groupAssignment.put(member, SchemaRegistryProtocol.serializeAssignment(assignment));
        }
        return groupAssignment;
    }

    protected boolean isProtocolRejoinNeeded() {
        if (this.assignmentSnapshot != null) {
            log.debug("assignmentSnapshot.failed {}", (Object)this.assignmentSnapshot.failed());
        }
        return this.assignmentSnapshot == null || this.assignmentSnapshot.failed();
    }

    @Override
    public void close() {
        super.close();
        this.assignmentSnapshot = null;
    }

    public class MarlinSchemaRegistryJoinCallback
    extends MarlinCoordinator.MarlinCoordinatorJoinCallback {
        public MarlinSchemaRegistryJoinCallback() {
            super((MarlinCoordinator)MarlinSRCoordinator.this);
        }

        public void onJoin(Marlinserver.JoinGroupInfo joinGroupInfo) {
            MarlinSRCoordinator.this.performOnJoin(joinGroupInfo);
        }
    }
}

