/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.security.auth.login.Configuration;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.javaapi.CollectionConverters;

public class SASLClusterTestHarness
extends ClusterTestHarness {
    public static final String JAAS_CONF = "java.security.auth.login.config";
    public static final String ZK_AUTH_PROVIDER = "zookeeper.authProvider.1";
    private MiniKdc kdc = null;
    private File kdcHome = TestUtils.tempDir();
    private Properties kdcProps = MiniKdc.createConfig();
    private static final Logger log = LoggerFactory.getLogger(SASLClusterTestHarness.class);

    public SASLClusterTestHarness() {
        super(1);
    }

    @Override
    protected SecurityProtocol getSecurityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        LoginManager.closeAll();
        File serverKeytab = File.createTempFile("server-", ".keytab");
        File clientKeytab = File.createTempFile("client-", ".keytab");
        Option serverKeytabOption = Option.apply((Object)serverKeytab);
        Option clientKeytabOption = Option.apply((Object)clientKeytab);
        List serverSaslMechanisms = JavaConverters.asScalaBuffer(Arrays.asList("GSSAPI")).toList();
        Option clientSaslMechanism = Option.apply((Object)"GSSAPI");
        ArrayList<JaasTestUtils.JaasSection> jaasSections = new ArrayList<JaasTestUtils.JaasSection>();
        jaasSections.add(JaasTestUtils.kafkaServerSection((String)JaasTestUtils.KafkaServerContextName(), (Seq)serverSaslMechanisms, (Option)serverKeytabOption));
        jaasSections.add(JaasTestUtils.kafkaClientSection((Option)clientSaslMechanism, (Option)clientKeytabOption));
        jaasSections.addAll(CollectionConverters.asJavaCollection((Iterable)JaasTestUtils.zkSections()));
        String jaasFilePath = JaasTestUtils.writeJaasContextsToFile((Seq)JavaConverters.asScalaBuffer(jaasSections).toSeq()).getAbsolutePath();
        log.info("Using KDC home: " + this.kdcHome.getAbsolutePath());
        this.kdc = new MiniKdc(this.kdcProps, this.kdcHome);
        this.kdc.start();
        this.createPrincipal(serverKeytab, "kafka/localhost");
        this.createPrincipal(clientKeytab, "client");
        this.createPrincipal(clientKeytab, "client2");
        Configuration.setConfiguration(null);
        System.setProperty(JAAS_CONF, jaasFilePath);
        System.setProperty(ZK_AUTH_PROVIDER, "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        super.setUp();
    }

    private void createPrincipal(File keytab, String principalNoRealm) throws Exception {
        List principals = JavaConverters.asScalaBuffer(Arrays.asList(principalNoRealm)).toList();
        this.kdc.createPrincipal(keytab, (scala.collection.immutable.Seq)principals);
    }

    @Override
    protected KafkaConfig getKafkaConfig(int brokerId) {
        Option trustStoreFileOption = Option.apply(null);
        Option saslInterBrokerSecurityProtocol = Option.apply((Object)SecurityProtocol.SASL_PLAINTEXT);
        Properties props = TestUtils.createBrokerConfig((int)brokerId, (String)this.zkConnect, (boolean)false, (boolean)false, (int)TestUtils.RandomPort(), (Option)saslInterBrokerSecurityProtocol, (Option)trustStoreFileOption, (Option)EMPTY_SASL_PROPERTIES, (boolean)false, (boolean)true, (int)TestUtils.RandomPort(), (boolean)false, (int)TestUtils.RandomPort(), (boolean)false, (int)TestUtils.RandomPort(), (Option)Option.empty(), (int)1, (boolean)false, (int)1, (short)1);
        this.injectProperties(props);
        props.setProperty("zookeeper.connection.timeout.ms", "30000");
        props.setProperty("sasl.mechanism.inter.broker.protocol", "GSSAPI");
        props.setProperty("sasl.enabled.mechanisms", "GSSAPI");
        return KafkaConfig.fromProps((Properties)props);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.kdc != null) {
            this.kdc.stop();
        }
        LoginManager.closeAll();
        System.clearProperty(JAAS_CONF);
        System.clearProperty(ZK_AUTH_PROVIDER);
        Configuration.setConfiguration(null);
        super.tearDown();
    }
}

