/*
 * Copyright 2018 Confluent Inc.
 *
 * Licensed under the Confluent Community License (the "License"); you may not use
 * this file except in compliance with the License.  You may obtain a copy of the
 * License at
 *
 * http://www.confluent.io/confluent-community-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OF ANY KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations under the License.
 */

package io.confluent.kafka.schemaregistry.rest.resources;

import java.util.HashMap;
import java.util.Map;

import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

import io.confluent.kafka.schemaregistry.client.rest.Versions;
import io.confluent.kafka.schemaregistry.filter.RequirePermission;
import io.confluent.kafka.schemaregistry.filter.Permission;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


@Path("/")
@Api(value = "/")
@Produces(
    {Versions.SCHEMA_REGISTRY_V1_JSON_WEIGHTED, Versions.SCHEMA_REGISTRY_DEFAULT_JSON_WEIGHTED,
     Versions.JSON_WEIGHTED})
@Consumes({Versions.SCHEMA_REGISTRY_V1_JSON, Versions.SCHEMA_REGISTRY_DEFAULT_JSON,
           Versions.JSON, Versions.GENERIC_REQUEST})
@RequirePermission(Permission.NONE)
public class RootResource {

  @GET
  @ApiOperation(value = "Schema Registry Root Resource",
      notes = "The Root resource is a no-op.",
      response = Map.class)
  public Map<String, String> get() {
    // Currently this just provides an endpoint that's a nop and can be used to check for
    // liveness and can be used for tests that need to test the server setup rather than the
    // functionality of a specific resource. Some APIs provide a listing of endpoints as their
    // root resource; it might be nice to provide that.
    return new HashMap<String, String>();
  }

  @POST
  public Map<String, String> post(@Valid Map<String, String> request) {
    // This version allows testing with posted entities
    return new HashMap<String, String>();
  }

}
