/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaUpdateHandler;
import java.io.IOException;
import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeSchemaUpdateHandler
implements SchemaUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(CompositeSchemaUpdateHandler.class);
    private final List<SchemaUpdateHandler> handlers;

    public CompositeSchemaUpdateHandler(List<SchemaUpdateHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public boolean validateUpdate(SchemaRegistryKey key, SchemaRegistryValue value, TopicPartition tp, long offset, long timestamp) {
        for (SchemaUpdateHandler handler : this.handlers) {
            boolean valid = handler.validateUpdate(key, value, tp, offset, timestamp);
            if (valid) continue;
            return false;
        }
        return true;
    }

    @Override
    public void handleUpdate(SchemaRegistryKey key, SchemaRegistryValue value, SchemaRegistryValue oldValue, TopicPartition tp, long offset, long timestamp) {
        for (SchemaUpdateHandler handler : this.handlers) {
            handler.handleUpdate(key, value, oldValue, tp, offset, timestamp);
        }
    }

    @Override
    public void close() throws IOException {
        for (SchemaUpdateHandler handler : this.handlers) {
            handler.close();
        }
    }
}

