/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SchemaRegistryExtensionTest
extends ClusterTestHarness {
    @Parameterized.Parameter
    public String resourceExtensionConfigName;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"resource.extension.class"}, {"schema.registry.resource.extension.class"});
    }

    public SchemaRegistryExtensionTest() {
        super(1, true, CompatibilityLevel.BACKWARD.name);
    }

    @Test
    public void testAllowResource() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(schemaString1, subject));
    }

    @Test
    public void tesRejectResource() throws Exception {
        String subject = "testSubject";
        try {
            this.restApp.restClient.getLatestVersion(subject);
            Assert.fail((String)"Getting all versions from non-existing subject1 should fail with 401");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 401 status for GET operations", (long)401L, (long)rce.getStatus());
        }
    }

    @Override
    protected Properties getSchemaRegistryProperties() {
        Properties props = new Properties();
        props.put(this.resourceExtensionConfigName, TestSchemaRegistryExtension.class.getName());
        return props;
    }

    public static class TestSchemaRegistryExtension
    implements SchemaRegistryResourceExtension {
        public void register(Configurable<?> config, SchemaRegistryConfig schemaRegistryConfig, SchemaRegistry schemaRegistry) {
            config.register((Object)new ContainerRequestFilter(){

                public void filter(ContainerRequestContext requestContext) throws IOException {
                    if (!requestContext.getMethod().equalsIgnoreCase("POST")) {
                        requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"User cannot access the resource.").build());
                    }
                }
            });
        }

        public void close() {
        }
    }
}

