/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.metrics;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.metrics.MetricsContainer;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class CustomSchemaProviderMetricTest
extends ClusterTestHarness {
    public CustomSchemaProviderMetricTest() {
        super(1, true);
    }

    @Override
    protected Properties getSchemaRegistryProperties() {
        Properties props = new Properties();
        props.setProperty("schema.providers", CustomSchemaProvider.class.getName());
        return props;
    }

    @Test
    public void testCustomSchemaProviderMetricCount() {
        MetricsContainer container = this.restApp.restApp.schemaRegistry().getMetricsContainer();
        Assert.assertEquals((long)1L, (long)container.getCustomSchemaProviderCount().get());
    }

    public static class CustomSchemaProvider
    implements SchemaProvider {
        public String schemaType() {
            return "CUSTOM_PROVIDER";
        }

        public Optional<ParsedSchema> parseSchema(String schemaString, List<SchemaReference> references) {
            return Optional.empty();
        }
    }
}

