/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.leaderelector.zookeeper;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.RestApp;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.utils.TestUtils;
import io.confluent.kafka.schemaregistry.utils.ZkUtils;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.junit.Assert;
import org.junit.Test;

public class ZookeeperLeaderElectorTest
extends ClusterTestHarness {
    private static final int ID_BATCH_SIZE = 20;
    private static final String ZK_ID_COUNTER_PATH = "/schema_registry/schema_id_counter";

    @Test
    public void testIncreasingIdZkResetLow() throws Exception {
        RestApp restApp1 = new RestApp(ZookeeperLeaderElectorTest.choosePort(), this.zkConnect, "");
        restApp1.start();
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(20);
        String subject = "testSubject";
        HashSet<Integer> ids = new HashSet<Integer>();
        int maxId = -1;
        for (int i = 0; i < 10; ++i) {
            int newId = restApp1.restClient.registerSchema(schemas.get(i), subject);
            ids.add(newId);
            Assert.assertTrue((newId > maxId ? 1 : 0) != 0);
            maxId = newId;
        }
        int zkIdCounter = ZookeeperLeaderElectorTest.getZkIdCounter(this.zkUtils);
        Assert.assertEquals((long)20L, (long)zkIdCounter);
        this.zkUtils.updatePersistentPath(ZK_ID_COUNTER_PATH, "0");
        String anotherSchema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        int newId = restApp1.restClient.registerSchema(anotherSchema, subject);
        Assert.assertTrue((String)"Next assigned id should be greater than all previous.", (newId > maxId ? 1 : 0) != 0);
        maxId = newId;
        final RestApp restApp2 = new RestApp(ZookeeperLeaderElectorTest.choosePort(), this.zkConnect, "");
        restApp2.start();
        restApp1.stop();
        Callable<Boolean> electionComplete = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return restApp2.isLeader();
            }
        };
        TestUtils.waitUntilTrue(electionComplete, 15000L, "Schema registry instance 2 should become the leader");
        Assert.assertEquals((String)"Zk counter is not the expected value.", (long)40L, (long)ZookeeperLeaderElectorTest.getZkIdCounter(this.zkUtils));
        this.zkUtils.updatePersistentPath(ZK_ID_COUNTER_PATH, "0");
        schemas = TestUtils.getRandomCanonicalAvroString(20);
        for (int i = 0; i < 20; ++i) {
            newId = restApp2.restClient.registerSchema(schemas.get(i), subject);
            ids.add(newId);
            Assert.assertTrue((String)("new id " + newId + " should be greater than previous max " + maxId), (newId > maxId ? 1 : 0) != 0);
            maxId = newId;
        }
        Assert.assertEquals((String)"Zk counter is not the expected value.", (long)60L, (long)ZookeeperLeaderElectorTest.getZkIdCounter(this.zkUtils));
    }

    @Test
    public void testIdBehaviorWithZkWithoutKafka() throws Exception {
        int weirdInitialCounterValue = 19;
        this.zkUtils.createPersistentPath(ZK_ID_COUNTER_PATH, "" + weirdInitialCounterValue);
        RestApp restApp = new RestApp(ZookeeperLeaderElectorTest.choosePort(), this.zkConnect, "");
        restApp.start();
        Assert.assertEquals((String)"", (long)40L, (long)ZookeeperLeaderElectorTest.getZkIdCounter(this.zkUtils));
    }

    @Test
    public void testIdBehaviorWithoutZkWithKafka() throws Exception {
        int numSchemas = 2;
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(numSchemas);
        String subject = "testSubject";
        HashSet<Integer> ids = new HashSet<Integer>();
        RestApp restApp = new RestApp(ZookeeperLeaderElectorTest.choosePort(), this.zkConnect, "");
        restApp.start();
        for (String schema : schemas) {
            int id = restApp.restClient.registerSchema(schema, subject);
            ids.add(id);
            this.waitUntilIdExists(restApp.restClient, id, "Expected id to be available.");
        }
        restApp.stop();
        int zkIdCounter = ZookeeperLeaderElectorTest.getZkIdCounter(this.zkUtils);
        Assert.assertEquals((String)"Incorrect ZK id counter.", (long)20L, (long)zkIdCounter);
        this.zkUtils.delete(ZK_ID_COUNTER_PATH);
        restApp = new RestApp(ZookeeperLeaderElectorTest.choosePort(), this.zkConnect, "");
        restApp.start();
        zkIdCounter = ZookeeperLeaderElectorTest.getZkIdCounter(this.zkUtils);
        Assert.assertEquals((String)"ZK id counter was incorrectly initialized.", (long)40L, (long)zkIdCounter);
        restApp.stop();
    }

    @Test
    public void testZkCounterOnStartup() throws Exception {
        RestApp restApp = new RestApp(ZookeeperLeaderElectorTest.choosePort(), this.zkConnect, "");
        restApp.start();
        int zkIdCounter = ZookeeperLeaderElectorTest.getZkIdCounter(this.zkUtils);
        Assert.assertEquals((String)"Initial value of ZooKeeper id counter is incorrect.", (long)20L, (long)zkIdCounter);
        restApp.stop();
    }

    private static int getZkIdCounter(ZkUtils zkUtils) {
        return Integer.valueOf(zkUtils.readData(ZK_ID_COUNTER_PATH).getData());
    }

    private void waitUntilIdExists(final RestService restService, final int expectedId, String errorMsg) {
        Callable<Boolean> canGetSchemaById = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    restService.getId(expectedId);
                    return true;
                }
                catch (RestClientException e) {
                    return false;
                }
            }
        };
        TestUtils.waitUntilTrue(canGetSchemaById, 15000L, errorMsg);
    }
}

