/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.filter.Permission;
import io.confluent.kafka.schemaregistry.filter.RequirePermission;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.rest.impersonation.ImpersonationUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/subjects")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class SubjectsResource {
    private static final Logger log = LoggerFactory.getLogger(SubjectsResource.class);
    private final KafkaSchemaRegistry schemaRegistry;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    public SubjectsResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @POST
    @Path(value="/{subject: .+}")
    @PerformanceMetric(value="subjects.get-schema")
    @RequirePermission(value=Permission.READ)
    public void lookUpSchemaUnderSubject(@Suspended AsyncResponse asyncResponse, @PathParam(value="subject") String subject, @QueryParam(value="deleted") boolean lookupDeletedSchema, @NotNull RegisterSchemaRequest request, @HeaderParam(value="Authorization") String auth, @HeaderParam(value="Cookie") String cookie) {
        ImpersonationUtils.runAsUserIfImpersonationEnabled(() -> {
            this.lookUpSchemaUnderSubject(asyncResponse, subject, lookupDeletedSchema, request);
            return null;
        }, (String)auth, (String)cookie);
    }

    private void lookUpSchemaUnderSubject(AsyncResponse asyncResponse, String subject, boolean lookupDeletedSchema, RegisterSchemaRequest request) {
        Schema matchingSchema;
        Schema schema = new Schema(subject, Integer.valueOf(0), Integer.valueOf(0), request.getSchema());
        try {
            if (!this.schemaRegistry.listSubjects().contains(subject)) {
                throw Errors.subjectNotFoundException();
            }
            matchingSchema = this.schemaRegistry.lookUpSchemaUnderSubject(subject, schema, lookupDeletedSchema);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while looking up schema under subject " + subject, e);
        }
        if (matchingSchema == null) {
            throw Errors.schemaNotFoundException();
        }
        asyncResponse.resume((Object)matchingSchema);
    }

    @GET
    @Valid
    @PerformanceMetric(value="subjects.list")
    @RequirePermission(value=Permission.READ)
    public Set<String> list(@HeaderParam(value="Authorization") String auth, @HeaderParam(value="Cookie") String cookie) {
        return (Set)ImpersonationUtils.runAsUserIfImpersonationEnabled(this::list, (String)auth, (String)cookie);
    }

    private Set<String> list() {
        try {
            return this.schemaRegistry.listSubjects();
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Error while listing subjects", e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while listing subjects", e);
        }
    }

    @DELETE
    @Path(value="/{subject: .+}")
    @PerformanceMetric(value="subjects.delete-subject")
    @RequirePermission(value=Permission.MODIFY)
    public void deleteSubject(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @PathParam(value="subject") String subject, @HeaderParam(value="Authorization") String auth, @HeaderParam(value="Cookie") String cookie) {
        ImpersonationUtils.runAsUserIfImpersonationEnabled(() -> {
            this.deleteSubject(asyncResponse, headers, subject);
            return null;
        }, (String)auth, (String)cookie);
    }

    private void deleteSubject(AsyncResponse asyncResponse, HttpHeaders headers, String subject) {
        List<Integer> deletedVersions;
        try {
            if (!this.schemaRegistry.listSubjects().contains(subject)) {
                throw Errors.subjectNotFoundException();
            }
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers);
            deletedVersions = this.schemaRegistry.deleteSubjectOrForward(headerProperties, subject);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while deleting the subject " + subject, e);
        }
        asyncResponse.resume(deletedVersions);
    }
}

