/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.NotEmpty;

public class SchemaValue
implements Comparable<SchemaValue>,
SchemaRegistryValue {
    @NotEmpty
    private String subject;
    @Min(value=1L)
    private Integer version;
    @Min(value=0L)
    private Integer id;
    @NotEmpty
    private String schema;
    @NotEmpty
    private boolean deleted;

    public SchemaValue(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version, @JsonProperty(value="id") Integer id, @JsonProperty(value="schema") String schema, @JsonProperty(value="deleted") boolean deleted) {
        this.subject = subject;
        this.version = version;
        this.id = id;
        this.schema = schema;
        this.deleted = deleted;
    }

    public SchemaValue(Schema schemaEntity) {
        this.subject = schemaEntity.getSubject();
        this.version = schemaEntity.getVersion();
        this.id = schemaEntity.getId();
        this.schema = schemaEntity.getSchema();
        this.deleted = false;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @JsonProperty(value="deleted")
    public boolean isDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaValue that = (SchemaValue)o;
        if (!this.subject.equals(that.subject)) {
            return false;
        }
        if (!this.version.equals(that.version)) {
            return false;
        }
        if (!this.id.equals(that.getId())) {
            return false;
        }
        if (!this.schema.equals(that.schema)) {
            return false;
        }
        return this.deleted == that.deleted;
    }

    public int hashCode() {
        int result = this.subject.hashCode();
        result = 31 * result + this.version;
        result = 31 * result + this.id;
        result = 31 * result + this.schema.hashCode();
        result = 31 * result + (this.deleted ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{subject=" + this.subject + ",");
        sb.append("version=" + this.version + ",");
        sb.append("id=" + this.id + ",");
        sb.append("schema=" + this.schema + ",");
        sb.append("deleted=" + this.deleted + "}");
        return sb.toString();
    }

    @Override
    public int compareTo(SchemaValue that) {
        int result = this.subject.compareTo(that.subject);
        if (result != 0) {
            return result;
        }
        result = this.version - that.version;
        return result;
    }
}

