/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.KafkaStoreReaderThread;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreTimeoutException;
import io.confluent.kafka.schemaregistry.utils.TestUtils;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStoreReaderThreadTest
extends ClusterTestHarness {
    private static final Logger log = LoggerFactory.getLogger(KafkaStoreReaderThreadTest.class);

    public KafkaStoreReaderThreadTest() {
        super(1, true);
    }

    @Before
    public void setup() {
        log.debug("Zk conn url = " + this.zkConnect);
    }

    @After
    public void teardown() {
        log.debug("Shutting down");
    }

    @Test
    public void testWaitUntilOffset() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        int id1 = this.restApp.restClient.registerSchema(schema, "subject1");
        KafkaSchemaRegistry sr = (KafkaSchemaRegistry)this.restApp.schemaRegistry();
        KafkaStoreReaderThread readerThread = sr.getKafkaStore().getKafkaStoreReaderThread();
        try {
            readerThread.waitUntilOffset(50L, 500L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Should have timed out waiting to reach non-existent offset.");
        }
        catch (StoreTimeoutException storeTimeoutException) {
            // empty catch block
        }
        try {
            readerThread.waitUntilOffset(0L, 5000L, TimeUnit.MILLISECONDS);
        }
        catch (StoreTimeoutException e) {
            Assert.fail((String)"5 seconds should be more than enough time to reach offset 0 in the log.");
        }
    }
}

