/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestSslUtils;
import scala.Option;

public class SSLClusterTestHarness
extends ClusterTestHarness {
    public Map<String, Object> clientSslConfigs;

    public SSLClusterTestHarness() {
        super(1);
    }

    @Override
    protected SecurityProtocol getSecurityProtocol() {
        return SecurityProtocol.SSL;
    }

    @Override
    protected KafkaConfig getKafkaConfig(int brokerId) {
        File trustStoreFile;
        try {
            trustStoreFile = File.createTempFile("SSLClusterTestHarness-truststore", ".jks");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create temporary file for the truststore.");
        }
        Option trustStoreFileOption = Option.apply((Object)trustStoreFile);
        Option sslInterBrokerSecurityProtocol = Option.apply((Object)SecurityProtocol.SSL);
        Properties props = TestUtils.createBrokerConfig((int)brokerId, (String)this.zkConnect, (boolean)false, (boolean)false, (int)TestUtils.RandomPort(), (Option)sslInterBrokerSecurityProtocol, (Option)trustStoreFileOption, (Option)EMPTY_SASL_PROPERTIES, (boolean)false, (boolean)false, (int)TestUtils.RandomPort(), (boolean)true, (int)TestUtils.RandomPort(), (boolean)false, (int)TestUtils.RandomPort(), (Option)Option.empty(), (int)1, (boolean)false);
        try {
            this.clientSslConfigs = TestSslUtils.createSslConfig((boolean)true, (boolean)true, (Mode)Mode.CLIENT, (File)trustStoreFile, (String)"client", (String)"localhost");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.injectProperties(props);
        if (this.requireSSLClientAuth()) {
            props.setProperty("ssl.client.auth", "required");
        }
        return KafkaConfig.fromProps((Properties)props);
    }

    protected boolean requireSSLClientAuth() {
        return true;
    }
}

