/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven.derive.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveSchema;
import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.core.classloader.annotations.SuppressStaticInitializationFor;
import org.powermock.modules.junit4.PowerMockRunner;

@PowerMockIgnore(value={"javax.crypto.*"})
@PrepareForTest(value={UserGroupInformation.class})
@RunWith(value=PowerMockRunner.class)
@SuppressStaticInitializationFor(value={"com.mapr.baseutils.JVMProperties"})
public abstract class DeriveSchemaTest {
    protected DeriveSchema derive;
    protected final ObjectMapper mapper = new ObjectMapper();
    static final String TYPE_NUMBER = "{\"type\":\"number\"}";
    static final String TYPE_BOOLEAN = "{\"type\":\"boolean\"}";
    static final String TYPE_STRING = "{\"type\":\"string\"}";
    static final String TYPE_NULL = "{\"type\":\"null\"}";
    static final String EMPTY_ARRAY = "{\"type\":\"array\",\"items\":{}}";
    static final String ARRAY_OF_NUMBERS = "{\"type\":\"array\",\"items\":{\"type\":\"number\"}}";
    static final String ARRAY_OF_NUMBERS_AND_STRINGS = "{\"type\":\"array\",\"items\":{\"oneOf\":[{\"type\":\"number\"},{\"type\":\"string\"}]}}";
    static final String ARRAY_OF_ARRAY_OF_NUMBERS = "{\"type\":\"array\",\"items\":{\"type\":\"array\",\"items\":{\"type\":\"number\"}}}";
    static final String ARRAY_OF_BOOLEAN_NUMBERS_AND_STRINGS = "{\"type\":\"array\",\"items\":{\"oneOf\":[{\"type\":\"boolean\"},{\"type\":\"number\"},{\"type\":\"string\"}]}}";
    static final String RECORD_WITH_STRING = "{\"type\":\"object\",\"properties\":{\"%s\":{\"type\":\"string\"}}}";
    static final String RECORD_WITH_ARRAY_OF_STRINGS = "{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"array\",\"items\":{\"type\":\"string\"}}}}";

    protected void generateSchemaAndCheckPrimitive(String message, String expectedSchema) throws JsonProcessingException {
        Optional primitiveSchema = this.derive.getPrimitiveSchema(this.mapper.readTree(message));
        assert (primitiveSchema.isPresent());
        Assert.assertEquals(primitiveSchema.get(), (Object)this.mapper.readTree(expectedSchema));
    }

    protected void generateSchemaAndCheckPrimitiveAbsent(String message) throws JsonProcessingException {
        Optional primitiveSchema = this.derive.getPrimitiveSchema(this.mapper.readTree(message));
        assert (!primitiveSchema.isPresent());
    }

    protected void generateSchemaAndCheckExpected(String message, String expectedSchema) throws IOException {
        ObjectNode schemaForRecord = this.derive.getSchemaForRecord((ObjectNode)this.mapper.readTree(message));
        JsonNode schema = this.derive.convertToFormat((JsonNode)schemaForRecord, "Schema");
        this.matchAndValidate(message, schema, expectedSchema);
    }

    protected abstract void matchAndValidate(String var1, JsonNode var2, String var3) throws IOException;
}

