/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleKind;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.maven.Metadata;
import io.confluent.kafka.schemaregistry.maven.Reference;
import io.confluent.kafka.schemaregistry.maven.RegisterSchemaRegistryMojo;
import io.confluent.kafka.schemaregistry.maven.Rule;
import io.confluent.kafka.schemaregistry.maven.RuleSet;
import io.confluent.kafka.schemaregistry.maven.SchemaRegistryTest;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.junit.Assert;
import org.junit.Test;

public class SchemasWithDependenciesTest
extends SchemaRegistryTest {
    private final String dependency = "{\n  \"type\": \"record\",\n  \"namespace\": \"com.pizza\",\n  \"name\": \"Amount\",\n  \"fields\": [\n    {\n      \"name\": \"amount\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"currency\",\n      \"type\": \"string\"\n    }\n  ]\n}";
    private final String schema = "{\n  \"type\": \"record\",\n  \"namespace\": \"com.pizza\",\n  \"name\": \"Pizza\",\n  \"fields\": [\n    {\n      \"name\": \"name\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"cost\",\n      \"type\": \"com.pizza.Amount\"\n    }\n  ]\n}";

    @Test
    public void testSchemaWithDependencies() throws Exception {
        RegisterSchemaRegistryMojo schemaRegistryMojo = new RegisterSchemaRegistryMojo();
        schemaRegistryMojo.client = new MockSchemaRegistryClient();
        File pizzaFile = new File(this.tempDirectory, "pizza.avsc");
        File amountFile = new File(this.tempDirectory, "amount.avsc");
        try (FileWriter pizzaWriter = new FileWriter(pizzaFile);
             FileWriter amountWriter = new FileWriter(amountFile);){
            pizzaWriter.write("{\n  \"type\": \"record\",\n  \"namespace\": \"com.pizza\",\n  \"name\": \"Pizza\",\n  \"fields\": [\n    {\n      \"name\": \"name\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"cost\",\n      \"type\": \"com.pizza.Amount\"\n    }\n  ]\n}");
            amountWriter.write("{\n  \"type\": \"record\",\n  \"namespace\": \"com.pizza\",\n  \"name\": \"Amount\",\n  \"fields\": [\n    {\n      \"name\": \"amount\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"currency\",\n      \"type\": \"string\"\n    }\n  ]\n}");
        }
        LinkedHashMap schemaRefs = new LinkedHashMap();
        ArrayList<Reference> subjectRefs = new ArrayList<Reference>();
        Reference ref = new Reference();
        ref.name = "com.pizza.Amount";
        ref.subject = "Amount";
        subjectRefs.add(ref);
        schemaRefs.put("Pizza", subjectRefs);
        schemaRegistryMojo.references = schemaRefs;
        LinkedHashMap<String, File> schemas = new LinkedHashMap<String, File>();
        schemas.put("Amount", amountFile);
        schemas.put("Pizza", pizzaFile);
        schemaRegistryMojo.subjects = schemas;
        schemaRegistryMojo.execute();
        Schema pizza = ((AvroSchema)schemaRegistryMojo.schemas.get("Pizza")).rawSchema();
        Assert.assertNotNull((String)"The schema should've been generated", (Object)pizza);
        Assert.assertTrue((String)"The schema should contain fields from the dependency", (boolean)pizza.toString().contains("currency"));
    }

    @Test
    public void testSchemaWithDependenciesAndMetadata() throws Exception {
        RegisterSchemaRegistryMojo schemaRegistryMojo = new RegisterSchemaRegistryMojo();
        schemaRegistryMojo.client = new MockSchemaRegistryClient();
        File pizzaFile = new File(this.tempDirectory, "pizza.avsc");
        File amountFile = new File(this.tempDirectory, "amount.avsc");
        try (FileWriter pizzaWriter = new FileWriter(pizzaFile);
             FileWriter amountWriter = new FileWriter(amountFile);){
            pizzaWriter.write("{\n  \"type\": \"record\",\n  \"namespace\": \"com.pizza\",\n  \"name\": \"Pizza\",\n  \"fields\": [\n    {\n      \"name\": \"name\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"cost\",\n      \"type\": \"com.pizza.Amount\"\n    }\n  ]\n}");
            amountWriter.write("{\n  \"type\": \"record\",\n  \"namespace\": \"com.pizza\",\n  \"name\": \"Amount\",\n  \"fields\": [\n    {\n      \"name\": \"amount\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"currency\",\n      \"type\": \"string\"\n    }\n  ]\n}");
        }
        HashMap<String, Set<String>> tags = new HashMap<String, Set<String>>();
        tags.put("**.ssn", Collections.singleton("PII"));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key1", "value1");
        Set<String> sensitive = Collections.singleton("key1");
        Metadata m = new Metadata();
        m.tags = tags;
        m.properties = properties;
        m.sensitive = sensitive;
        schemaRegistryMojo.metadata = Collections.singletonMap("Pizza", m);
        Rule rule = new Rule();
        rule.name = "rule1";
        rule.kind = RuleKind.TRANSFORM;
        rule.mode = RuleMode.WRITEREAD;
        rule.type = "ENCRYPT";
        rule.tags = Collections.singleton("PII");
        List<Rule> domainRules = Collections.singletonList(rule);
        RuleSet rs = new RuleSet();
        rs.migrationRules = Collections.emptyList();
        rs.domainRules = domainRules;
        schemaRegistryMojo.ruleSet = Collections.singletonMap("Pizza", rs);
        LinkedHashMap schemaRefs = new LinkedHashMap();
        ArrayList<Reference> subjectRefs = new ArrayList<Reference>();
        Reference ref = new Reference();
        ref.name = "com.pizza.Amount";
        ref.subject = "Amount";
        subjectRefs.add(ref);
        schemaRefs.put("Pizza", subjectRefs);
        schemaRegistryMojo.references = schemaRefs;
        LinkedHashMap<String, File> schemas = new LinkedHashMap<String, File>();
        schemas.put("Amount", amountFile);
        schemas.put("Pizza", pizzaFile);
        schemaRegistryMojo.subjects = schemas;
        schemaRegistryMojo.execute();
        Schema pizza = ((AvroSchema)schemaRegistryMojo.schemas.get("Pizza")).rawSchema();
        io.confluent.kafka.schemaregistry.client.rest.entities.Metadata metadata = ((ParsedSchema)schemaRegistryMojo.schemas.get("Pizza")).metadata();
        io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet ruleSet = ((ParsedSchema)schemaRegistryMojo.schemas.get("Pizza")).ruleSet();
        Assert.assertEquals((Object)m.toMetadataEntity(), (Object)metadata);
        Assert.assertEquals((Object)rs.toRuleSetEntity(), (Object)ruleSet);
        Assert.assertNotNull((String)"The schema should've been generated", (Object)pizza);
        Assert.assertTrue((String)"The schema should contain fields from the dependency", (boolean)pizza.toString().contains("currency"));
    }

    @Test
    public void testSchemaWithPreregisteredDependencies() throws Exception {
        RegisterSchemaRegistryMojo schemaRegistryMojo = new RegisterSchemaRegistryMojo();
        schemaRegistryMojo.client = new MockSchemaRegistryClient();
        File pizzaFile = new File(this.tempDirectory, "pizza.avsc");
        try (FileWriter pizzaWriter = new FileWriter(pizzaFile);){
            pizzaWriter.write("{\n  \"type\": \"record\",\n  \"namespace\": \"com.pizza\",\n  \"name\": \"Pizza\",\n  \"fields\": [\n    {\n      \"name\": \"name\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"cost\",\n      \"type\": \"com.pizza.Amount\"\n    }\n  ]\n}");
        }
        schemaRegistryMojo.client.register("Amount", (ParsedSchema)new AvroSchema("{\n  \"type\": \"record\",\n  \"namespace\": \"com.pizza\",\n  \"name\": \"Amount\",\n  \"fields\": [\n    {\n      \"name\": \"amount\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"currency\",\n      \"type\": \"string\"\n    }\n  ]\n}"));
        LinkedHashMap schemaRefs = new LinkedHashMap();
        ArrayList<Reference> subjectRefs = new ArrayList<Reference>();
        Reference ref = new Reference();
        ref.name = "com.pizza.Amount";
        ref.subject = "Amount";
        subjectRefs.add(ref);
        schemaRefs.put("Pizza", subjectRefs);
        schemaRegistryMojo.references = schemaRefs;
        LinkedHashMap<String, File> schemas = new LinkedHashMap<String, File>();
        schemas.put("Pizza", pizzaFile);
        schemaRegistryMojo.subjects = schemas;
        schemaRegistryMojo.execute();
        Schema pizza = ((AvroSchema)schemaRegistryMojo.schemas.get("Pizza")).rawSchema();
        Assert.assertNotNull((String)"The schema should've been generated", (Object)pizza);
        Assert.assertTrue((String)"The schema should contain fields from the dependency", (boolean)pizza.toString().contains("currency"));
    }

    @Test
    public void testSchemaWithDependenciesWithSlash() throws Exception {
        RegisterSchemaRegistryMojo schemaRegistryMojo = new RegisterSchemaRegistryMojo();
        schemaRegistryMojo.client = new MockSchemaRegistryClient();
        File pizzaFile = new File(this.tempDirectory, "pizza.avsc");
        File amountFile = new File(this.tempDirectory, "amount.avsc");
        try (FileWriter pizzaWriter = new FileWriter(pizzaFile);
             FileWriter amountWriter = new FileWriter(amountFile);){
            pizzaWriter.write("{\n  \"type\": \"record\",\n  \"namespace\": \"com.pizza\",\n  \"name\": \"Pizza\",\n  \"fields\": [\n    {\n      \"name\": \"name\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"cost\",\n      \"type\": \"com.pizza.Amount\"\n    }\n  ]\n}");
            amountWriter.write("{\n  \"type\": \"record\",\n  \"namespace\": \"com.pizza\",\n  \"name\": \"Amount\",\n  \"fields\": [\n    {\n      \"name\": \"amount\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"currency\",\n      \"type\": \"string\"\n    }\n  ]\n}");
        }
        LinkedHashMap schemaRefs = new LinkedHashMap();
        ArrayList<Reference> subjectRefs = new ArrayList<Reference>();
        Reference ref = new Reference();
        ref.name = "com.pizza.Amount";
        ref.subject = "Root/Amount";
        subjectRefs.add(ref);
        schemaRefs.put("Root_x2FPizza", subjectRefs);
        schemaRegistryMojo.references = schemaRefs;
        LinkedHashMap<String, File> schemas = new LinkedHashMap<String, File>();
        schemas.put("Root_x2FAmount", amountFile);
        schemas.put("Root_x2FPizza", pizzaFile);
        schemaRegistryMojo.subjects = schemas;
        schemaRegistryMojo.execute();
        Schema pizza = ((AvroSchema)schemaRegistryMojo.schemas.get("Root/Pizza")).rawSchema();
        Assert.assertNotNull((String)"The schema should've been generated", (Object)pizza);
        Assert.assertTrue((String)"The schema should contain fields from the dependency", (boolean)pizza.toString().contains("currency"));
    }
}

