/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.maven.DownloadSchemaRegistryMojo;
import io.confluent.kafka.schemaregistry.maven.SchemaRegistryTest;
import java.io.File;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DownloadSchemaRegistryMojoTest
extends SchemaRegistryTest {
    DownloadSchemaRegistryMojo mojo;

    @Before
    public void createMojo() {
        this.mojo = new DownloadSchemaRegistryMojo();
        this.mojo.client((SchemaRegistryClient)new MockSchemaRegistryClient());
        this.mojo.outputDirectory = this.tempDirectory;
    }

    @Test
    public void specificSubjects() throws Exception {
        String valueSubject;
        String keySubject;
        int i;
        this.mojo.subjectPatterns.clear();
        for (i = 0; i < 100; ++i) {
            keySubject = String.format("TestSubject%03d-key", i);
            valueSubject = String.format("TestSubject%03d-value", i);
            Schema keySchema = Schema.create((Schema.Type)Schema.Type.STRING);
            Schema valueSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
            this.mojo.client().register(keySubject, (ParsedSchema)new AvroSchema(keySchema));
            this.mojo.client().register(valueSubject, (ParsedSchema)new AvroSchema(valueSchema));
            if (i % 10 != 0) continue;
            String subjectPattern = String.format("^TestSubject%03d-(key|value)$", i);
            this.mojo.subjectPatterns.add(subjectPattern);
        }
        this.mojo.execute();
        for (i = 0; i < 100; ++i) {
            keySubject = String.format("TestSubject%03d-key", i);
            valueSubject = String.format("TestSubject%03d-value", i);
            File keySchemaFile = new File(this.tempDirectory, keySubject + ".avsc");
            File valueSchemaFile = new File(this.tempDirectory, valueSubject + ".avsc");
            if (i % 10 == 0) {
                Assert.assertTrue((boolean)keySchemaFile.exists());
                Assert.assertTrue((boolean)valueSchemaFile.exists());
                continue;
            }
            Assert.assertFalse((boolean)keySchemaFile.exists());
            Assert.assertFalse((boolean)valueSchemaFile.exists());
        }
    }

    @Test
    public void specificContexts() throws Exception {
        String valueSubject;
        String keySubject;
        int i;
        this.mojo.subjectPatterns.clear();
        for (i = 0; i < 100; ++i) {
            keySubject = String.format(":.ctx:TestSubject%03d-key", i);
            valueSubject = String.format(":.ctx:TestSubject%03d-value", i);
            Schema keySchema = Schema.create((Schema.Type)Schema.Type.STRING);
            Schema valueSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
            this.mojo.client().register(keySubject, (ParsedSchema)new AvroSchema(keySchema));
            this.mojo.client().register(valueSubject, (ParsedSchema)new AvroSchema(valueSchema));
            if (i % 10 != 0) continue;
            String subjectPattern = String.format("^:.ctx:TestSubject%03d-(key|value)$", i);
            this.mojo.subjectPatterns.add(subjectPattern);
        }
        this.mojo.execute();
        for (i = 0; i < 100; ++i) {
            keySubject = String.format("_x3A.ctx_x3ATestSubject%03d-key", i);
            valueSubject = String.format("_x3A.ctx_x3ATestSubject%03d-value", i);
            File keySchemaFile = new File(this.tempDirectory, keySubject + ".avsc");
            File valueSchemaFile = new File(this.tempDirectory, valueSubject + ".avsc");
            if (i % 10 == 0) {
                Assert.assertTrue((boolean)keySchemaFile.exists());
                Assert.assertTrue((boolean)valueSchemaFile.exists());
                continue;
            }
            Assert.assertFalse((boolean)keySchemaFile.exists());
            Assert.assertFalse((boolean)valueSchemaFile.exists());
        }
    }
}

