/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.confluent.kafka.schemaregistry.maven.DeriveSchemaMojo;
import io.confluent.kafka.schemaregistry.maven.MojoUtils;
import io.confluent.kafka.schemaregistry.maven.SchemaRegistryTest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.maven.plugin.MojoExecutionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeriveSchemaMojoTest
extends SchemaRegistryTest {
    DeriveSchemaMojo mojo;
    private final ObjectMapper mapper = new ObjectMapper();

    @Before
    public void createMojoAndFiles() {
        this.mojo = new DeriveSchemaMojo();
        this.makeMessageFile();
        this.mojo.messagePath = new File(this.tempDirectory, "/message.json");
        this.mojo.outputPath = new File(this.tempDirectory, "/ans.json");
    }

    private void makeMessageFile() {
        String message = "{\"F1\": 1}";
        try (FileWriter writer = new FileWriter(this.tempDirectory + "/message.json");){
            writer.write(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkExpected(String expectedSchema) throws IOException {
        String schema = MojoUtils.readFile((File)this.mojo.outputPath, (Charset)StandardCharsets.UTF_8);
        JsonNode schemaInfo = this.mapper.readTree(schema);
        assert (schemaInfo.has("schemas"));
        assert (schemaInfo.get("schemas") instanceof ArrayNode);
        Assert.assertEquals((long)schemaInfo.get("schemas").size(), (long)1L);
        JsonNode outputSchema = schemaInfo.get("schemas").get(0).get("schema");
        if (outputSchema.isTextual()) {
            Assert.assertEquals((Object)expectedSchema, (Object)outputSchema.asText());
        } else {
            Assert.assertEquals((Object)expectedSchema, (Object)outputSchema.toString());
        }
    }

    @Test
    public void testProtobuf() throws MojoExecutionException, IOException {
        this.mojo.schemaType = "protobuf";
        this.mojo.execute();
        String expectedSchema = "syntax = \"proto3\";\n\nmessage Schema {\n  int32 F1 = 1;\n}\n";
        this.checkExpected(expectedSchema);
    }

    @Test
    public void testAvro() throws MojoExecutionException, IOException {
        this.mojo.schemaType = "avro";
        this.mojo.execute();
        String expectedSchema = "{\"type\":\"record\",\"name\":\"Schema\",\"fields\":[{\"name\":\"F1\",\"type\":\"int\"}]}";
        this.checkExpected(expectedSchema);
    }

    @Test
    public void testJson() throws MojoExecutionException, IOException {
        this.mojo.schemaType = "json";
        this.mojo.execute();
        String expectedSchema = "{\"type\":\"object\",\"properties\":{\"F1\":{\"type\":\"number\"}}}";
        this.checkExpected(expectedSchema);
    }
}

