/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.maven.Reference;
import io.confluent.kafka.schemaregistry.maven.RegisterSchemaRegistryMojo;
import io.confluent.kafka.schemaregistry.maven.SchemaRegistryTest;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.avro.Schema;
import org.junit.Assert;
import org.junit.Test;

public class SchemasWithDependenciesTest
extends SchemaRegistryTest {
    private final String dependency = "{\n  \"type\": \"record\",\n  \"namespace\": \"com.pizza\",\n  \"name\": \"Amount\",\n  \"fields\": [\n    {\n      \"name\": \"amount\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"currency\",\n      \"type\": \"string\"\n    }\n  ]\n}";
    private final String schema = "{\n  \"type\": \"record\",\n  \"namespace\": \"com.pizza\",\n  \"name\": \"Pizza\",\n  \"fields\": [\n    {\n      \"name\": \"name\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"cost\",\n      \"type\": \"com.pizza.Amount\"\n    }\n  ]\n}";

    @Test
    public void testSchemaWithDependencies() throws Exception {
        RegisterSchemaRegistryMojo schemaRegistryMojo = new RegisterSchemaRegistryMojo();
        schemaRegistryMojo.client = new MockSchemaRegistryClient();
        File pizzaFile = new File(this.tempDirectory, "pizza.avsc");
        File amountFile = new File(this.tempDirectory, "amount.avsc");
        try (FileWriter pizzaWriter = new FileWriter(pizzaFile);
             FileWriter amountWriter = new FileWriter(amountFile);){
            pizzaWriter.write("{\n  \"type\": \"record\",\n  \"namespace\": \"com.pizza\",\n  \"name\": \"Pizza\",\n  \"fields\": [\n    {\n      \"name\": \"name\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"cost\",\n      \"type\": \"com.pizza.Amount\"\n    }\n  ]\n}");
            amountWriter.write("{\n  \"type\": \"record\",\n  \"namespace\": \"com.pizza\",\n  \"name\": \"Amount\",\n  \"fields\": [\n    {\n      \"name\": \"amount\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"currency\",\n      \"type\": \"string\"\n    }\n  ]\n}");
        }
        LinkedHashMap schemaRefs = new LinkedHashMap();
        ArrayList<Reference> subjectRefs = new ArrayList<Reference>();
        Reference ref = new Reference();
        ref.name = "com.pizza.Amount";
        ref.subject = "Amount";
        subjectRefs.add(ref);
        schemaRefs.put("Pizza", subjectRefs);
        schemaRegistryMojo.references = schemaRefs;
        LinkedHashMap<String, File> schemas = new LinkedHashMap<String, File>();
        schemas.put("Amount", amountFile);
        schemas.put("Pizza", pizzaFile);
        schemaRegistryMojo.subjects = schemas;
        schemaRegistryMojo.execute();
        Schema pizza = ((AvroSchema)schemaRegistryMojo.schemas.get("Pizza")).rawSchema();
        Assert.assertNotNull((String)"The schema should've been generated", (Object)pizza);
        Assert.assertTrue((String)"The schema should contain fields from the dependency", (boolean)pizza.toString().contains("currency"));
    }
}

