/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.maven.SchemaRegistryMojo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="download")
public class DownloadSchemaRegistryMojo
extends SchemaRegistryMojo {
    @Parameter(required=false)
    String schemaExtension;
    @Parameter(required=true)
    List<String> subjectPatterns = new ArrayList<String>();
    @Parameter(required=true)
    File outputDirectory;

    Map<String, ParsedSchema> downloadSchemas(Collection<String> subjects) throws MojoExecutionException {
        LinkedHashMap<String, ParsedSchema> results = new LinkedHashMap<String, ParsedSchema>();
        for (String subject : subjects) {
            try {
                this.getLog().info((CharSequence)String.format("Downloading latest metadata for %s.", subject));
                SchemaMetadata schemaMetadata = this.client().getLatestSchemaMetadata(subject);
                Optional schema = this.client().parseSchema(schemaMetadata.getSchemaType(), schemaMetadata.getSchema(), schemaMetadata.getReferences());
                if (schema.isPresent()) {
                    results.put(subject, (ParsedSchema)schema.get());
                    continue;
                }
                throw new MojoExecutionException(String.format("Error while parsing schema for %s", subject));
            }
            catch (Exception ex) {
                throw new MojoExecutionException(String.format("Exception thrown while downloading metadata for %s.", subject), ex);
            }
        }
        return results;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Collection allSubjects;
        try {
            this.getLog().debug((CharSequence)String.format("Checking if '%s' exists and is not a directory.", this.outputDirectory));
            if (this.outputDirectory.exists() && !this.outputDirectory.isDirectory()) {
                throw new IllegalStateException("outputDirectory must be a directory");
            }
            this.getLog().debug((CharSequence)String.format("Checking if outputDirectory('%s') exists.", this.outputDirectory));
            if (!this.outputDirectory.isDirectory()) {
                this.getLog().debug((CharSequence)String.format("Creating outputDirectory('%s').", this.outputDirectory));
                if (!this.outputDirectory.mkdirs()) {
                    throw new IllegalStateException("Could not create output directory " + this.outputDirectory);
                }
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Exception thrown while creating outputDirectory", ex);
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String subject : this.subjectPatterns) {
            try {
                this.getLog().debug((CharSequence)String.format("Creating pattern for '%s'", subject));
                Pattern pattern = Pattern.compile(subject);
                patterns.add(pattern);
            }
            catch (Exception ex) {
                throw new IllegalStateException(String.format("Exception thrown while creating pattern '%s'", subject), ex);
            }
        }
        try {
            this.getLog().info((CharSequence)"Getting all subjects on schema registry...");
            allSubjects = this.client().getAllSubjects();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Exception thrown", ex);
        }
        this.getLog().info((CharSequence)String.format("Schema Registry has %s subject(s).", allSubjects.size()));
        LinkedHashSet<String> subjectsToDownload = new LinkedHashSet<String>();
        block14: for (String subject : allSubjects) {
            for (Pattern pattern : patterns) {
                this.getLog().debug((CharSequence)String.format("Checking '%s' against pattern '%s'", subject, pattern.pattern()));
                Matcher matcher = pattern.matcher(subject);
                if (!matcher.matches()) continue;
                this.getLog().debug((CharSequence)String.format("'%s' matches pattern '%s' so downloading.", subject, pattern.pattern()));
                subjectsToDownload.add(subject);
                continue block14;
            }
        }
        Map<String, ParsedSchema> subjectToSchema = this.downloadSchemas(subjectsToDownload);
        for (Map.Entry<String, ParsedSchema> kvp : subjectToSchema.entrySet()) {
            String fileName = String.format("%s%s", kvp.getKey(), this.getExtension(kvp.getValue()));
            File outputFile = new File(this.outputDirectory, fileName);
            this.getLog().info((CharSequence)String.format("Writing schema for Subject(%s) to %s.", kvp.getKey(), outputFile));
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8);){
                writer.write(kvp.getValue().toString());
            }
            catch (Exception ex) {
                throw new MojoExecutionException(String.format("Exception thrown while writing subject('%s') schema to %s", kvp.getKey(), outputFile), ex);
            }
        }
    }

    private String getExtension(ParsedSchema parsedSchema) {
        if (this.schemaExtension != null) {
            return this.schemaExtension;
        }
        switch (parsedSchema.schemaType()) {
            case "AVRO": {
                return ".avsc";
            }
            case "JSON": {
                return ".schema.json";
            }
            case "PROTOBUF": {
                return ".proto";
            }
        }
        return ".txt";
    }
}

