/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.bearerauth;

import io.confluent.kafka.schemaregistry.client.security.bearerauth.StaticTokenCredentialProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Assert;
import org.junit.Test;

public class StaticTokenCredentialProviderTest {
    @Test
    public void testBearerToken() throws MalformedURLException {
        HashMap<String, String> clientConfig = new HashMap<String, String>();
        clientConfig.put("bearer.auth.token", "auth-token");
        clientConfig.put("bearer.auth.logical.cluster", "lsrc-xyz123");
        StaticTokenCredentialProvider provider = new StaticTokenCredentialProvider();
        provider.configure(clientConfig);
        Assert.assertEquals((Object)"auth-token", (Object)provider.getBearerToken(new URL("http://localhost")));
        Assert.assertEquals((Object)"lsrc-xyz123", (Object)provider.getTargetSchemaRegistry());
        Assert.assertNull((Object)provider.getTargetIdentityPoolId());
    }

    @Test(expected=ConfigException.class)
    public void testNulBearerToken() throws MalformedURLException {
        HashMap clientConfig = new HashMap();
        StaticTokenCredentialProvider provider = new StaticTokenCredentialProvider();
        provider.configure(clientConfig);
    }
}

