/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.bearerauth;

import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProviderFactory;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.CustomBearerAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.StaticTokenCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.OauthCredentialProvider;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BearerAuthCredentialProviderFactoryTest {
    private Map<String, String> CONFIG_MAP = new HashMap<String, String>();

    @Before
    public void setup() throws IOException {
        this.CONFIG_MAP.put("bearer.auth.token", "auth-token");
    }

    @Test
    public void testStaticTokenCredentialProvider() {
        HashMap<String, String> CONFIG_MAP = new HashMap<String, String>();
        CONFIG_MAP.put("bearer.auth.token", "auth-token");
        this.assertInstance(BearerAuthCredentialProviderFactory.getBearerAuthCredentialProvider((String)"STATIC_TOKEN", CONFIG_MAP), StaticTokenCredentialProvider.class);
    }

    @Test
    public void testOAuthCredentialProvider() {
        HashMap<String, String> CONFIG_MAP = new HashMap<String, String>();
        CONFIG_MAP.put("bearer.auth.logical.cluster", "lsrc-dummy");
        CONFIG_MAP.put("bearer.auth.identity.pool.id", "my-pool-id");
        CONFIG_MAP.put("bearer.auth.scope", "test-scope");
        CONFIG_MAP.put("bearer.auth.client.secret", "mysecret");
        CONFIG_MAP.put("bearer.auth.client.id", "myid");
        CONFIG_MAP.put("bearer.auth.issuer.endpoint.url", "https://okta.com");
        this.assertInstance(BearerAuthCredentialProviderFactory.getBearerAuthCredentialProvider((String)"OAUTHBEARER", CONFIG_MAP), OauthCredentialProvider.class);
    }

    @Test
    public void testCustomBearerAuthCredentialProvider() {
        HashMap<String, String> CONFIG_MAP = new HashMap<String, String>();
        CONFIG_MAP.put("bearer.auth.logical.cluster", "lsrc-dummy");
        CONFIG_MAP.put("bearer.auth.identity.pool.id", "my-pool-id");
        CONFIG_MAP.put("bearer.auth.custom.provider.class", StaticTokenCredentialProvider.class.getName());
        CONFIG_MAP.put("bearer.auth.token", "custom-token");
        this.assertInstance(BearerAuthCredentialProviderFactory.getBearerAuthCredentialProvider((String)"CUSTOM", CONFIG_MAP), CustomBearerAuthCredentialProvider.class);
    }

    @Test
    public void testUnknownProvider() {
        Assert.assertNull((Object)BearerAuthCredentialProviderFactory.getBearerAuthCredentialProvider((String)"UNKNOWN", this.CONFIG_MAP));
    }

    public void assertInstance(BearerAuthCredentialProvider instance, Class<? extends BearerAuthCredentialProvider> klass) {
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals(klass, instance.getClass());
    }
}

