/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities.requests;

import com.google.common.collect.ImmutableSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaEntity;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTags;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.TagSchemaRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class TagSchemaRequestTest {
    @Test
    public void testMergeSchemaTags() {
        SchemaEntity entity1 = new SchemaEntity("SampleRecord.f1", SchemaEntity.EntityType.SR_FIELD);
        SchemaEntity entity2 = new SchemaEntity(".SampleRecord.f1", SchemaEntity.EntityType.SR_FIELD);
        SchemaTags tag1 = new SchemaTags(entity1, Collections.singletonList("tag1"));
        SchemaTags tag2 = new SchemaTags(entity2, Collections.singletonList("tag2"));
        Map result = TagSchemaRequest.schemaTagsListToMap(Arrays.asList(tag1, tag2));
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey(entity1));
        Assert.assertTrue((boolean)result.containsKey(entity2));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"tag1", (Object)"tag2"), result.get(entity1));
    }

    @Test
    public void testMergeSchemaTagsOrder() {
        SchemaEntity entity1 = new SchemaEntity("com.example.SampleRecord.f1", SchemaEntity.EntityType.SR_FIELD);
        SchemaEntity entity2 = new SchemaEntity("SampleRecord.f1", SchemaEntity.EntityType.SR_FIELD);
        SchemaEntity entity3 = new SchemaEntity("SampleRecord.f2", SchemaEntity.EntityType.SR_FIELD);
        SchemaTags tag1 = new SchemaTags(entity1, Collections.singletonList("tag1"));
        SchemaTags tag2 = new SchemaTags(entity2, Collections.singletonList("tag2"));
        SchemaTags tag3 = new SchemaTags(entity3, Collections.singletonList("tag3"));
        Map result = TagSchemaRequest.schemaTagsListToMap(Arrays.asList(tag1, tag2, tag3));
        Assert.assertEquals((long)3L, (long)result.size());
        Iterator mapIter = result.keySet().iterator();
        Assert.assertEquals((Object)"com.example.SampleRecord.f1", (Object)((SchemaEntity)mapIter.next()).getEntityPath());
        Assert.assertEquals((Object)"SampleRecord.f1", (Object)((SchemaEntity)mapIter.next()).getEntityPath());
        Assert.assertEquals((Object)"SampleRecord.f2", (Object)((SchemaEntity)mapIter.next()).getEntityPath());
    }
}

