/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;

public class MergeEntitiesTest {
    @Test
    public void mergeMetadatas() throws Exception {
        HashMap<String, Set<String>> tags = new HashMap<String, Set<String>>();
        tags.put("**.ssn", Collections.singleton("PII"));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key1", "value1");
        HashSet<String> sensitive = new HashSet<String>();
        sensitive.add("key1");
        Metadata m1 = new Metadata(tags, properties, sensitive);
        Metadata m2 = new Metadata(Collections.emptyMap(), Collections.emptyMap(), null);
        Metadata m3 = Metadata.mergeMetadata((Metadata)m1, (Metadata)m2);
        TestCase.assertEquals(m3.getTags().get("**.ssn"), Collections.singleton("PII"));
        TestCase.assertEquals((String)((String)m3.getProperties().get("key1")), (String)"value1");
        Assert.assertTrue((boolean)m3.getSensitive().contains("key1"));
        tags = new HashMap();
        tags.put("**.ssn", Collections.singleton("PRIVATE"));
        properties = new HashMap();
        properties.put("key2", "value2");
        sensitive = new HashSet();
        sensitive.add("key2");
        m2 = new Metadata(tags, properties, sensitive);
        Metadata m4 = Metadata.mergeMetadata((Metadata)m1, (Metadata)m2);
        TestCase.assertEquals(m4.getTags().get("**.ssn"), Collections.singleton("PRIVATE"));
        TestCase.assertEquals((String)((String)m4.getProperties().get("key1")), (String)"value1");
        TestCase.assertEquals((String)((String)m4.getProperties().get("key2")), (String)"value2");
        Assert.assertTrue((boolean)m4.getSensitive().contains("key1"));
        Assert.assertTrue((boolean)m4.getSensitive().contains("key2"));
    }

    @Test
    public void mergeRuleSets() throws Exception {
        Rule r1 = new Rule("hi", null, null, null, null, null, null, null, null, null, false);
        Rule r2 = new Rule("bye", null, null, null, null, null, null, null, null, null, false);
        ImmutableList rules1 = ImmutableList.of((Object)r1, (Object)r2);
        RuleSet rs1 = new RuleSet((List)rules1, null);
        ImmutableList rules2 = ImmutableList.of((Object)r2, (Object)r1);
        RuleSet rs2 = new RuleSet((List)rules2, null);
        RuleSet rs3 = RuleSet.mergeRuleSets((RuleSet)rs1, (RuleSet)rs2);
        TestCase.assertEquals((Object)rs3.getMigrationRules(), (Object)rules2);
        rs3 = RuleSet.mergeRuleSets((RuleSet)rs2, (RuleSet)rs1);
        TestCase.assertEquals((Object)rs3.getMigrationRules(), (Object)rules1);
    }

    @Test
    public void invalidRuleSets() throws Exception {
        Rule r1 = new Rule(null, null, null, null, "DUMMY", null, null, null, null, null, false);
        try {
            r1.validate();
            Assert.fail();
        }
        catch (RuleException e) {
            TestCase.assertEquals((String)"Missing rule name", (String)e.getMessage());
        }
        Rule r2 = new Rule("", null, null, null, "DUMMY", null, null, null, null, null, false);
        try {
            r2.validate();
            Assert.fail();
        }
        catch (RuleException e) {
            TestCase.assertEquals((String)"Empty rule name", (String)e.getMessage());
        }
        Rule r3 = new Rule("0", null, null, null, "DUMMY", null, null, null, null, null, false);
        try {
            r3.validate();
            Assert.fail();
        }
        catch (RuleException e) {
            Assert.assertTrue((String)"Illegal ", (boolean)e.getMessage().startsWith("Illegal initial character"));
        }
        Rule r4 = new Rule("With space", null, null, null, "DUMMY", null, null, null, null, null, false);
        try {
            r4.validate();
            Assert.fail();
        }
        catch (RuleException e) {
            Assert.assertTrue((String)"Illegal ", (boolean)e.getMessage().startsWith("Illegal character"));
        }
    }
}

