/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.utils;

import com.mapr.fs.MapRFileSystem;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkMarshallingError;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryDiscoveryClient {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaRegistryDiscoveryClient.class);
    protected static final String SCHEMAREGISTRY_ZK_NAMESPACE_PREFIX = "schema_registry_";
    protected static final String SCHEMAREGISTRY_ZK_URLS_DIR = "/sr_urls";
    private String serviceId = "default_";
    private int timeoutMs = 60000;
    private int retries = 6;
    private long intervalMs = 15000L;

    public List<String> discoverUrls() {
        String schemaRegistryZkUrl = this.getSchemaRegistryZkUrl();
        LOG.info("Discovering Schema Registry from Zookeeper {} ({} retries with interval {} ms)", new Object[]{schemaRegistryZkUrl, this.retries, this.intervalMs});
        int retries = this.retries;
        while (true) {
            --retries;
            try {
                List<String> urls = this.readSchemaRegistryUrlsFromZookeeper(schemaRegistryZkUrl);
                if (!urls.isEmpty()) {
                    LOG.info("Discovered Schema Registry urls: {}", urls);
                    return urls;
                }
                if (retries > 0) {
                    LOG.warn("Schema Registry Urls are not available, retrying after the interval {} ms (attempts left: {})", (Object)this.intervalMs, (Object)retries);
                    Utils.sleep((long)this.intervalMs);
                    continue;
                }
                throw new IllegalStateException(String.format("Schema Registry Discovery failed with service id '%s'", this.serviceId));
            }
            catch (Exception e) {
                if (retries > 0) {
                    LOG.warn("Failed to discover Schema Registry, retrying after the interval {} ms (attempts left: {})", new Object[]{this.intervalMs, retries, e});
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readSchemaRegistryUrlsFromZookeeper(String zkUrl) {
        try (ZkClient zkClient = this.createZkClient(zkUrl);){
            if (!zkClient.exists(SCHEMAREGISTRY_ZK_URLS_DIR)) {
                List<String> list = Collections.emptyList();
                return list;
            }
            List<String> list = zkClient.getChildren(SCHEMAREGISTRY_ZK_URLS_DIR).stream().map(child -> "/sr_urls/" + child).map(fullPath -> zkClient.readData(fullPath).toString()).collect(Collectors.toList());
            return list;
        }
    }

    private String getSchemaRegistryZkUrl() {
        String srZkNamespace = SCHEMAREGISTRY_ZK_NAMESPACE_PREFIX + this.serviceId;
        String srClusterZkUrl = this.getZkUrl();
        String zkConnForNamespaceCreation = StringUtils.substringBefore((String)srClusterZkUrl, (String)"/");
        return zkConnForNamespaceCreation + "/" + srZkNamespace;
    }

    protected ZkClient createZkClient(String zkUrl) {
        return new ZkClient(zkUrl, this.timeoutMs, this.timeoutMs, (ZkSerializer)new ZKStringSerializer());
    }

    protected String getZkUrl() {
        try {
            MapRFileSystem mfs = (MapRFileSystem)FileSystem.get((Configuration)new Configuration());
            return Objects.requireNonNull(mfs.getZkConnectString());
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot receive Zookeeper URL from MapR-FS", e);
        }
    }

    public SchemaRegistryDiscoveryClient serviceId(String serviceId) {
        if (StringUtils.isEmpty((CharSequence)serviceId)) {
            throw new IllegalArgumentException("serviceId should not be empty");
        }
        this.serviceId = serviceId;
        return this;
    }

    public SchemaRegistryDiscoveryClient timeout(int timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    public SchemaRegistryDiscoveryClient retries(int retries) {
        this.retries = retries;
        return this;
    }

    public SchemaRegistryDiscoveryClient retryInterval(long intervalMs) {
        this.intervalMs = intervalMs;
        return this;
    }

    private static class ZKStringSerializer
    implements ZkSerializer {
        private ZKStringSerializer() {
        }

        public byte[] serialize(Object data) throws ZkMarshallingError {
            return data.toString().getBytes(StandardCharsets.UTF_8);
        }

        public Object deserialize(byte[] bytes) throws ZkMarshallingError {
            if (bytes == null) {
                return null;
            }
            return new String(bytes, StandardCharsets.UTF_8);
        }
    }
}

