/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.testing.FakeTicker;
import com.google.crypto.tink.aead.AeadConfig;
import io.confluent.dekregistry.DekRegistryResourceExtension;
import io.confluent.dekregistry.client.CachedDekRegistryClient;
import io.confluent.dekregistry.client.DekRegistryClient;
import io.confluent.dekregistry.client.rest.DekRegistryRestService;
import io.confluent.dekregistry.client.rest.entities.Dek;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.encryption.FieldEncryptionProperties;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.RuleSet;
import io.confluent.kafka.schemaregistry.storage.RuleSetHandler;
import io.confluent.kafka.schemaregistry.testutil.FakeClock;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class RestApiFieldEncryptionTest
extends ClusterTestHarness {
    public RestApiFieldEncryptionTest() {
        super(1, true);
    }

    protected abstract FieldEncryptionProperties getFieldEncryptionProperties(List<String> var1);

    protected Properties getSchemaRegistryProperties() throws Exception {
        Properties props = new Properties();
        props.setProperty("resource.extension.class", DekRegistryResourceExtension.class.getName());
        Object testClient = this.getFieldEncryptionProperties(null).getTestClient();
        if (testClient != null) {
            props.put("test.client", testClient);
        }
        return props;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ((KafkaSchemaRegistry)this.restApp.schemaRegistry()).setRuleSetHandler(new RuleSetHandler(){

            public void handle(String subject, ConfigUpdateRequest request) {
            }

            public void handle(String subject, boolean normalize, RegisterSchemaRequest request) {
            }

            public RuleSet transform(io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet ruleSet) {
                return ruleSet != null ? new RuleSet(ruleSet) : null;
            }
        });
    }

    @Test
    public void testPrivateKek() throws Exception {
        ImmutableList ruleNames = ImmutableList.of((Object)"myRule");
        FieldEncryptionProperties fieldEncryptionProps = this.getFieldEncryptionProperties((List<String>)ruleNames);
        CachedDekRegistryClient dekRegistry = new CachedDekRegistryClient(new DekRegistryRestService(this.restApp.restClient.getBaseUrls()), 1000, 600, Collections.emptyMap(), Collections.emptyMap());
        this.testFieldEncryption(fieldEncryptionProps, (DekRegistryClient)dekRegistry);
    }

    @Test
    public void testSharedKek() throws Exception {
        ImmutableList ruleNames = ImmutableList.of((Object)"myRule");
        FieldEncryptionProperties fieldEncryptionProps = this.getFieldEncryptionProperties((List<String>)ruleNames);
        CachedDekRegistryClient dekRegistry = new CachedDekRegistryClient(new DekRegistryRestService(this.restApp.restClient.getBaseUrls()), 1000, 600, Collections.emptyMap(), Collections.emptyMap());
        dekRegistry.createKek("kek1", fieldEncryptionProps.getKmsType(), fieldEncryptionProps.getKmsKeyId(), fieldEncryptionProps.getKmsProps(), null, true);
        this.testFieldEncryption(fieldEncryptionProps, (DekRegistryClient)dekRegistry);
    }

    private void testFieldEncryption(FieldEncryptionProperties fieldEncryptionProps, DekRegistryClient dekRegistry) throws Exception {
        String topic = "test";
        Map<String, Object> clientProps = fieldEncryptionProps.getClientProperties(this.restApp.restClient.getBaseUrls().toString());
        FakeTicker fakeTicker = new FakeTicker();
        CachedSchemaRegistryClient schemaRegistry = new CachedSchemaRegistryClient(this.restApp.restClient, 10, (List)ImmutableList.of((Object)new AvroSchemaProvider(), (Object)new ProtobufSchemaProvider(), (Object)new JsonSchemaProvider()), Collections.emptyMap(), Collections.emptyMap(), (Ticker)fakeTicker);
        KafkaAvroSerializer avroSerializer = new KafkaAvroSerializer((SchemaRegistryClient)schemaRegistry, clientProps);
        KafkaAvroDeserializer avroDeserializer = new KafkaAvroDeserializer((SchemaRegistryClient)schemaRegistry, clientProps);
        String subject = "test-value";
        AvroSchema schema = this.createUserSchema();
        RestApiFieldEncryptionTest.registerAndVerifySchema((SchemaRegistryClient)schemaRegistry, (ParsedSchema)schema, 1, subject);
        IndexedRecord avroRecord = this.createUserRecord();
        RecordHeaders headers = new RecordHeaders();
        byte[] bytes = avroSerializer.serialize(topic, (Headers)headers, (Object)avroRecord);
        GenericRecord record = (GenericRecord)avroDeserializer.deserialize(topic, (Headers)headers, bytes);
        Assert.assertEquals((Object)"testUser", (Object)record.get("name").toString());
        Rule rule = new Rule("myRule", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, null, null, "NONE,NONE", false);
        io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet ruleSet = new io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata(fieldEncryptionProps, "kek1");
        AvroSchema ruleSchema = new AvroSchema(null, Collections.emptyList(), Collections.emptyMap(), metadata, ruleSet, null, true);
        RestApiFieldEncryptionTest.registerAndVerifySchema((SchemaRegistryClient)schemaRegistry, (ParsedSchema)ruleSchema, 2, subject);
        fakeTicker.advance(61L, TimeUnit.SECONDS);
        bytes = avroSerializer.serialize(topic, (Headers)headers, (Object)avroRecord);
        record = (GenericRecord)avroDeserializer.deserialize(topic, (Headers)headers, bytes);
        Assert.assertEquals((Object)"testUser", (Object)record.get("name").toString());
        dekRegistry.deleteDek("kek1", subject, null, false);
        dekRegistry.deleteDek("kek1", subject, null, true);
        HashMap<String, Object> badClientProps = new HashMap<String, Object>(clientProps);
        badClientProps.remove("rule.executors");
        KafkaAvroDeserializer badDeserializer = new KafkaAvroDeserializer((SchemaRegistryClient)schemaRegistry, badClientProps);
        record = (GenericRecord)badDeserializer.deserialize(topic, (Headers)headers, bytes);
        Assert.assertNotEquals((Object)"testUser", (Object)record.get("name").toString());
    }

    @Test
    public void testFieldEncryptionWithDekRotation() throws Exception {
        ImmutableList ruleNames = ImmutableList.of((Object)"myRule");
        FieldEncryptionProperties fieldEncryptionProps = this.getFieldEncryptionProperties((List<String>)ruleNames);
        CachedDekRegistryClient dekRegistry = new CachedDekRegistryClient(new DekRegistryRestService(this.restApp.restClient.getBaseUrls()), 1000, 600, Collections.emptyMap(), Collections.emptyMap());
        String topic = "test";
        Map<String, Object> clientProps = fieldEncryptionProps.getClientProperties(this.restApp.restClient.getBaseUrls().toString());
        FakeTicker fakeTicker = new FakeTicker();
        FakeClock fakeClock = new FakeClock();
        clientProps.put("clock", fakeClock);
        CachedSchemaRegistryClient schemaRegistry = new CachedSchemaRegistryClient(this.restApp.restClient, 10, (List)ImmutableList.of((Object)new AvroSchemaProvider(), (Object)new ProtobufSchemaProvider(), (Object)new JsonSchemaProvider()), Collections.emptyMap(), Collections.emptyMap(), (Ticker)fakeTicker);
        KafkaAvroSerializer avroSerializer = new KafkaAvroSerializer((SchemaRegistryClient)schemaRegistry, clientProps);
        KafkaAvroDeserializer avroDeserializer = new KafkaAvroDeserializer((SchemaRegistryClient)schemaRegistry, clientProps);
        String subject = "test-value";
        AvroSchema schema = this.createUserSchema();
        RestApiFieldEncryptionTest.registerAndVerifySchema((SchemaRegistryClient)schemaRegistry, (ParsedSchema)schema, 1, subject);
        IndexedRecord avroRecord = this.createUserRecord();
        RecordHeaders headers = new RecordHeaders();
        byte[] bytes = avroSerializer.serialize(topic, (Headers)headers, (Object)avroRecord);
        GenericRecord record = (GenericRecord)avroDeserializer.deserialize(topic, (Headers)headers, bytes);
        Assert.assertEquals((Object)"testUser", (Object)record.get("name").toString());
        Rule rule = new Rule("myRule", null, null, null, "ENCRYPT", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), (Map)ImmutableMap.of((Object)"encrypt.dek.expiry.days", (Object)"1", (Object)"preserve.source.fields", (Object)"true"), null, null, "ERROR,NONE", false);
        io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet ruleSet = new io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule));
        Metadata metadata = this.getMetadata(fieldEncryptionProps, "kek1");
        AvroSchema ruleSchema = new AvroSchema(null, Collections.emptyList(), Collections.emptyMap(), metadata, ruleSet, null, true);
        RestApiFieldEncryptionTest.registerAndVerifySchema((SchemaRegistryClient)schemaRegistry, (ParsedSchema)ruleSchema, 2, subject);
        fakeTicker.advance(61L, TimeUnit.SECONDS);
        bytes = avroSerializer.serialize(topic, (Headers)headers, (Object)avroRecord);
        record = (GenericRecord)avroDeserializer.deserialize(topic, (Headers)headers, bytes);
        Assert.assertEquals((Object)"testUser", (Object)record.get("name").toString());
        fakeClock.advance(2L, ChronoUnit.DAYS);
        bytes = avroSerializer.serialize(topic, (Headers)headers, (Object)avroRecord);
        record = (GenericRecord)avroDeserializer.deserialize(topic, (Headers)headers, bytes);
        Assert.assertEquals((Object)"testUser", (Object)record.get("name").toString());
        fakeClock.advance(2L, ChronoUnit.DAYS);
        bytes = avroSerializer.serialize(topic, (Headers)headers, (Object)avroRecord);
        record = (GenericRecord)avroDeserializer.deserialize(topic, (Headers)headers, bytes);
        Assert.assertEquals((Object)"testUser", (Object)record.get("name").toString());
        Dek dek = dekRegistry.getDekLatestVersion("kek1", subject, null, false);
        Assert.assertEquals((long)3L, (long)dek.getVersion());
        dekRegistry.deleteDek("kek1", subject, null, false);
        dekRegistry.deleteDek("kek1", subject, null, true);
    }

    private AvroSchema createUserSchema() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": [\"null\", \"string\"], \"confluent:tags\": [\"PII\"]}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        return new AvroSchema(schema);
    }

    private IndexedRecord createUserRecord() {
        Schema schema = this.createUserSchema().rawSchema();
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)"testUser");
        return avroRecord;
    }

    private Metadata getMetadata(FieldEncryptionProperties fieldEncryptionProps, String kekName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("encrypt.kek.name", kekName);
        properties.put("encrypt.kms.type", fieldEncryptionProps.getKmsType());
        properties.put("encrypt.kms.key.id", fieldEncryptionProps.getKmsKeyId());
        return new Metadata(Collections.emptyMap(), properties, Collections.emptySet());
    }

    static void registerAndVerifySchema(SchemaRegistryClient schemaRegistry, ParsedSchema schema, int expectedId, String subject) throws IOException, RestClientException {
        int registeredId = schemaRegistry.register(subject, schema);
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)expectedId, (long)registeredId);
        ParsedSchema newSchema = schemaRegistry.getSchemaBySubjectAndId(subject, expectedId);
        Assert.assertNotNull((String)"Registered schema should be found", (Object)newSchema);
    }

    static {
        try {
            AeadConfig.register();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

