/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.tink;

import io.confluent.kafka.schemaregistry.encryption.tink.Cryptor;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class CryptorTest {
    @Test
    public void testRandomCryptor() throws Exception {
        Cryptor cryptor = new Cryptor(DekFormat.AES128_GCM);
        byte[] dek = cryptor.generateKey();
        byte[] plaintext = "hello world".getBytes(StandardCharsets.UTF_8);
        byte[] ciphertext = cryptor.encrypt(dek, plaintext, new byte[0]);
        Assert.assertNotEquals((Object)plaintext, (Object)ciphertext);
        plaintext = cryptor.decrypt(dek, ciphertext, new byte[0]);
        Assert.assertEquals((Object)"hello world", (Object)new String(plaintext, StandardCharsets.UTF_8));
    }

    @Test
    public void testRandomCryptor2() throws Exception {
        Cryptor cryptor = new Cryptor(DekFormat.AES256_GCM);
        byte[] dek = cryptor.generateKey();
        byte[] plaintext = "hello world".getBytes(StandardCharsets.UTF_8);
        byte[] ciphertext = cryptor.encrypt(dek, plaintext, new byte[0]);
        Assert.assertNotEquals((Object)plaintext, (Object)ciphertext);
        plaintext = cryptor.decrypt(dek, ciphertext, new byte[0]);
        Assert.assertEquals((Object)"hello world", (Object)new String(plaintext, StandardCharsets.UTF_8));
    }

    @Test
    public void testDeterministicCryptor() throws Exception {
        Cryptor cryptor = new Cryptor(DekFormat.AES256_SIV);
        byte[] dek = cryptor.generateKey();
        byte[] plaintext = "hello world".getBytes(StandardCharsets.UTF_8);
        byte[] ciphertext = cryptor.encrypt(dek, plaintext, new byte[0]);
        Assert.assertNotEquals((Object)plaintext, (Object)ciphertext);
        plaintext = cryptor.decrypt(dek, ciphertext, new byte[0]);
        Assert.assertEquals((Object)"hello world", (Object)new String(plaintext, StandardCharsets.UTF_8));
        byte[] ciphertext2 = cryptor.encrypt(dek, plaintext, new byte[0]);
        Assert.assertArrayEquals((byte[])ciphertext, (byte[])ciphertext2);
    }
}

