/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.hcvault;

import com.google.crypto.tink.KmsClient;
import io.confluent.kafka.schemaregistry.encryption.hcvault.HcVaultKmsClient;
import io.confluent.kafka.schemaregistry.encryption.tink.KmsDriver;
import io.github.jopenlibs.vault.api.Logical;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Optional;

public class HcVaultKmsDriver
implements KmsDriver {
    public static final String TOKEN_ID = "token.id";
    public static final String NAMESPACE = "namespace";

    public String getKeyUrlPrefix() {
        return "hcvault://";
    }

    private String getToken(Map<String, ?> configs) {
        return (String)configs.get(TOKEN_ID);
    }

    private String getNamespace(Map<String, ?> configs) {
        return (String)configs.get(NAMESPACE);
    }

    public KmsClient newKmsClient(Map<String, ?> configs, Optional<String> kekUrl) throws GeneralSecurityException {
        Logical testClient = (Logical)this.getTestClient(configs);
        Optional<String> creds = testClient != null ? Optional.empty() : Optional.ofNullable(this.getToken(configs));
        Optional<String> namespace = Optional.ofNullable(this.getNamespace(configs));
        return HcVaultKmsDriver.newKmsClientWithHcVaultKms(kekUrl, creds, namespace, testClient);
    }

    protected static KmsClient newKmsClientWithHcVaultKms(Optional<String> keyUri, Optional<String> credentials, Optional<String> namespace, Logical vault) throws GeneralSecurityException {
        HcVaultKmsClient client = keyUri.isPresent() ? new HcVaultKmsClient(keyUri.get()) : new HcVaultKmsClient();
        if (credentials.isPresent()) {
            client.withCredentials(credentials.get());
        } else {
            client.withDefaultCredentials();
        }
        if (vault != null) {
            client.withVault(vault);
        }
        return client;
    }
}

