/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.gcp;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.cloudkms.v1.CloudKMS;
import com.google.api.services.cloudkms.v1.model.DecryptRequest;
import com.google.api.services.cloudkms.v1.model.DecryptResponse;
import com.google.api.services.cloudkms.v1.model.EncryptRequest;
import com.google.api.services.cloudkms.v1.model.EncryptResponse;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.KeysetHandle;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class FakeCloudKms
extends CloudKMS {
    private final Map<String, Aead> aeads = new HashMap<String, Aead>();
    private final Projects projects = new Projects();

    public FakeCloudKms(List<String> validKeyIds) throws GeneralSecurityException {
        super(new HttpTransport(){

            protected LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                throw new IOException("Test should not have interacted with HttpTransport.");
            }
        }, (JsonFactory)new GsonFactory(), (HttpRequestInitializer)new GoogleCredential());
        for (String keyId : validKeyIds) {
            Aead aead = (Aead)KeysetHandle.generateNew((KeyTemplate)KeyTemplates.get((String)"AES128_GCM")).getPrimitive(Aead.class);
            this.aeads.put(keyId, aead);
        }
    }

    public Projects projects() {
        return this.projects;
    }

    final class Projects
    extends CloudKMS.Projects {
        private final Locations locations;

        Projects() {
            super((CloudKMS)FakeCloudKms.this);
            this.locations = new Locations();
        }

        public Locations locations() {
            return this.locations;
        }

        final class Locations
        extends CloudKMS.Projects.Locations {
            private final KeyRings keyRings;

            Locations() {
                super((CloudKMS.Projects)Projects.this);
                this.keyRings = new KeyRings();
            }

            public KeyRings keyRings() {
                return this.keyRings;
            }

            final class KeyRings
            extends CloudKMS.Projects.Locations.KeyRings {
                private final CryptoKeys cryptoKeys;

                KeyRings() {
                    super((CloudKMS.Projects.Locations)Locations.this);
                    this.cryptoKeys = new CryptoKeys();
                }

                public CryptoKeys cryptoKeys() {
                    return this.cryptoKeys;
                }

                final class CryptoKeys
                extends CloudKMS.Projects.Locations.KeyRings.CryptoKeys {
                    CryptoKeys() {
                        super((CloudKMS.Projects.Locations.KeyRings)KeyRings.this);
                    }

                    public Encrypt encrypt(String name, EncryptRequest request) {
                        return new Encrypt(name, request);
                    }

                    public Decrypt decrypt(String name, DecryptRequest request) {
                        return new Decrypt(name, request);
                    }

                    final class Decrypt
                    extends CloudKMS.Projects.Locations.KeyRings.CryptoKeys.Decrypt {
                        String name;
                        DecryptRequest request;

                        Decrypt(String name, DecryptRequest request) {
                            super((CloudKMS.Projects.Locations.KeyRings.CryptoKeys)CryptoKeys.this, name, request);
                            this.name = name;
                            this.request = request;
                        }

                        public DecryptResponse execute() throws IOException {
                            if (!FakeCloudKms.this.aeads.containsKey(this.name)) {
                                throw new IOException("Unknown key ID : " + this.name + " is not in " + FakeCloudKms.this.aeads.keySet());
                            }
                            try {
                                Aead aead = (Aead)FakeCloudKms.this.aeads.get(this.name);
                                byte[] plaintext = aead.decrypt(this.request.decodeCiphertext(), this.request.decodeAdditionalAuthenticatedData());
                                return new DecryptResponse().encodePlaintext(plaintext);
                            }
                            catch (GeneralSecurityException e) {
                                throw new IOException(e.getMessage());
                            }
                        }

                        public boolean equals(Object o) {
                            if (this == o) {
                                return true;
                            }
                            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                                return false;
                            }
                            if (!super.equals(o)) {
                                return false;
                            }
                            Decrypt decrypt = (Decrypt)((Object)o);
                            return Objects.equals(this.name, decrypt.name) && Objects.equals(this.request, decrypt.request);
                        }

                        public int hashCode() {
                            return Objects.hash(super.hashCode(), this.name, this.request);
                        }
                    }

                    final class Encrypt
                    extends CloudKMS.Projects.Locations.KeyRings.CryptoKeys.Encrypt {
                        String name;
                        EncryptRequest request;

                        Encrypt(String name, EncryptRequest request) {
                            super((CloudKMS.Projects.Locations.KeyRings.CryptoKeys)CryptoKeys.this, name, request);
                            this.name = name;
                            this.request = request;
                        }

                        public EncryptResponse execute() throws IOException {
                            if (!FakeCloudKms.this.aeads.containsKey(this.name)) {
                                throw new IOException("Unknown key ID : " + this.name + " is not in " + FakeCloudKms.this.aeads.keySet());
                            }
                            try {
                                Aead aead = (Aead)FakeCloudKms.this.aeads.get(this.name);
                                byte[] ciphertext = aead.encrypt(this.request.decodePlaintext(), this.request.decodeAdditionalAuthenticatedData());
                                return new EncryptResponse().encodeCiphertext(ciphertext);
                            }
                            catch (GeneralSecurityException e) {
                                throw new IOException(e.getMessage());
                            }
                        }

                        public boolean equals(Object o) {
                            if (this == o) {
                                return true;
                            }
                            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                                return false;
                            }
                            if (!super.equals(o)) {
                                return false;
                            }
                            Encrypt encrypt = (Encrypt)((Object)o);
                            return Objects.equals(this.name, encrypt.name) && Objects.equals(this.request, encrypt.request);
                        }

                        public int hashCode() {
                            return Objects.hash(super.hashCode(), this.name, this.request);
                        }
                    }
                }
            }
        }
    }
}

