/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaInject;
import com.kjetland.jackson.jsonSchema.annotations.JsonSchemaString;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializer;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.validation.constraints.Min;
import org.apache.kafka.common.errors.SerializationException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class KafkaJsonSchemaSerializerTest {
    private final Properties config = new Properties();
    private final SchemaRegistryClient schemaRegistry;
    private KafkaJsonSchemaSerializer<Object> serializer;
    private KafkaJsonSchemaDeserializer<Object> deserializer;
    private final String topic;

    public KafkaJsonSchemaSerializerTest() {
        this.config.put("auto.register.schemas", (Object)true);
        this.config.put("schema.registry.url", "bogus");
        this.config.put("json.fail.invalid.schema", (Object)true);
        this.schemaRegistry = new MockSchemaRegistryClient();
        this.serializer = new KafkaJsonSchemaSerializer(this.schemaRegistry, new HashMap<Object, Object>(this.config));
        this.deserializer = this.getDeserializer(Object.class);
        this.topic = "test";
    }

    private <T> KafkaJsonSchemaDeserializer<T> getDeserializer(Class<T> cls) {
        return new KafkaJsonSchemaDeserializer(this.schemaRegistry, new HashMap<Object, Object>(this.config), cls);
    }

    @Test
    public void testKafkaJsonSchemaSerializer() {
        byte[] bytes = this.serializer.serialize(this.topic, null);
        Assert.assertEquals(null, (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)true);
        Assert.assertEquals((Object)true, (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)123);
        Assert.assertEquals((Object)123, (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)345L);
        Assert.assertEquals((Object)345, (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)Float.valueOf(1.23f));
        Assert.assertEquals((Object)new BigDecimal("1.23"), (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)2.34);
        Assert.assertEquals((Object)new BigDecimal("2.34"), (Object)this.deserializer.deserialize(this.topic, bytes));
        bytes = this.serializer.serialize(this.topic, (Object)"abc");
        Assert.assertEquals((Object)"abc", (Object)this.deserializer.deserialize(this.topic, bytes));
    }

    @Test
    public void serializeNull() {
        Assert.assertNull((Object)this.serializer.serialize("foo", null));
    }

    @Test
    @Ignore
    public void serializeMap() throws Exception {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("foo", "bar");
        message.put("baz", new BigDecimal("354.99"));
        byte[] bytes = this.serializer.serialize("foo", message);
        Object deserialized = this.deserializer.deserialize(this.topic, bytes);
        Assert.assertEquals(message, (Object)deserialized);
    }

    @Test
    public void serializeUser() throws Exception {
        User user = new User("john", "doe", 50);
        byte[] bytes = this.serializer.serialize("foo", (Object)user);
        Object deserialized = this.getDeserializer(User.class).deserialize(this.topic, bytes);
        Assert.assertEquals((Object)user, (Object)deserialized);
        deserialized = this.getDeserializer(null).deserialize(this.topic, bytes);
        Assert.assertEquals((Object)user, (Object)deserialized);
        deserialized = this.getDeserializer(Object.class).deserialize(this.topic, bytes);
        Assert.assertEquals((Object)user, (Object)deserialized);
    }

    @Test(expected=SerializationException.class)
    public void serializeInvalidUser() throws Exception {
        User user = new User("john", "doe", -1, "jack");
        byte[] bytes = this.serializer.serialize("foo", (Object)user);
        Object deserialized = this.getDeserializer(User.class).deserialize(this.topic, bytes);
        Assert.assertEquals((Object)user, (Object)deserialized);
    }

    @JsonSchemaInject(strings={@JsonSchemaString(path="javaType", value="io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializerTest$User")})
    public static class User {
        @JsonProperty
        public String firstName;
        @JsonProperty
        public String lastName;
        @JsonProperty
        @Min(value=0L)
        public @Min(value=0L) short age;
        @JsonProperty
        public Optional<String> nickName;

        public User() {
        }

        public User(String firstName, String lastName, short age) {
            this(firstName, lastName, age, null);
        }

        public User(String firstName, String lastName, short age, String nickName) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.age = age;
            this.nickName = Optional.ofNullable(nickName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            return this.age == user.age && Objects.equals(this.firstName, user.firstName) && Objects.equals(this.lastName, user.lastName) && Objects.equals(this.nickName, user.nickName);
        }

        public int hashCode() {
            return Objects.hash(this.firstName, this.lastName, this.age, this.nickName);
        }
    }
}

