/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.schemaregistry.json.SpecificationVersion;
import java.util.ArrayList;
import java.util.Iterator;
import org.everit.json.schema.ValidationException;
import org.junit.Assert;
import org.junit.Test;

public class JsonSchemaTest {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static final String recordSchemaString = "{\"properties\": {\n     \"null\": {\"type\": \"null\"},\n     \"boolean\": {\"type\": \"boolean\"},\n     \"number\": {\"type\": \"number\"},\n     \"string\": {\"type\": \"string\"}\n  },\n  \"additionalProperties\": false\n}";
    private static final JsonSchema recordSchema = new JsonSchema("{\"properties\": {\n     \"null\": {\"type\": \"null\"},\n     \"boolean\": {\"type\": \"boolean\"},\n     \"number\": {\"type\": \"number\"},\n     \"string\": {\"type\": \"string\"}\n  },\n  \"additionalProperties\": false\n}");
    private static final String arraySchemaString = "{\"type\": \"array\", \"items\": { \"type\": \"string\" } }";
    private static final JsonSchema arraySchema = new JsonSchema("{\"type\": \"array\", \"items\": { \"type\": \"string\" } }");
    private static final String unionSchemaString = "{\n  \"oneOf\": [\n    { \"type\": \"string\", \"maxLength\": 5 },\n    { \"type\": \"number\", \"minimum\": 0 }\n  ]\n}";
    private static final JsonSchema unionSchema = new JsonSchema("{\n  \"oneOf\": [\n    { \"type\": \"string\", \"maxLength\": 5 },\n    { \"type\": \"number\", \"minimum\": 0 }\n  ]\n}");
    private static final String enumSchemaString = "{ \"type\": \"string\", \"enum\": [\"red\", \"amber\", \"green\"] }";
    private static final JsonSchema enumSchema = new JsonSchema("{ \"type\": \"string\", \"enum\": [\"red\", \"amber\", \"green\"] }");

    @Test
    public void testPrimitiveTypesToJsonSchema() throws Exception {
        Object envelope = JsonSchemaUtils.toObject((String)null, (JsonSchema)JsonSchemaTest.createPrimitiveSchema("null"));
        JsonNode result = (JsonNode)JsonSchemaUtils.getValue((Object)envelope);
        Assert.assertEquals((Object)NullNode.getInstance(), (Object)result);
        envelope = JsonSchemaUtils.toObject((String)"true", (JsonSchema)JsonSchemaTest.createPrimitiveSchema("boolean"));
        result = (JsonNode)JsonSchemaUtils.getValue((Object)envelope);
        Assert.assertEquals((Object)true, (Object)((BooleanNode)result).asBoolean());
        envelope = JsonSchemaUtils.toObject((String)"false", (JsonSchema)JsonSchemaTest.createPrimitiveSchema("boolean"));
        result = (JsonNode)JsonSchemaUtils.getValue((Object)envelope);
        Assert.assertEquals((Object)false, (Object)((BooleanNode)result).asBoolean());
        envelope = JsonSchemaUtils.toObject((String)"12", (JsonSchema)JsonSchemaTest.createPrimitiveSchema("number"));
        result = (JsonNode)JsonSchemaUtils.getValue((Object)envelope);
        Assert.assertEquals((long)12L, (long)((NumericNode)result).asInt());
        envelope = JsonSchemaUtils.toObject((String)"23.2", (JsonSchema)JsonSchemaTest.createPrimitiveSchema("number"));
        result = (JsonNode)JsonSchemaUtils.getValue((Object)envelope);
        Assert.assertEquals((double)23.2, (double)((NumericNode)result).asDouble(), (double)0.1);
        envelope = JsonSchemaUtils.toObject((String)"\"a string\"", (JsonSchema)JsonSchemaTest.createPrimitiveSchema("string"));
        result = (JsonNode)JsonSchemaUtils.getValue((Object)envelope);
        Assert.assertEquals((Object)"a string", (Object)((TextNode)result).asText());
    }

    @Test
    public void testRecordToJsonSchema() throws Exception {
        String json = "{\n    \"null\": null,\n    \"boolean\": true,\n    \"number\": 12,\n    \"string\": \"string\"\n}";
        JsonNode envelope = (JsonNode)JsonSchemaUtils.toObject((String)json, (JsonSchema)recordSchema);
        JsonNode result = (JsonNode)JsonSchemaUtils.getValue((Object)envelope);
        Assert.assertEquals((Object)true, (Object)result.get("null").isNull());
        Assert.assertEquals((Object)true, (Object)result.get("boolean").booleanValue());
        Assert.assertEquals((long)12L, (long)result.get("number").intValue());
        Assert.assertEquals((Object)"string", (Object)result.get("string").textValue());
    }

    @Test(expected=ValidationException.class)
    public void testInvalidRecordToJsonSchema() throws Exception {
        String json = "{\n    \"null\": null,\n    \"boolean\": true,\n    \"number\": 12,\n    \"string\": \"string\",\n    \"badString\": \"string\"\n}";
        JsonNode envelope = (JsonNode)JsonSchemaUtils.toObject((String)json, (JsonSchema)recordSchema);
        JsonNode result = (JsonNode)JsonSchemaUtils.getValue((Object)envelope);
        Assert.assertEquals((Object)true, (Object)result.get("null").isNull());
        Assert.assertEquals((Object)true, (Object)result.get("boolean").booleanValue());
        Assert.assertEquals((long)12L, (long)result.get("number").intValue());
        Assert.assertEquals((Object)"string", (Object)result.get("string").textValue());
    }

    @Test
    public void testArrayToJsonSchema() throws Exception {
        String json = "[\"one\", \"two\", \"three\"]";
        Object envelope = JsonSchemaUtils.toObject((String)json, (JsonSchema)arraySchema);
        JsonNode result = (JsonNode)JsonSchemaUtils.getValue((Object)envelope);
        ArrayNode arrayNode = (ArrayNode)result;
        Iterator elements = arrayNode.elements();
        ArrayList<String> strings = new ArrayList<String>();
        while (elements.hasNext()) {
            strings.add(((JsonNode)elements.next()).textValue());
        }
        Assert.assertArrayEquals((Object[])new String[]{"one", "two", "three"}, (Object[])strings.toArray());
    }

    @Test
    public void testUnionToJsonSchema() throws Exception {
        Object envelope = JsonSchemaUtils.toObject((String)"\"test\"", (JsonSchema)unionSchema);
        JsonNode result = (JsonNode)JsonSchemaUtils.getValue((Object)envelope);
        Assert.assertEquals((Object)"test", (Object)((TextNode)result).asText());
        envelope = JsonSchemaUtils.toObject((String)"12", (JsonSchema)unionSchema);
        result = (JsonNode)JsonSchemaUtils.getValue((Object)envelope);
        Assert.assertEquals((long)12L, (long)((NumericNode)result).asInt());
        try {
            JsonSchemaUtils.toObject((String)"-1", (JsonSchema)unionSchema);
            Assert.fail((String)"Trying to use negative number should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testEnumToJsonSchema() throws Exception {
        Object envelope = JsonSchemaUtils.toObject((String)"\"red\"", (JsonSchema)enumSchema);
        JsonNode result = (JsonNode)JsonSchemaUtils.getValue((Object)envelope);
        Assert.assertEquals((Object)"red", (Object)((TextNode)result).asText());
        try {
            JsonSchemaUtils.toObject((String)"\"yellow\"", (JsonSchema)enumSchema);
            Assert.fail((String)"Trying to use non-enum should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testPrimitiveTypesToJson() throws Exception {
        JsonNode result = objectMapper.readTree(JsonSchemaUtils.toJson((Object)0));
        Assert.assertTrue((boolean)result.isNumber());
        result = objectMapper.readTree(JsonSchemaUtils.toJson((Object)0L));
        Assert.assertTrue((boolean)result.isNumber());
        result = objectMapper.readTree(JsonSchemaUtils.toJson((Object)Float.valueOf(0.1f)));
        Assert.assertTrue((boolean)result.isNumber());
        result = objectMapper.readTree(JsonSchemaUtils.toJson((Object)0.1));
        Assert.assertTrue((boolean)result.isNumber());
        result = objectMapper.readTree(JsonSchemaUtils.toJson((Object)true));
        Assert.assertTrue((boolean)result.isBoolean());
        result = objectMapper.readTree(JsonSchemaUtils.toJson((Object)"abcdefg"));
        Assert.assertTrue((boolean)result.isTextual());
        Assert.assertEquals((Object)"abcdefg", (Object)result.textValue());
    }

    @Test
    public void testRecordToJson() throws Exception {
        String json = "{\n    \"null\": null,\n    \"boolean\": true,\n    \"number\": 12,\n    \"string\": \"string\"\n}";
        JsonNode data = new ObjectMapper().readTree(json);
        JsonNode result = objectMapper.readTree(JsonSchemaUtils.toJson((Object)data));
        Assert.assertTrue((boolean)result.isObject());
        Assert.assertTrue((boolean)result.get("null").isNull());
        Assert.assertTrue((boolean)result.get("boolean").isBoolean());
        Assert.assertEquals((Object)true, (Object)result.get("boolean").booleanValue());
        Assert.assertTrue((boolean)result.get("number").isIntegralNumber());
        Assert.assertEquals((long)12L, (long)result.get("number").intValue());
        Assert.assertTrue((boolean)result.get("string").isTextual());
        Assert.assertEquals((Object)"string", (Object)result.get("string").textValue());
    }

    @Test
    public void testArrayToJson() throws Exception {
        String json = "[\"one\", \"two\", \"three\"]";
        JsonNode data = new ObjectMapper().readTree(json);
        JsonNode result = objectMapper.readTree(JsonSchemaUtils.toJson((Object)data));
        Assert.assertTrue((boolean)result.isArray());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)JsonNodeFactory.instance.textNode("one"), (Object)result.get(0));
        Assert.assertEquals((Object)JsonNodeFactory.instance.textNode("two"), (Object)result.get(1));
        Assert.assertEquals((Object)JsonNodeFactory.instance.textNode("three"), (Object)result.get(2));
    }

    @Test
    public void testSchemaWithDraft4() throws Exception {
        TestObj testObj = new TestObj();
        String actual = JsonSchemaUtils.getSchema((Object)testObj, (SpecificationVersion)SpecificationVersion.DRAFT_4, (boolean)true, null).toString();
        String expected = "{\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"title\":\"Test Obj\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"prop\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]}}}";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSchemaWithOneofs() throws Exception {
        TestObj testObj = new TestObj();
        String actual = JsonSchemaUtils.getSchema((Object)testObj).toString();
        String expected = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Test Obj\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"prop\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]}}}";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSchemaWithoutOneofs() throws Exception {
        TestObj testObj = new TestObj();
        String actual = JsonSchemaUtils.getSchema((Object)testObj, (SpecificationVersion)SpecificationVersion.DRAFT_7, (boolean)false, null).toString();
        String expected = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Test Obj\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"prop\":{\"type\":\"string\"}}}";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private static JsonSchema createPrimitiveSchema(String type) {
        String schemaString = String.format("{\"type\" : \"%s\"}", type);
        return new JsonSchema(schemaString);
    }

    static class TestObj {
        private String prop;

        TestObj() {
        }

        public String getProp() {
            return this.prop;
        }
    }
}

