/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.protobuf;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.util.Timestamps;
import com.google.type.Date;
import com.google.type.TimeOfDay;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import io.confluent.connect.protobuf.ProtobufData;
import io.confluent.connect.protobuf.ProtobufDataConfig;
import io.confluent.connect.protobuf.test.KeyValue;
import io.confluent.connect.protobuf.test.KeyValueOptional;
import io.confluent.connect.protobuf.test.KeyValueProto2;
import io.confluent.connect.protobuf.test.KeyValueWrapper;
import io.confluent.connect.protobuf.test.MapReferences;
import io.confluent.connect.protobuf.test.NestedKeyValue;
import io.confluent.connect.protobuf.test.RecursiveKeyValue;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.serializers.protobuf.ProtobufSchemaAndValue;
import io.confluent.kafka.serializers.protobuf.test.DateValueOuterClass;
import io.confluent.kafka.serializers.protobuf.test.DecimalValueOuterClass;
import io.confluent.kafka.serializers.protobuf.test.EnumUnionOuter;
import io.confluent.kafka.serializers.protobuf.test.Int16ValueOuterClass;
import io.confluent.kafka.serializers.protobuf.test.Int8ValueOuterClass;
import io.confluent.kafka.serializers.protobuf.test.NestedTestProto;
import io.confluent.kafka.serializers.protobuf.test.SInt32ValueOuterClass;
import io.confluent.kafka.serializers.protobuf.test.SInt64ValueOuterClass;
import io.confluent.kafka.serializers.protobuf.test.TestMessageProtos;
import io.confluent.kafka.serializers.protobuf.test.TimeOfDayValueOuterClass;
import io.confluent.kafka.serializers.protobuf.test.TimestampValueOuterClass;
import io.confluent.kafka.serializers.protobuf.test.UInt32ValueOuterClass;
import io.confluent.protobuf.type.Decimal;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.errors.DataException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufDataTest {
    private static final Logger log = LoggerFactory.getLogger(ProtobufDataTest.class);
    private static Schema OPTIONAL_INT8_SCHEMA = SchemaBuilder.int8().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static Schema OPTIONAL_INT16_SCHEMA = SchemaBuilder.int16().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static Schema OPTIONAL_INT32_SCHEMA = SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static Schema OPTIONAL_INT64_SCHEMA = SchemaBuilder.int64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static Schema OPTIONAL_FLOAT32_SCHEMA = SchemaBuilder.float32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static Schema OPTIONAL_FLOAT64_SCHEMA = SchemaBuilder.float64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static Schema OPTIONAL_BOOLEAN_SCHEMA = SchemaBuilder.bool().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static Schema OPTIONAL_STRING_SCHEMA = SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static Schema OPTIONAL_BYTES_SCHEMA = SchemaBuilder.bytes().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
    private static final String VALUE_FIELD_NAME = "value";

    private SchemaAndValue getExpectedSchemaAndValue(Schema fieldSchema, Message message, Object value) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        schemaBuilder.name(message.getDescriptorForType().getName());
        schemaBuilder.field(VALUE_FIELD_NAME, fieldSchema);
        Schema schema = schemaBuilder.build();
        Struct expectedResult = new Struct(schema);
        expectedResult.put(VALUE_FIELD_NAME, value);
        return new SchemaAndValue(schema, (Object)expectedResult);
    }

    private StringValue createStringValueMessage(String messageText) {
        StringValue.Builder builder = StringValue.newBuilder();
        builder.setValue(messageText);
        return builder.build();
    }

    private EnumUnionOuter.EnumUnion createEnumUnionWithString() throws ParseException {
        EnumUnionOuter.EnumUnion.Builder message = EnumUnionOuter.EnumUnion.newBuilder();
        message.setOneId("ID");
        message.setStatus(EnumUnionOuter.Status.INACTIVE);
        return message.build();
    }

    private EnumUnionOuter.EnumUnion createEnumUnionWithSomeStatus() throws ParseException {
        EnumUnionOuter.EnumUnion.Builder message = EnumUnionOuter.EnumUnion.newBuilder();
        message.setSomeStatus(EnumUnionOuter.Status.INACTIVE);
        message.setStatus(EnumUnionOuter.Status.INACTIVE);
        return message.build();
    }

    private NestedTestProto.NestedMessage createNestedTestProtoStringUserId() throws ParseException {
        return this.createNestedTestProto(NestedTestProto.UserId.newBuilder().setKafkaUserId("my_user").build());
    }

    private NestedTestProto.NestedMessage createNestedTestProtoIntUserId() throws ParseException {
        return this.createNestedTestProto(NestedTestProto.UserId.newBuilder().setOtherUserId(5).build());
    }

    private NestedTestProto.NestedMessage createNestedTestProto(NestedTestProto.UserId id) throws ParseException {
        NestedTestProto.NestedMessage.Builder message = NestedTestProto.NestedMessage.newBuilder();
        message.setUserId(id);
        message.setIsActive(true);
        message.addExperimentsActive("first experiment");
        message.addExperimentsActive("second experiment");
        message.setStatus(NestedTestProto.Status.INACTIVE);
        NestedTestProto.NestedMessage.InnerMessage.Builder inner = NestedTestProto.NestedMessage.InnerMessage.newBuilder();
        inner.setId("");
        message.setInner(inner.build());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        java.util.Date date = sdf.parse("2017/09/18");
        Timestamp timestamp = Timestamps.fromMillis((long)date.getTime());
        message.setUpdatedAt(timestamp);
        message.putMapType("Hello", "World");
        return message.build();
    }

    private NestedTestProto.NestedMessage createEmptyNestedTestProto() throws ParseException {
        NestedTestProto.NestedMessage.Builder message = NestedTestProto.NestedMessage.newBuilder();
        return message.build();
    }

    private Schema getExpectedNestedTestProtoSchemaStringUserId(boolean useIntForEnums) {
        return this.getExpectedNestedTestProtoSchema(useIntForEnums);
    }

    private Schema getExpectedNestedTestProtoSchemaIntUserId(boolean useIntForEnums) {
        return this.getExpectedNestedTestProtoSchema(useIntForEnums);
    }

    private SchemaBuilder getEnumUnionSchemaBuilder() {
        SchemaBuilder enumUnionBuilder = SchemaBuilder.struct();
        enumUnionBuilder.name("EnumUnion");
        SchemaBuilder someValBuilder = SchemaBuilder.struct();
        someValBuilder.name("io.confluent.connect.protobuf.Union.some_val");
        someValBuilder.field("one_id", SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        someValBuilder.field("other_id", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        someValBuilder.field("some_status", SchemaBuilder.string().name("Status").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(3)).parameter("io.confluent.connect.protobuf.Enum", "Status").parameter("io.confluent.connect.protobuf.Enum.ACTIVE", "0").parameter("io.confluent.connect.protobuf.Enum.INACTIVE", "1").build());
        enumUnionBuilder.field("some_val_0", someValBuilder.optional().build());
        enumUnionBuilder.field("status", SchemaBuilder.string().name("Status").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(4)).parameter("io.confluent.connect.protobuf.Enum", "Status").parameter("io.confluent.connect.protobuf.Enum.ACTIVE", "0").parameter("io.confluent.connect.protobuf.Enum.INACTIVE", "1").build());
        return enumUnionBuilder;
    }

    private SchemaBuilder getEnumUnionSchemaBuilderWithoutIndex() {
        SchemaBuilder enumUnionBuilder = SchemaBuilder.struct();
        enumUnionBuilder.name("EnumUnion");
        SchemaBuilder someValBuilder = SchemaBuilder.struct();
        someValBuilder.name("io.confluent.connect.protobuf.Union.some_val");
        someValBuilder.field("one_id", SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        someValBuilder.field("other_id", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        someValBuilder.field("some_status", SchemaBuilder.string().name("Status").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(3)).parameter("io.confluent.connect.protobuf.Enum", "Status").parameter("io.confluent.connect.protobuf.Enum.ACTIVE", "0").parameter("io.confluent.connect.protobuf.Enum.INACTIVE", "1").build());
        enumUnionBuilder.field("some_val", someValBuilder.optional().build());
        enumUnionBuilder.field("status", SchemaBuilder.string().name("Status").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(4)).parameter("io.confluent.connect.protobuf.Enum", "Status").parameter("io.confluent.connect.protobuf.Enum.ACTIVE", "0").parameter("io.confluent.connect.protobuf.Enum.INACTIVE", "1").build());
        return enumUnionBuilder;
    }

    private SchemaBuilder getEnumUnionSchemaBuilderWithGeneralizedSumTypeSupport() {
        SchemaBuilder enumUnionBuilder = SchemaBuilder.struct();
        enumUnionBuilder.name("EnumUnion");
        SchemaBuilder someValBuilder = SchemaBuilder.struct();
        someValBuilder.name("some_val");
        someValBuilder.parameter("org.apache.kafka.connect.data.Union", "some_val");
        someValBuilder.field("one_id", SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        someValBuilder.field("other_id", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        someValBuilder.field("some_status", SchemaBuilder.string().name("Status").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(3)).parameter("org.apache.kafka.connect.data.Enum", "Status").parameter("org.apache.kafka.connect.data.Enum.ACTIVE", "0").parameter("org.apache.kafka.connect.data.Enum.INACTIVE", "1").build());
        enumUnionBuilder.field("some_val_0", someValBuilder.optional().build());
        enumUnionBuilder.field("status", SchemaBuilder.string().name("Status").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(4)).parameter("org.apache.kafka.connect.data.Enum", "Status").parameter("org.apache.kafka.connect.data.Enum.ACTIVE", "0").parameter("org.apache.kafka.connect.data.Enum.INACTIVE", "1").build());
        return enumUnionBuilder;
    }

    private Struct getEnumUnionWithString() throws ParseException {
        Schema schema = this.getEnumUnionSchemaBuilder().build();
        Struct result = new Struct(schema.schema());
        Struct union = new Struct(schema.field("some_val_0").schema());
        union.put("one_id", (Object)"ID");
        result.put("some_val_0", (Object)union);
        result.put("status", (Object)"INACTIVE");
        return result;
    }

    private Struct getEnumUnionWithStringWithoutIndex() throws ParseException {
        Schema schema = this.getEnumUnionSchemaBuilderWithoutIndex().build();
        Struct result = new Struct(schema.schema());
        Struct union = new Struct(schema.field("some_val").schema());
        union.put("one_id", (Object)"ID");
        result.put("some_val", (Object)union);
        result.put("status", (Object)"INACTIVE");
        return result;
    }

    private Struct getEnumUnionWithStringWithGeneralizedSumTypeSupport() throws ParseException {
        Schema schema = this.getEnumUnionSchemaBuilderWithGeneralizedSumTypeSupport().build();
        Struct result = new Struct(schema.schema());
        Struct union = new Struct(schema.field("some_val_0").schema());
        union.put("one_id", (Object)"ID");
        result.put("some_val_0", (Object)union);
        result.put("status", (Object)"INACTIVE");
        return result;
    }

    private Struct getEnumUnionWithSomeStatus() throws ParseException {
        Schema schema = this.getEnumUnionSchemaBuilder().build();
        Struct result = new Struct(schema.schema());
        Struct union = new Struct(schema.field("some_val_0").schema());
        union.put("some_status", (Object)"INACTIVE");
        result.put("some_val_0", (Object)union);
        result.put("status", (Object)"INACTIVE");
        return result;
    }

    private Struct getEnumUnionWithSomeStatusWithGeneralizedSumTypeSupport() throws ParseException {
        Schema schema = this.getEnumUnionSchemaBuilderWithGeneralizedSumTypeSupport().build();
        Struct result = new Struct(schema.schema());
        Struct union = new Struct(schema.field("some_val_0").schema());
        union.put("some_status", (Object)"INACTIVE");
        result.put("some_val_0", (Object)union);
        result.put("status", (Object)"INACTIVE");
        return result;
    }

    private SchemaBuilder getComplexTypeSchemaBuilder() {
        SchemaBuilder complexTypeBuilder = SchemaBuilder.struct();
        complexTypeBuilder.name("ComplexType");
        SchemaBuilder someValBuilder = SchemaBuilder.struct();
        someValBuilder.name("io.confluent.connect.protobuf.Union.some_val");
        someValBuilder.field("one_id", SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        someValBuilder.field("other_id", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        complexTypeBuilder.field("some_val_0", someValBuilder.optional().build());
        complexTypeBuilder.field("is_active", SchemaBuilder.bool().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(3)).build());
        return complexTypeBuilder;
    }

    private SchemaBuilder getInnerMessageSchemaBuilder() {
        SchemaBuilder innerMessageBuilder = SchemaBuilder.struct();
        innerMessageBuilder.name("InnerMessage");
        innerMessageBuilder.field("id", SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        innerMessageBuilder.field("ids", SchemaBuilder.array((Schema)SchemaBuilder.int32().optional().build()).optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        return innerMessageBuilder;
    }

    private Schema getExpectedNestedTestProtoSchema() {
        return this.getExpectedNestedTestProtoSchema(false);
    }

    private Schema getExpectedNestedTestProtoSchema(boolean useIntForEnums) {
        SchemaBuilder builder = SchemaBuilder.struct();
        builder.name("NestedMessage");
        SchemaBuilder userIdBuilder = SchemaBuilder.struct();
        userIdBuilder.name("UserId");
        SchemaBuilder idBuilder = SchemaBuilder.struct();
        idBuilder.name("io.confluent.connect.protobuf.Union.user_id");
        idBuilder.field("kafka_user_id", SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        idBuilder.field("other_user_id", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        SchemaBuilder messageIdBuilder = SchemaBuilder.struct();
        messageIdBuilder.name("MessageId");
        messageIdBuilder.field("id", SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        idBuilder.field("another_id", messageIdBuilder.optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(3)).build());
        userIdBuilder.field("user_id_0", idBuilder.optional().build());
        builder.field("user_id", userIdBuilder.optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        builder.field("is_active", SchemaBuilder.bool().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        builder.field("experiments_active", SchemaBuilder.array((Schema)SchemaBuilder.string().optional().build()).optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(3)).build());
        builder.field("updated_at", org.apache.kafka.connect.data.Timestamp.builder().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(4)).build());
        SchemaBuilder enumBuilder = useIntForEnums ? SchemaBuilder.int32() : SchemaBuilder.string();
        builder.field("status", enumBuilder.name("Status").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(5)).parameter("io.confluent.connect.protobuf.Enum", "Status").parameter("io.confluent.connect.protobuf.Enum.ACTIVE", "0").parameter("io.confluent.connect.protobuf.Enum.INACTIVE", "1").build());
        builder.field("complex_type", this.getComplexTypeSchemaBuilder().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(6)).build());
        builder.field("map_type", SchemaBuilder.map((Schema)OPTIONAL_STRING_SCHEMA, (Schema)SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build()).name("map_type").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(7)).build());
        builder.field("inner", this.getInnerMessageSchemaBuilder().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(8)).build());
        return builder.build();
    }

    private Map<String, String> getTestKeyValueMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Hello", "World");
        return result;
    }

    private Struct getExpectedNestedProtoResultStringUserId(boolean useIntForEnums) throws ParseException {
        Schema schema = this.getExpectedNestedTestProtoSchemaStringUserId(useIntForEnums);
        Struct result = new Struct(schema.schema());
        Struct userId = new Struct(schema.field("user_id").schema());
        Struct union = new Struct(schema.field("user_id").schema().field("user_id_0").schema());
        union.put("kafka_user_id", (Object)"my_user");
        userId.put("user_id_0", (Object)union);
        result.put("user_id", (Object)userId);
        result.put("is_active", (Object)true);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        java.util.Date date = sdf.parse("2017/09/18");
        result.put("updated_at", (Object)date);
        ArrayList<String> experiments = new ArrayList<String>();
        experiments.add("first experiment");
        experiments.add("second experiment");
        result.put("experiments_active", experiments);
        result.put("status", useIntForEnums ? Integer.valueOf(1) : "INACTIVE");
        result.put("map_type", this.getTestKeyValueMap());
        Struct inner = new Struct(schema.field("inner").schema());
        inner.put("id", (Object)"");
        inner.put("ids", new ArrayList());
        result.put("inner", (Object)inner);
        return result;
    }

    private Struct getExpectedNestedTestProtoResultIntUserId(boolean useIntForEnums) throws ParseException {
        Schema schema = this.getExpectedNestedTestProtoSchemaIntUserId(useIntForEnums);
        Struct result = new Struct(schema.schema());
        Struct userId = new Struct(schema.field("user_id").schema());
        Struct union = new Struct(schema.field("user_id").schema().field("user_id_0").schema());
        union.put("other_user_id", (Object)5);
        userId.put("user_id_0", (Object)union);
        result.put("user_id", (Object)userId);
        result.put("is_active", (Object)true);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        java.util.Date date = sdf.parse("2017/09/18");
        result.put("updated_at", (Object)date);
        ArrayList<String> experiments = new ArrayList<String>();
        experiments.add("first experiment");
        experiments.add("second experiment");
        result.put("experiments_active", experiments);
        result.put("status", useIntForEnums ? Integer.valueOf(1) : "INACTIVE");
        result.put("map_type", this.getTestKeyValueMap());
        Struct inner = new Struct(schema.field("inner").schema());
        inner.put("id", (Object)"");
        inner.put("ids", new ArrayList());
        result.put("inner", (Object)inner);
        return result;
    }

    private Struct getExpectedEmptyNestedTestProtoResult() throws ParseException {
        Schema schema = this.getExpectedNestedTestProtoSchema();
        Struct result = new Struct(schema.schema());
        result.put("is_active", (Object)false);
        ArrayList experiments = new ArrayList();
        result.put("experiments_active", experiments);
        result.put("status", (Object)"ACTIVE");
        result.put("map_type", new HashMap());
        return result;
    }

    private NestedTestProto.ComplexType createProtoDefaultOneOf() throws ParseException {
        NestedTestProto.ComplexType.Builder complexTypeBuilder = NestedTestProto.ComplexType.newBuilder();
        complexTypeBuilder.setOtherId(0);
        return complexTypeBuilder.build();
    }

    private NestedTestProto.ComplexType createProtoMultipleSetOneOf() throws ParseException {
        NestedTestProto.ComplexType.Builder complexTypeBuilder = NestedTestProto.ComplexType.newBuilder();
        complexTypeBuilder.setOneId("asdf");
        complexTypeBuilder.setOtherId(0);
        return complexTypeBuilder.build();
    }

    private Struct getExpectedComplexTypeProtoWithDefaultOneOf() {
        Schema schema = this.getComplexTypeSchemaBuilder().build();
        Struct result = new Struct(schema.schema());
        Struct union = new Struct(schema.field("some_val_0").schema());
        union.put("other_id", (Object)0);
        result.put("some_val_0", (Object)union);
        result.put("is_active", (Object)false);
        return result;
    }

    private void assertSchemasEqual(Schema expectedSchema, Schema actualSchema) {
        Assert.assertEquals((Object)expectedSchema.isOptional(), (Object)actualSchema.isOptional());
        Assert.assertEquals((Object)expectedSchema.version(), (Object)actualSchema.version());
        Assert.assertEquals((Object)expectedSchema.name(), (Object)actualSchema.name());
        Assert.assertEquals((Object)expectedSchema.doc(), (Object)actualSchema.doc());
        Assert.assertEquals((Object)expectedSchema.type(), (Object)actualSchema.type());
        Assert.assertEquals((Object)expectedSchema.defaultValue(), (Object)actualSchema.defaultValue());
        Assert.assertEquals((Object)expectedSchema.parameters(), (Object)actualSchema.parameters());
        if (expectedSchema.type() == Schema.Type.STRUCT) {
            Assert.assertEquals((long)expectedSchema.fields().size(), (long)actualSchema.fields().size());
            for (int i = 0; i < expectedSchema.fields().size(); ++i) {
                Field expectedField = (Field)expectedSchema.fields().get(i);
                Field actualField = actualSchema.field(expectedField.name());
                this.assertSchemasEqual(expectedField.schema(), actualField.schema());
            }
        } else if (expectedSchema.type() == Schema.Type.ARRAY) {
            this.assertSchemasEqual(expectedSchema.valueSchema(), actualSchema.valueSchema());
        } else if (expectedSchema.type() == Schema.Type.MAP) {
            this.assertSchemasEqual(expectedSchema.keySchema(), actualSchema.keySchema());
            this.assertSchemasEqual(expectedSchema.valueSchema(), actualSchema.valueSchema());
        }
    }

    private SchemaAndValue getSchemaAndValue(Message message) throws Exception {
        return this.getSchemaAndValue(message, false);
    }

    private SchemaAndValue getSchemaAndValue(Message message, boolean wrapperForRawPrimitives) throws Exception {
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("wrapper.for.raw.primitives", (Object)wrapperForRawPrimitives).build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        return this.getSchemaAndValue(protobufData, message);
    }

    private SchemaAndValue getSchemaAndValue(ProtobufData protobufData, Message message) throws Exception {
        DynamicMessage dynamicMessage;
        ProtobufSchema protobufSchema = new ProtobufSchema(message.getDescriptorForType());
        SchemaAndValue schemaAndValue = protobufData.toConnectData(protobufSchema, (Message)(dynamicMessage = DynamicMessage.parseFrom((Descriptors.Descriptor)protobufSchema.toDescriptor(), (byte[])message.toByteArray())));
        if (schemaAndValue.schema() != null) {
            ConnectSchema.validateValue((Schema)schemaAndValue.schema(), (Object)schemaAndValue.value());
        }
        return schemaAndValue;
    }

    @Test
    public void testToConnectDataWithNestedProtobufMessageAndStringUserId() throws Exception {
        NestedTestProto.NestedMessage message = this.createNestedTestProtoStringUserId();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema expectedSchema = this.getExpectedNestedTestProtoSchemaStringUserId(false);
        this.assertSchemasEqual(expectedSchema, result.schema());
        Struct expected = this.getExpectedNestedProtoResultStringUserId(false);
        Assert.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void testToConnectDataWithNestedProtobufMessageAndStringUserIdWithIntEnums() throws Exception {
        NestedTestProto.NestedMessage message = this.createNestedTestProtoStringUserId();
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("int.for.enums", (Object)true).build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        SchemaAndValue result = this.getSchemaAndValue(protobufData, (Message)message);
        Schema expectedSchema = this.getExpectedNestedTestProtoSchemaStringUserId(true);
        this.assertSchemasEqual(expectedSchema, result.schema());
        Struct expected = this.getExpectedNestedProtoResultStringUserId(true);
        Assert.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void testToConnectDataWithNestedProtobufMessageAndIntUserId() throws Exception {
        NestedTestProto.NestedMessage message = this.createNestedTestProtoIntUserId();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema expectedSchema = this.getExpectedNestedTestProtoSchemaIntUserId(false);
        this.assertSchemasEqual(expectedSchema, result.schema());
        Struct expected = this.getExpectedNestedTestProtoResultIntUserId(false);
        this.assertSchemasEqual(expected.schema(), ((Struct)result.value()).schema());
        Assert.assertEquals((Object)expected.schema(), (Object)((Struct)result.value()).schema());
        Assert.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void testToConnectDataWithNestedProtobufMessageAndIntUserIdWithIntEnums() throws Exception {
        NestedTestProto.NestedMessage message = this.createNestedTestProtoIntUserId();
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("int.for.enums", (Object)true).build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        SchemaAndValue result = this.getSchemaAndValue(protobufData, (Message)message);
        Schema expectedSchema = this.getExpectedNestedTestProtoSchemaIntUserId(true);
        this.assertSchemasEqual(expectedSchema, result.schema());
        Struct expected = this.getExpectedNestedTestProtoResultIntUserId(true);
        this.assertSchemasEqual(expected.schema(), ((Struct)result.value()).schema());
        Assert.assertEquals((Object)expected.schema(), (Object)((Struct)result.value()).schema());
        Assert.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void testToConnectDataWithEmptyNestedProtobufMessage() throws Exception {
        NestedTestProto.NestedMessage message = this.createEmptyNestedTestProto();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema expectedSchema = this.getExpectedNestedTestProtoSchema();
        this.assertSchemasEqual(expectedSchema, result.schema());
        Struct expected = this.getExpectedEmptyNestedTestProtoResult();
        this.assertSchemasEqual(expected.schema(), ((Struct)result.value()).schema());
        Assert.assertEquals((Object)expected.schema(), (Object)((Struct)result.value()).schema());
        Assert.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void testToConnectDataDefaultOneOf() throws Exception {
        Schema schema = this.getComplexTypeSchemaBuilder().build();
        NestedTestProto.ComplexType message = this.createProtoDefaultOneOf();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        this.assertSchemasEqual(schema, result.schema());
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)this.getExpectedComplexTypeProtoWithDefaultOneOf()), (Object)result);
    }

    @Test
    public void testToConnectDataDefaultOneOfCannotHaveTwoOneOfsSet() throws Exception {
        Schema schema = this.getComplexTypeSchemaBuilder().build();
        NestedTestProto.ComplexType message = this.createProtoMultipleSetOneOf();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        this.assertSchemasEqual(schema, result.schema());
        Assert.assertEquals((Object)new SchemaAndValue(schema, (Object)this.getExpectedComplexTypeProtoWithDefaultOneOf()), (Object)result);
    }

    @Test
    public void testToConnectEnumUnionWithString() throws Exception {
        EnumUnionOuter.EnumUnion message = this.createEnumUnionWithString();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema expectedSchema = this.getEnumUnionSchemaBuilder().build();
        this.assertSchemasEqual(expectedSchema, result.schema());
        Struct expected = this.getEnumUnionWithString();
        Assert.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void testToConnectEnumUnionWithStringWithoutIndex() throws Exception {
        EnumUnionOuter.EnumUnion message = this.createEnumUnionWithString();
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("generate.index.for.unions", (Object)"false").build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        SchemaAndValue result = this.getSchemaAndValue(protobufData, (Message)message);
        Schema expectedSchema = this.getEnumUnionSchemaBuilderWithoutIndex().build();
        this.assertSchemasEqual(expectedSchema, result.schema());
        Struct expected = this.getEnumUnionWithStringWithoutIndex();
        Assert.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void testToConnectEnumUnionWithStringWithGeneralizedSumTypeSupport() throws Exception {
        EnumUnionOuter.EnumUnion message = this.createEnumUnionWithString();
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("generalized.sum.type.support", (Object)"true").build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        SchemaAndValue result = this.getSchemaAndValue(protobufData, (Message)message);
        Schema expectedSchema = this.getEnumUnionSchemaBuilderWithGeneralizedSumTypeSupport().build();
        this.assertSchemasEqual(expectedSchema, result.schema());
        Struct expected = this.getEnumUnionWithStringWithGeneralizedSumTypeSupport();
        Assert.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void testToConnectEnumUnionWithSomeStatus() throws Exception {
        EnumUnionOuter.EnumUnion message = this.createEnumUnionWithSomeStatus();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema expectedSchema = this.getEnumUnionSchemaBuilder().build();
        this.assertSchemasEqual(expectedSchema, result.schema());
        Struct expected = this.getEnumUnionWithSomeStatus();
        Assert.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void testToConnectEnumUnionWithSomeStatusWithGeneralizedSumTypeSupport() throws Exception {
        EnumUnionOuter.EnumUnion message = this.createEnumUnionWithSomeStatus();
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("generalized.sum.type.support", (Object)"true").build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        SchemaAndValue result = this.getSchemaAndValue(protobufData, (Message)message);
        Schema expectedSchema = this.getEnumUnionSchemaBuilderWithGeneralizedSumTypeSupport().build();
        this.assertSchemasEqual(expectedSchema, result.schema());
        Struct expected = this.getEnumUnionWithSomeStatusWithGeneralizedSumTypeSupport();
        Assert.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void testToConnectNestedNull() throws Exception {
        NestedKeyValue.NestedKeyValueMessage.Builder builder = NestedKeyValue.NestedKeyValueMessage.newBuilder();
        NestedKeyValue.NestedKeyValueMessage message = builder.build();
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("wrapper.for.raw.primitives", (Object)true).with("generate.struct.for.nulls", (Object)true).build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        SchemaAndValue result = this.getSchemaAndValue(protobufData, (Message)message);
        Schema schema = result.schema();
        Struct value = (Struct)result.value();
        Assert.assertNotNull((Object)value.get(schema.field("wrapper_field").schema().field("nested_field")));
    }

    @Test
    public void testToConnectNestedNullNegative() throws Exception {
        NestedKeyValue.NestedKeyValueMessage.Builder builder = NestedKeyValue.NestedKeyValueMessage.newBuilder();
        NestedKeyValue.NestedKeyValueMessage message = builder.build();
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("wrapper.for.raw.primitives", (Object)true).with("generate.struct.for.nulls", (Object)false).build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        SchemaAndValue result = this.getSchemaAndValue(protobufData, (Message)message);
        Schema schema = result.schema();
        Struct value = (Struct)result.value();
        Assert.assertNull((Object)value.get(schema.field("wrapper_field").schema().field("nested_field")));
    }

    @Test
    public void testToConnectNull() {
        ProtobufData protobufData = new ProtobufData();
        Schema schema = OPTIONAL_BOOLEAN_SCHEMA.schema();
        Assert.assertNull((Object)protobufData.toConnectData(schema, null));
        Assert.assertNull((Object)protobufData.toConnectData((Schema)null, null));
    }

    @Test
    public void testToConnectBoolean() throws Exception {
        Boolean expectedValue = true;
        BoolValue.Builder builder = BoolValue.newBuilder();
        builder.setValue(expectedValue.booleanValue());
        BoolValue message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message, true);
        Assert.assertEquals((Object)new SchemaAndValue(Schema.BOOLEAN_SCHEMA, (Object)expectedValue), (Object)result);
    }

    @Test
    public void testToConnectBooleanStruct() throws Exception {
        Boolean expectedValue = true;
        BoolValue.Builder builder = BoolValue.newBuilder();
        builder.setValue(expectedValue.booleanValue());
        BoolValue message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_BOOLEAN_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectInt8Struct() throws Exception {
        Byte expectedValue = 12;
        Int8ValueOuterClass.Int8Value.Builder builder = Int8ValueOuterClass.Int8Value.newBuilder();
        builder.setValue((int)expectedValue.byteValue());
        Int8ValueOuterClass.Int8Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_INT8_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectInt16Struct() throws Exception {
        Short expectedValue = 12;
        Int16ValueOuterClass.Int16Value.Builder builder = Int16ValueOuterClass.Int16Value.newBuilder();
        builder.setValue((int)expectedValue.shortValue());
        Int16ValueOuterClass.Int16Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_INT16_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectInt32() throws Exception {
        Integer expectedValue = 12;
        Int32Value.Builder builder = Int32Value.newBuilder();
        builder.setValue(expectedValue.intValue());
        Int32Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message, true);
        Assert.assertEquals((Object)new SchemaAndValue(Schema.INT32_SCHEMA, (Object)expectedValue), (Object)result);
    }

    @Test
    public void testToConnectInt32Struct() throws Exception {
        Integer expectedValue = 12;
        Int32Value.Builder builder = Int32Value.newBuilder();
        builder.setValue(expectedValue.intValue());
        Int32Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_INT32_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectInt32With0() throws Exception {
        Integer expectedValue = 0;
        Int32Value.Builder builder = Int32Value.newBuilder();
        builder.setValue(expectedValue.intValue());
        Int32Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message, true);
        Assert.assertEquals((Object)new SchemaAndValue(Schema.INT32_SCHEMA, (Object)expectedValue), (Object)result);
    }

    @Test
    public void testToConnectInt32StructWith0() throws Exception {
        Integer expectedValue = 0;
        Int32Value.Builder builder = Int32Value.newBuilder();
        builder.setValue(expectedValue.intValue());
        Int32Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_INT32_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectInt32StructWithSint32() throws Exception {
        int expectedValue = 12;
        SInt32ValueOuterClass.SInt32Value.Builder builder = SInt32ValueOuterClass.SInt32Value.newBuilder();
        builder.setValue(expectedValue);
        SInt32ValueOuterClass.SInt32Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema sint32Schema = SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).parameter("io.confluent.connect.protobuf.Type", "sint32").build();
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(sint32Schema, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectInt32StructWithUInt32() throws Exception {
        Long UNSIGNED_RESULT = 0xFFFFFFFFL;
        Integer expectedValue = -1;
        UInt32ValueOuterClass.UInt32Value.Builder builder = UInt32ValueOuterClass.UInt32Value.newBuilder();
        builder.setValue(expectedValue.intValue());
        UInt32ValueOuterClass.UInt32Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema schema = SchemaBuilder.int64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).parameter("io.confluent.connect.protobuf.Type", "uint32").build();
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(schema, (Message)message, UNSIGNED_RESULT), (Object)result);
    }

    @Test
    public void testToConnectInt64() throws Exception {
        Long expectedValue = 12L;
        Int64Value.Builder builder = Int64Value.newBuilder();
        builder.setValue(expectedValue.longValue());
        Int64Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message, true);
        Assert.assertEquals((Object)new SchemaAndValue(Schema.INT64_SCHEMA, (Object)expectedValue), (Object)result);
    }

    @Test
    public void testToConnectInt64Struct() throws Exception {
        Long expectedValue = 12L;
        Int64Value.Builder builder = Int64Value.newBuilder();
        builder.setValue(expectedValue.longValue());
        Int64Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_INT64_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectSInt64Struct() throws Exception {
        Long expectedValue = 12L;
        SInt64ValueOuterClass.SInt64Value.Builder builder = SInt64ValueOuterClass.SInt64Value.newBuilder();
        builder.setValue(expectedValue.longValue());
        SInt64ValueOuterClass.SInt64Value message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema sint64Schema = SchemaBuilder.int64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).parameter("io.confluent.connect.protobuf.Type", "sint64").build();
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(sint64Schema, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectFloat32() throws Exception {
        Float expectedValue = Float.valueOf(12.0f);
        FloatValue.Builder builder = FloatValue.newBuilder();
        builder.setValue(expectedValue.floatValue());
        FloatValue message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message, true);
        Assert.assertEquals((Object)new SchemaAndValue(Schema.FLOAT32_SCHEMA, (Object)expectedValue), (Object)result);
    }

    @Test
    public void testToConnectFloat32Struct() throws Exception {
        Float expectedValue = Float.valueOf(12.0f);
        FloatValue.Builder builder = FloatValue.newBuilder();
        builder.setValue(expectedValue.floatValue());
        FloatValue message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_FLOAT32_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectFloat64() throws Exception {
        Double expectedValue = 12.0;
        DoubleValue.Builder builder = DoubleValue.newBuilder();
        builder.setValue(expectedValue.doubleValue());
        DoubleValue message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message, true);
        Assert.assertEquals((Object)new SchemaAndValue(Schema.FLOAT64_SCHEMA, (Object)expectedValue), (Object)result);
    }

    @Test
    public void testToConnectFloat64Struct() throws Exception {
        Double expectedValue = 12.0;
        DoubleValue.Builder builder = DoubleValue.newBuilder();
        builder.setValue(expectedValue.doubleValue());
        DoubleValue message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_FLOAT64_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectString() throws Exception {
        String expectedValue = "Hello";
        StringValue message = this.createStringValueMessage(expectedValue);
        SchemaAndValue result = this.getSchemaAndValue((Message)message, true);
        Assert.assertEquals((Object)new SchemaAndValue(Schema.STRING_SCHEMA, (Object)expectedValue), (Object)result);
    }

    @Test
    public void testToConnectStringStruct() throws Exception {
        String expectedValue = "Hello";
        StringValue message = this.createStringValueMessage(expectedValue);
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_STRING_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectEmptyString() throws Exception {
        String expectedValue = "";
        StringValue message = this.createStringValueMessage(expectedValue);
        SchemaAndValue result = this.getSchemaAndValue((Message)message, true);
        Assert.assertEquals((Object)new SchemaAndValue(Schema.STRING_SCHEMA, (Object)expectedValue), (Object)result);
    }

    @Test
    public void testToConnectEmptyStringStruct() throws Exception {
        String expectedValue = "";
        StringValue message = this.createStringValueMessage(expectedValue);
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(OPTIONAL_STRING_SCHEMA, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectDecimal() throws Exception {
        BigDecimal expectedValue = new BigDecimal(BigInteger.valueOf(12345678L), 3);
        Decimal.Builder decimalBuilder = io.confluent.protobuf.type.Decimal.newBuilder();
        decimalBuilder.setValue(ByteString.copyFrom((byte[])expectedValue.unscaledValue().toByteArray()));
        decimalBuilder.setPrecision(8);
        decimalBuilder.setScale(expectedValue.scale());
        DecimalValueOuterClass.DecimalValue.Builder builder = DecimalValueOuterClass.DecimalValue.newBuilder();
        builder.setValue(decimalBuilder.build());
        DecimalValueOuterClass.DecimalValue message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema decimalSchema = Decimal.builder((int)3).optional().parameter("connect.decimal.precision", String.valueOf(8)).parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(decimalSchema, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectDate() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        java.util.Date expectedValue = sdf.parse("2017/12/31");
        Date.Builder dateBuilder = Date.newBuilder();
        dateBuilder.setYear(2017);
        dateBuilder.setMonth(12);
        dateBuilder.setDay(31);
        DateValueOuterClass.DateValue.Builder builder = DateValueOuterClass.DateValue.newBuilder();
        builder.setValue(dateBuilder.build());
        DateValueOuterClass.DateValue message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema dateSchema = org.apache.kafka.connect.data.Date.builder().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(dateSchema, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectTime() throws Exception {
        LocalTime localTime = LocalTime.of(11, 12, 13, 14000000);
        java.util.Date expectedValue = new java.util.Date(localTime.toNanoOfDay() / 1000000L);
        TimeOfDay.Builder timeBuilder = TimeOfDay.newBuilder();
        timeBuilder.setHours(11);
        timeBuilder.setMinutes(12);
        timeBuilder.setSeconds(13);
        timeBuilder.setNanos(14000000);
        TimeOfDayValueOuterClass.TimeOfDayValue.Builder builder = TimeOfDayValueOuterClass.TimeOfDayValue.newBuilder();
        builder.setValue(timeBuilder.build());
        TimeOfDayValueOuterClass.TimeOfDayValue message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema dateSchema = Time.builder().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(dateSchema, (Message)message, expectedValue), (Object)result);
    }

    @Test
    public void testToConnectTimestamp() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        java.util.Date expectedValue = sdf.parse("2017/12/31");
        Timestamp timestamp = Timestamps.fromMillis((long)expectedValue.getTime());
        TimestampValueOuterClass.TimestampValue.Builder builder = TimestampValueOuterClass.TimestampValue.newBuilder();
        builder.setValue(timestamp);
        TimestampValueOuterClass.TimestampValue message = builder.build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        Schema timestampSchema = org.apache.kafka.connect.data.Timestamp.builder().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build();
        Assert.assertEquals((Object)this.getExpectedSchemaAndValue(timestampSchema, (Message)message, expectedValue), (Object)result);
    }

    @Test(expected=DataException.class)
    public void testToConnectSchemaMismatchArray() {
        ProtobufData protobufData = new ProtobufData();
        Schema schema = SchemaBuilder.array((Schema)OPTIONAL_STRING_SCHEMA).build();
        protobufData.toConnectData(schema, Arrays.asList(1, 2, 3));
    }

    private byte[] getMessageBytes(Schema schema, Object value) throws Exception {
        Schema structSchema = SchemaBuilder.struct().field(VALUE_FIELD_NAME, schema).build();
        Struct struct = new Struct(structSchema.schema());
        struct.put(VALUE_FIELD_NAME, value);
        SchemaAndValue schemaAndValue = new SchemaAndValue(structSchema, (Object)struct);
        return this.getMessageBytes(schemaAndValue);
    }

    private byte[] getMessageBytes(SchemaAndValue schemaAndValue) throws Exception {
        return this.getMessageBytes(new ProtobufData(), schemaAndValue);
    }

    private byte[] getMessageBytes(ProtobufData protobufData, SchemaAndValue schemaAndValue) throws Exception {
        ProtobufSchemaAndValue protobufSchemaAndValue = protobufData.fromConnectData(schemaAndValue);
        Message message = (Message)protobufSchemaAndValue.getValue();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        message.writeTo((OutputStream)baos);
        return baos.toByteArray();
    }

    @Test
    public void testRoundTripConnectPreserveSignedAndFixed() throws Exception {
        TestMessageProtos.TestMessage originalMessage = TestMessageProtos.TestMessage.newBuilder().setTestSint32(12).setTestSint64(12L).setTestFixed32(12).setTestFixed64(12L).setTestSfixed32(12).setTestSfixed64(12L).setTestUint32(12).setTestUint64(12L).build();
        SchemaAndValue toConnectResult = this.getSchemaAndValue((Message)originalMessage);
        ProtobufData protobufData = new ProtobufData();
        ProtobufSchemaAndValue fromConnectResult = protobufData.fromConnectData(toConnectResult.schema(), toConnectResult.value());
        Message message = (Message)fromConnectResult.getValue();
        MessageElement messageElem = (MessageElement)fromConnectResult.getSchema().rawSchema().getTypes().get(0);
        FieldElement fieldElem = (FieldElement)messageElem.getFields().get(5);
        Assert.assertEquals((Object)"test_fixed32", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"fixed32", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(6);
        Assert.assertEquals((Object)"test_fixed64", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"fixed64", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(9);
        Assert.assertEquals((Object)"test_sfixed32", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"sfixed32", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(10);
        Assert.assertEquals((Object)"test_sfixed64", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"sfixed64", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(11);
        Assert.assertEquals((Object)"test_sint32", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"sint32", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(12);
        Assert.assertEquals((Object)"test_sint64", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"sint64", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(13);
        Assert.assertEquals((Object)"test_uint32", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"uint32", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(14);
        Assert.assertEquals((Object)"test_uint64", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"uint64", (Object)fieldElem.getType());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName("test_fixed32");
        Assert.assertEquals((Object)12, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("test_fixed64");
        Assert.assertEquals((Object)12L, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("test_sfixed32");
        Assert.assertEquals((Object)12, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("test_sfixed64");
        Assert.assertEquals((Object)12L, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("test_sint32");
        Assert.assertEquals((Object)12, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("test_sint64");
        Assert.assertEquals((Object)12L, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("test_uint32");
        Assert.assertEquals((Object)12, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("test_uint64");
        Assert.assertEquals((Object)12L, (Object)message.getField(fieldDescriptor));
        TestMessageProtos.TestMessage convertedMessage = TestMessageProtos.TestMessage.parseFrom((byte[])message.toByteArray());
        Assert.assertEquals((Object)originalMessage, (Object)convertedMessage);
    }

    @Test
    public void testRoundTripConnectUInt32Fixed32() throws Exception {
        Long UNSIGNED_RESULT = 0xFFFFFFFFL;
        Integer expectedValue = -1;
        TestMessageProtos.TestMessage message = TestMessageProtos.TestMessage.newBuilder().setTestFixed32(expectedValue.intValue()).setTestUint32(expectedValue.intValue()).build();
        SchemaAndValue result = this.getSchemaAndValue((Message)message);
        ProtobufData protobufData = new ProtobufData();
        ProtobufSchemaAndValue converted = protobufData.fromConnectData(result.schema(), result.value());
        Message convertedValue = (Message)converted.getValue();
        TestMessageProtos.TestMessage parsedMessage = TestMessageProtos.TestMessage.parseFrom((byte[])convertedValue.toByteArray());
        Assert.assertEquals((Object)message, (Object)parsedMessage);
        Assert.assertTrue((boolean)parsedMessage.toString().contains("test_fixed32: " + UNSIGNED_RESULT));
        Assert.assertTrue((boolean)parsedMessage.toString().contains("test_uint32: " + UNSIGNED_RESULT));
    }

    @Test
    public void testFromConnectEnumUnionWithString() throws Exception {
        EnumUnionOuter.EnumUnion message = this.createEnumUnionWithString();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue((Message)message);
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])message.toByteArray());
    }

    @Test
    public void testFromConnectEnumUnionWithSomeStatus() throws Exception {
        EnumUnionOuter.EnumUnion message = this.createEnumUnionWithSomeStatus();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue((Message)message);
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])message.toByteArray());
    }

    @Test
    public void testFromConnectEnumUnionWithStringWithGeneralizedSumTypeSupport() throws Exception {
        EnumUnionOuter.EnumUnion message = this.createEnumUnionWithString();
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("generalized.sum.type.support", (Object)"true").build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        SchemaAndValue schemaAndValue = this.getSchemaAndValue(protobufData, (Message)message);
        byte[] messageBytes = this.getMessageBytes(protobufData, schemaAndValue);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])message.toByteArray());
    }

    @Test
    public void testFromConnectEnumUnionWithSomeStatusWithGeneralizedSumTypeSupport() throws Exception {
        EnumUnionOuter.EnumUnion message = this.createEnumUnionWithSomeStatus();
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("generalized.sum.type.support", (Object)"true").build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        SchemaAndValue schemaAndValue = this.getSchemaAndValue(protobufData, (Message)message);
        byte[] messageBytes = this.getMessageBytes(protobufData, schemaAndValue);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])message.toByteArray());
    }

    @Test
    public void testFromConnectDataWithNestedProtobufMessageAndStringUserId() throws Exception {
        NestedTestProto.NestedMessage nestedMessage = this.createNestedTestProtoStringUserId();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue((Message)nestedMessage);
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])nestedMessage.toByteArray());
    }

    @Test
    public void testFromConnectDataWithNestedProtobufMessageAndStringUserIdWithIntEnums() throws Exception {
        NestedTestProto.NestedMessage nestedMessage = this.createNestedTestProtoStringUserId();
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("int.for.enums", (Object)true).build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        SchemaAndValue schemaAndValue = this.getSchemaAndValue(protobufData, (Message)nestedMessage);
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])nestedMessage.toByteArray());
    }

    @Test
    public void testFromConnectDataWithNestedProtobufMessageAndIntUserId() throws Exception {
        NestedTestProto.NestedMessage nestedMessage = this.createNestedTestProtoIntUserId();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue((Message)nestedMessage);
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])nestedMessage.toByteArray());
    }

    @Test
    public void testFromConnectDataWithNestedProtobufMessageAndIntUserIdWithIntEnums() throws Exception {
        NestedTestProto.NestedMessage nestedMessage = this.createNestedTestProtoIntUserId();
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("int.for.enums", (Object)true).build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        SchemaAndValue schemaAndValue = this.getSchemaAndValue(protobufData, (Message)nestedMessage);
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])nestedMessage.toByteArray());
    }

    @Test
    public void testFromConnectDataWithEmptyNestedProtobufMessage() throws Exception {
        NestedTestProto.NestedMessage nestedMessage = this.createEmptyNestedTestProto();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue((Message)nestedMessage);
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])nestedMessage.toByteArray());
    }

    @Test
    public void testFromConnectComplex() {
        Schema schema = SchemaBuilder.struct().field("int8", SchemaBuilder.int8().defaultValue((Object)2).doc("int8 field").build()).field("int16", Schema.INT16_SCHEMA).field("int32", Schema.INT32_SCHEMA).field("int64", Schema.INT64_SCHEMA).field("float32", Schema.FLOAT32_SCHEMA).field("float64", Schema.FLOAT64_SCHEMA).field("boolean", Schema.BOOLEAN_SCHEMA).field("string", Schema.STRING_SCHEMA).field("bytes", Schema.BYTES_SCHEMA).field("array", SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).build()).field("map", SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.INT32_SCHEMA).build()).field("mapNonStringKeys", SchemaBuilder.map((Schema)Schema.INT32_SCHEMA, (Schema)Schema.INT32_SCHEMA).build()).field("mapNullValues", SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.OPTIONAL_STRING_SCHEMA).build()).field("enum", SchemaBuilder.string().name("Status").optional().parameter("io.confluent.connect.protobuf.Enum", "Status").parameter("io.confluent.connect.protobuf.Enum.ACTIVE", "0").parameter("io.confluent.connect.protobuf.Enum.INACTIVE", "1").build()).build();
        Struct struct = new Struct(schema).put("int8", (Object)12).put("int16", (Object)12).put("int32", (Object)12).put("int64", (Object)12L).put("float32", (Object)Float.valueOf(12.2f)).put("float64", (Object)12.2).put("boolean", (Object)true).put("string", (Object)"foo").put("bytes", (Object)ByteBuffer.wrap("foo".getBytes())).put("array", Arrays.asList("a", "b", "c")).put("map", Collections.singletonMap("field", 1)).put("mapNonStringKeys", Collections.singletonMap(1, 1)).put("mapNullValues", Collections.singletonMap("field", null)).put("enum", (Object)"INACTIVE");
        ProtobufSchemaAndValue convertedRecord = new ProtobufData().fromConnectData(schema, (Object)struct);
        ProtobufSchema protobufSchema = convertedRecord.getSchema();
        Message message = (Message)convertedRecord.getValue();
        MessageElement messageElem = (MessageElement)protobufSchema.rawSchema().getTypes().get(0);
        FieldElement fieldElem = (FieldElement)messageElem.getFields().get(0);
        Assert.assertEquals((Object)"int8", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"int32", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(1);
        Assert.assertEquals((Object)"int16", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"int32", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(2);
        Assert.assertEquals((Object)"int32", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"int32", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(3);
        Assert.assertEquals((Object)"int64", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"int64", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(4);
        Assert.assertEquals((Object)"float32", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"float", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(5);
        Assert.assertEquals((Object)"float64", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"double", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(6);
        Assert.assertEquals((Object)"boolean", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"bool", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(7);
        Assert.assertEquals((Object)"string", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"string", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(8);
        Assert.assertEquals((Object)"bytes", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"bytes", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(9);
        Assert.assertEquals((Object)"array", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"string", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(10);
        Assert.assertEquals((Object)"map", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"ConnectDefault2Entry", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(11);
        Assert.assertEquals((Object)"mapNonStringKeys", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"ConnectDefault3Entry", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(12);
        Assert.assertEquals((Object)"mapNullValues", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"ConnectDefault4Entry", (Object)fieldElem.getType());
        fieldElem = (FieldElement)messageElem.getFields().get(13);
        Assert.assertEquals((Object)"enum", (Object)fieldElem.getName());
        Assert.assertEquals((Object)"Status", (Object)fieldElem.getType());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName("int8");
        Assert.assertEquals((Object)12, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("int16");
        Assert.assertEquals((Object)12, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("int32");
        Assert.assertEquals((Object)12, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("int64");
        Assert.assertEquals((Object)12L, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("float32");
        Assert.assertEquals((Object)Float.valueOf(12.2f), (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("float64");
        Assert.assertEquals((Object)12.2, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("boolean");
        Assert.assertEquals((Object)true, (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("string");
        Assert.assertEquals((Object)"foo", (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("bytes");
        Assert.assertEquals((Object)ByteString.copyFrom((byte[])"foo".getBytes()), (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("array");
        Assert.assertEquals(Arrays.asList("a", "b", "c"), (Object)message.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("map");
        Object value = message.getField(fieldDescriptor);
        DynamicMessage dynamicMessage = (DynamicMessage)((List)value).get(0);
        fieldDescriptor = dynamicMessage.getDescriptorForType().findFieldByName("key");
        Assert.assertEquals((Object)"field", (Object)dynamicMessage.getField(fieldDescriptor));
        fieldDescriptor = dynamicMessage.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)1, (Object)dynamicMessage.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("mapNonStringKeys");
        value = message.getField(fieldDescriptor);
        dynamicMessage = (DynamicMessage)((List)value).get(0);
        fieldDescriptor = dynamicMessage.getDescriptorForType().findFieldByName("key");
        Assert.assertEquals((Object)1, (Object)dynamicMessage.getField(fieldDescriptor));
        fieldDescriptor = dynamicMessage.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)1, (Object)dynamicMessage.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("mapNullValues");
        value = message.getField(fieldDescriptor);
        dynamicMessage = (DynamicMessage)((List)value).get(0);
        fieldDescriptor = dynamicMessage.getDescriptorForType().findFieldByName("key");
        Assert.assertEquals((Object)"field", (Object)dynamicMessage.getField(fieldDescriptor));
        fieldDescriptor = dynamicMessage.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)"", (Object)dynamicMessage.getField(fieldDescriptor));
        fieldDescriptor = message.getDescriptorForType().findFieldByName("enum");
        Descriptors.EnumValueDescriptor enumValueDescriptor = (Descriptors.EnumValueDescriptor)message.getField(fieldDescriptor);
        Assert.assertEquals((Object)"INACTIVE", (Object)enumValueDescriptor.getName());
    }

    @Test
    public void testFromConnectComplexDuplicateImports() {
        Schema schema = SchemaBuilder.struct().field("createdAt", org.apache.kafka.connect.data.Timestamp.SCHEMA).field("updatedAt", org.apache.kafka.connect.data.Timestamp.SCHEMA).build();
        ProtobufSchema protobufSchema = new ProtobufData().fromConnectSchema(schema);
        Assert.assertEquals((long)1L, (long)protobufSchema.rawSchema().getImports().size());
    }

    @Test
    public void testFromConnectNull() throws Exception {
        ProtobufData protobufData = new ProtobufData();
        Schema schema = SchemaBuilder.struct().field(VALUE_FIELD_NAME, OPTIONAL_BOOLEAN_SCHEMA).build();
        ProtobufSchemaAndValue converted = protobufData.fromConnectData(schema, null);
        Assert.assertNull((Object)converted.getValue());
        converted = protobufData.fromConnectData(null, null);
        Assert.assertNull((Object)converted.getSchema());
        Assert.assertNull((Object)converted.getValue());
    }

    @Test
    public void testFromConnectNameCollision() {
        Schema nested = SchemaBuilder.struct().name("nested").field("string", Schema.STRING_SCHEMA).build();
        Schema schema = SchemaBuilder.struct().field("nested", nested).build();
        ProtobufSchema protobufSchema = new ProtobufData().fromConnectSchema(schema);
        Descriptors.FieldDescriptor fieldDescriptor = protobufSchema.toDescriptor().findFieldByName("nested");
        Descriptors.Descriptor nestedDescriptor = fieldDescriptor.getMessageType();
        Assert.assertEquals((Object)"nestedMessage", (Object)nestedDescriptor.getName());
    }

    @Test
    public void testFromConnectInt8Struct() throws Exception {
        Byte value = 15;
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_INT8_SCHEMA, value);
        Int8ValueOuterClass.Int8Value message = Int8ValueOuterClass.Int8Value.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value.intValue(), (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectInt16Struct() throws Exception {
        Short value = 15;
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_INT16_SCHEMA, value);
        Int16ValueOuterClass.Int16Value message = Int16ValueOuterClass.Int16Value.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value.intValue(), (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectInt32() throws Exception {
        Integer value = 15;
        byte[] messageBytes = this.getMessageBytes(new SchemaAndValue(Schema.INT32_SCHEMA, (Object)value));
        Int32Value message = Int32Value.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectInt32Struct() throws Exception {
        Integer value = 15;
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_INT32_SCHEMA, value);
        Int32Value message = Int32Value.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectInt64() throws Exception {
        Long value = 15L;
        byte[] messageBytes = this.getMessageBytes(new SchemaAndValue(Schema.INT64_SCHEMA, (Object)value));
        Int64Value message = Int64Value.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectInt64Struct() throws Exception {
        Long value = 15L;
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_INT64_SCHEMA, value);
        Int64Value message = Int64Value.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectDecimal() throws Exception {
        BigDecimal bigDecimal = new BigDecimal(BigInteger.valueOf(12345678L), 3);
        DecimalValueOuterClass.DecimalValue.Builder builder = DecimalValueOuterClass.DecimalValue.newBuilder();
        io.confluent.protobuf.type.Decimal decimal = io.confluent.protobuf.type.Decimal.newBuilder().setValue(ByteString.copyFrom((byte[])bigDecimal.unscaledValue().toByteArray())).setPrecision(8).setScale(3).build();
        builder.setValue(decimal);
        DecimalValueOuterClass.DecimalValue decimalMessage = builder.build();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue((Message)decimalMessage);
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        DecimalValueOuterClass.DecimalValue message = DecimalValueOuterClass.DecimalValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)decimal, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectDate() throws Exception {
        DateValueOuterClass.DateValue.Builder builder = DateValueOuterClass.DateValue.newBuilder();
        Date date = Date.newBuilder().setYear(2017).setMonth(9).setDay(18).build();
        builder.setValue(date);
        DateValueOuterClass.DateValue dateMessage = builder.build();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue((Message)dateMessage);
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        DateValueOuterClass.DateValue message = DateValueOuterClass.DateValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)date, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectTime() throws Exception {
        TimeOfDayValueOuterClass.TimeOfDayValue.Builder builder = TimeOfDayValueOuterClass.TimeOfDayValue.newBuilder();
        TimeOfDay time = TimeOfDay.newBuilder().setHours(11).setMinutes(12).setSeconds(13).setNanos(140000000).build();
        builder.setValue(time);
        TimeOfDayValueOuterClass.TimeOfDayValue timeMessage = builder.build();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue((Message)timeMessage);
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        TimeOfDayValueOuterClass.TimeOfDayValue message = TimeOfDayValueOuterClass.TimeOfDayValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)time, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectTimestamp() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        java.util.Date date = sdf.parse("2017/09/18");
        Timestamp timestamp = Timestamps.fromMillis((long)date.getTime());
        TimestampValueOuterClass.TimestampValue.Builder builder = TimestampValueOuterClass.TimestampValue.newBuilder();
        builder.setValue(timestamp);
        TimestampValueOuterClass.TimestampValue timestampMessage = builder.build();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue((Message)timestampMessage);
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        TimestampValueOuterClass.TimestampValue message = TimestampValueOuterClass.TimestampValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)timestamp, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectTimestampWithDefault() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        java.util.Date date = sdf.parse("2017/09/18");
        Schema fieldSchema = SchemaBuilder.int64().name("org.apache.kafka.connect.data.Timestamp").defaultValue((Object)new java.util.Date(0L)).version(Integer.valueOf(1)).build();
        Schema schema = SchemaBuilder.struct().name("TimestampValue").field(VALUE_FIELD_NAME, fieldSchema).build();
        Struct value = new Struct(schema).put(VALUE_FIELD_NAME, (Object)date);
        byte[] messageBytes = this.getMessageBytes(new SchemaAndValue(schema, (Object)value));
        TimestampValueOuterClass.TimestampValue message = TimestampValueOuterClass.TimestampValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)Timestamps.fromMillis((long)date.getTime()), (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectFloat32() throws Exception {
        Float value = Float.valueOf(12.3f);
        byte[] messageBytes = this.getMessageBytes(new SchemaAndValue(Schema.FLOAT32_SCHEMA, (Object)value));
        FloatValue message = FloatValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectFloat32Struct() throws Exception {
        Float value = Float.valueOf(12.3f);
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_FLOAT32_SCHEMA, value);
        FloatValue message = FloatValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectFloat64() throws Exception {
        Double value = 12.3;
        byte[] messageBytes = this.getMessageBytes(new SchemaAndValue(Schema.FLOAT64_SCHEMA, (Object)value));
        DoubleValue message = DoubleValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectFloat64Struct() throws Exception {
        Double value = 12.3;
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_FLOAT64_SCHEMA, value);
        DoubleValue message = DoubleValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectBoolean() throws Exception {
        Boolean value = true;
        byte[] messageBytes = this.getMessageBytes(new SchemaAndValue(Schema.BOOLEAN_SCHEMA, (Object)value));
        BoolValue message = BoolValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectBooleanStruct() throws Exception {
        Boolean value = true;
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_BOOLEAN_SCHEMA, value);
        BoolValue message = BoolValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectBooleanWithFalse() throws Exception {
        Boolean value = false;
        byte[] messageBytes = this.getMessageBytes(new SchemaAndValue(Schema.BOOLEAN_SCHEMA, (Object)value));
        BoolValue message = BoolValue.parseFrom((byte[])messageBytes);
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectBooleanStructWithFalse() throws Exception {
        Boolean value = false;
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_BOOLEAN_SCHEMA, value);
        BoolValue message = BoolValue.parseFrom((byte[])messageBytes);
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectString() throws Exception {
        String value = "Hello";
        byte[] messageBytes = this.getMessageBytes(new SchemaAndValue(Schema.STRING_SCHEMA, (Object)value));
        StringValue message = StringValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectStringStruct() throws Exception {
        String value = "Hello";
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_STRING_SCHEMA, value);
        StringValue message = StringValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectEmptyString() throws Exception {
        String value = "";
        byte[] messageBytes = this.getMessageBytes(new SchemaAndValue(Schema.STRING_SCHEMA, (Object)value));
        StringValue message = StringValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)0L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectEmptyStringStruct() throws Exception {
        String value = "";
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_STRING_SCHEMA, value);
        StringValue message = StringValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)0L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)value, (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectBytes() throws Exception {
        byte[] value = ByteBuffer.wrap("foo".getBytes()).array();
        byte[] messageBytes = this.getMessageBytes(new SchemaAndValue(Schema.BYTES_SCHEMA, (Object)value));
        BytesValue message = BytesValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)ByteString.copyFrom((byte[])value), (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectBytesStruct() throws Exception {
        byte[] value = ByteBuffer.wrap("foo".getBytes()).array();
        byte[] messageBytes = this.getMessageBytes(OPTIONAL_BYTES_SCHEMA, value);
        BytesValue message = BytesValue.parseFrom((byte[])messageBytes);
        Assert.assertEquals((long)1L, (long)message.getAllFields().size());
        Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(VALUE_FIELD_NAME);
        Assert.assertEquals((Object)ByteString.copyFrom((byte[])value), (Object)message.getField(fieldDescriptor));
    }

    @Test
    public void testFromConnectWithInvalidName() {
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("scrub.invalid.names", (Object)true).build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        Schema schema = SchemaBuilder.struct().name("org.acme.invalid record-name").field("invalid field-name", Schema.STRING_SCHEMA).build();
        Struct struct = new Struct(schema);
        struct.put("invalid field-name", (Object)"foo");
        SchemaAndValue schemaAndValue = new SchemaAndValue(schema, (Object)struct);
        ProtobufSchemaAndValue protobufSchemaAndValue = protobufData.fromConnectData(schemaAndValue);
        ProtobufSchema protobufSchema = protobufSchemaAndValue.getSchema();
        Descriptors.Descriptor descriptor = protobufSchema.toDescriptor();
        Message message = (Message)protobufSchemaAndValue.getValue();
        Descriptors.Descriptor messageDescriptor = message.getDescriptorForType();
        Assert.assertEquals((Object)"invalid_record_name", (Object)descriptor.getName());
        Assert.assertEquals((Object)"invalid_field_name", (Object)((Descriptors.FieldDescriptor)descriptor.getFields().get(0)).getName());
        Assert.assertEquals((Object)"invalid_record_name", (Object)messageDescriptor.getName());
        Assert.assertEquals((Object)"invalid_field_name", (Object)((Descriptors.FieldDescriptor)messageDescriptor.getFields().get(0)).getName());
        Assert.assertEquals((Object)"foo", (Object)message.getField((Descriptors.FieldDescriptor)messageDescriptor.getFields().get(0)));
    }

    @Test
    public void testFromConnectIgnoreDefaultForNullables() throws Exception {
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("ignore.default.for.nullables", (Object)true).build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        KeyValue.KeyValueMessage message = KeyValue.KeyValueMessage.newBuilder().setKey(123).build();
        Schema connectSchema = this.getIgnoreDefaultForNullablesSchema();
        Struct data = this.getIgnoreDefaultForNullablesData();
        byte[] messageBytes = this.getMessageBytes(protobufData, new SchemaAndValue(connectSchema, (Object)data));
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])message.toByteArray());
    }

    private Schema getIgnoreDefaultForNullablesSchema() {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        schemaBuilder.name("KeyValueMessage");
        schemaBuilder.field("key", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        schemaBuilder.field(VALUE_FIELD_NAME, SchemaBuilder.string().optional().defaultValue((Object)"string-value").parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        return schemaBuilder.build();
    }

    private Struct getIgnoreDefaultForNullablesData() {
        Schema schema = this.getIgnoreDefaultForNullablesSchema();
        Struct result = new Struct(schema.schema());
        result.put("key", (Object)123);
        result.put(VALUE_FIELD_NAME, null);
        return result;
    }

    @Test
    public void testNameScrubbing() {
        Assert.assertEquals(null, (Object)ProtobufData.doScrubName(null));
        Assert.assertEquals((Object)"", (Object)ProtobufData.doScrubName((String)""));
        Assert.assertEquals((Object)"abc_DEF_123", (Object)ProtobufData.doScrubName((String)"abc_DEF_123"));
        Assert.assertEquals((Object)"abc_2B____", (Object)ProtobufData.doScrubName((String)"abc+-.*_"));
        Assert.assertEquals((Object)"abc_def", (Object)ProtobufData.doScrubName((String)"abc-def"));
        Assert.assertEquals((Object)"abc_2Bdef", (Object)ProtobufData.doScrubName((String)"abc+def"));
        Assert.assertEquals((Object)"abc__def", (Object)ProtobufData.doScrubName((String)"abc  def"));
        Assert.assertEquals((Object)"abc_def", (Object)ProtobufData.doScrubName((String)"abc.def"));
        Assert.assertEquals((Object)"x0abc_def", (Object)ProtobufData.doScrubName((String)"0abc.def"));
        Assert.assertEquals((Object)"x_abc_def", (Object)ProtobufData.doScrubName((String)"_abc.def"));
        Assert.assertEquals((Object)"x0abc", (Object)ProtobufData.doScrubName((String)"0abc"));
        Assert.assertEquals((Object)"x_abc", (Object)ProtobufData.doScrubName((String)"_abc"));
    }

    @Test
    public void testRoundTripConnectNoWrapperForNullables() throws Exception {
        KeyValueWrapper.KeyValueWrapperMessage message = KeyValueWrapper.KeyValueWrapperMessage.newBuilder().setKey(123).setWrappedValue(StringValue.newBuilder().setValue("hi").build()).setWrappedValue2(UInt32Value.newBuilder().setValue(456).build()).build();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue((Message)message);
        Schema expectedSchema = this.getExpectedNoWrapperForNullablesSchema();
        this.assertSchemasEqual(expectedSchema, schemaAndValue.schema());
        Struct expected = this.getExpectedNoWrapperForNullablesData();
        Assert.assertEquals((Object)expected, (Object)schemaAndValue.value());
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])message.toByteArray());
    }

    private Schema getExpectedNoWrapperForNullablesSchema() {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        schemaBuilder.name("KeyValueWrapperMessage");
        schemaBuilder.field("key", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        schemaBuilder.field("wrappedValue", SchemaBuilder.struct().name("StringValue").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).field(VALUE_FIELD_NAME, SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build()).build());
        schemaBuilder.field("wrappedValue2", SchemaBuilder.struct().name("UInt32Value").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(3)).field(VALUE_FIELD_NAME, SchemaBuilder.int64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).parameter("io.confluent.connect.protobuf.Type", "uint32").build()).build());
        return schemaBuilder.build();
    }

    private Struct getExpectedNoWrapperForNullablesData() {
        Schema schema = this.getExpectedNoWrapperForNullablesSchema();
        Struct result = new Struct(schema.schema());
        Struct value = new Struct(schema.field("wrappedValue").schema());
        value.put(VALUE_FIELD_NAME, (Object)"hi");
        Struct value2 = new Struct(schema.field("wrappedValue2").schema());
        value2.put(VALUE_FIELD_NAME, (Object)456L);
        result.put("key", (Object)123);
        result.put("wrappedValue", (Object)value);
        result.put("wrappedValue2", (Object)value2);
        return result;
    }

    @Test
    public void testRoundTripConnectWrapperForNullables() throws Exception {
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("wrapper.for.nullables", (Object)true).build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        KeyValueWrapper.KeyValueWrapperMessage message = KeyValueWrapper.KeyValueWrapperMessage.newBuilder().setKey(123).setWrappedValue(StringValue.newBuilder().setValue("hi").build()).setWrappedValue2(UInt32Value.newBuilder().setValue(456).build()).build();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue(protobufData, (Message)message);
        Schema expectedSchema = this.getExpectedWrapperForNullablesSchema();
        this.assertSchemasEqual(expectedSchema, schemaAndValue.schema());
        Struct expected = this.getExpectedWrapperForNullablesData();
        Assert.assertEquals((Object)expected, (Object)schemaAndValue.value());
        byte[] messageBytes = this.getMessageBytes(protobufData, schemaAndValue);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])message.toByteArray());
    }

    private Schema getExpectedWrapperForNullablesSchema() {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        schemaBuilder.name("KeyValueWrapperMessage");
        schemaBuilder.field("key", SchemaBuilder.int32().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        schemaBuilder.field("wrappedValue", SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        schemaBuilder.field("wrappedValue2", SchemaBuilder.int64().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(3)).build());
        return schemaBuilder.build();
    }

    private Struct getExpectedWrapperForNullablesData() {
        Schema schema = this.getExpectedWrapperForNullablesSchema();
        Struct result = new Struct(schema.schema());
        result.put("key", (Object)123);
        result.put("wrappedValue", (Object)"hi");
        result.put("wrappedValue2", (Object)456L);
        return result;
    }

    @Test
    public void testRoundTripConnectNoOptionalForNullables() throws Exception {
        KeyValueOptional.KeyValueOptionalMessage message = KeyValueOptional.KeyValueOptionalMessage.newBuilder().setKey(123).setValue("hi").build();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue((Message)message);
        Schema expectedSchema = this.getExpectedNoOptionalForNullablesSchema();
        this.assertSchemasEqual(expectedSchema, schemaAndValue.schema());
        Struct expected = this.getExpectedNoOptionalForNullablesData();
        Assert.assertEquals((Object)expected, (Object)schemaAndValue.value());
        byte[] messageBytes = this.getMessageBytes(schemaAndValue);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])message.toByteArray());
    }

    private Schema getExpectedNoOptionalForNullablesSchema() {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        schemaBuilder.name("KeyValueOptionalMessage");
        schemaBuilder.field("key", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        schemaBuilder.field(VALUE_FIELD_NAME, SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        return schemaBuilder.build();
    }

    private Struct getExpectedNoOptionalForNullablesData() {
        Schema schema = this.getExpectedNoOptionalForNullablesSchema();
        Struct result = new Struct(schema.schema());
        result.put("key", (Object)123);
        result.put(VALUE_FIELD_NAME, (Object)"hi");
        return result;
    }

    @Test
    public void testRoundTripConnectOptionalForNullables() throws Exception {
        ProtobufDataConfig protobufDataConfig = new ProtobufDataConfig.Builder().with("optional.for.nullables", (Object)true).build();
        ProtobufData protobufData = new ProtobufData(protobufDataConfig);
        KeyValueOptional.KeyValueOptionalMessage message = KeyValueOptional.KeyValueOptionalMessage.newBuilder().setKey(123).setValue("hi").build();
        SchemaAndValue schemaAndValue = this.getSchemaAndValue(protobufData, (Message)message);
        Schema expectedSchema = this.getExpectedOptionalForNullablesSchema();
        this.assertSchemasEqual(expectedSchema, schemaAndValue.schema());
        Struct expected = this.getExpectedOptionalForNullablesData();
        Assert.assertEquals((Object)expected, (Object)schemaAndValue.value());
        byte[] messageBytes = this.getMessageBytes(protobufData, schemaAndValue);
        Assert.assertArrayEquals((byte[])messageBytes, (byte[])message.toByteArray());
    }

    private Schema getExpectedOptionalForNullablesSchema() {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        schemaBuilder.name("KeyValueOptionalMessage");
        schemaBuilder.field("key", SchemaBuilder.int32().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        schemaBuilder.field(VALUE_FIELD_NAME, SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        return schemaBuilder.build();
    }

    private Struct getExpectedOptionalForNullablesData() {
        Schema schema = this.getExpectedOptionalForNullablesSchema();
        Struct result = new Struct(schema.schema());
        result.put("key", (Object)123);
        result.put(VALUE_FIELD_NAME, (Object)"hi");
        return result;
    }

    @Test
    public void testToConnectRecursiveSchema() {
        ProtobufSchema protobufSchema = new ProtobufSchema(RecursiveKeyValue.RecursiveKeyValueMessage.getDescriptor());
        ProtobufData protobufData = new ProtobufData();
        Schema expected = this.getRecursiveSchema();
        Schema actual = protobufData.toConnectSchema(protobufSchema);
        Assert.assertEquals((Object)expected.field("key"), (Object)actual.field("key"));
        Assert.assertEquals((Object)expected.field(VALUE_FIELD_NAME), (Object)actual.field(VALUE_FIELD_NAME));
        Schema expectedNested = expected.field("key_value").schema();
        Schema actualNested = actual.field("key_value").schema();
        Assert.assertEquals((Object)expectedNested.name(), (Object)actualNested.name());
        Assert.assertEquals((Object)expectedNested.type(), (Object)actualNested.type());
        Assert.assertEquals((Object)expectedNested.parameters(), (Object)actualNested.parameters());
    }

    @Test
    public void testMultipleOneofs() throws Exception {
        String schema = "syntax = \"proto3\";\n\npackage foo;\n\nmessage Customer {\n    int64 count = 1;\n    string first_name = 2;\n    string last_name = 3;\n    string address = 4;\n    oneof survey_id {\n        string survey_response_id = 5;\n        string outgoing_action_id = 6;\n    }\n    oneof comment {\n        string email = 7;\n        string platform = 8;\n    }\n}";
        ProtobufSchema protobufSchema = new ProtobufSchema(schema);
        HashMap configs = new HashMap();
        ProtobufData protobufData = new ProtobufData(new ProtobufDataConfig(configs));
        String json = "{\"count\":\"0\",\"firstName\":\"Bob\",\"lastName\":\"Jones\",\"address\":\"123 Main St\",\"outgoingActionId\":\"my outgoing_action_id\",\"platform\":\"my platform\"}";
        Message message = (Message)ProtobufSchemaUtils.toObject((String)json, (ProtobufSchema)protobufSchema);
        SchemaAndValue result = protobufData.toConnectData(protobufSchema, message);
        Struct value = (Struct)result.value();
        Assert.assertEquals((Object)"my outgoing_action_id", (Object)((Struct)value.get("survey_id_0")).get("outgoing_action_id"));
        Assert.assertEquals((Object)"my platform", (Object)((Struct)value.get("comment_1")).get("platform"));
    }

    @Test
    public void testDiamond() throws Exception {
        String schema = "syntax = \"proto3\";\npackage com.mycorp.mynamespace;\n\nmessage SampleRecord {\n  int32 my_field1 = 1;\n  int32 totalAmount = 2;\n  Org payee = 3;\n}\nmessage Org {\n  string id = 1;\n  string name = 2;\n  PAdd contactAddress = 3;\n  repeated Location locations = 4;\n}\nmessage PAdd {\n  string postalAddress = 1;\n  PAddType type = 2;\n}\nmessage Location {\n  string id = 1;\n  string name = 2;\n  PAdd physicalAddress = 3;\n}\nenum PAddType {\n  POSTAL_ADDRESS_TYPE_UNSPECIFIED = 0;\n  POSTAL = 1;\n  PHYSICAL = 2;\n}";
        ProtobufSchema protobufSchema = new ProtobufSchema(schema);
        HashMap configs = new HashMap();
        ProtobufData protobufData = new ProtobufData(new ProtobufDataConfig(configs));
        Schema connectSchema = protobufData.toConnectSchema(protobufSchema);
        ProtobufSchema protobufSchema2 = protobufData.fromConnectSchema(connectSchema);
        Assert.assertNotNull((Object)protobufSchema2);
    }

    @Test
    public void testToConnectFullyQualifiedSchema() {
        String schema = "syntax = \"proto3\";\n\npackage foo;\n\nmessage Event {\n  Action action = 1;\n  Target target = 2;\n\n  message Target {\n    oneof payload {\n      string payload_id = 1;\n      Action action = 2;\n    }\n    enum Action {\n      ON  = 0;\n      OFF = 1;\n    }\n  }\n\n  oneof payload {\n    string payload_id = 3;\n  }\n\n  enum Action {\n    ON  = 0;\n    OFF = 1;\n  }\n}";
        ProtobufSchema protobufSchema = new ProtobufSchema(schema);
        HashMap<String, Boolean> configs = new HashMap<String, Boolean>();
        configs.put("enhanced.protobuf.schema.support", true);
        ProtobufData protobufData = new ProtobufData(new ProtobufDataConfig(configs));
        Schema actual = protobufData.toConnectSchema(protobufSchema);
        Assert.assertEquals((Object)"io.confluent.connect.protobuf.Union.foo.Event.payload", (Object)actual.field("payload_0").schema().name());
        Assert.assertEquals((Object)"foo.Event.Action", (Object)actual.field("action").schema().name());
    }

    @Test
    public void testToConnectFullyQualifiedMapSchema() {
        String schema = "syntax = \"proto3\";\n\noption java_package = \"io.confluent.connect.protobuf.test\";\n\nmessage Customer {\n  map<string,string> tags = 1;\n  Meta meta = 2;\n}\n\nmessage Meta {\n  map<string,Value> tags = 2;\n}\n\nmessage Value{\n  float a=1;\n  float b=2;\n}\n";
        ProtobufSchema protobufSchema = new ProtobufSchema(schema);
        HashMap<String, Boolean> configs = new HashMap<String, Boolean>();
        configs.put("enhanced.protobuf.schema.support", true);
        ProtobufData protobufData = new ProtobufData(new ProtobufDataConfig(configs));
        Schema actual = protobufData.toConnectSchema(protobufSchema);
        Assert.assertEquals((Object)"Customer.tags", (Object)actual.field("tags").schema().name());
        Assert.assertEquals((Object)"Meta.tags", (Object)actual.field("meta").schema().field("tags").schema().name());
    }

    @Test
    public void testToConnectOptionalProto2() {
        KeyValueProto2.KeyValueMessage message = KeyValueProto2.KeyValueMessage.newBuilder().setKey(123).build();
        ProtobufSchema protobufSchema = new ProtobufSchema(message.getDescriptorForType());
        ProtobufData protobufData = new ProtobufData();
        SchemaAndValue result = protobufData.toConnectData(protobufSchema, (Message)message);
        Struct value = (Struct)result.value();
        Assert.assertNull((Object)value.get(VALUE_FIELD_NAME));
    }

    @Test
    public void testToConnectOptionalProto2Disabled() {
        KeyValueProto2.KeyValueMessage message = KeyValueProto2.KeyValueMessage.newBuilder().setKey(123).build();
        ProtobufSchema protobufSchema = new ProtobufSchema(message.getDescriptorForType());
        HashMap<String, Boolean> configs = new HashMap<String, Boolean>();
        configs.put("optional.for.proto2", false);
        ProtobufData protobufData = new ProtobufData(new ProtobufDataConfig(configs));
        SchemaAndValue result = protobufData.toConnectData(protobufSchema, (Message)message);
        Struct value = (Struct)result.value();
        Assert.assertNotNull((Object)value.get(VALUE_FIELD_NAME));
    }

    @Test
    public void testToConnectMultipleMapReferences() throws Exception {
        MapReferences.AttributeFieldEntry entry1 = MapReferences.AttributeFieldEntry.newBuilder().setKey("key1").setValue("value1").build();
        MapReferences.AttributeFieldEntry entry2 = MapReferences.AttributeFieldEntry.newBuilder().setKey("key2").setValue("value2").build();
        MapReferences.AttributeFieldEntry entry3 = MapReferences.AttributeFieldEntry.newBuilder().setKey("key3").setValue("value3").build();
        MapReferences.AttributeFieldEntry entry4 = MapReferences.AttributeFieldEntry.newBuilder().setKey("key4").setValue("value4").build();
        MapReferences.MapReferencesMessage message = MapReferences.MapReferencesMessage.newBuilder().addMap1(entry1).addMap2(entry2).setNotAMap1(entry3).setNotAMap2(entry4).build();
        ProtobufData protobufData = new ProtobufData();
        ProtobufSchema protobufSchema = new ProtobufSchema(message.getDescriptorForType());
        SchemaAndValue result = protobufData.toConnectData(protobufSchema, (Message)message);
        SchemaBuilder structBuilder = SchemaBuilder.struct();
        structBuilder.name("AttributeFieldEntry");
        structBuilder.field("key", SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        structBuilder.field(VALUE_FIELD_NAME, SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        SchemaBuilder builder = SchemaBuilder.struct();
        builder.name("MapReferencesMessage");
        builder.field("map1", SchemaBuilder.map((Schema)OPTIONAL_STRING_SCHEMA, (Schema)SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build()).name("attribute_field").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        builder.field("map2", SchemaBuilder.map((Schema)OPTIONAL_STRING_SCHEMA, (Schema)SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build()).name("attribute_field").optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        builder.field("notAMap1", structBuilder.optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(3)).build());
        builder.field("notAMap2", new ProtobufData.SchemaWrapper(structBuilder).optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(4)).build());
        Schema expectedSchema = builder.build();
        this.assertSchemasEqual(expectedSchema, result.schema());
        Struct expected = new Struct(expectedSchema);
        expected.put("map1", Collections.singletonMap("key1", "value1"));
        expected.put("map2", Collections.singletonMap("key2", "value2"));
        expected.put("notAMap1", (Object)new Struct(expectedSchema.field("notAMap1").schema()).put("key", (Object)"key3").put(VALUE_FIELD_NAME, (Object)"value3"));
        expected.put("notAMap2", (Object)new Struct(expectedSchema.field("notAMap2").schema()).put("key", (Object)"key4").put(VALUE_FIELD_NAME, (Object)"value4"));
        Assert.assertEquals((Object)expected.get("map1"), (Object)((Struct)result.value()).get("map1"));
        Assert.assertEquals((Object)expected.get("map2"), (Object)((Struct)result.value()).get("map2"));
        Assert.assertEquals((Object)expected.get("notAMap1"), (Object)((Struct)result.value()).get("notAMap1"));
        Struct expectedNotAMap2 = (Struct)expected.get("notAMap2");
        Struct actualNotAMap2 = (Struct)((Struct)result.value()).get("notAMap2");
        Assert.assertEquals((Object)expectedNotAMap2.get("key"), (Object)actualNotAMap2.get("key"));
        Assert.assertEquals((Object)expectedNotAMap2.get(VALUE_FIELD_NAME), (Object)actualNotAMap2.get(VALUE_FIELD_NAME));
    }

    @Test
    public void testFromConnectRecursiveSchema() {
        Descriptors.Descriptor expected = RecursiveKeyValue.RecursiveKeyValueMessage.getDescriptor();
        ProtobufData protobufData = new ProtobufData();
        ProtobufSchema protobufSchema = protobufData.fromConnectSchema(this.getRecursiveSchema());
        Descriptors.Descriptor actual = protobufSchema.toDescriptor();
        Descriptors.FieldDescriptor expectedKey = expected.findFieldByName("key");
        Descriptors.FieldDescriptor expectedValue = expected.findFieldByName(VALUE_FIELD_NAME);
        Descriptors.FieldDescriptor expectedKeyValue = expected.findFieldByName("key_value");
        Descriptors.FieldDescriptor actualKey = actual.findFieldByName("key");
        Descriptors.FieldDescriptor actualValue = actual.findFieldByName(VALUE_FIELD_NAME);
        Descriptors.FieldDescriptor actualKeyValue = actual.findFieldByName("key_value");
        Assert.assertEquals((Object)expectedKey.getType(), (Object)actualKey.getType());
        Assert.assertEquals((long)expectedKey.getNumber(), (long)actualKey.getNumber());
        Assert.assertEquals((Object)expectedValue.getType(), (Object)actualValue.getType());
        Assert.assertEquals((long)expectedValue.getNumber(), (long)actualValue.getNumber());
        Assert.assertEquals((long)expectedKeyValue.getNumber(), (long)actualKeyValue.getNumber());
    }

    private Schema getRecursiveSchema() {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        schemaBuilder.name("RecursiveKeyValueMessage");
        schemaBuilder.field("key", SchemaBuilder.int32().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(1)).build());
        schemaBuilder.field(VALUE_FIELD_NAME, SchemaBuilder.string().optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(2)).build());
        schemaBuilder.field("key_value", new ProtobufData.SchemaWrapper(schemaBuilder).optional().parameter("io.confluent.connect.protobuf.Tag", String.valueOf(10)).build());
        return schemaBuilder.build();
    }
}

