/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.confluent.connect.protobuf.ProtobufDataConfig;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.DynamicSchema;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.EnumDefinition;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.MessageDefinition;
import io.confluent.kafka.serializers.protobuf.ProtobufSchemaAndValue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;

public class ProtobufData {
    public static final String NAMESPACE = "io.confluent.connect.protobuf";
    public static final String DEFAULT_SCHEMA_NAME = "ConnectDefault";
    public static final String MAP_ENTRY_SUFFIX = "Entry";
    public static final String KEY_FIELD = "key";
    public static final String VALUE_FIELD = "value";
    public static final String PROTOBUF_TYPE_ENUM = "io.confluent.connect.protobuf.Enum";
    public static final String PROTOBUF_TYPE_ENUM_PREFIX = "io.confluent.connect.protobuf.Enum.";
    public static final String PROTOBUF_TYPE_UNION = "io.confluent.connect.protobuf.Union";
    public static final String PROTOBUF_TYPE_UNION_PREFIX = "io.confluent.connect.protobuf.Union.";
    public static final String PROTOBUF_TYPE_TAG = "io.confluent.connect.protobuf.Tag";
    public static final String GOOGLE_PROTOBUF_PACKAGE = "google.protobuf";
    public static final String GOOGLE_PROTOBUF_TIMESTAMP_NAME = "Timestamp";
    public static final String GOOGLE_PROTOBUF_TIMESTAMP_FULL_NAME = "google.protobuf.Timestamp";
    public static final String GOOGLE_PROTOBUF_TIMESTAMP_LOCATION = "google/protobuf/timestamp.proto";
    private int defaultSchemaNameIndex = 0;
    private final Cache<Schema, ProtobufSchema> fromConnectSchemaCache;
    private final Cache<Pair<String, ProtobufSchema>, Schema> toConnectSchemaCache;
    private boolean enhancedSchemaSupport;

    public ProtobufData() {
        this(new ProtobufDataConfig.Builder().with("schemas.cache.config", 1000).build());
    }

    public ProtobufData(int cacheSize) {
        this(new ProtobufDataConfig.Builder().with("schemas.cache.config", cacheSize).build());
    }

    public ProtobufData(ProtobufDataConfig protobufDataConfig) {
        this.fromConnectSchemaCache = new SynchronizedCache((Cache)new LRUCache(protobufDataConfig.schemaCacheSize()));
        this.toConnectSchemaCache = new SynchronizedCache((Cache)new LRUCache(protobufDataConfig.schemaCacheSize()));
        this.enhancedSchemaSupport = protobufDataConfig.isEnhancedProtobufSchemaSupport();
    }

    public ProtobufSchemaAndValue fromConnectData(Schema schema, Object value) {
        ProtobufSchema protobufSchema = this.fromConnectSchema(schema);
        Descriptors.Descriptor ctx = null;
        if (schema != null) {
            String name = schema.name();
            if (name == null) {
                name = "ConnectDefault1";
            }
            ctx = protobufSchema.toDescriptor(name);
        }
        return new ProtobufSchemaAndValue(protobufSchema, this.fromConnectData(ctx, schema, "", value, protobufSchema));
    }

    protected ProtobufSchemaAndValue fromConnectData(SchemaAndValue schemaAndValue) {
        return this.fromConnectData(schemaAndValue.schema(), schemaAndValue.value());
    }

    private Object fromConnectData(Object ctx, Schema schema, String scope, Object value, ProtobufSchema protobufSchema) {
        if (value == null) {
            return null;
        }
        Schema.Type schemaType = schema.type();
        try {
            switch (schemaType) {
                case INT8: 
                case INT16: 
                case INT32: {
                    int intValue = ((Number)value).intValue();
                    return intValue;
                }
                case INT64: {
                    if (this.isProtobufTimestamp(schema)) {
                        Date timestamp = (Date)value;
                        return Timestamps.fromMillis((long)org.apache.kafka.connect.data.Timestamp.fromLogical((Schema)schema, (Date)timestamp));
                    }
                    long longValue = ((Number)value).longValue();
                    return longValue;
                }
                case FLOAT32: {
                    float floatValue = ((Number)value).floatValue();
                    return Float.valueOf(floatValue);
                }
                case FLOAT64: {
                    double doubleValue = ((Number)value).doubleValue();
                    return doubleValue;
                }
                case BOOLEAN: {
                    Boolean boolValue = (Boolean)value;
                    return boolValue;
                }
                case STRING: {
                    String stringValue = (String)value;
                    if (schema.parameters() != null && schema.parameters().containsKey(PROTOBUF_TYPE_ENUM)) {
                        String enumType = (String)schema.parameters().get(PROTOBUF_TYPE_ENUM);
                        String tag = (String)schema.parameters().get(PROTOBUF_TYPE_ENUM_PREFIX + stringValue);
                        if (tag != null) {
                            return protobufSchema.getEnumValue(scope + enumType, Integer.parseInt(tag));
                        }
                    }
                    return stringValue;
                }
                case BYTES: {
                    ByteBuffer bytesValue = value instanceof byte[] ? ByteBuffer.wrap((byte[])value) : (ByteBuffer)value;
                    return ByteString.copyFrom((ByteBuffer)bytesValue);
                }
                case ARRAY: {
                    Collection listValue = (Collection)value;
                    if (listValue.isEmpty()) {
                        return null;
                    }
                    ArrayList<Object> newListValue = new ArrayList<Object>();
                    for (Object o : listValue) {
                        newListValue.add(this.fromConnectData(ctx, schema.valueSchema(), scope, o, protobufSchema));
                    }
                    return newListValue;
                }
                case MAP: {
                    Map mapValue = (Map)value;
                    String scopedMapName = ((Descriptors.Descriptor)ctx).getFullName();
                    ArrayList<DynamicMessage> newMapValue = new ArrayList<DynamicMessage>();
                    for (Map.Entry mapEntry : mapValue.entrySet()) {
                        DynamicMessage.Builder mapBuilder = protobufSchema.newMessageBuilder(scopedMapName);
                        if (mapBuilder == null) {
                            throw new IllegalStateException("Invalid message name: " + scopedMapName);
                        }
                        Descriptors.Descriptor mapDescriptor = mapBuilder.getDescriptorForType();
                        Descriptors.FieldDescriptor keyDescriptor = mapDescriptor.findFieldByName(KEY_FIELD);
                        Descriptors.FieldDescriptor valueDescriptor = mapDescriptor.findFieldByName(VALUE_FIELD);
                        Object entryKey = this.fromConnectData(this.getFieldType(keyDescriptor), schema.keySchema(), scopedMapName + ".", mapEntry.getKey(), protobufSchema);
                        Object entryValue = this.fromConnectData(this.getFieldType(valueDescriptor), schema.valueSchema(), scopedMapName + ".", mapEntry.getValue(), protobufSchema);
                        mapBuilder.setField(keyDescriptor, entryKey);
                        mapBuilder.setField(valueDescriptor, entryValue);
                        newMapValue.add(mapBuilder.build());
                    }
                    return newMapValue;
                }
                case STRUCT: {
                    Struct struct = (Struct)value;
                    if (!struct.schema().equals(schema)) {
                        throw new DataException("Mismatching struct schema");
                    }
                    String structName = schema.name();
                    if (structName != null && structName.startsWith(PROTOBUF_TYPE_UNION_PREFIX)) {
                        for (Field field : schema.fields()) {
                            Object object = struct.get(field);
                            if (object == null) continue;
                            Object fieldCtx = this.getFieldType(ctx, field.name());
                            return new Pair<String, Object>(field.name(), this.fromConnectData(fieldCtx, field.schema(), scope, object, protobufSchema));
                        }
                        throw new DataException("Cannot find non-null field");
                    }
                    String scopedStructName = ((Descriptors.Descriptor)ctx).getFullName();
                    DynamicMessage.Builder messageBuilder = protobufSchema.newMessageBuilder(scopedStructName);
                    if (messageBuilder == null) {
                        throw new DataException("Invalid message name: " + scopedStructName);
                    }
                    for (Field field : schema.fields()) {
                        Descriptors.FieldDescriptor fieldDescriptor;
                        Object fieldCtx = this.getFieldType(ctx, field.name());
                        Object fieldValue = this.fromConnectData(fieldCtx, field.schema(), scopedStructName + ".", struct.get(field), protobufSchema);
                        if (fieldValue == null) continue;
                        if (fieldValue instanceof Pair) {
                            Pair union = (Pair)fieldValue;
                            fieldDescriptor = messageBuilder.getDescriptorForType().findFieldByName((String)union.getKey());
                            fieldValue = union.getValue();
                        } else {
                            fieldDescriptor = messageBuilder.getDescriptorForType().findFieldByName(field.name());
                        }
                        if (fieldDescriptor == null) {
                            throw new DataException("Cannot find field with name " + field.name());
                        }
                        messageBuilder.setField(fieldDescriptor, fieldValue);
                    }
                    return messageBuilder.build();
                }
            }
            throw new DataException("Unknown schema type: " + schema.type());
        }
        catch (ClassCastException e) {
            throw new DataException("Invalid type for " + schema.type() + ": " + value.getClass());
        }
    }

    private Object getFieldType(Object ctx, String name) {
        Descriptors.FieldDescriptor field = ((Descriptors.Descriptor)ctx).findFieldByName(name);
        if (field == null) {
            return ctx;
        }
        return this.getFieldType(field);
    }

    private Object getFieldType(Descriptors.FieldDescriptor field) {
        switch (field.getJavaType()) {
            case MESSAGE: {
                return field.getMessageType();
            }
            case ENUM: {
                return field.getEnumType();
            }
        }
        return field.getJavaType();
    }

    public ProtobufSchema fromConnectSchema(Schema schema) {
        if (schema == null) {
            return null;
        }
        ProtobufSchema cachedSchema = (ProtobufSchema)this.fromConnectSchemaCache.get((Object)schema);
        if (cachedSchema != null) {
            return cachedSchema;
        }
        String name = schema.name();
        if (name == null) {
            name = "ConnectDefault1";
        }
        ProtobufSchema resultSchema = new ProtobufSchema(this.rawSchemaFromConnectSchema(schema).getMessageDescriptor(name));
        this.fromConnectSchemaCache.put((Object)schema, (Object)resultSchema);
        return resultSchema;
    }

    private DynamicSchema rawSchemaFromConnectSchema(Schema rootElem) {
        if (rootElem.type() != Schema.Type.STRUCT) {
            throw new IllegalArgumentException("Unsupported root schema of type " + rootElem.type());
        }
        try {
            DynamicSchema.Builder schema = DynamicSchema.newBuilder();
            schema.setSyntax("proto3");
            String fullName = this.getNameOrDefault(rootElem.name());
            String[] split = ProtobufData.splitName(fullName);
            String namespace = split[0];
            String name = split[1];
            if (namespace != null) {
                schema.setPackage(namespace);
            }
            FromConnectContext ctx = new FromConnectContext();
            ctx.add(fullName);
            schema.addMessageDefinition(this.messageDefinitionFromConnectSchema(ctx, schema, name, rootElem));
            return schema.build();
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new IllegalStateException(e);
        }
    }

    private MessageDefinition messageDefinitionFromConnectSchema(FromConnectContext ctx, DynamicSchema.Builder schema, String name, Schema messageElem) {
        MessageDefinition.Builder message = MessageDefinition.newBuilder((String)name);
        int index = 1;
        for (Field field : messageElem.fields()) {
            int tag;
            Schema fieldSchema = field.schema();
            String fieldTag = fieldSchema.parameters() != null ? (String)fieldSchema.parameters().get(PROTOBUF_TYPE_TAG) : null;
            int n = tag = fieldTag != null ? Integer.parseInt(fieldTag) : index++;
            FieldDefinition fieldDef = this.fieldDefinitionFromConnectSchema(ctx, schema, message, fieldSchema, field.name(), tag);
            if (fieldDef == null) continue;
            message.addField(fieldDef.getLabel(), fieldDef.getType(), fieldDef.getName(), fieldDef.getNum(), fieldDef.getDefaultVal());
        }
        return message.build();
    }

    private void oneofDefinitionFromConnectSchema(FromConnectContext ctx, DynamicSchema.Builder schema, MessageDefinition.Builder message, Schema unionElem, String unionName) {
        MessageDefinition.OneofBuilder oneof = message.addOneof(unionName);
        for (Field field : unionElem.fields()) {
            int tag;
            Schema fieldSchema = field.schema();
            String fieldTag = fieldSchema.parameters() != null ? (String)fieldSchema.parameters().get(PROTOBUF_TYPE_TAG) : null;
            int n = tag = fieldTag != null ? Integer.parseInt(fieldTag) : 0;
            FieldDefinition fieldDef = this.fieldDefinitionFromConnectSchema(ctx, schema, message, field.schema(), field.name(), tag);
            if (fieldDef == null) continue;
            oneof.addField(fieldDef.getType(), fieldDef.getName(), fieldDef.getNum(), fieldDef.getDefaultVal());
        }
    }

    private FieldDefinition fieldDefinitionFromConnectSchema(FromConnectContext ctx, DynamicSchema.Builder schema, MessageDefinition.Builder message, Schema fieldSchema, String name, int tag) {
        try {
            String label;
            String string = label = fieldSchema.isOptional() ? "optional" : "required";
            if (fieldSchema.type() == Schema.Type.ARRAY) {
                label = "repeated";
                fieldSchema = fieldSchema.valueSchema();
            } else if (fieldSchema.type() == Schema.Type.MAP) {
                label = "repeated";
            }
            String type = this.dataTypeFromConnectSchema(fieldSchema);
            if (fieldSchema.type() == Schema.Type.STRUCT) {
                String fieldSchemaName = fieldSchema.name();
                if (fieldSchemaName != null && fieldSchemaName.startsWith(PROTOBUF_TYPE_UNION_PREFIX)) {
                    String unionName = this.getUnqualifiedName(fieldSchemaName.substring(PROTOBUF_TYPE_UNION_PREFIX.length()));
                    this.oneofDefinitionFromConnectSchema(ctx, schema, message, fieldSchema, unionName);
                    return null;
                }
                if (!ctx.contains(fieldSchemaName)) {
                    ctx.add(fieldSchemaName);
                    message.addMessageDefinition(this.messageDefinitionFromConnectSchema(ctx, schema, type, fieldSchema));
                }
            } else if (fieldSchema.type() == Schema.Type.MAP) {
                message.addMessageDefinition(this.mapDefinitionFromConnectSchema(ctx, schema, type, fieldSchema));
            } else if (fieldSchema.parameters() != null && fieldSchema.parameters().containsKey(PROTOBUF_TYPE_ENUM)) {
                message.addEnumDefinition(this.enumDefinitionFromConnectSchema(schema, fieldSchema));
            } else if (type.equals(GOOGLE_PROTOBUF_TIMESTAMP_FULL_NAME)) {
                DynamicSchema.Builder timestampSchema = DynamicSchema.newBuilder();
                timestampSchema.setSyntax("proto3");
                timestampSchema.setName(GOOGLE_PROTOBUF_TIMESTAMP_LOCATION);
                timestampSchema.setPackage(GOOGLE_PROTOBUF_PACKAGE);
                timestampSchema.addMessageDefinition(ProtobufData.timestampDefinition());
                schema.addSchema(timestampSchema.build());
                schema.addDependency(GOOGLE_PROTOBUF_TIMESTAMP_LOCATION);
            }
            Object defaultVal = fieldSchema.defaultValue();
            return new FieldDefinition(label, type, name, tag, defaultVal != null ? defaultVal.toString() : null);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new IllegalStateException(e);
        }
    }

    private MessageDefinition mapDefinitionFromConnectSchema(FromConnectContext ctx, DynamicSchema.Builder schema, String name, Schema mapElem) {
        MessageDefinition.Builder map = MessageDefinition.newBuilder((String)name);
        FieldDefinition key = this.fieldDefinitionFromConnectSchema(ctx, schema, map, mapElem.keySchema(), KEY_FIELD, 1);
        map.addField(key.getLabel(), key.getType(), key.getName(), key.getNum(), key.getDefaultVal());
        FieldDefinition val = this.fieldDefinitionFromConnectSchema(ctx, schema, map, mapElem.valueSchema(), VALUE_FIELD, 2);
        map.addField(val.getLabel(), val.getType(), val.getName(), val.getNum(), val.getDefaultVal());
        return map.build();
    }

    private EnumDefinition enumDefinitionFromConnectSchema(DynamicSchema.Builder schema, Schema enumElem) {
        String enumName = this.getUnqualifiedName(enumElem.name());
        EnumDefinition.Builder enumer = EnumDefinition.newBuilder((String)enumName);
        for (Map.Entry entry : enumElem.parameters().entrySet()) {
            if (!((String)entry.getKey()).startsWith(PROTOBUF_TYPE_ENUM_PREFIX)) continue;
            String name = ((String)entry.getKey()).substring(PROTOBUF_TYPE_ENUM_PREFIX.length());
            int tag = Integer.parseInt((String)entry.getValue());
            enumer.addValue(name, tag);
        }
        return enumer.build();
    }

    private String dataTypeFromConnectSchema(Schema schema) {
        switch (schema.type()) {
            case INT8: 
            case INT16: 
            case INT32: {
                return Descriptors.FieldDescriptor.Type.INT32.toString().toLowerCase();
            }
            case INT64: {
                if (this.isProtobufTimestamp(schema)) {
                    return GOOGLE_PROTOBUF_TIMESTAMP_FULL_NAME;
                }
                return Descriptors.FieldDescriptor.Type.INT64.toString().toLowerCase();
            }
            case FLOAT32: {
                return Descriptors.FieldDescriptor.Type.FLOAT.toString().toLowerCase();
            }
            case FLOAT64: {
                return Descriptors.FieldDescriptor.Type.DOUBLE.toString().toLowerCase();
            }
            case BOOLEAN: {
                return Descriptors.FieldDescriptor.Type.BOOL.toString().toLowerCase();
            }
            case STRING: {
                if (schema.parameters() != null && schema.parameters().containsKey(PROTOBUF_TYPE_ENUM)) {
                    return (String)schema.parameters().get(PROTOBUF_TYPE_ENUM);
                }
                return Descriptors.FieldDescriptor.Type.STRING.toString().toLowerCase();
            }
            case BYTES: {
                return Descriptors.FieldDescriptor.Type.BYTES.toString().toLowerCase();
            }
            case ARRAY: {
                throw new IllegalArgumentException("Array cannot be nested");
            }
            case MAP: {
                return ProtobufSchema.toMapEntry((String)this.getUnqualifiedName(schema.name()));
            }
            case STRUCT: {
                return this.getUnqualifiedName(schema.name());
            }
        }
        throw new DataException("Unknown schema type: " + schema.type());
    }

    private boolean isProtobufTimestamp(Schema schema) {
        return org.apache.kafka.connect.data.Timestamp.SCHEMA.name().equals(schema.name());
    }

    public SchemaAndValue toConnectData(ProtobufSchema protobufSchema, Message message) {
        if (message == null) {
            return SchemaAndValue.NULL;
        }
        Schema schema = this.toConnectSchema(protobufSchema);
        return new SchemaAndValue(schema, this.toConnectData(schema, (Object)message));
    }

    protected Object toConnectData(Schema schema, Object value) {
        try {
            if (value == null) {
                return null;
            }
            if (this.isProtobufTimestamp(schema)) {
                Message message = (Message)value;
                long seconds = 0L;
                int nanos = 0;
                for (Map.Entry entry : message.getAllFields().entrySet()) {
                    if (((Descriptors.FieldDescriptor)entry.getKey()).getName().equals("seconds")) {
                        seconds = ((Number)entry.getValue()).longValue();
                        continue;
                    }
                    if (!((Descriptors.FieldDescriptor)entry.getKey()).getName().equals("nanos")) continue;
                    nanos = ((Number)entry.getValue()).intValue();
                }
                Timestamp timestamp = Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
                return org.apache.kafka.connect.data.Timestamp.toLogical((Schema)schema, (long)Timestamps.toMillis((Timestamp)timestamp));
            }
            Struct converted = null;
            switch (schema.type()) {
                case INT8: 
                case INT16: 
                case INT32: {
                    converted = Integer.valueOf(((Number)value).intValue());
                    break;
                }
                case INT64: {
                    long longValue = value instanceof Long ? (Long)value : Integer.toUnsignedLong(((Number)value).intValue());
                    converted = Long.valueOf(longValue);
                    break;
                }
                case FLOAT32: {
                    converted = Float.valueOf(((Number)value).floatValue());
                    break;
                }
                case FLOAT64: {
                    converted = Double.valueOf(((Number)value).doubleValue());
                    break;
                }
                case BOOLEAN: {
                    converted = (Boolean)value;
                    break;
                }
                case STRING: {
                    if (value instanceof String) {
                        converted = value;
                        break;
                    }
                    if (value instanceof CharSequence || value instanceof Enum || value instanceof Descriptors.EnumValueDescriptor) {
                        converted = value.toString();
                        break;
                    }
                    throw new DataException("Invalid class for string type, expecting String or CharSequence but found " + value.getClass());
                }
                case BYTES: {
                    if (value instanceof byte[]) {
                        converted = ByteBuffer.wrap((byte[])value);
                        break;
                    }
                    if (value instanceof ByteBuffer) {
                        converted = value;
                        break;
                    }
                    if (value instanceof ByteString) {
                        converted = ((ByteString)value).asReadOnlyByteBuffer();
                        break;
                    }
                    throw new DataException("Invalid class for bytes type, expecting byte[], ByteBuffer, or ByteString but found " + value.getClass());
                }
                case ARRAY: {
                    Schema elemSchema = schema.valueSchema();
                    Collection array = (Collection)value;
                    ArrayList<Object> newArray = new ArrayList<Object>(array.size());
                    for (Object elem : array) {
                        newArray.add(this.toConnectData(elemSchema, elem));
                    }
                    converted = newArray;
                    break;
                }
                case MAP: {
                    Schema keySchema = schema.keySchema();
                    Schema valueSchema = schema.valueSchema();
                    Collection map = (Collection)value;
                    HashMap<Object, Object> newMap = new HashMap<Object, Object>();
                    for (Message message : map) {
                        Descriptors.Descriptor descriptor = message.getDescriptorForType();
                        Object elemKey = message.getField(descriptor.findFieldByName(KEY_FIELD));
                        Object elemValue = message.getField(descriptor.findFieldByName(VALUE_FIELD));
                        newMap.put(this.toConnectData(keySchema, elemKey), this.toConnectData(valueSchema, elemValue));
                    }
                    converted = newMap;
                    break;
                }
                case STRUCT: {
                    Message message = (Message)value;
                    Struct struct = new Struct(schema.schema());
                    Descriptors.Descriptor descriptor = message.getDescriptorForType();
                    for (Descriptors.OneofDescriptor oneOfDescriptor : descriptor.getOneofs()) {
                        Descriptors.FieldDescriptor fieldDescriptor;
                        Object obj;
                        if (!message.hasOneof(oneOfDescriptor) || (obj = message.getField(fieldDescriptor = message.getOneofFieldDescriptor(oneOfDescriptor))) == null) continue;
                        this.setUnionField(schema, message, struct, oneOfDescriptor, fieldDescriptor);
                        break;
                    }
                    for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
                        Descriptors.OneofDescriptor oneOfDescriptor = fieldDescriptor.getContainingOneof();
                        if (oneOfDescriptor != null || fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && !fieldDescriptor.isRepeated() && !message.hasField(fieldDescriptor)) continue;
                        this.setStructField(schema, message, struct, fieldDescriptor);
                    }
                    converted = struct;
                    break;
                }
                default: {
                    throw new DataException("Unknown Connect schema type: " + schema.type());
                }
            }
            return converted;
        }
        catch (ClassCastException e) {
            throw new DataException("Invalid type for " + schema.type() + ": " + value.getClass());
        }
    }

    private void setUnionField(Schema schema, Message message, Struct result, Descriptors.OneofDescriptor oneOfDescriptor, Descriptors.FieldDescriptor fieldDescriptor) {
        String unionName = oneOfDescriptor.getName() + "_" + oneOfDescriptor.getIndex();
        Field unionField = schema.field(unionName);
        Schema unionSchema = unionField.schema();
        Struct union = new Struct(unionSchema);
        String fieldName = fieldDescriptor.getName();
        Field field = unionSchema.field(fieldName);
        Object obj = message.getField(fieldDescriptor);
        union.put(fieldName, this.toConnectData(field.schema(), obj));
        result.put(unionField, (Object)union);
    }

    private void setStructField(Schema schema, Message message, Struct result, Descriptors.FieldDescriptor fieldDescriptor) {
        String fieldName = fieldDescriptor.getName();
        Field field = schema.field(fieldName);
        Object obj = message.getField(fieldDescriptor);
        result.put(fieldName, this.toConnectData(field.schema(), obj));
    }

    public Schema toConnectSchema(ProtobufSchema schema) {
        if (schema == null) {
            return null;
        }
        Pair<String, ProtobufSchema> cacheKey = new Pair<String, ProtobufSchema>(schema.name(), schema);
        Schema cachedSchema = (Schema)this.toConnectSchemaCache.get(cacheKey);
        if (cachedSchema != null) {
            return cachedSchema;
        }
        SchemaBuilder builder = SchemaBuilder.struct();
        Descriptors.Descriptor descriptor = schema.toDescriptor();
        ToConnectContext ctx = new ToConnectContext();
        ctx.put(descriptor.getFullName(), builder);
        Schema resultSchema = this.toConnectSchema(ctx, builder, descriptor, schema.version()).build();
        this.toConnectSchemaCache.put(cacheKey, (Object)resultSchema);
        return resultSchema;
    }

    private SchemaBuilder toConnectSchema(ToConnectContext ctx, SchemaBuilder builder, Descriptors.Descriptor descriptor, Integer version) {
        List fieldDescriptors = descriptor.getFields();
        if (ProtobufData.isMapDescriptor(descriptor, fieldDescriptors)) {
            String name = ProtobufSchema.toMapField((String)descriptor.getName());
            return SchemaBuilder.map((Schema)this.toConnectSchema(ctx, (Descriptors.FieldDescriptor)fieldDescriptors.get(0)), (Schema)this.toConnectSchema(ctx, (Descriptors.FieldDescriptor)fieldDescriptors.get(1))).name(name);
        }
        String name = this.enhancedSchemaSupport ? descriptor.getFullName() : descriptor.getName();
        builder.name(name);
        List oneOfDescriptors = descriptor.getOneofs();
        for (Descriptors.OneofDescriptor oneOfDescriptor : oneOfDescriptors) {
            String unionName = oneOfDescriptor.getName() + "_" + oneOfDescriptor.getIndex();
            builder.field(unionName, this.toConnectSchema(ctx, oneOfDescriptor));
        }
        for (Descriptors.FieldDescriptor fieldDescriptor : fieldDescriptors) {
            Descriptors.OneofDescriptor oneOfDescriptor = fieldDescriptor.getContainingOneof();
            if (oneOfDescriptor != null) continue;
            builder.field(fieldDescriptor.getName(), this.toConnectSchema(ctx, fieldDescriptor));
        }
        if (version != null) {
            builder.version(version);
        }
        return builder;
    }

    private Schema toConnectSchema(ToConnectContext ctx, Descriptors.OneofDescriptor descriptor) {
        SchemaBuilder builder = SchemaBuilder.struct();
        builder.name(PROTOBUF_TYPE_UNION_PREFIX + descriptor.getName());
        List fieldDescriptors = descriptor.getFields();
        for (Descriptors.FieldDescriptor fieldDescriptor : fieldDescriptors) {
            builder.field(fieldDescriptor.getName(), this.toConnectSchema(ctx, fieldDescriptor));
        }
        builder.optional();
        return builder.build();
    }

    private Schema toConnectSchema(ToConnectContext ctx, Descriptors.FieldDescriptor descriptor) {
        SchemaBuilder builder;
        switch (descriptor.getType()) {
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                builder = SchemaBuilder.int32();
                break;
            }
            case UINT32: 
            case FIXED32: 
            case INT64: 
            case UINT64: 
            case SINT64: 
            case FIXED64: 
            case SFIXED64: {
                builder = SchemaBuilder.int64();
                break;
            }
            case FLOAT: {
                builder = SchemaBuilder.float32();
                break;
            }
            case DOUBLE: {
                builder = SchemaBuilder.float64();
                break;
            }
            case BOOL: {
                builder = SchemaBuilder.bool();
                break;
            }
            case STRING: {
                builder = SchemaBuilder.string();
                break;
            }
            case BYTES: {
                builder = SchemaBuilder.bytes();
                break;
            }
            case ENUM: {
                builder = SchemaBuilder.string();
                Descriptors.EnumDescriptor enumDescriptor = descriptor.getEnumType();
                builder.name(enumDescriptor.getName());
                builder.parameter(PROTOBUF_TYPE_ENUM, enumDescriptor.getName());
                for (Descriptors.EnumValueDescriptor enumValueDesc : enumDescriptor.getValues()) {
                    String enumSymbol = enumValueDesc.getName();
                    String enumTag = String.valueOf(enumValueDesc.getNumber());
                    builder.parameter(PROTOBUF_TYPE_ENUM_PREFIX + enumSymbol, enumTag);
                }
                break;
            }
            case MESSAGE: {
                if (ProtobufData.isTimestampDescriptor(descriptor)) {
                    builder = org.apache.kafka.connect.data.Timestamp.builder();
                    break;
                }
                String fullName = descriptor.getMessageType().getFullName();
                builder = ctx.get(fullName);
                if (builder != null) {
                    builder = new SchemaWrapper(builder);
                    break;
                }
                builder = SchemaBuilder.struct();
                ctx.put(fullName, builder);
                builder = this.toConnectSchema(ctx, builder, descriptor.getMessageType(), null);
                break;
            }
            default: {
                throw new DataException("Unknown Connect schema type: " + descriptor.getType());
            }
        }
        if (descriptor.isRepeated() && builder.type() != Schema.Type.MAP) {
            Schema schema = builder.optional().build();
            builder = SchemaBuilder.array((Schema)schema);
        }
        builder.optional();
        builder.parameter(PROTOBUF_TYPE_TAG, String.valueOf(descriptor.getNumber()));
        return builder.build();
    }

    private static MessageDefinition timestampDefinition() {
        MessageDefinition.Builder timestampType = MessageDefinition.newBuilder((String)GOOGLE_PROTOBUF_TIMESTAMP_NAME);
        timestampType.addField("optional", "int64", "seconds", 1, null);
        timestampType.addField("optional", "int32", "nanos", 2, null);
        return timestampType.build();
    }

    private static boolean isTimestampDescriptor(Descriptors.FieldDescriptor descriptor) {
        String name = descriptor.getMessageType().getFullName();
        return GOOGLE_PROTOBUF_TIMESTAMP_FULL_NAME.equals(name);
    }

    private static boolean isMapDescriptor(Descriptors.Descriptor descriptor, List<Descriptors.FieldDescriptor> fieldDescriptors) {
        return descriptor.getName().endsWith(MAP_ENTRY_SUFFIX) && fieldDescriptors.size() == 2 && fieldDescriptors.get(0).getName().equals(KEY_FIELD) && fieldDescriptors.get(1).getName().equals(VALUE_FIELD);
    }

    private static String[] splitName(String fullName) {
        String[] result = new String[2];
        int indexLastDot = fullName.lastIndexOf(46);
        if (indexLastDot >= 0) {
            result[0] = fullName.substring(0, indexLastDot);
            result[1] = fullName.substring(indexLastDot + 1);
        } else {
            result[0] = null;
            result[1] = fullName;
        }
        return result;
    }

    private String getUnqualifiedName(String name) {
        String fullName = this.getNameOrDefault(name);
        int indexLastDot = fullName.lastIndexOf(46);
        if (indexLastDot >= 0) {
            return fullName.substring(indexLastDot + 1);
        }
        return fullName;
    }

    private String getNameOrDefault(String name) {
        return name != null && !name.isEmpty() ? name : DEFAULT_SCHEMA_NAME + ++this.defaultSchemaNameIndex;
    }

    private static class FromConnectContext {
        private final Set<String> structNames = new HashSet<String>();

        public boolean contains(String structName) {
            return structName != null ? this.structNames.contains(structName) : false;
        }

        public void add(String structName) {
            if (structName != null) {
                this.structNames.add(structName);
            }
        }
    }

    private static class ToConnectContext {
        private final Map<String, SchemaBuilder> messageToStructMap = new HashMap<String, SchemaBuilder>();

        public SchemaBuilder get(String messageName) {
            return this.messageToStructMap.get(messageName);
        }

        public void put(String messageName, SchemaBuilder builder) {
            this.messageToStructMap.put(messageName, builder);
        }
    }

    static class SchemaWrapper
    extends SchemaBuilder {
        private final SchemaBuilder builder;
        private final Map<String, String> parameters;

        public SchemaWrapper(SchemaBuilder builder) {
            super(Schema.Type.STRUCT);
            this.builder = builder;
            this.parameters = new LinkedHashMap<String, String>();
        }

        public boolean isOptional() {
            return this.builder.isOptional();
        }

        public SchemaBuilder optional() {
            return this.builder.optional();
        }

        public SchemaBuilder required() {
            return this.builder.required();
        }

        public Object defaultValue() {
            return this.builder.defaultValue();
        }

        public SchemaBuilder defaultValue(Object value) {
            return this.builder.defaultValue(value);
        }

        public String name() {
            return this.builder.name();
        }

        public SchemaBuilder name(String name) {
            return this.builder.name(name);
        }

        public Integer version() {
            return this.builder.version();
        }

        public SchemaBuilder version(Integer version) {
            return this.builder.version(version);
        }

        public String doc() {
            return this.builder.doc();
        }

        public SchemaBuilder doc(String doc) {
            return this.builder.doc(doc);
        }

        public Map<String, String> parameters() {
            return this.parameters;
        }

        public SchemaBuilder parameters(Map<String, String> props) {
            this.parameters.putAll(props);
            return this;
        }

        public SchemaBuilder parameter(String propertyName, String propertyValue) {
            this.parameters.put(propertyName, propertyValue);
            return this;
        }

        public Schema.Type type() {
            return this.builder.type();
        }

        public List<Field> fields() {
            return this.builder.fields();
        }

        public Field field(String fieldName) {
            return this.builder.field(fieldName);
        }

        public SchemaBuilder field(String fieldName, Schema fieldSchema) {
            return this.builder.field(fieldName, fieldSchema);
        }

        public Schema keySchema() {
            return this.builder.keySchema();
        }

        public Schema valueSchema() {
            return this.builder.valueSchema();
        }

        public Schema build() {
            return this;
        }

        public Schema schema() {
            return this;
        }
    }

    static class FieldDefinition {
        private final String label;
        private final String type;
        private final String name;
        private final int num;
        private final String defaultVal;

        public FieldDefinition(String label, String type, String name, int num, String defaultVal) {
            this.label = label;
            this.type = type;
            this.name = name;
            this.num = num;
            this.defaultVal = defaultVal;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public int getNum() {
            return this.num;
        }

        public String getDefaultVal() {
            return this.defaultVal;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldDefinition field = (FieldDefinition)o;
            return this.num == field.num && Objects.equals(this.label, field.label) && Objects.equals(this.type, field.type) && Objects.equals(this.name, field.name) && Objects.equals(this.defaultVal, field.defaultVal);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.type, this.name, this.num, this.defaultVal);
        }
    }

    static class Pair<K, V> {
        private K key;
        private V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            return Objects.equals(this.key, pair.key) && Objects.equals(this.value, pair.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return "Pair{key=" + this.key + ", value=" + this.value + '}';
        }
    }
}

