/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.protobuf;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class ProtobufDataConfig
extends AbstractConfig {
    public static final String ENHANCED_PROTOBUF_SCHEMA_SUPPORT_CONFIG = "enhanced.protobuf.schema.support";
    public static final boolean ENHANCED_PROTOBUF_SCHEMA_SUPPORT_DEFAULT = false;
    public static final String ENHANCED_PROTOBUF_SCHEMA_SUPPORT_DOC = "Toggle for enabling/disabling enhanced protobuf schema support: package name preservation";
    public static final String SCHEMAS_CACHE_SIZE_CONFIG = "schemas.cache.config";
    public static final int SCHEMAS_CACHE_SIZE_DEFAULT = 1000;
    public static final String SCHEMAS_CACHE_SIZE_DOC = "Size of the converted schemas cache";

    public static ConfigDef baseConfigDef() {
        return new ConfigDef().define(ENHANCED_PROTOBUF_SCHEMA_SUPPORT_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, ENHANCED_PROTOBUF_SCHEMA_SUPPORT_DOC).define(SCHEMAS_CACHE_SIZE_CONFIG, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, SCHEMAS_CACHE_SIZE_DOC);
    }

    public ProtobufDataConfig(Map<?, ?> props) {
        super(ProtobufDataConfig.baseConfigDef(), props);
    }

    public boolean isEnhancedProtobufSchemaSupport() {
        return this.getBoolean(ENHANCED_PROTOBUF_SCHEMA_SUPPORT_CONFIG);
    }

    public int schemaCacheSize() {
        return this.getInt(SCHEMAS_CACHE_SIZE_CONFIG);
    }

    public static class Builder {
        private final Map<String, Object> props = new HashMap<String, Object>();

        public Builder with(String key, Object value) {
            this.props.put(key, value);
            return this;
        }

        public ProtobufDataConfig build() {
            return new ProtobufDataConfig(this.props);
        }
    }
}

