/*
 * Decompiled with CFR 0.152.
 */
package io.test.trade.v1.common.contingent;

import io.test.trade.v1.Id;
import io.test.trade.v1.common.contingent.LimitValueType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class Limit
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -4083397827631581811L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Limit\",\"namespace\":\"io.test.trade.v1.common.contingent\",\"fields\":[{\"name\":\"value\",\"type\":\"double\",\"doc\":\"Limit value can be expressed either as a Level or Distance. Use this field in conjunction with valueType\"},{\"name\":\"valueType\",\"type\":{\"type\":\"enum\",\"name\":\"LimitValueType\",\"symbols\":[\"DISTANCE\",\"LEVEL\"]},\"doc\":\"Represents the unit in which the limit value is expressed\"},{\"name\":\"orderIds\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"Id\",\"namespace\":\"io.test.trade.v1\",\"doc\":\"Id of an order or position.\",\"fields\":[{\"name\":\"source\",\"type\":{\"type\":\"enum\",\"name\":\"Source\",\"symbols\":[\"ORDER_SERVER\",\"CLIENT\",\"UNIVERSE\",\"L2\",\"L2_CHAIN\",\"EXCHANGE\",\"UNIVERSE_ATTR\",\"UNDEFINED\"]}},{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]}}],\"doc\":\"Ids identifying this limit.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<Limit> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<Limit> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double value;
    private LimitValueType valueType;
    private List<Id> orderIds;
    private static final DatumWriter<Limit> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<Limit> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<Limit> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<Limit> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Limit> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Limit fromByteBuffer(ByteBuffer b) throws IOException {
        return (Limit)((Object)DECODER.decode(b));
    }

    public Limit() {
    }

    public Limit(Double value, LimitValueType valueType, List<Id> orderIds) {
        this.value = value;
        this.valueType = valueType;
        this.orderIds = orderIds;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.value;
            }
            case 1: {
                return this.valueType;
            }
            case 2: {
                return this.orderIds;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.value = (Double)value$;
                break;
            }
            case 1: {
                this.valueType = (LimitValueType)((Object)value$);
                break;
            }
            case 2: {
                this.orderIds = (List)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public LimitValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(LimitValueType value) {
        this.valueType = value;
    }

    public List<Id> getOrderIds() {
        return this.orderIds;
    }

    public void setOrderIds(List<Id> value) {
        this.orderIds = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(Limit other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.value);
        out.writeEnum(this.valueType.ordinal());
        if (this.orderIds == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size0 = this.orderIds.size();
            out.writeArrayStart();
            out.setItemCount(size0);
            long actualSize0 = 0L;
            for (Id e0 : this.orderIds) {
                ++actualSize0;
                out.startItem();
                e0.customEncode(out);
            }
            out.writeArrayEnd();
            if (actualSize0 != size0) {
                throw new ConcurrentModificationException("Array-size written was " + size0 + ", but element count was " + actualSize0 + ".");
            }
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.value = in.readDouble();
            this.valueType = LimitValueType.values()[in.readEnum()];
            if (in.readIndex() != 1) {
                in.readNull();
                this.orderIds = null;
            } else {
                GenericData.Array ga0;
                long size0 = in.readArrayStart();
                GenericData.Array a0 = this.orderIds;
                if (a0 == null) {
                    this.orderIds = a0 = new GenericData.Array((int)size0, (Schema)SCHEMA$.getField("orderIds").schema().getTypes().get(1));
                } else {
                    a0.clear();
                }
                GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                while (0L < size0) {
                    while (size0 != 0L) {
                        Id e0;
                        Id id = e0 = ga0 != null ? (Id)((Object)ga0.peek()) : null;
                        if (e0 == null) {
                            e0 = new Id();
                        }
                        e0.customDecode(in);
                        a0.add(e0);
                        --size0;
                    }
                    size0 = in.arrayNext();
                }
            }
        } else {
            block7: for (int i = 0; i < 3; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.value = in.readDouble();
                        continue block7;
                    }
                    case 1: {
                        this.valueType = LimitValueType.values()[in.readEnum()];
                        continue block7;
                    }
                    case 2: {
                        GenericData.Array ga0;
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.orderIds = null;
                            continue block7;
                        }
                        long size0 = in.readArrayStart();
                        GenericData.Array a0 = this.orderIds;
                        if (a0 == null) {
                            this.orderIds = a0 = new GenericData.Array((int)size0, (Schema)SCHEMA$.getField("orderIds").schema().getTypes().get(1));
                        } else {
                            a0.clear();
                        }
                        GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                        while (0L < size0) {
                            while (size0 != 0L) {
                                Id e0;
                                Id id = e0 = ga0 != null ? (Id)((Object)ga0.peek()) : null;
                                if (e0 == null) {
                                    e0 = new Id();
                                }
                                e0.customDecode(in);
                                a0.add(e0);
                                --size0;
                            }
                            size0 = in.arrayNext();
                        }
                        continue block7;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<Limit>
    implements RecordBuilder<Limit> {
        private double value;
        private LimitValueType valueType;
        private List<Id> orderIds;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.value)) {
                this.value = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.value);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.valueType))) {
                this.valueType = (LimitValueType)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.valueType));
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], other.orderIds)) {
                this.orderIds = (List)this.data().deepCopy(this.fields()[2].schema(), other.orderIds);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
        }

        private Builder(Limit other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.value)) {
                this.value = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.value);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.valueType))) {
                this.valueType = (LimitValueType)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.valueType));
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.orderIds)) {
                this.orderIds = (List)this.data().deepCopy(this.fields()[2].schema(), (Object)other.orderIds);
                this.fieldSetFlags()[2] = true;
            }
        }

        public double getValue() {
            return this.value;
        }

        public Builder setValue(double value) {
            this.validate(this.fields()[0], value);
            this.value = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasValue() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearValue() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public LimitValueType getValueType() {
            return this.valueType;
        }

        public Builder setValueType(LimitValueType value) {
            this.validate(this.fields()[1], (Object)value);
            this.valueType = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasValueType() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearValueType() {
            this.valueType = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public List<Id> getOrderIds() {
            return this.orderIds;
        }

        public Builder setOrderIds(List<Id> value) {
            this.validate(this.fields()[2], value);
            this.orderIds = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasOrderIds() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearOrderIds() {
            this.orderIds = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Limit build() {
            try {
                Limit record = new Limit();
                record.value = this.fieldSetFlags()[0] ? this.value : (Double)this.defaultValue(this.fields()[0]);
                record.valueType = this.fieldSetFlags()[1] ? this.valueType : (LimitValueType)((Object)this.defaultValue(this.fields()[1]));
                record.orderIds = this.fieldSetFlags()[2] ? this.orderIds : (List)this.defaultValue(this.fields()[2]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

