/*
 * Decompiled with CFR 0.152.
 */
package io.test.trade.v1.common;

import io.test.trade.v1.common.BookingCodeType;
import io.test.trade.v1.common.InstrumentType;
import io.test.trade.v1.common.Level;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class Instrument
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -8504953500124139525L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Instrument\",\"namespace\":\"io.test.trade.v1.common\",\"fields\":[{\"name\":\"bookingCodeType\",\"type\":{\"type\":\"enum\",\"name\":\"BookingCodeType\",\"symbols\":[\"EPIC\",\"ISIN_AND_CURRENCY\"]},\"doc\":\"Indicates if the booking was made using an ISIN or EPIC. If EPIC, unique instrument identifier is the EPIC. If ISIN_AND_CURRENCY, the unique identifier is ISIN and CURRENCY. In this last case EPIC is also set for internal usage.\"},{\"name\":\"epic\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"This field is populated for all booking operations and it represents the id of the instrument on which the booking was made. Note: This field will probably be made optional when contract-ids are introduced\"},{\"name\":\"isin\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"ISIN is populated for stock-broking deals\",\"default\":null},{\"name\":\"level\",\"type\":{\"type\":\"record\",\"name\":\"Level\",\"fields\":[{\"name\":\"value\",\"type\":\"double\"}]},\"doc\":\"The level at which the position is booked. This level is used for pnl, margining, auto-hedge, exposure calculation, and other such purposes. This level should always be displayLevel multiplied by scaling factor, however, there are a few UV based flows where that constraint doesn't hold.\"},{\"name\":\"displayLevel\",\"type\":\"Level\",\"doc\":\"The level displayed in the front-end. Note: PnL calculation, auto-hedge and other such operations should multiply by scaling factor.\"},{\"name\":\"scalingFactor\",\"type\":\"double\",\"doc\":\"The scaling factor used for booking this position.\"},{\"name\":\"instrumentType\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"InstrumentType\",\"symbols\":[\"SHARES\",\"CURRENCIES\",\"INDICES\",\"BINARY\",\"FAST_BINARY\",\"COMMODITIES\",\"RATES\",\"OPTIONS_SHARES\",\"OPTIONS_CURRENCIES\",\"OPTIONS_INDICES\",\"OPTIONS_COMMODITIES\",\"OPTIONS_RATES\",\"BUNGEE_SHARES\",\"BUNGEE_CURRENCIES\",\"BUNGEE_INDICES\",\"BUNGEE_COMMODITIES\",\"BUNGEE_RATES\",\"CAPPED_BUNGEE\",\"TEST_MARKETS\",\"SPORTS\",\"SECTORS\"]}],\"doc\":\"Type of the instrument on which the booking is made. This field is made optional to accommodate positions missing instrument type for some reason (very old positions, UV based legacy flows, etc)\",\"default\":null},{\"name\":\"marketName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"scalingFactorOnInstrumentIfDifferent\",\"type\":[\"null\",\"double\"],\"doc\":\"If the scaling factor on the instrument is different from the scaling factor used to book this position then this field carries this new scaling factor. This field is used by a trade anomaly report (maintained by XCON)\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<Instrument> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<Instrument> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public BookingCodeType bookingCodeType;
    @Deprecated
    public String epic;
    @Deprecated
    public String isin;
    @Deprecated
    public Level level;
    @Deprecated
    public Level displayLevel;
    @Deprecated
    public double scalingFactor;
    @Deprecated
    public InstrumentType instrumentType;
    @Deprecated
    public String marketName;
    @Deprecated
    public Double scalingFactorOnInstrumentIfDifferent;
    private static final DatumWriter<Instrument> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<Instrument> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<Instrument> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<Instrument> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Instrument> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Instrument fromByteBuffer(ByteBuffer b) throws IOException {
        return (Instrument)((Object)DECODER.decode(b));
    }

    public Instrument() {
    }

    public Instrument(BookingCodeType bookingCodeType, String epic, String isin, Level level, Level displayLevel, Double scalingFactor, InstrumentType instrumentType, String marketName, Double scalingFactorOnInstrumentIfDifferent) {
        this.bookingCodeType = bookingCodeType;
        this.epic = epic;
        this.isin = isin;
        this.level = level;
        this.displayLevel = displayLevel;
        this.scalingFactor = scalingFactor;
        this.instrumentType = instrumentType;
        this.marketName = marketName;
        this.scalingFactorOnInstrumentIfDifferent = scalingFactorOnInstrumentIfDifferent;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.bookingCodeType;
            }
            case 1: {
                return this.epic;
            }
            case 2: {
                return this.isin;
            }
            case 3: {
                return this.level;
            }
            case 4: {
                return this.displayLevel;
            }
            case 5: {
                return this.scalingFactor;
            }
            case 6: {
                return this.instrumentType;
            }
            case 7: {
                return this.marketName;
            }
            case 8: {
                return this.scalingFactorOnInstrumentIfDifferent;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.bookingCodeType = (BookingCodeType)((Object)value$);
                break;
            }
            case 1: {
                this.epic = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.isin = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.level = (Level)((Object)value$);
                break;
            }
            case 4: {
                this.displayLevel = (Level)((Object)value$);
                break;
            }
            case 5: {
                this.scalingFactor = (Double)value$;
                break;
            }
            case 6: {
                this.instrumentType = (InstrumentType)((Object)value$);
                break;
            }
            case 7: {
                this.marketName = value$ != null ? value$.toString() : null;
                break;
            }
            case 8: {
                this.scalingFactorOnInstrumentIfDifferent = (Double)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public BookingCodeType getBookingCodeType() {
        return this.bookingCodeType;
    }

    public void setBookingCodeType(BookingCodeType value) {
        this.bookingCodeType = value;
    }

    public String getEpic() {
        return this.epic;
    }

    public void setEpic(String value) {
        this.epic = value;
    }

    public String getIsin() {
        return this.isin;
    }

    public void setIsin(String value) {
        this.isin = value;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level value) {
        this.level = value;
    }

    public Level getDisplayLevel() {
        return this.displayLevel;
    }

    public void setDisplayLevel(Level value) {
        this.displayLevel = value;
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public void setScalingFactor(double value) {
        this.scalingFactor = value;
    }

    public InstrumentType getInstrumentType() {
        return this.instrumentType;
    }

    public void setInstrumentType(InstrumentType value) {
        this.instrumentType = value;
    }

    public String getMarketName() {
        return this.marketName;
    }

    public void setMarketName(String value) {
        this.marketName = value;
    }

    public Double getScalingFactorOnInstrumentIfDifferent() {
        return this.scalingFactorOnInstrumentIfDifferent;
    }

    public void setScalingFactorOnInstrumentIfDifferent(Double value) {
        this.scalingFactorOnInstrumentIfDifferent = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(Instrument other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeEnum(this.bookingCodeType.ordinal());
        out.writeString(this.epic);
        if (this.isin == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.isin);
        }
        this.level.customEncode(out);
        this.displayLevel.customEncode(out);
        out.writeDouble(this.scalingFactor);
        if (this.instrumentType == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeEnum(this.instrumentType.ordinal());
        }
        if (this.marketName == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.marketName);
        }
        if (this.scalingFactorOnInstrumentIfDifferent == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeDouble(this.scalingFactorOnInstrumentIfDifferent.doubleValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.bookingCodeType = BookingCodeType.values()[in.readEnum()];
            this.epic = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.isin = null;
            } else {
                this.isin = in.readString();
            }
            if (this.level == null) {
                this.level = new Level();
            }
            this.level.customDecode(in);
            if (this.displayLevel == null) {
                this.displayLevel = new Level();
            }
            this.displayLevel.customDecode(in);
            this.scalingFactor = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.instrumentType = null;
            } else {
                this.instrumentType = InstrumentType.values()[in.readEnum()];
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.marketName = null;
            } else {
                this.marketName = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.scalingFactorOnInstrumentIfDifferent = null;
            } else {
                this.scalingFactorOnInstrumentIfDifferent = in.readDouble();
            }
        } else {
            block11: for (int i = 0; i < 9; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.bookingCodeType = BookingCodeType.values()[in.readEnum()];
                        continue block11;
                    }
                    case 1: {
                        this.epic = in.readString();
                        continue block11;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.isin = null;
                            continue block11;
                        }
                        this.isin = in.readString();
                        continue block11;
                    }
                    case 3: {
                        if (this.level == null) {
                            this.level = new Level();
                        }
                        this.level.customDecode(in);
                        continue block11;
                    }
                    case 4: {
                        if (this.displayLevel == null) {
                            this.displayLevel = new Level();
                        }
                        this.displayLevel.customDecode(in);
                        continue block11;
                    }
                    case 5: {
                        this.scalingFactor = in.readDouble();
                        continue block11;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.instrumentType = null;
                            continue block11;
                        }
                        this.instrumentType = InstrumentType.values()[in.readEnum()];
                        continue block11;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.marketName = null;
                            continue block11;
                        }
                        this.marketName = in.readString();
                        continue block11;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.scalingFactorOnInstrumentIfDifferent = null;
                            continue block11;
                        }
                        this.scalingFactorOnInstrumentIfDifferent = in.readDouble();
                        continue block11;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<Instrument>
    implements RecordBuilder<Instrument> {
        private BookingCodeType bookingCodeType;
        private String epic;
        private String isin;
        private Level level;
        private Level.Builder levelBuilder;
        private Level displayLevel;
        private Level.Builder displayLevelBuilder;
        private double scalingFactor;
        private InstrumentType instrumentType;
        private String marketName;
        private Double scalingFactorOnInstrumentIfDifferent;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.bookingCodeType))) {
                this.bookingCodeType = (BookingCodeType)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.bookingCodeType));
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.epic)) {
                this.epic = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.epic);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.isin)) {
                this.isin = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.isin);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.level))) {
                this.level = (Level)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.level));
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (other.hasLevelBuilder()) {
                this.levelBuilder = Level.newBuilder(other.getLevelBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.displayLevel))) {
                this.displayLevel = (Level)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.displayLevel));
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (other.hasDisplayLevelBuilder()) {
                this.displayLevelBuilder = Level.newBuilder(other.getDisplayLevelBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.scalingFactor)) {
                this.scalingFactor = (Double)this.data().deepCopy(this.fields()[5].schema(), (Object)other.scalingFactor);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.instrumentType))) {
                this.instrumentType = (InstrumentType)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.instrumentType));
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.marketName)) {
                this.marketName = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.marketName);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.scalingFactorOnInstrumentIfDifferent)) {
                this.scalingFactorOnInstrumentIfDifferent = (Double)this.data().deepCopy(this.fields()[8].schema(), (Object)other.scalingFactorOnInstrumentIfDifferent);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
        }

        private Builder(Instrument other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.bookingCodeType))) {
                this.bookingCodeType = (BookingCodeType)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.bookingCodeType));
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.epic)) {
                this.epic = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.epic);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.isin)) {
                this.isin = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.isin);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.level))) {
                this.level = (Level)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.level));
                this.fieldSetFlags()[3] = true;
            }
            this.levelBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.displayLevel))) {
                this.displayLevel = (Level)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.displayLevel));
                this.fieldSetFlags()[4] = true;
            }
            this.displayLevelBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.scalingFactor)) {
                this.scalingFactor = (Double)this.data().deepCopy(this.fields()[5].schema(), (Object)other.scalingFactor);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.instrumentType))) {
                this.instrumentType = (InstrumentType)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.instrumentType));
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.marketName)) {
                this.marketName = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.marketName);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.scalingFactorOnInstrumentIfDifferent)) {
                this.scalingFactorOnInstrumentIfDifferent = (Double)this.data().deepCopy(this.fields()[8].schema(), (Object)other.scalingFactorOnInstrumentIfDifferent);
                this.fieldSetFlags()[8] = true;
            }
        }

        public BookingCodeType getBookingCodeType() {
            return this.bookingCodeType;
        }

        public Builder setBookingCodeType(BookingCodeType value) {
            this.validate(this.fields()[0], (Object)value);
            this.bookingCodeType = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasBookingCodeType() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearBookingCodeType() {
            this.bookingCodeType = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getEpic() {
            return this.epic;
        }

        public Builder setEpic(String value) {
            this.validate(this.fields()[1], value);
            this.epic = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasEpic() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearEpic() {
            this.epic = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getIsin() {
            return this.isin;
        }

        public Builder setIsin(String value) {
            this.validate(this.fields()[2], value);
            this.isin = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasIsin() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearIsin() {
            this.isin = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Level getLevel() {
            return this.level;
        }

        public Builder setLevel(Level value) {
            this.validate(this.fields()[3], (Object)value);
            this.levelBuilder = null;
            this.level = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasLevel() {
            return this.fieldSetFlags()[3];
        }

        public Level.Builder getLevelBuilder() {
            if (this.levelBuilder == null) {
                if (this.hasLevel()) {
                    this.setLevelBuilder(Level.newBuilder(this.level));
                } else {
                    this.setLevelBuilder(Level.newBuilder());
                }
            }
            return this.levelBuilder;
        }

        public Builder setLevelBuilder(Level.Builder value) {
            this.clearLevel();
            this.levelBuilder = value;
            return this;
        }

        public boolean hasLevelBuilder() {
            return this.levelBuilder != null;
        }

        public Builder clearLevel() {
            this.level = null;
            this.levelBuilder = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Level getDisplayLevel() {
            return this.displayLevel;
        }

        public Builder setDisplayLevel(Level value) {
            this.validate(this.fields()[4], (Object)value);
            this.displayLevelBuilder = null;
            this.displayLevel = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasDisplayLevel() {
            return this.fieldSetFlags()[4];
        }

        public Level.Builder getDisplayLevelBuilder() {
            if (this.displayLevelBuilder == null) {
                if (this.hasDisplayLevel()) {
                    this.setDisplayLevelBuilder(Level.newBuilder(this.displayLevel));
                } else {
                    this.setDisplayLevelBuilder(Level.newBuilder());
                }
            }
            return this.displayLevelBuilder;
        }

        public Builder setDisplayLevelBuilder(Level.Builder value) {
            this.clearDisplayLevel();
            this.displayLevelBuilder = value;
            return this;
        }

        public boolean hasDisplayLevelBuilder() {
            return this.displayLevelBuilder != null;
        }

        public Builder clearDisplayLevel() {
            this.displayLevel = null;
            this.displayLevelBuilder = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public double getScalingFactor() {
            return this.scalingFactor;
        }

        public Builder setScalingFactor(double value) {
            this.validate(this.fields()[5], value);
            this.scalingFactor = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasScalingFactor() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearScalingFactor() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public InstrumentType getInstrumentType() {
            return this.instrumentType;
        }

        public Builder setInstrumentType(InstrumentType value) {
            this.validate(this.fields()[6], (Object)value);
            this.instrumentType = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasInstrumentType() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearInstrumentType() {
            this.instrumentType = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getMarketName() {
            return this.marketName;
        }

        public Builder setMarketName(String value) {
            this.validate(this.fields()[7], value);
            this.marketName = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasMarketName() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearMarketName() {
            this.marketName = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Double getScalingFactorOnInstrumentIfDifferent() {
            return this.scalingFactorOnInstrumentIfDifferent;
        }

        public Builder setScalingFactorOnInstrumentIfDifferent(Double value) {
            this.validate(this.fields()[8], value);
            this.scalingFactorOnInstrumentIfDifferent = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasScalingFactorOnInstrumentIfDifferent() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearScalingFactorOnInstrumentIfDifferent() {
            this.scalingFactorOnInstrumentIfDifferent = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Instrument build() {
            try {
                Instrument record = new Instrument();
                record.bookingCodeType = this.fieldSetFlags()[0] ? this.bookingCodeType : (BookingCodeType)((Object)this.defaultValue(this.fields()[0]));
                record.epic = this.fieldSetFlags()[1] ? this.epic : (String)this.defaultValue(this.fields()[1]);
                String string = record.isin = this.fieldSetFlags()[2] ? this.isin : (String)this.defaultValue(this.fields()[2]);
                if (this.levelBuilder != null) {
                    try {
                        record.level = this.levelBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("level"));
                        throw e;
                    }
                } else {
                    Level level = record.level = this.fieldSetFlags()[3] ? this.level : (Level)((Object)this.defaultValue(this.fields()[3]));
                }
                if (this.displayLevelBuilder != null) {
                    try {
                        record.displayLevel = this.displayLevelBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("displayLevel"));
                        throw e;
                    }
                } else {
                    record.displayLevel = this.fieldSetFlags()[4] ? this.displayLevel : (Level)((Object)this.defaultValue(this.fields()[4]));
                }
                record.scalingFactor = this.fieldSetFlags()[5] ? this.scalingFactor : (Double)this.defaultValue(this.fields()[5]);
                record.instrumentType = this.fieldSetFlags()[6] ? this.instrumentType : (InstrumentType)((Object)this.defaultValue(this.fields()[6]));
                record.marketName = this.fieldSetFlags()[7] ? this.marketName : (String)this.defaultValue(this.fields()[7]);
                record.scalingFactorOnInstrumentIfDifferent = this.fieldSetFlags()[8] ? this.scalingFactorOnInstrumentIfDifferent : (Double)this.defaultValue(this.fields()[8]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

