/*
 * Decompiled with CFR 0.152.
 */
package io.test.trade.v1.order.common;

import io.test.trade.v1.common.Direction;
import io.test.trade.v1.common.Instrument;
import io.test.trade.v1.common.Level;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class AdditionalLeg
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -9031436364402886742L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"AdditionalLeg\",\"namespace\":\"io.test.trade.v1.order.common\",\"fields\":[{\"name\":\"instrument\",\"type\":{\"type\":\"record\",\"name\":\"Instrument\",\"namespace\":\"io.test.trade.v1.common\",\"fields\":[{\"name\":\"bookingCodeType\",\"type\":{\"type\":\"enum\",\"name\":\"BookingCodeType\",\"symbols\":[\"EPIC\",\"ISIN_AND_CURRENCY\"]},\"doc\":\"Indicates if the booking was made using an ISIN or EPIC. If EPIC, unique instrument identifier is the EPIC. If ISIN_AND_CURRENCY, the unique identifier is ISIN and CURRENCY. In this last case EPIC is also set for internal usage.\"},{\"name\":\"epic\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"This field is populated for all booking operations and it represents the id of the instrument on which the booking was made. Note: This field will probably be made optional when contract-ids are introduced\"},{\"name\":\"isin\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"ISIN is populated for stock-broking deals\",\"default\":null},{\"name\":\"level\",\"type\":{\"type\":\"record\",\"name\":\"Level\",\"fields\":[{\"name\":\"value\",\"type\":\"double\"}]},\"doc\":\"The level at which the position is booked. This level is used for pnl, margining, auto-hedge, exposure calculation, and other such purposes. This level should always be displayLevel multiplied by scaling factor, however, there are a few UV based flows where that constraint doesn't hold.\"},{\"name\":\"displayLevel\",\"type\":\"Level\",\"doc\":\"The level displayed in the front-end. Note: PnL calculation, auto-hedge and other such operations should multiply by scaling factor.\"},{\"name\":\"scalingFactor\",\"type\":\"double\",\"doc\":\"The scaling factor used for booking this position.\"},{\"name\":\"instrumentType\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"InstrumentType\",\"symbols\":[\"SHARES\",\"CURRENCIES\",\"INDICES\",\"BINARY\",\"FAST_BINARY\",\"COMMODITIES\",\"RATES\",\"OPTIONS_SHARES\",\"OPTIONS_CURRENCIES\",\"OPTIONS_INDICES\",\"OPTIONS_COMMODITIES\",\"OPTIONS_RATES\",\"BUNGEE_SHARES\",\"BUNGEE_CURRENCIES\",\"BUNGEE_INDICES\",\"BUNGEE_COMMODITIES\",\"BUNGEE_RATES\",\"CAPPED_BUNGEE\",\"TEST_MARKETS\",\"SPORTS\",\"SECTORS\"]}],\"doc\":\"Type of the instrument on which the booking is made. This field is made optional to accommodate positions missing instrument type for some reason (very old positions, UV based legacy flows, etc)\",\"default\":null},{\"name\":\"marketName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"scalingFactorOnInstrumentIfDifferent\",\"type\":[\"null\",\"double\"],\"doc\":\"If the scaling factor on the instrument is different from the scaling factor used to book this position then this field carries this new scaling factor. This field is used by a trade anomaly report (maintained by XCON)\",\"default\":null}]}},{\"name\":\"marketCommodity\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"direction\",\"type\":{\"type\":\"enum\",\"name\":\"Direction\",\"namespace\":\"io.test.trade.v1.common\",\"symbols\":[\"BUY\",\"SELL\"]}},{\"name\":\"averagePrice\",\"type\":[\"null\",\"io.test.trade.v1.common.Level\"],\"default\":null}]}");
    @Deprecated
    public Instrument instrument;
    @Deprecated
    public String marketCommodity;
    @Deprecated
    public Direction direction;
    @Deprecated
    public Level averagePrice;
    private static final DatumWriter WRITER$ = new SpecificDatumWriter(SCHEMA$);
    private static final DatumReader READER$ = new SpecificDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public AdditionalLeg() {
    }

    public AdditionalLeg(Instrument instrument, String marketCommodity, Direction direction, Level averagePrice) {
        this.instrument = instrument;
        this.marketCommodity = marketCommodity;
        this.direction = direction;
        this.averagePrice = averagePrice;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.instrument;
            }
            case 1: {
                return this.marketCommodity;
            }
            case 2: {
                return this.direction;
            }
            case 3: {
                return this.averagePrice;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.instrument = (Instrument)((Object)value$);
                break;
            }
            case 1: {
                this.marketCommodity = (String)value$;
                break;
            }
            case 2: {
                this.direction = (Direction)((Object)value$);
                break;
            }
            case 3: {
                this.averagePrice = (Level)((Object)value$);
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument value) {
        this.instrument = value;
    }

    public String getMarketCommodity() {
        return this.marketCommodity;
    }

    public void setMarketCommodity(String value) {
        this.marketCommodity = value;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction value) {
        this.direction = value;
    }

    public Level getAveragePrice() {
        return this.averagePrice;
    }

    public void setAveragePrice(Level value) {
        this.averagePrice = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(AdditionalLeg other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<AdditionalLeg>
    implements RecordBuilder<AdditionalLeg> {
        private Instrument instrument;
        private Instrument.Builder instrumentBuilder;
        private String marketCommodity;
        private Direction direction;
        private Level averagePrice;
        private Level.Builder averagePriceBuilder;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.instrument))) {
                this.instrument = (Instrument)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.instrument));
                this.fieldSetFlags()[0] = true;
            }
            if (other.hasInstrumentBuilder()) {
                this.instrumentBuilder = Instrument.newBuilder(other.getInstrumentBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.marketCommodity)) {
                this.marketCommodity = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.marketCommodity);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.direction))) {
                this.direction = (Direction)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.direction));
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.averagePrice))) {
                this.averagePrice = (Level)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.averagePrice));
                this.fieldSetFlags()[3] = true;
            }
            if (other.hasAveragePriceBuilder()) {
                this.averagePriceBuilder = Level.newBuilder(other.getAveragePriceBuilder());
            }
        }

        private Builder(AdditionalLeg other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.instrument))) {
                this.instrument = (Instrument)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.instrument));
                this.fieldSetFlags()[0] = true;
            }
            this.instrumentBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.marketCommodity)) {
                this.marketCommodity = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.marketCommodity);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.direction))) {
                this.direction = (Direction)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.direction));
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.averagePrice))) {
                this.averagePrice = (Level)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.averagePrice));
                this.fieldSetFlags()[3] = true;
            }
            this.averagePriceBuilder = null;
        }

        public Instrument getInstrument() {
            return this.instrument;
        }

        public Builder setInstrument(Instrument value) {
            this.validate(this.fields()[0], (Object)value);
            this.instrumentBuilder = null;
            this.instrument = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasInstrument() {
            return this.fieldSetFlags()[0];
        }

        public Instrument.Builder getInstrumentBuilder() {
            if (this.instrumentBuilder == null) {
                if (this.hasInstrument()) {
                    this.setInstrumentBuilder(Instrument.newBuilder(this.instrument));
                } else {
                    this.setInstrumentBuilder(Instrument.newBuilder());
                }
            }
            return this.instrumentBuilder;
        }

        public Builder setInstrumentBuilder(Instrument.Builder value) {
            this.clearInstrument();
            this.instrumentBuilder = value;
            return this;
        }

        public boolean hasInstrumentBuilder() {
            return this.instrumentBuilder != null;
        }

        public Builder clearInstrument() {
            this.instrument = null;
            this.instrumentBuilder = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getMarketCommodity() {
            return this.marketCommodity;
        }

        public Builder setMarketCommodity(String value) {
            this.validate(this.fields()[1], value);
            this.marketCommodity = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasMarketCommodity() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearMarketCommodity() {
            this.marketCommodity = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public Builder setDirection(Direction value) {
            this.validate(this.fields()[2], (Object)value);
            this.direction = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasDirection() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearDirection() {
            this.direction = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Level getAveragePrice() {
            return this.averagePrice;
        }

        public Builder setAveragePrice(Level value) {
            this.validate(this.fields()[3], (Object)value);
            this.averagePriceBuilder = null;
            this.averagePrice = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasAveragePrice() {
            return this.fieldSetFlags()[3];
        }

        public Level.Builder getAveragePriceBuilder() {
            if (this.averagePriceBuilder == null) {
                if (this.hasAveragePrice()) {
                    this.setAveragePriceBuilder(Level.newBuilder(this.averagePrice));
                } else {
                    this.setAveragePriceBuilder(Level.newBuilder());
                }
            }
            return this.averagePriceBuilder;
        }

        public Builder setAveragePriceBuilder(Level.Builder value) {
            this.clearAveragePrice();
            this.averagePriceBuilder = value;
            return this;
        }

        public boolean hasAveragePriceBuilder() {
            return this.averagePriceBuilder != null;
        }

        public Builder clearAveragePrice() {
            this.averagePrice = null;
            this.averagePriceBuilder = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public AdditionalLeg build() {
            try {
                AdditionalLeg record = new AdditionalLeg();
                record.instrument = this.instrumentBuilder != null ? this.instrumentBuilder.build() : (this.fieldSetFlags()[0] ? this.instrument : (Instrument)((Object)this.defaultValue(this.fields()[0])));
                record.marketCommodity = this.fieldSetFlags()[1] ? this.marketCommodity : (String)this.defaultValue(this.fields()[1]);
                Direction direction = record.direction = this.fieldSetFlags()[2] ? this.direction : (Direction)((Object)this.defaultValue(this.fields()[2]));
                record.averagePrice = this.averagePriceBuilder != null ? this.averagePriceBuilder.build() : (this.fieldSetFlags()[3] ? this.averagePrice : (Level)((Object)this.defaultValue(this.fields()[3])));
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

