/*
 * Decompiled with CFR 0.152.
 */
package io.test.trade.v1.order;

import io.test.trade.v1.Id;
import io.test.trade.v1.common.Allocation;
import io.test.trade.v1.common.Channel;
import io.test.trade.v1.common.Instrument;
import io.test.trade.v1.common.LegacyInfo;
import io.test.trade.v1.common.Timestamps;
import io.test.trade.v1.common.account.Attributes;
import io.test.trade.v1.common.account.Id;
import io.test.trade.v1.common.commission.Instructions;
import io.test.trade.v1.common.contingent.Limit;
import io.test.trade.v1.common.contingent.Stop;
import io.test.trade.v1.common.dma.Order;
import io.test.trade.v1.common.lock.State;
import io.test.trade.v1.order.ProfileData;
import io.test.trade.v1.order.common.AdditionalLeg;
import io.test.trade.v1.order.common.Expiry;
import io.test.trade.v1.order.stockbroking.Attributes;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class State
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -3676142451791948527L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"State\",\"namespace\":\"io.test.trade.v1.order\",\"fields\":[{\"name\":\"orderId\",\"type\":{\"type\":\"record\",\"name\":\"Id\",\"namespace\":\"io.test.trade.v1\",\"doc\":\"Id of an order or position.\",\"fields\":[{\"name\":\"source\",\"type\":{\"type\":\"enum\",\"name\":\"Source\",\"symbols\":[\"ORDER_SERVER\",\"CLIENT\",\"UNIVERSE\",\"L2\",\"L2_CHAIN\",\"EXCHANGE\",\"UNIVERSE_ATTR\",\"UNDEFINED\"]}},{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]},\"doc\":\"The ID to reference this order.\"},{\"name\":\"accountId\",\"type\":{\"type\":\"record\",\"name\":\"Id\",\"namespace\":\"io.test.trade.v1.common.account\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]},\"doc\":\"The account that the order is associated to.\"},{\"name\":\"allocation\",\"type\":{\"type\":\"record\",\"name\":\"Allocation\",\"namespace\":\"io.test.trade.v1.common\",\"fields\":[{\"name\":\"direction\",\"type\":{\"type\":\"enum\",\"name\":\"Direction\",\"symbols\":[\"BUY\",\"SELL\"]}},{\"name\":\"size\",\"type\":{\"type\":\"record\",\"name\":\"Size\",\"fields\":[{\"name\":\"value\",\"type\":\"double\"}]}},{\"name\":\"displaySize\",\"type\":\"Size\",\"doc\":\"Size used for presentation and external reporting purposes. Note: Margining, Profit/Loss calculation, exposure, etc., should multiply this size with lotSize for calculations.\"},{\"name\":\"displaySizeUnit\",\"type\":{\"type\":\"enum\",\"name\":\"DisplaySizeUnit\",\"symbols\":[\"SHARES\",\"CONTRACTS\",\"AMOUNT_PER_POINTS\"]},\"doc\":\"Define how the displaySize is expressed.\"},{\"name\":\"lotSize\",\"type\":\"double\",\"doc\":\"Defined on the instrument. Clients on spread-bet accounts use lot size of 1, while CFD and StockBroking clients use lot size configured on the instrument. Dealers can book orders on any client account with a lot size of 1. Hedge accounts have different rules - they are generally booked in lots with lotSize 1, except equities (and equity options)\"},{\"name\":\"currency\",\"type\":{\"type\":\"record\",\"name\":\"ISOCurrency\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]},\"doc\":\"Currency of the order/position\"}]},\"doc\":\"Details of the allocation of this order, size/amount, currency and direction.\"},{\"name\":\"instrument\",\"type\":{\"type\":\"record\",\"name\":\"Instrument\",\"namespace\":\"io.test.trade.v1.common\",\"fields\":[{\"name\":\"bookingCodeType\",\"type\":{\"type\":\"enum\",\"name\":\"BookingCodeType\",\"symbols\":[\"EPIC\",\"ISIN_AND_CURRENCY\"]},\"doc\":\"Indicates if the booking was made using an ISIN or EPIC. If EPIC, unique instrument identifier is the EPIC. If ISIN_AND_CURRENCY, the unique identifier is ISIN and CURRENCY. In this last case EPIC is also set for internal usage.\"},{\"name\":\"epic\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"This field is populated for all booking operations and it represents the id of the instrument on which the booking was made. Note: This field will probably be made optional when contract-ids are introduced\"},{\"name\":\"isin\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"ISIN is populated for stock-broking deals\",\"default\":null},{\"name\":\"level\",\"type\":{\"type\":\"record\",\"name\":\"Level\",\"fields\":[{\"name\":\"value\",\"type\":\"double\"}]},\"doc\":\"The level at which the position is booked. This level is used for pnl, margining, auto-hedge, exposure calculation, and other such purposes. This level should always be displayLevel multiplied by scaling factor, however, there are a few UV based flows where that constraint doesn't hold.\"},{\"name\":\"displayLevel\",\"type\":\"Level\",\"doc\":\"The level displayed in the front-end. Note: PnL calculation, auto-hedge and other such operations should multiply by scaling factor.\"},{\"name\":\"scalingFactor\",\"type\":\"double\",\"doc\":\"The scaling factor used for booking this position.\"},{\"name\":\"instrumentType\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"InstrumentType\",\"symbols\":[\"SHARES\",\"CURRENCIES\",\"INDICES\",\"BINARY\",\"FAST_BINARY\",\"COMMODITIES\",\"RATES\",\"OPTIONS_SHARES\",\"OPTIONS_CURRENCIES\",\"OPTIONS_INDICES\",\"OPTIONS_COMMODITIES\",\"OPTIONS_RATES\",\"BUNGEE_SHARES\",\"BUNGEE_CURRENCIES\",\"BUNGEE_INDICES\",\"BUNGEE_COMMODITIES\",\"BUNGEE_RATES\",\"CAPPED_BUNGEE\",\"TEST_MARKETS\",\"SPORTS\",\"SECTORS\"]}],\"doc\":\"Type of the instrument on which the booking is made. This field is made optional to accommodate positions missing instrument type for some reason (very old positions, UV based legacy flows, etc)\",\"default\":null},{\"name\":\"marketName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"scalingFactorOnInstrumentIfDifferent\",\"type\":[\"null\",\"double\"],\"doc\":\"If the scaling factor on the instrument is different from the scaling factor used to book this position then this field carries this new scaling factor. This field is used by a trade anomaly report (maintained by XCON)\",\"default\":null}]},\"doc\":\"Details on booked level and instrument information\"},{\"name\":\"timestamps\",\"type\":{\"type\":\"record\",\"name\":\"Timestamps\",\"namespace\":\"io.test.trade.v1.common\",\"doc\":\"See http://test.io/wiki/Position+History+Tactical+Fixes\",\"fields\":[{\"name\":\"created\",\"type\":{\"type\":\"record\",\"name\":\"UTCTimestamp\",\"fields\":[{\"name\":\"value\",\"type\":\"long\"}]},\"doc\":\"Timestamp of the trade's creation time\"},{\"name\":\"lastModified\",\"type\":[\"null\",\"UTCTimestamp\"],\"doc\":\"Timestamp of the trade's modification time. For RESTATE, this field indicates the timestamp of the restate\",\"default\":null},{\"name\":\"lastEdited\",\"type\":[\"null\",\"UTCTimestamp\"],\"doc\":\"Applicable only for RESTATES and specifies the timestamp at which this trade was last edited\",\"default\":null},{\"name\":\"margin\",\"type\":[\"null\",\"UTCTimestamp\"],\"doc\":\"Timestamp of the trade's margin time.\",\"default\":null}]},\"doc\":\"Timestamps of when the order was created, modified or last edited.\"},{\"name\":\"isForceOpen\",\"type\":\"boolean\",\"doc\":\"Upon full fill, should this order close positions existing in opposite direction?\",\"default\":false},{\"name\":\"attachedStop\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Stop\",\"namespace\":\"io.test.trade.v1.common.contingent\",\"fields\":[{\"name\":\"value\",\"type\":\"double\",\"doc\":\"Stop value can be expressed either as a Level or Distance. Use this field in conjunction with valueType\"},{\"name\":\"valueType\",\"type\":{\"type\":\"enum\",\"name\":\"StopValueType\",\"symbols\":[\"DISTANCE\",\"LEVEL\"]},\"doc\":\"Represents the unit in which the stop value is expressed\"},{\"name\":\"isGuaranteed\",\"type\":\"boolean\",\"default\":false},{\"name\":\"lrPremium\",\"type\":[\"null\",\"double\"],\"doc\":\"This field represents a multiplier to be applied to the trade's size to derive a limited risk fee (LR Fee). The LR fee is a monetary amount and is expressed in the currency of the order.\",\"default\":null},{\"name\":\"trailingStop\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"TrailingStop\",\"fields\":[{\"name\":\"distance\",\"type\":\"double\",\"default\":0.0},{\"name\":\"increment\",\"type\":\"double\",\"default\":0.0}]}],\"default\":null},{\"name\":\"orderIds\",\"type\":[\"null\",{\"type\":\"array\",\"items\":\"io.test.trade.v1.Id\"}],\"doc\":\"Ids identifying this stop.\",\"default\":null}]}],\"doc\":\"An attached Stop is a 'stop-loss' order; an instruction to close a position when a certain level is breached, to minimize loss.\",\"default\":null},{\"name\":\"attachedLimit\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Limit\",\"namespace\":\"io.test.trade.v1.common.contingent\",\"fields\":[{\"name\":\"value\",\"type\":\"double\",\"doc\":\"Limit value can be expressed either as a Level or Distance. Use this field in conjunction with valueType\"},{\"name\":\"valueType\",\"type\":{\"type\":\"enum\",\"name\":\"LimitValueType\",\"symbols\":[\"DISTANCE\",\"LEVEL\"]},\"doc\":\"Represents the unit in which the limit value is expressed\"},{\"name\":\"orderIds\",\"type\":[\"null\",{\"type\":\"array\",\"items\":\"io.test.trade.v1.Id\"}],\"doc\":\"Ids identifying this limit.\",\"default\":null}]}],\"doc\":\"An attached limit is a 'profit-limit' order; an instruction to close a position when a certain level is breached, to guarantee profit.\",\"default\":null},{\"name\":\"legacyInfo\",\"type\":{\"type\":\"record\",\"name\":\"LegacyInfo\",\"namespace\":\"io.test.trade.v1.common\",\"doc\":\"Legacy information for retro compatibility purpose. Should not be used in any new service.\",\"fields\":[{\"name\":\"uvCurrency\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"deprecated field\",\"default\":\"\"},{\"name\":\"marketCommodity\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"deprecated field\",\"default\":\"\"},", new String[]{"{\"name\":\"prompt\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Deprecated field. Represents the period at which the instrument expires. This field is also referred to as 'period' in some legacy messages\",\"default\":null},{\"name\":\"submitOrderType\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"SubmitOrderType\",\"symbols\":[\"UNCONTROLLED_OPEN\",\"UNCONTROLLED_CLOSE\",\"CONTROLLED_OPEN\",\"CONTROLLED_CLOSE\",\"UNCONTROLLED_OPEN_WITH_STOP\",\"UNCONTROLLED_CLOSE_WITH_STOP\",\"MANUAL_POSITION_DELETE\",\"OPEN_WITH_EXPIRY_STOP\"]}],\"doc\":\"deprecated field\",\"default\":null},{\"name\":\"requestType\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"RequestType\",\"symbols\":[\"AMEND_ORDER\",\"FINANCE_ORDER\",\"CFD_ORDER\",\"PHYSICAL\",\"UNATTACHED_LIMIT_ORDER\",\"UNATTACHED_STOP_ORDER\",\"UNATTACHED_ORDER_DELETE\",\"UNATTACHED_ORDER_FILL\",\"UNATTACHED_BUFFER_LIMITS\",\"UNATTACHED_BUFFER_LIMITS_DELETE\",\"MARKET_ORDER\"]}],\"doc\":\"deprecated field\",\"default\":null},{\"name\":\"exchangeRateEpic\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Deprecated field. This field represents the fx rate epic mapped to the trade's currency.\",\"default\":null}]},\"doc\":\"Legacy attributes, a hang over from UV, eg market commod.\"},{\"name\":\"channel\",\"type\":{\"type\":\"record\",\"name\":\"Channel\",\"namespace\":\"io.test.trade.v1.common\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]},\"doc\":\"The channel though which the order was placed , eg. WEB, L2. This will not change if the order is amended. For this, see channel in change info.\"},{\"name\":\"expiry\",\"type\":{\"type\":\"record\",\"name\":\"Expiry\",\"namespace\":\"io.test.trade.v1.order.common\",\"fields\":[{\"name\":\"timeInForce\",\"type\":{\"type\":\"enum\",\"name\":\"TimeInForce\",\"namespace\":\"io.test.trade.v1.common\",\"symbols\":[\"DAY\",\"GOOD_TILL_CANCEL\",\"AT_THE_OPENING\",\"IMMEDIATE_OR_CANCEL\",\"FILL_OR_KILL\",\"GOOD_TILL_CROSSING\",\"GOOD_TILL_DATE\",\"AT_THE_CLOSE\",\"DAY_ALL_SESSIONS\"]}},{\"name\":\"goodTillDateTimestamp\",\"type\":[\"null\",\"io.test.trade.v1.common.UTCTimestamp\"],\"default\":null}]},\"doc\":\"The date/time of when this order expires.\"},{\"name\":\"accountAttributes\",\"type\":{\"type\":\"record\",\"name\":\"Attributes\",\"namespace\":\"io.test.trade.v1.common.account\",\"fields\":[{\"name\":\"accountProduct\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"Product\",\"symbols\":[\"SPREAD_BET\",\"CFD\",\"PHYSICAL\"]}],\"default\":null},{\"name\":\"locale\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Represents the locale of the account, such as en_gb. It is highly likely that this field will be removed in the future.\"},{\"name\":\"powerOfAttorneyName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The POA name specified on the order that booked this position.\",\"default\":null},{\"name\":\"convertOnCloseCurrency\",\"type\":[\"null\",\"io.test.trade.v1.common.ISOCurrency\"],\"doc\":\"Retrieved from the convert on close information stored on this position. Note: Only populated if convert-on-close is applicable for this position.\",\"default\":null},{\"name\":\"currency\",\"type\":[\"null\",\"io.test.trade.v1.common.ISOCurrency\"],\"doc\":\"Account's currency in ISO format\",\"default\":null}]},\"doc\":\"Account attributes such as convert on close details and Power Of Attorney name.\"},{\"name\":\"dmaOrder\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Order\",\"namespace\":\"io.test.trade.v1.common.dma\",\"fields\":[{\"name\":\"pseudoPositionId\",\"type\":[\"null\",\"io.test.trade.v1.Id\"],\"doc\":\"Represents ID of position created by a partially filled DMA order.\",\"default\":null},{\"name\":\"orderType\",\"type\":{\"type\":\"enum\",\"name\":\"OrderType\",\"symbols\":[\"MARKET\",\"LIMIT\",\"STOP\",\"STOP_LIMIT\",\"MARKET_ON_CLOSE\",\"WITH_OR_WITHOUT\",\"LIMIT_OR_BETTER\",\"LIMIT_WITH_OR_WITHOUT\",\"ON_BASIS\",\"ON_CLOSE\",\"LIMIT_ON_CLOSE\",\"FOREX_MARKET\",\"PREVIOUSLY_QUOTED\",\"PREVIOUSLY_INDICATED\",\"FOREX_LIMIT\",\"PEGGED\",\"TRADE_REPORT\",\"FAST_BINARY\",\"UNKNOWN\"]}},{\"name\":\"timeInForce\",\"type\":\"io.test.trade.v1.common.TimeInForce\"},{\"name\":\"originalSize\",\"type\":\"io.test.trade.v1.common.Size\",\"doc\":\"The original size on a DMA working order. This is in display terms and does not include lotSize\"},{\"name\":\"fills\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Fills\",\"fields\":[{\"name\":\"aggregatedFill\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"AggregatedFill\",\"doc\":\"Aggregated information of fills received per hedge account\",\"fields\":[{\"name\":\"hedgeAccountId\",\"type\":\"io.test.trade.v1.common.account.Id\"},{\"name\":\"averageLevel\",\"type\":\"io.test.trade.v1.common.Level\",\"doc\":\"A volume-weighted-average level of all fills originating from this hedge account\"},{\"name\":\"totalSize\",\"type\":\"io.test.trade.v1.common.Size\",\"doc\":\"Total size of all fills received from this hedge account\"},{\"name\":\"averageExchangeFee\",\"type\":\"double\",\"doc\":\"The fee is expressed in account's currency.\"}]}}],\"doc\":\"A collection of DMA fills aggregated per hedge account\",\"default\":null},{\"name\":\"updateType\",\"type\":{\"type\":\"enum\",\"name\":\"FillsUpdateType\",\"symbols\":[\"ADD\",\"COPY\",\"DELETE_ALL\"]},\"default\":\"COPY\"},{\"name\":\"nextWorkingOrderId\",\"type\":[\"null\",\"io.test.trade.v1.Id\"],\"default\":null}]}],\"default\":null},{\"name\":\"isDMAInteractable\",\"type\":\"boolean\",\"default\":true},{\"name\":\"executionPricePreference\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"ExecType\",\"symbols\":[\"ASK\",\"BID\"]}],\"doc\":\"Called executionInstruction in current schema. This field represents DMA FX Stop Order execution price preference, could be either empty, ASK(0) or BID(9) and indicates whether one's order gets executed closer to the Bid or Ask side compared to the specified order direction.\",\"default\":null},{\"name\":\"uvOrderId\",\"type\":[\"null\",\"io.test.trade.v1.Id\"],\"default\":null},{\"name\":\"isPseudoPosition\",\"type\":\"boolean\",\"doc\":\"Is this position a partial fill for a DMA order?\",\"default\":false},{\"name\":\"nextPseudoPositionId\",\"type\":[\"null\",\"io.test.trade.v1.Id\"],\"doc\":\"In a DMA amend scenario, the id of a pseudo-position changes and this field indicates the new pseudo position id.\",\"default\":null}]}],\"doc\":\"DMA order attributes such as order type\",\"default\":null},{\"name\":\"additionalIds\",\"type\":[\"null\",{\"type\":\"array\",\"items\":\"io.test.trade.v1.Id\"}],\"doc\":\"Additional ids used to reference this order.\",\"default\":null},{\"name\":\"stockBrokingAttributes\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Attributes\",\"namespace\":\"io.test.trade.v1.order.stockbroking\",\"fields\":[{\"name\":\"settlementDate\",\"type\":[\"null\",\"io.test.trade.v1.common.UTCTimestamp\"],\"default\":null},{\"name\":\"tradeDate\",\"type\":[\"null\",\"io.test.trade.v1.common.UTCTimestamp\"],\"default\":null},{\"name\":\"charges\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Charges\",\"fields\":[{\"name\":\"commission\",\"type\":{\"type\":\"record\",\"name\":\"Money\",\"namespace\":\"io.test.trade.v1.common\",\"fields\":[{\"name\":\"currency\",\"type\":\"ISOCurrency\"},{\"name\":\"amount\",\"type\":\"double\"}]}},{\"name\":\"physicalCharges\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"Charge\",\"fields\":[{\"name\":\"code\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"default\":\"\"},{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"default\":\"\"},{\"name\":\"amount\",\"type\":\"io.test.trade.v1.common.Money\"},{\"name\":\"rate\",\"type\":\"double\"},{\"name\":\"threshold\",\"type\":\"double\"}]}}],\"default\":null}]}],\"default\":null},{\"name\":\"reservedCash\",\"type\":[\"null\",\"io.test.trade.v1.common.Money\"],\"default\":null}]}],\"doc\":\"Stock Broking specific attributes such as settlement date and trade date.\",\"default\":null},{\"name\":\"commissionInstructions\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Instructions\",\"namespace\":\"io.test.trade.v1.common.commission\",\"fields\":[{\"name\":\"bypasses\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Bypasses\",\"fields\":[{\"name\":\"legacyCRPremium\",\"type\":\"boolean\",\"doc\":\"For guaranteed stops, should bypass reserving LR Premium fee\",\"default\":false},{\"name\":\"commission\",\"type\":\"boolean\",\"doc\":\"Should commission be bypassed\",\"default\":false},{\"name\":\"charges\",\"type\":\"boolean\",\"doc\":\"Should charges be bypassed\",\"default\":false},{\"name\":\"consideration\",\"type\":\"boolean\",\"doc\":\"Should consideration based fee be bypassed\",\"default\":false}]}],\"default\":null},{\"name\":\"overrideType\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"OverrideType\",\"doc\":\"AMOUNT: This type used when dealer wants to fixed Commission charge in Client's base curren", "cy. When the Amount value is Zero, no commission will be charged.\\n. WEB_RATES: This type is used when dealer wants the client's web rates to be used. Otherwise an input from IG Dealer will cause the phone rates to be used.\\nPERCENT: This type is used when dealer wants to supply the percentage rate to be used for commission calculation\",\"symbols\":[\"AMOUNT\",\"PERCENT\",\"WEB_RATES\"]}],\"default\":null},{\"name\":\"rate\",\"type\":[\"null\",\"double\"],\"default\":null},{\"name\":\"comment\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null}]}],\"doc\":\"instructions of which changes to bypass or override.\",\"default\":null},{\"name\":\"additionalLeg\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"AdditionalLeg\",\"namespace\":\"io.test.trade.v1.order.common\",\"fields\":[{\"name\":\"instrument\",\"type\":\"io.test.trade.v1.common.Instrument\"},{\"name\":\"marketCommodity\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"direction\",\"type\":\"io.test.trade.v1.common.Direction\"},{\"name\":\"averagePrice\",\"type\":[\"null\",\"io.test.trade.v1.common.Level\"],\"default\":null}]}],\"doc\":\"DMA orders on hedge accounts can optionally have an additional leg (instrument) to book the same order.\",\"default\":null},{\"name\":\"profileData\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"ProfileData\",\"fields\":[{\"name\":\"parentAccountId\",\"type\":\"io.test.trade.v1.common.account.Id\",\"doc\":\"For Profile orders this is the reference to the parent account.\"},{\"name\":\"parentOrderId\",\"type\":\"io.test.trade.v1.Id\",\"doc\":\"For profile orders this will be the parent order id.\"}]}],\"doc\":\"Profile orders where the order is processed on the parent account and booked against the child accounts.\",\"default\":null},{\"name\":\"lockState\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"State\",\"namespace\":\"io.test.trade.v1.common.lock\",\"fields\":[{\"name\":\"idOfLockingDMAOrder\",\"type\":\"io.test.trade.v1.Id\",\"doc\":\"Contains id of a DMA order that has locked this position, presumably for explicitly closing this position\"},{\"name\":\"holder\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"source\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"Source\",\"symbols\":[\"COM\",\"DMA\",\"STOP_MONITOR\"]}],\"default\":null},{\"name\":\"stopMonitorState\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"StopMonitorState\",\"symbols\":[\"COM\",\"DMA\",\"STOP_MONITOR\"]}],\"default\":null}]}],\"doc\":\"Indicates if the order is locked and they type of lock.\",\"default\":null},{\"name\":\"narrative\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Free text for reference. Not used in processing.\",\"default\":null}]}"});
    @Deprecated
    public Id orderId;
    @Deprecated
    public io.test.trade.v1.common.account.Id accountId;
    @Deprecated
    public Allocation allocation;
    @Deprecated
    public Instrument instrument;
    @Deprecated
    public Timestamps timestamps;
    @Deprecated
    public boolean isForceOpen;
    @Deprecated
    public Stop attachedStop;
    @Deprecated
    public Limit attachedLimit;
    @Deprecated
    public LegacyInfo legacyInfo;
    @Deprecated
    public Channel channel;
    @Deprecated
    public Expiry expiry;
    @Deprecated
    public io.test.trade.v1.common.account.Attributes accountAttributes;
    @Deprecated
    public Order dmaOrder;
    @Deprecated
    public List<Id> additionalIds;
    @Deprecated
    public Attributes stockBrokingAttributes;
    @Deprecated
    public Instructions commissionInstructions;
    @Deprecated
    public AdditionalLeg additionalLeg;
    @Deprecated
    public ProfileData profileData;
    @Deprecated
    public io.test.trade.v1.common.lock.State lockState;
    @Deprecated
    public String narrative;
    private static final DatumWriter WRITER$ = new SpecificDatumWriter(SCHEMA$);
    private static final DatumReader READER$ = new SpecificDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public State() {
    }

    public State(Id orderId, io.test.trade.v1.common.account.Id accountId, Allocation allocation, Instrument instrument, Timestamps timestamps, Boolean isForceOpen, Stop attachedStop, Limit attachedLimit, LegacyInfo legacyInfo, Channel channel, Expiry expiry, io.test.trade.v1.common.account.Attributes accountAttributes, Order dmaOrder, List<Id> additionalIds, Attributes stockBrokingAttributes, Instructions commissionInstructions, AdditionalLeg additionalLeg, ProfileData profileData, io.test.trade.v1.common.lock.State lockState, String narrative) {
        this.orderId = orderId;
        this.accountId = accountId;
        this.allocation = allocation;
        this.instrument = instrument;
        this.timestamps = timestamps;
        this.isForceOpen = isForceOpen;
        this.attachedStop = attachedStop;
        this.attachedLimit = attachedLimit;
        this.legacyInfo = legacyInfo;
        this.channel = channel;
        this.expiry = expiry;
        this.accountAttributes = accountAttributes;
        this.dmaOrder = dmaOrder;
        this.additionalIds = additionalIds;
        this.stockBrokingAttributes = stockBrokingAttributes;
        this.commissionInstructions = commissionInstructions;
        this.additionalLeg = additionalLeg;
        this.profileData = profileData;
        this.lockState = lockState;
        this.narrative = narrative;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.orderId;
            }
            case 1: {
                return this.accountId;
            }
            case 2: {
                return this.allocation;
            }
            case 3: {
                return this.instrument;
            }
            case 4: {
                return this.timestamps;
            }
            case 5: {
                return this.isForceOpen;
            }
            case 6: {
                return this.attachedStop;
            }
            case 7: {
                return this.attachedLimit;
            }
            case 8: {
                return this.legacyInfo;
            }
            case 9: {
                return this.channel;
            }
            case 10: {
                return this.expiry;
            }
            case 11: {
                return this.accountAttributes;
            }
            case 12: {
                return this.dmaOrder;
            }
            case 13: {
                return this.additionalIds;
            }
            case 14: {
                return this.stockBrokingAttributes;
            }
            case 15: {
                return this.commissionInstructions;
            }
            case 16: {
                return this.additionalLeg;
            }
            case 17: {
                return this.profileData;
            }
            case 18: {
                return this.lockState;
            }
            case 19: {
                return this.narrative;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.orderId = (Id)((Object)value$);
                break;
            }
            case 1: {
                this.accountId = (io.test.trade.v1.common.account.Id)((Object)value$);
                break;
            }
            case 2: {
                this.allocation = (Allocation)((Object)value$);
                break;
            }
            case 3: {
                this.instrument = (Instrument)((Object)value$);
                break;
            }
            case 4: {
                this.timestamps = (Timestamps)((Object)value$);
                break;
            }
            case 5: {
                this.isForceOpen = (Boolean)value$;
                break;
            }
            case 6: {
                this.attachedStop = (Stop)((Object)value$);
                break;
            }
            case 7: {
                this.attachedLimit = (Limit)((Object)value$);
                break;
            }
            case 8: {
                this.legacyInfo = (LegacyInfo)((Object)value$);
                break;
            }
            case 9: {
                this.channel = (Channel)((Object)value$);
                break;
            }
            case 10: {
                this.expiry = (Expiry)((Object)value$);
                break;
            }
            case 11: {
                this.accountAttributes = (io.test.trade.v1.common.account.Attributes)((Object)value$);
                break;
            }
            case 12: {
                this.dmaOrder = (Order)((Object)value$);
                break;
            }
            case 13: {
                this.additionalIds = (List)value$;
                break;
            }
            case 14: {
                this.stockBrokingAttributes = (Attributes)((Object)value$);
                break;
            }
            case 15: {
                this.commissionInstructions = (Instructions)((Object)value$);
                break;
            }
            case 16: {
                this.additionalLeg = (AdditionalLeg)((Object)value$);
                break;
            }
            case 17: {
                this.profileData = (ProfileData)((Object)value$);
                break;
            }
            case 18: {
                this.lockState = (io.test.trade.v1.common.lock.State)((Object)value$);
                break;
            }
            case 19: {
                this.narrative = (String)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public Id getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Id value) {
        this.orderId = value;
    }

    public io.test.trade.v1.common.account.Id getAccountId() {
        return this.accountId;
    }

    public void setAccountId(io.test.trade.v1.common.account.Id value) {
        this.accountId = value;
    }

    public Allocation getAllocation() {
        return this.allocation;
    }

    public void setAllocation(Allocation value) {
        this.allocation = value;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument value) {
        this.instrument = value;
    }

    public Timestamps getTimestamps() {
        return this.timestamps;
    }

    public void setTimestamps(Timestamps value) {
        this.timestamps = value;
    }

    public Boolean getIsForceOpen() {
        return this.isForceOpen;
    }

    public void setIsForceOpen(Boolean value) {
        this.isForceOpen = value;
    }

    public Stop getAttachedStop() {
        return this.attachedStop;
    }

    public void setAttachedStop(Stop value) {
        this.attachedStop = value;
    }

    public Limit getAttachedLimit() {
        return this.attachedLimit;
    }

    public void setAttachedLimit(Limit value) {
        this.attachedLimit = value;
    }

    public LegacyInfo getLegacyInfo() {
        return this.legacyInfo;
    }

    public void setLegacyInfo(LegacyInfo value) {
        this.legacyInfo = value;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel value) {
        this.channel = value;
    }

    public Expiry getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Expiry value) {
        this.expiry = value;
    }

    public io.test.trade.v1.common.account.Attributes getAccountAttributes() {
        return this.accountAttributes;
    }

    public void setAccountAttributes(io.test.trade.v1.common.account.Attributes value) {
        this.accountAttributes = value;
    }

    public Order getDmaOrder() {
        return this.dmaOrder;
    }

    public void setDmaOrder(Order value) {
        this.dmaOrder = value;
    }

    public List<Id> getAdditionalIds() {
        return this.additionalIds;
    }

    public void setAdditionalIds(List<Id> value) {
        this.additionalIds = value;
    }

    public Attributes getStockBrokingAttributes() {
        return this.stockBrokingAttributes;
    }

    public void setStockBrokingAttributes(Attributes value) {
        this.stockBrokingAttributes = value;
    }

    public Instructions getCommissionInstructions() {
        return this.commissionInstructions;
    }

    public void setCommissionInstructions(Instructions value) {
        this.commissionInstructions = value;
    }

    public AdditionalLeg getAdditionalLeg() {
        return this.additionalLeg;
    }

    public void setAdditionalLeg(AdditionalLeg value) {
        this.additionalLeg = value;
    }

    public ProfileData getProfileData() {
        return this.profileData;
    }

    public void setProfileData(ProfileData value) {
        this.profileData = value;
    }

    public io.test.trade.v1.common.lock.State getLockState() {
        return this.lockState;
    }

    public void setLockState(io.test.trade.v1.common.lock.State value) {
        this.lockState = value;
    }

    public String getNarrative() {
        return this.narrative;
    }

    public void setNarrative(String value) {
        this.narrative = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(State other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<State>
    implements RecordBuilder<State> {
        private Id orderId;
        private Id.Builder orderIdBuilder;
        private io.test.trade.v1.common.account.Id accountId;
        private Id.Builder accountIdBuilder;
        private Allocation allocation;
        private Allocation.Builder allocationBuilder;
        private Instrument instrument;
        private Instrument.Builder instrumentBuilder;
        private Timestamps timestamps;
        private Timestamps.Builder timestampsBuilder;
        private boolean isForceOpen;
        private Stop attachedStop;
        private Stop.Builder attachedStopBuilder;
        private Limit attachedLimit;
        private Limit.Builder attachedLimitBuilder;
        private LegacyInfo legacyInfo;
        private LegacyInfo.Builder legacyInfoBuilder;
        private Channel channel;
        private Channel.Builder channelBuilder;
        private Expiry expiry;
        private Expiry.Builder expiryBuilder;
        private io.test.trade.v1.common.account.Attributes accountAttributes;
        private Attributes.Builder accountAttributesBuilder;
        private Order dmaOrder;
        private Order.Builder dmaOrderBuilder;
        private List<Id> additionalIds;
        private Attributes stockBrokingAttributes;
        private Attributes.Builder stockBrokingAttributesBuilder;
        private Instructions commissionInstructions;
        private Instructions.Builder commissionInstructionsBuilder;
        private AdditionalLeg additionalLeg;
        private AdditionalLeg.Builder additionalLegBuilder;
        private ProfileData profileData;
        private ProfileData.Builder profileDataBuilder;
        private io.test.trade.v1.common.lock.State lockState;
        private State.Builder lockStateBuilder;
        private String narrative;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.orderId))) {
                this.orderId = (Id)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.orderId));
                this.fieldSetFlags()[0] = true;
            }
            if (other.hasOrderIdBuilder()) {
                this.orderIdBuilder = Id.newBuilder(other.getOrderIdBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.accountId))) {
                this.accountId = (io.test.trade.v1.common.account.Id)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.accountId));
                this.fieldSetFlags()[1] = true;
            }
            if (other.hasAccountIdBuilder()) {
                this.accountIdBuilder = io.test.trade.v1.common.account.Id.newBuilder(other.getAccountIdBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.allocation))) {
                this.allocation = (Allocation)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.allocation));
                this.fieldSetFlags()[2] = true;
            }
            if (other.hasAllocationBuilder()) {
                this.allocationBuilder = Allocation.newBuilder(other.getAllocationBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.instrument))) {
                this.instrument = (Instrument)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.instrument));
                this.fieldSetFlags()[3] = true;
            }
            if (other.hasInstrumentBuilder()) {
                this.instrumentBuilder = Instrument.newBuilder(other.getInstrumentBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.timestamps))) {
                this.timestamps = (Timestamps)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.timestamps));
                this.fieldSetFlags()[4] = true;
            }
            if (other.hasTimestampsBuilder()) {
                this.timestampsBuilder = Timestamps.newBuilder(other.getTimestampsBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.isForceOpen)) {
                this.isForceOpen = (Boolean)this.data().deepCopy(this.fields()[5].schema(), (Object)other.isForceOpen);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.attachedStop))) {
                this.attachedStop = (Stop)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.attachedStop));
                this.fieldSetFlags()[6] = true;
            }
            if (other.hasAttachedStopBuilder()) {
                this.attachedStopBuilder = Stop.newBuilder(other.getAttachedStopBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)((Object)other.attachedLimit))) {
                this.attachedLimit = (Limit)((Object)this.data().deepCopy(this.fields()[7].schema(), (Object)other.attachedLimit));
                this.fieldSetFlags()[7] = true;
            }
            if (other.hasAttachedLimitBuilder()) {
                this.attachedLimitBuilder = Limit.newBuilder(other.getAttachedLimitBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.legacyInfo))) {
                this.legacyInfo = (LegacyInfo)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.legacyInfo));
                this.fieldSetFlags()[8] = true;
            }
            if (other.hasLegacyInfoBuilder()) {
                this.legacyInfoBuilder = LegacyInfo.newBuilder(other.getLegacyInfoBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)((Object)other.channel))) {
                this.channel = (Channel)((Object)this.data().deepCopy(this.fields()[9].schema(), (Object)other.channel));
                this.fieldSetFlags()[9] = true;
            }
            if (other.hasChannelBuilder()) {
                this.channelBuilder = Channel.newBuilder(other.getChannelBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)((Object)other.expiry))) {
                this.expiry = (Expiry)((Object)this.data().deepCopy(this.fields()[10].schema(), (Object)other.expiry));
                this.fieldSetFlags()[10] = true;
            }
            if (other.hasExpiryBuilder()) {
                this.expiryBuilder = Expiry.newBuilder(other.getExpiryBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)((Object)other.accountAttributes))) {
                this.accountAttributes = (io.test.trade.v1.common.account.Attributes)((Object)this.data().deepCopy(this.fields()[11].schema(), (Object)other.accountAttributes));
                this.fieldSetFlags()[11] = true;
            }
            if (other.hasAccountAttributesBuilder()) {
                this.accountAttributesBuilder = io.test.trade.v1.common.account.Attributes.newBuilder(other.getAccountAttributesBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)((Object)other.dmaOrder))) {
                this.dmaOrder = (Order)((Object)this.data().deepCopy(this.fields()[12].schema(), (Object)other.dmaOrder));
                this.fieldSetFlags()[12] = true;
            }
            if (other.hasDmaOrderBuilder()) {
                this.dmaOrderBuilder = Order.newBuilder(other.getDmaOrderBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], other.additionalIds)) {
                this.additionalIds = (List)this.data().deepCopy(this.fields()[13].schema(), other.additionalIds);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)((Object)other.stockBrokingAttributes))) {
                this.stockBrokingAttributes = (Attributes)((Object)this.data().deepCopy(this.fields()[14].schema(), (Object)other.stockBrokingAttributes));
                this.fieldSetFlags()[14] = true;
            }
            if (other.hasStockBrokingAttributesBuilder()) {
                this.stockBrokingAttributesBuilder = Attributes.newBuilder(other.getStockBrokingAttributesBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)((Object)other.commissionInstructions))) {
                this.commissionInstructions = (Instructions)((Object)this.data().deepCopy(this.fields()[15].schema(), (Object)other.commissionInstructions));
                this.fieldSetFlags()[15] = true;
            }
            if (other.hasCommissionInstructionsBuilder()) {
                this.commissionInstructionsBuilder = Instructions.newBuilder(other.getCommissionInstructionsBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)((Object)other.additionalLeg))) {
                this.additionalLeg = (AdditionalLeg)((Object)this.data().deepCopy(this.fields()[16].schema(), (Object)other.additionalLeg));
                this.fieldSetFlags()[16] = true;
            }
            if (other.hasAdditionalLegBuilder()) {
                this.additionalLegBuilder = AdditionalLeg.newBuilder(other.getAdditionalLegBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)((Object)other.profileData))) {
                this.profileData = (ProfileData)((Object)this.data().deepCopy(this.fields()[17].schema(), (Object)other.profileData));
                this.fieldSetFlags()[17] = true;
            }
            if (other.hasProfileDataBuilder()) {
                this.profileDataBuilder = ProfileData.newBuilder(other.getProfileDataBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)((Object)other.lockState))) {
                this.lockState = (io.test.trade.v1.common.lock.State)((Object)this.data().deepCopy(this.fields()[18].schema(), (Object)other.lockState));
                this.fieldSetFlags()[18] = true;
            }
            if (other.hasLockStateBuilder()) {
                this.lockStateBuilder = io.test.trade.v1.common.lock.State.newBuilder(other.getLockStateBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.narrative)) {
                this.narrative = (String)this.data().deepCopy(this.fields()[19].schema(), (Object)other.narrative);
                this.fieldSetFlags()[19] = true;
            }
        }

        private Builder(State other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.orderId))) {
                this.orderId = (Id)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.orderId));
                this.fieldSetFlags()[0] = true;
            }
            this.orderIdBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.accountId))) {
                this.accountId = (io.test.trade.v1.common.account.Id)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.accountId));
                this.fieldSetFlags()[1] = true;
            }
            this.accountIdBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.allocation))) {
                this.allocation = (Allocation)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.allocation));
                this.fieldSetFlags()[2] = true;
            }
            this.allocationBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.instrument))) {
                this.instrument = (Instrument)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.instrument));
                this.fieldSetFlags()[3] = true;
            }
            this.instrumentBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.timestamps))) {
                this.timestamps = (Timestamps)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.timestamps));
                this.fieldSetFlags()[4] = true;
            }
            this.timestampsBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.isForceOpen)) {
                this.isForceOpen = (Boolean)this.data().deepCopy(this.fields()[5].schema(), (Object)other.isForceOpen);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.attachedStop))) {
                this.attachedStop = (Stop)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.attachedStop));
                this.fieldSetFlags()[6] = true;
            }
            this.attachedStopBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)((Object)other.attachedLimit))) {
                this.attachedLimit = (Limit)((Object)this.data().deepCopy(this.fields()[7].schema(), (Object)other.attachedLimit));
                this.fieldSetFlags()[7] = true;
            }
            this.attachedLimitBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.legacyInfo))) {
                this.legacyInfo = (LegacyInfo)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.legacyInfo));
                this.fieldSetFlags()[8] = true;
            }
            this.legacyInfoBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)((Object)other.channel))) {
                this.channel = (Channel)((Object)this.data().deepCopy(this.fields()[9].schema(), (Object)other.channel));
                this.fieldSetFlags()[9] = true;
            }
            this.channelBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)((Object)other.expiry))) {
                this.expiry = (Expiry)((Object)this.data().deepCopy(this.fields()[10].schema(), (Object)other.expiry));
                this.fieldSetFlags()[10] = true;
            }
            this.expiryBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)((Object)other.accountAttributes))) {
                this.accountAttributes = (io.test.trade.v1.common.account.Attributes)((Object)this.data().deepCopy(this.fields()[11].schema(), (Object)other.accountAttributes));
                this.fieldSetFlags()[11] = true;
            }
            this.accountAttributesBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)((Object)other.dmaOrder))) {
                this.dmaOrder = (Order)((Object)this.data().deepCopy(this.fields()[12].schema(), (Object)other.dmaOrder));
                this.fieldSetFlags()[12] = true;
            }
            this.dmaOrderBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[13], other.additionalIds)) {
                this.additionalIds = (List)this.data().deepCopy(this.fields()[13].schema(), other.additionalIds);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)((Object)other.stockBrokingAttributes))) {
                this.stockBrokingAttributes = (Attributes)((Object)this.data().deepCopy(this.fields()[14].schema(), (Object)other.stockBrokingAttributes));
                this.fieldSetFlags()[14] = true;
            }
            this.stockBrokingAttributesBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)((Object)other.commissionInstructions))) {
                this.commissionInstructions = (Instructions)((Object)this.data().deepCopy(this.fields()[15].schema(), (Object)other.commissionInstructions));
                this.fieldSetFlags()[15] = true;
            }
            this.commissionInstructionsBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)((Object)other.additionalLeg))) {
                this.additionalLeg = (AdditionalLeg)((Object)this.data().deepCopy(this.fields()[16].schema(), (Object)other.additionalLeg));
                this.fieldSetFlags()[16] = true;
            }
            this.additionalLegBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)((Object)other.profileData))) {
                this.profileData = (ProfileData)((Object)this.data().deepCopy(this.fields()[17].schema(), (Object)other.profileData));
                this.fieldSetFlags()[17] = true;
            }
            this.profileDataBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)((Object)other.lockState))) {
                this.lockState = (io.test.trade.v1.common.lock.State)((Object)this.data().deepCopy(this.fields()[18].schema(), (Object)other.lockState));
                this.fieldSetFlags()[18] = true;
            }
            this.lockStateBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.narrative)) {
                this.narrative = (String)this.data().deepCopy(this.fields()[19].schema(), (Object)other.narrative);
                this.fieldSetFlags()[19] = true;
            }
        }

        public Id getOrderId() {
            return this.orderId;
        }

        public Builder setOrderId(Id value) {
            this.validate(this.fields()[0], (Object)value);
            this.orderIdBuilder = null;
            this.orderId = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasOrderId() {
            return this.fieldSetFlags()[0];
        }

        public Id.Builder getOrderIdBuilder() {
            if (this.orderIdBuilder == null) {
                if (this.hasOrderId()) {
                    this.setOrderIdBuilder(Id.newBuilder(this.orderId));
                } else {
                    this.setOrderIdBuilder(Id.newBuilder());
                }
            }
            return this.orderIdBuilder;
        }

        public Builder setOrderIdBuilder(Id.Builder value) {
            this.clearOrderId();
            this.orderIdBuilder = value;
            return this;
        }

        public boolean hasOrderIdBuilder() {
            return this.orderIdBuilder != null;
        }

        public Builder clearOrderId() {
            this.orderId = null;
            this.orderIdBuilder = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public io.test.trade.v1.common.account.Id getAccountId() {
            return this.accountId;
        }

        public Builder setAccountId(io.test.trade.v1.common.account.Id value) {
            this.validate(this.fields()[1], (Object)value);
            this.accountIdBuilder = null;
            this.accountId = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasAccountId() {
            return this.fieldSetFlags()[1];
        }

        public Id.Builder getAccountIdBuilder() {
            if (this.accountIdBuilder == null) {
                if (this.hasAccountId()) {
                    this.setAccountIdBuilder(io.test.trade.v1.common.account.Id.newBuilder(this.accountId));
                } else {
                    this.setAccountIdBuilder(io.test.trade.v1.common.account.Id.newBuilder());
                }
            }
            return this.accountIdBuilder;
        }

        public Builder setAccountIdBuilder(Id.Builder value) {
            this.clearAccountId();
            this.accountIdBuilder = value;
            return this;
        }

        public boolean hasAccountIdBuilder() {
            return this.accountIdBuilder != null;
        }

        public Builder clearAccountId() {
            this.accountId = null;
            this.accountIdBuilder = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Allocation getAllocation() {
            return this.allocation;
        }

        public Builder setAllocation(Allocation value) {
            this.validate(this.fields()[2], (Object)value);
            this.allocationBuilder = null;
            this.allocation = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasAllocation() {
            return this.fieldSetFlags()[2];
        }

        public Allocation.Builder getAllocationBuilder() {
            if (this.allocationBuilder == null) {
                if (this.hasAllocation()) {
                    this.setAllocationBuilder(Allocation.newBuilder(this.allocation));
                } else {
                    this.setAllocationBuilder(Allocation.newBuilder());
                }
            }
            return this.allocationBuilder;
        }

        public Builder setAllocationBuilder(Allocation.Builder value) {
            this.clearAllocation();
            this.allocationBuilder = value;
            return this;
        }

        public boolean hasAllocationBuilder() {
            return this.allocationBuilder != null;
        }

        public Builder clearAllocation() {
            this.allocation = null;
            this.allocationBuilder = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Instrument getInstrument() {
            return this.instrument;
        }

        public Builder setInstrument(Instrument value) {
            this.validate(this.fields()[3], (Object)value);
            this.instrumentBuilder = null;
            this.instrument = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasInstrument() {
            return this.fieldSetFlags()[3];
        }

        public Instrument.Builder getInstrumentBuilder() {
            if (this.instrumentBuilder == null) {
                if (this.hasInstrument()) {
                    this.setInstrumentBuilder(Instrument.newBuilder(this.instrument));
                } else {
                    this.setInstrumentBuilder(Instrument.newBuilder());
                }
            }
            return this.instrumentBuilder;
        }

        public Builder setInstrumentBuilder(Instrument.Builder value) {
            this.clearInstrument();
            this.instrumentBuilder = value;
            return this;
        }

        public boolean hasInstrumentBuilder() {
            return this.instrumentBuilder != null;
        }

        public Builder clearInstrument() {
            this.instrument = null;
            this.instrumentBuilder = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Timestamps getTimestamps() {
            return this.timestamps;
        }

        public Builder setTimestamps(Timestamps value) {
            this.validate(this.fields()[4], (Object)value);
            this.timestampsBuilder = null;
            this.timestamps = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasTimestamps() {
            return this.fieldSetFlags()[4];
        }

        public Timestamps.Builder getTimestampsBuilder() {
            if (this.timestampsBuilder == null) {
                if (this.hasTimestamps()) {
                    this.setTimestampsBuilder(Timestamps.newBuilder(this.timestamps));
                } else {
                    this.setTimestampsBuilder(Timestamps.newBuilder());
                }
            }
            return this.timestampsBuilder;
        }

        public Builder setTimestampsBuilder(Timestamps.Builder value) {
            this.clearTimestamps();
            this.timestampsBuilder = value;
            return this;
        }

        public boolean hasTimestampsBuilder() {
            return this.timestampsBuilder != null;
        }

        public Builder clearTimestamps() {
            this.timestamps = null;
            this.timestampsBuilder = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Boolean getIsForceOpen() {
            return this.isForceOpen;
        }

        public Builder setIsForceOpen(boolean value) {
            this.validate(this.fields()[5], value);
            this.isForceOpen = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasIsForceOpen() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearIsForceOpen() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Stop getAttachedStop() {
            return this.attachedStop;
        }

        public Builder setAttachedStop(Stop value) {
            this.validate(this.fields()[6], (Object)value);
            this.attachedStopBuilder = null;
            this.attachedStop = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasAttachedStop() {
            return this.fieldSetFlags()[6];
        }

        public Stop.Builder getAttachedStopBuilder() {
            if (this.attachedStopBuilder == null) {
                if (this.hasAttachedStop()) {
                    this.setAttachedStopBuilder(Stop.newBuilder(this.attachedStop));
                } else {
                    this.setAttachedStopBuilder(Stop.newBuilder());
                }
            }
            return this.attachedStopBuilder;
        }

        public Builder setAttachedStopBuilder(Stop.Builder value) {
            this.clearAttachedStop();
            this.attachedStopBuilder = value;
            return this;
        }

        public boolean hasAttachedStopBuilder() {
            return this.attachedStopBuilder != null;
        }

        public Builder clearAttachedStop() {
            this.attachedStop = null;
            this.attachedStopBuilder = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Limit getAttachedLimit() {
            return this.attachedLimit;
        }

        public Builder setAttachedLimit(Limit value) {
            this.validate(this.fields()[7], (Object)value);
            this.attachedLimitBuilder = null;
            this.attachedLimit = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasAttachedLimit() {
            return this.fieldSetFlags()[7];
        }

        public Limit.Builder getAttachedLimitBuilder() {
            if (this.attachedLimitBuilder == null) {
                if (this.hasAttachedLimit()) {
                    this.setAttachedLimitBuilder(Limit.newBuilder(this.attachedLimit));
                } else {
                    this.setAttachedLimitBuilder(Limit.newBuilder());
                }
            }
            return this.attachedLimitBuilder;
        }

        public Builder setAttachedLimitBuilder(Limit.Builder value) {
            this.clearAttachedLimit();
            this.attachedLimitBuilder = value;
            return this;
        }

        public boolean hasAttachedLimitBuilder() {
            return this.attachedLimitBuilder != null;
        }

        public Builder clearAttachedLimit() {
            this.attachedLimit = null;
            this.attachedLimitBuilder = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public LegacyInfo getLegacyInfo() {
            return this.legacyInfo;
        }

        public Builder setLegacyInfo(LegacyInfo value) {
            this.validate(this.fields()[8], (Object)value);
            this.legacyInfoBuilder = null;
            this.legacyInfo = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasLegacyInfo() {
            return this.fieldSetFlags()[8];
        }

        public LegacyInfo.Builder getLegacyInfoBuilder() {
            if (this.legacyInfoBuilder == null) {
                if (this.hasLegacyInfo()) {
                    this.setLegacyInfoBuilder(LegacyInfo.newBuilder(this.legacyInfo));
                } else {
                    this.setLegacyInfoBuilder(LegacyInfo.newBuilder());
                }
            }
            return this.legacyInfoBuilder;
        }

        public Builder setLegacyInfoBuilder(LegacyInfo.Builder value) {
            this.clearLegacyInfo();
            this.legacyInfoBuilder = value;
            return this;
        }

        public boolean hasLegacyInfoBuilder() {
            return this.legacyInfoBuilder != null;
        }

        public Builder clearLegacyInfo() {
            this.legacyInfo = null;
            this.legacyInfoBuilder = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public Builder setChannel(Channel value) {
            this.validate(this.fields()[9], (Object)value);
            this.channelBuilder = null;
            this.channel = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasChannel() {
            return this.fieldSetFlags()[9];
        }

        public Channel.Builder getChannelBuilder() {
            if (this.channelBuilder == null) {
                if (this.hasChannel()) {
                    this.setChannelBuilder(Channel.newBuilder(this.channel));
                } else {
                    this.setChannelBuilder(Channel.newBuilder());
                }
            }
            return this.channelBuilder;
        }

        public Builder setChannelBuilder(Channel.Builder value) {
            this.clearChannel();
            this.channelBuilder = value;
            return this;
        }

        public boolean hasChannelBuilder() {
            return this.channelBuilder != null;
        }

        public Builder clearChannel() {
            this.channel = null;
            this.channelBuilder = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Expiry getExpiry() {
            return this.expiry;
        }

        public Builder setExpiry(Expiry value) {
            this.validate(this.fields()[10], (Object)value);
            this.expiryBuilder = null;
            this.expiry = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasExpiry() {
            return this.fieldSetFlags()[10];
        }

        public Expiry.Builder getExpiryBuilder() {
            if (this.expiryBuilder == null) {
                if (this.hasExpiry()) {
                    this.setExpiryBuilder(Expiry.newBuilder(this.expiry));
                } else {
                    this.setExpiryBuilder(Expiry.newBuilder());
                }
            }
            return this.expiryBuilder;
        }

        public Builder setExpiryBuilder(Expiry.Builder value) {
            this.clearExpiry();
            this.expiryBuilder = value;
            return this;
        }

        public boolean hasExpiryBuilder() {
            return this.expiryBuilder != null;
        }

        public Builder clearExpiry() {
            this.expiry = null;
            this.expiryBuilder = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public io.test.trade.v1.common.account.Attributes getAccountAttributes() {
            return this.accountAttributes;
        }

        public Builder setAccountAttributes(io.test.trade.v1.common.account.Attributes value) {
            this.validate(this.fields()[11], (Object)value);
            this.accountAttributesBuilder = null;
            this.accountAttributes = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasAccountAttributes() {
            return this.fieldSetFlags()[11];
        }

        public Attributes.Builder getAccountAttributesBuilder() {
            if (this.accountAttributesBuilder == null) {
                if (this.hasAccountAttributes()) {
                    this.setAccountAttributesBuilder(io.test.trade.v1.common.account.Attributes.newBuilder(this.accountAttributes));
                } else {
                    this.setAccountAttributesBuilder(io.test.trade.v1.common.account.Attributes.newBuilder());
                }
            }
            return this.accountAttributesBuilder;
        }

        public Builder setAccountAttributesBuilder(Attributes.Builder value) {
            this.clearAccountAttributes();
            this.accountAttributesBuilder = value;
            return this;
        }

        public boolean hasAccountAttributesBuilder() {
            return this.accountAttributesBuilder != null;
        }

        public Builder clearAccountAttributes() {
            this.accountAttributes = null;
            this.accountAttributesBuilder = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Order getDmaOrder() {
            return this.dmaOrder;
        }

        public Builder setDmaOrder(Order value) {
            this.validate(this.fields()[12], (Object)value);
            this.dmaOrderBuilder = null;
            this.dmaOrder = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasDmaOrder() {
            return this.fieldSetFlags()[12];
        }

        public Order.Builder getDmaOrderBuilder() {
            if (this.dmaOrderBuilder == null) {
                if (this.hasDmaOrder()) {
                    this.setDmaOrderBuilder(Order.newBuilder(this.dmaOrder));
                } else {
                    this.setDmaOrderBuilder(Order.newBuilder());
                }
            }
            return this.dmaOrderBuilder;
        }

        public Builder setDmaOrderBuilder(Order.Builder value) {
            this.clearDmaOrder();
            this.dmaOrderBuilder = value;
            return this;
        }

        public boolean hasDmaOrderBuilder() {
            return this.dmaOrderBuilder != null;
        }

        public Builder clearDmaOrder() {
            this.dmaOrder = null;
            this.dmaOrderBuilder = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public List<Id> getAdditionalIds() {
            return this.additionalIds;
        }

        public Builder setAdditionalIds(List<Id> value) {
            this.validate(this.fields()[13], value);
            this.additionalIds = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasAdditionalIds() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearAdditionalIds() {
            this.additionalIds = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Attributes getStockBrokingAttributes() {
            return this.stockBrokingAttributes;
        }

        public Builder setStockBrokingAttributes(Attributes value) {
            this.validate(this.fields()[14], (Object)value);
            this.stockBrokingAttributesBuilder = null;
            this.stockBrokingAttributes = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasStockBrokingAttributes() {
            return this.fieldSetFlags()[14];
        }

        public Attributes.Builder getStockBrokingAttributesBuilder() {
            if (this.stockBrokingAttributesBuilder == null) {
                if (this.hasStockBrokingAttributes()) {
                    this.setStockBrokingAttributesBuilder(Attributes.newBuilder(this.stockBrokingAttributes));
                } else {
                    this.setStockBrokingAttributesBuilder(Attributes.newBuilder());
                }
            }
            return this.stockBrokingAttributesBuilder;
        }

        public Builder setStockBrokingAttributesBuilder(Attributes.Builder value) {
            this.clearStockBrokingAttributes();
            this.stockBrokingAttributesBuilder = value;
            return this;
        }

        public boolean hasStockBrokingAttributesBuilder() {
            return this.stockBrokingAttributesBuilder != null;
        }

        public Builder clearStockBrokingAttributes() {
            this.stockBrokingAttributes = null;
            this.stockBrokingAttributesBuilder = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Instructions getCommissionInstructions() {
            return this.commissionInstructions;
        }

        public Builder setCommissionInstructions(Instructions value) {
            this.validate(this.fields()[15], (Object)value);
            this.commissionInstructionsBuilder = null;
            this.commissionInstructions = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasCommissionInstructions() {
            return this.fieldSetFlags()[15];
        }

        public Instructions.Builder getCommissionInstructionsBuilder() {
            if (this.commissionInstructionsBuilder == null) {
                if (this.hasCommissionInstructions()) {
                    this.setCommissionInstructionsBuilder(Instructions.newBuilder(this.commissionInstructions));
                } else {
                    this.setCommissionInstructionsBuilder(Instructions.newBuilder());
                }
            }
            return this.commissionInstructionsBuilder;
        }

        public Builder setCommissionInstructionsBuilder(Instructions.Builder value) {
            this.clearCommissionInstructions();
            this.commissionInstructionsBuilder = value;
            return this;
        }

        public boolean hasCommissionInstructionsBuilder() {
            return this.commissionInstructionsBuilder != null;
        }

        public Builder clearCommissionInstructions() {
            this.commissionInstructions = null;
            this.commissionInstructionsBuilder = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public AdditionalLeg getAdditionalLeg() {
            return this.additionalLeg;
        }

        public Builder setAdditionalLeg(AdditionalLeg value) {
            this.validate(this.fields()[16], (Object)value);
            this.additionalLegBuilder = null;
            this.additionalLeg = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasAdditionalLeg() {
            return this.fieldSetFlags()[16];
        }

        public AdditionalLeg.Builder getAdditionalLegBuilder() {
            if (this.additionalLegBuilder == null) {
                if (this.hasAdditionalLeg()) {
                    this.setAdditionalLegBuilder(AdditionalLeg.newBuilder(this.additionalLeg));
                } else {
                    this.setAdditionalLegBuilder(AdditionalLeg.newBuilder());
                }
            }
            return this.additionalLegBuilder;
        }

        public Builder setAdditionalLegBuilder(AdditionalLeg.Builder value) {
            this.clearAdditionalLeg();
            this.additionalLegBuilder = value;
            return this;
        }

        public boolean hasAdditionalLegBuilder() {
            return this.additionalLegBuilder != null;
        }

        public Builder clearAdditionalLeg() {
            this.additionalLeg = null;
            this.additionalLegBuilder = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public ProfileData getProfileData() {
            return this.profileData;
        }

        public Builder setProfileData(ProfileData value) {
            this.validate(this.fields()[17], (Object)value);
            this.profileDataBuilder = null;
            this.profileData = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasProfileData() {
            return this.fieldSetFlags()[17];
        }

        public ProfileData.Builder getProfileDataBuilder() {
            if (this.profileDataBuilder == null) {
                if (this.hasProfileData()) {
                    this.setProfileDataBuilder(ProfileData.newBuilder(this.profileData));
                } else {
                    this.setProfileDataBuilder(ProfileData.newBuilder());
                }
            }
            return this.profileDataBuilder;
        }

        public Builder setProfileDataBuilder(ProfileData.Builder value) {
            this.clearProfileData();
            this.profileDataBuilder = value;
            return this;
        }

        public boolean hasProfileDataBuilder() {
            return this.profileDataBuilder != null;
        }

        public Builder clearProfileData() {
            this.profileData = null;
            this.profileDataBuilder = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public io.test.trade.v1.common.lock.State getLockState() {
            return this.lockState;
        }

        public Builder setLockState(io.test.trade.v1.common.lock.State value) {
            this.validate(this.fields()[18], (Object)value);
            this.lockStateBuilder = null;
            this.lockState = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasLockState() {
            return this.fieldSetFlags()[18];
        }

        public State.Builder getLockStateBuilder() {
            if (this.lockStateBuilder == null) {
                if (this.hasLockState()) {
                    this.setLockStateBuilder(io.test.trade.v1.common.lock.State.newBuilder(this.lockState));
                } else {
                    this.setLockStateBuilder(io.test.trade.v1.common.lock.State.newBuilder());
                }
            }
            return this.lockStateBuilder;
        }

        public Builder setLockStateBuilder(State.Builder value) {
            this.clearLockState();
            this.lockStateBuilder = value;
            return this;
        }

        public boolean hasLockStateBuilder() {
            return this.lockStateBuilder != null;
        }

        public Builder clearLockState() {
            this.lockState = null;
            this.lockStateBuilder = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public String getNarrative() {
            return this.narrative;
        }

        public Builder setNarrative(String value) {
            this.validate(this.fields()[19], value);
            this.narrative = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasNarrative() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearNarrative() {
            this.narrative = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public State build() {
            try {
                State record = new State();
                if (this.orderIdBuilder != null) {
                    record.orderId = this.orderIdBuilder.build();
                } else {
                    Id id = record.orderId = this.fieldSetFlags()[0] ? this.orderId : (Id)((Object)this.defaultValue(this.fields()[0]));
                }
                if (this.accountIdBuilder != null) {
                    record.accountId = this.accountIdBuilder.build();
                } else {
                    io.test.trade.v1.common.account.Id id = record.accountId = this.fieldSetFlags()[1] ? this.accountId : (io.test.trade.v1.common.account.Id)((Object)this.defaultValue(this.fields()[1]));
                }
                if (this.allocationBuilder != null) {
                    record.allocation = this.allocationBuilder.build();
                } else {
                    Allocation allocation = record.allocation = this.fieldSetFlags()[2] ? this.allocation : (Allocation)((Object)this.defaultValue(this.fields()[2]));
                }
                if (this.instrumentBuilder != null) {
                    record.instrument = this.instrumentBuilder.build();
                } else {
                    Instrument instrument = record.instrument = this.fieldSetFlags()[3] ? this.instrument : (Instrument)((Object)this.defaultValue(this.fields()[3]));
                }
                record.timestamps = this.timestampsBuilder != null ? this.timestampsBuilder.build() : (this.fieldSetFlags()[4] ? this.timestamps : (Timestamps)((Object)this.defaultValue(this.fields()[4])));
                boolean bl = record.isForceOpen = this.fieldSetFlags()[5] ? this.isForceOpen : (Boolean)this.defaultValue(this.fields()[5]);
                if (this.attachedStopBuilder != null) {
                    record.attachedStop = this.attachedStopBuilder.build();
                } else {
                    Stop stop = record.attachedStop = this.fieldSetFlags()[6] ? this.attachedStop : (Stop)((Object)this.defaultValue(this.fields()[6]));
                }
                if (this.attachedLimitBuilder != null) {
                    record.attachedLimit = this.attachedLimitBuilder.build();
                } else {
                    Limit limit = record.attachedLimit = this.fieldSetFlags()[7] ? this.attachedLimit : (Limit)((Object)this.defaultValue(this.fields()[7]));
                }
                if (this.legacyInfoBuilder != null) {
                    record.legacyInfo = this.legacyInfoBuilder.build();
                } else {
                    LegacyInfo legacyInfo = record.legacyInfo = this.fieldSetFlags()[8] ? this.legacyInfo : (LegacyInfo)((Object)this.defaultValue(this.fields()[8]));
                }
                if (this.channelBuilder != null) {
                    record.channel = this.channelBuilder.build();
                } else {
                    Channel channel = record.channel = this.fieldSetFlags()[9] ? this.channel : (Channel)((Object)this.defaultValue(this.fields()[9]));
                }
                if (this.expiryBuilder != null) {
                    record.expiry = this.expiryBuilder.build();
                } else {
                    Expiry expiry = record.expiry = this.fieldSetFlags()[10] ? this.expiry : (Expiry)((Object)this.defaultValue(this.fields()[10]));
                }
                if (this.accountAttributesBuilder != null) {
                    record.accountAttributes = this.accountAttributesBuilder.build();
                } else {
                    io.test.trade.v1.common.account.Attributes attributes = record.accountAttributes = this.fieldSetFlags()[11] ? this.accountAttributes : (io.test.trade.v1.common.account.Attributes)((Object)this.defaultValue(this.fields()[11]));
                }
                record.dmaOrder = this.dmaOrderBuilder != null ? this.dmaOrderBuilder.build() : (this.fieldSetFlags()[12] ? this.dmaOrder : (Order)((Object)this.defaultValue(this.fields()[12])));
                List<Id> list = record.additionalIds = this.fieldSetFlags()[13] ? this.additionalIds : (List<Id>)this.defaultValue(this.fields()[13]);
                if (this.stockBrokingAttributesBuilder != null) {
                    record.stockBrokingAttributes = this.stockBrokingAttributesBuilder.build();
                } else {
                    Attributes attributes = record.stockBrokingAttributes = this.fieldSetFlags()[14] ? this.stockBrokingAttributes : (Attributes)((Object)this.defaultValue(this.fields()[14]));
                }
                if (this.commissionInstructionsBuilder != null) {
                    record.commissionInstructions = this.commissionInstructionsBuilder.build();
                } else {
                    Instructions instructions = record.commissionInstructions = this.fieldSetFlags()[15] ? this.commissionInstructions : (Instructions)((Object)this.defaultValue(this.fields()[15]));
                }
                if (this.additionalLegBuilder != null) {
                    record.additionalLeg = this.additionalLegBuilder.build();
                } else {
                    AdditionalLeg additionalLeg = record.additionalLeg = this.fieldSetFlags()[16] ? this.additionalLeg : (AdditionalLeg)((Object)this.defaultValue(this.fields()[16]));
                }
                if (this.profileDataBuilder != null) {
                    record.profileData = this.profileDataBuilder.build();
                } else {
                    ProfileData profileData = record.profileData = this.fieldSetFlags()[17] ? this.profileData : (ProfileData)((Object)this.defaultValue(this.fields()[17]));
                }
                record.lockState = this.lockStateBuilder != null ? this.lockStateBuilder.build() : (this.fieldSetFlags()[18] ? this.lockState : (io.test.trade.v1.common.lock.State)((Object)this.defaultValue(this.fields()[18])));
                record.narrative = this.fieldSetFlags()[19] ? this.narrative : (String)this.defaultValue(this.fields()[19]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

