/*
 * Decompiled with CFR 0.152.
 */
package io.test.trade.v1.common;

import io.test.trade.v1.common.Direction;
import io.test.trade.v1.common.DisplaySizeUnit;
import io.test.trade.v1.common.ISOCurrency;
import io.test.trade.v1.common.Size;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class Allocation
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -5418740296810575511L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Allocation\",\"namespace\":\"io.test.trade.v1.common\",\"fields\":[{\"name\":\"direction\",\"type\":{\"type\":\"enum\",\"name\":\"Direction\",\"symbols\":[\"BUY\",\"SELL\"]}},{\"name\":\"size\",\"type\":{\"type\":\"record\",\"name\":\"Size\",\"fields\":[{\"name\":\"value\",\"type\":\"double\"}]}},{\"name\":\"displaySize\",\"type\":\"Size\",\"doc\":\"Size used for presentation and external reporting purposes. Note: Margining, Profit/Loss calculation, exposure, etc., should multiply this size with lotSize for calculations.\"},{\"name\":\"displaySizeUnit\",\"type\":{\"type\":\"enum\",\"name\":\"DisplaySizeUnit\",\"symbols\":[\"SHARES\",\"CONTRACTS\",\"AMOUNT_PER_POINTS\"]},\"doc\":\"Define how the displaySize is expressed.\"},{\"name\":\"lotSize\",\"type\":\"double\",\"doc\":\"Defined on the instrument. Clients on spread-bet accounts use lot size of 1, while CFD and StockBroking clients use lot size configured on the instrument. Dealers can book orders on any client account with a lot size of 1. Hedge accounts have different rules - they are generally booked in lots with lotSize 1, except equities (and equity options)\"},{\"name\":\"currency\",\"type\":{\"type\":\"record\",\"name\":\"ISOCurrency\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]},\"doc\":\"Currency of the order/position\"}]}");
    @Deprecated
    public Direction direction;
    @Deprecated
    public Size size;
    @Deprecated
    public Size displaySize;
    @Deprecated
    public DisplaySizeUnit displaySizeUnit;
    @Deprecated
    public double lotSize;
    @Deprecated
    public ISOCurrency currency;
    private static final DatumWriter WRITER$ = new SpecificDatumWriter(SCHEMA$);
    private static final DatumReader READER$ = new SpecificDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public Allocation() {
    }

    public Allocation(Direction direction, Size size, Size displaySize, DisplaySizeUnit displaySizeUnit, Double lotSize, ISOCurrency currency) {
        this.direction = direction;
        this.size = size;
        this.displaySize = displaySize;
        this.displaySizeUnit = displaySizeUnit;
        this.lotSize = lotSize;
        this.currency = currency;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.direction;
            }
            case 1: {
                return this.size;
            }
            case 2: {
                return this.displaySize;
            }
            case 3: {
                return this.displaySizeUnit;
            }
            case 4: {
                return this.lotSize;
            }
            case 5: {
                return this.currency;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.direction = (Direction)((Object)value$);
                break;
            }
            case 1: {
                this.size = (Size)((Object)value$);
                break;
            }
            case 2: {
                this.displaySize = (Size)((Object)value$);
                break;
            }
            case 3: {
                this.displaySizeUnit = (DisplaySizeUnit)((Object)value$);
                break;
            }
            case 4: {
                this.lotSize = (Double)value$;
                break;
            }
            case 5: {
                this.currency = (ISOCurrency)((Object)value$);
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction value) {
        this.direction = value;
    }

    public Size getSize() {
        return this.size;
    }

    public void setSize(Size value) {
        this.size = value;
    }

    public Size getDisplaySize() {
        return this.displaySize;
    }

    public void setDisplaySize(Size value) {
        this.displaySize = value;
    }

    public DisplaySizeUnit getDisplaySizeUnit() {
        return this.displaySizeUnit;
    }

    public void setDisplaySizeUnit(DisplaySizeUnit value) {
        this.displaySizeUnit = value;
    }

    public Double getLotSize() {
        return this.lotSize;
    }

    public void setLotSize(Double value) {
        this.lotSize = value;
    }

    public ISOCurrency getCurrency() {
        return this.currency;
    }

    public void setCurrency(ISOCurrency value) {
        this.currency = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Allocation other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<Allocation>
    implements RecordBuilder<Allocation> {
        private Direction direction;
        private Size size;
        private Size.Builder sizeBuilder;
        private Size displaySize;
        private Size.Builder displaySizeBuilder;
        private DisplaySizeUnit displaySizeUnit;
        private double lotSize;
        private ISOCurrency currency;
        private ISOCurrency.Builder currencyBuilder;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.direction))) {
                this.direction = (Direction)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.direction));
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.size))) {
                this.size = (Size)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.size));
                this.fieldSetFlags()[1] = true;
            }
            if (other.hasSizeBuilder()) {
                this.sizeBuilder = Size.newBuilder(other.getSizeBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.displaySize))) {
                this.displaySize = (Size)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.displaySize));
                this.fieldSetFlags()[2] = true;
            }
            if (other.hasDisplaySizeBuilder()) {
                this.displaySizeBuilder = Size.newBuilder(other.getDisplaySizeBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.displaySizeUnit))) {
                this.displaySizeUnit = (DisplaySizeUnit)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.displaySizeUnit));
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.lotSize)) {
                this.lotSize = (Double)this.data().deepCopy(this.fields()[4].schema(), (Object)other.lotSize);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.currency))) {
                this.currency = (ISOCurrency)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.currency));
                this.fieldSetFlags()[5] = true;
            }
            if (other.hasCurrencyBuilder()) {
                this.currencyBuilder = ISOCurrency.newBuilder(other.getCurrencyBuilder());
            }
        }

        private Builder(Allocation other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.direction))) {
                this.direction = (Direction)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.direction));
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.size))) {
                this.size = (Size)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.size));
                this.fieldSetFlags()[1] = true;
            }
            this.sizeBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.displaySize))) {
                this.displaySize = (Size)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.displaySize));
                this.fieldSetFlags()[2] = true;
            }
            this.displaySizeBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.displaySizeUnit))) {
                this.displaySizeUnit = (DisplaySizeUnit)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.displaySizeUnit));
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.lotSize)) {
                this.lotSize = (Double)this.data().deepCopy(this.fields()[4].schema(), (Object)other.lotSize);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.currency))) {
                this.currency = (ISOCurrency)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.currency));
                this.fieldSetFlags()[5] = true;
            }
            this.currencyBuilder = null;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public Builder setDirection(Direction value) {
            this.validate(this.fields()[0], (Object)value);
            this.direction = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasDirection() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearDirection() {
            this.direction = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Size getSize() {
            return this.size;
        }

        public Builder setSize(Size value) {
            this.validate(this.fields()[1], (Object)value);
            this.sizeBuilder = null;
            this.size = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasSize() {
            return this.fieldSetFlags()[1];
        }

        public Size.Builder getSizeBuilder() {
            if (this.sizeBuilder == null) {
                if (this.hasSize()) {
                    this.setSizeBuilder(Size.newBuilder(this.size));
                } else {
                    this.setSizeBuilder(Size.newBuilder());
                }
            }
            return this.sizeBuilder;
        }

        public Builder setSizeBuilder(Size.Builder value) {
            this.clearSize();
            this.sizeBuilder = value;
            return this;
        }

        public boolean hasSizeBuilder() {
            return this.sizeBuilder != null;
        }

        public Builder clearSize() {
            this.size = null;
            this.sizeBuilder = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Size getDisplaySize() {
            return this.displaySize;
        }

        public Builder setDisplaySize(Size value) {
            this.validate(this.fields()[2], (Object)value);
            this.displaySizeBuilder = null;
            this.displaySize = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasDisplaySize() {
            return this.fieldSetFlags()[2];
        }

        public Size.Builder getDisplaySizeBuilder() {
            if (this.displaySizeBuilder == null) {
                if (this.hasDisplaySize()) {
                    this.setDisplaySizeBuilder(Size.newBuilder(this.displaySize));
                } else {
                    this.setDisplaySizeBuilder(Size.newBuilder());
                }
            }
            return this.displaySizeBuilder;
        }

        public Builder setDisplaySizeBuilder(Size.Builder value) {
            this.clearDisplaySize();
            this.displaySizeBuilder = value;
            return this;
        }

        public boolean hasDisplaySizeBuilder() {
            return this.displaySizeBuilder != null;
        }

        public Builder clearDisplaySize() {
            this.displaySize = null;
            this.displaySizeBuilder = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public DisplaySizeUnit getDisplaySizeUnit() {
            return this.displaySizeUnit;
        }

        public Builder setDisplaySizeUnit(DisplaySizeUnit value) {
            this.validate(this.fields()[3], (Object)value);
            this.displaySizeUnit = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasDisplaySizeUnit() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearDisplaySizeUnit() {
            this.displaySizeUnit = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Double getLotSize() {
            return this.lotSize;
        }

        public Builder setLotSize(double value) {
            this.validate(this.fields()[4], value);
            this.lotSize = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasLotSize() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearLotSize() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public ISOCurrency getCurrency() {
            return this.currency;
        }

        public Builder setCurrency(ISOCurrency value) {
            this.validate(this.fields()[5], (Object)value);
            this.currencyBuilder = null;
            this.currency = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasCurrency() {
            return this.fieldSetFlags()[5];
        }

        public ISOCurrency.Builder getCurrencyBuilder() {
            if (this.currencyBuilder == null) {
                if (this.hasCurrency()) {
                    this.setCurrencyBuilder(ISOCurrency.newBuilder(this.currency));
                } else {
                    this.setCurrencyBuilder(ISOCurrency.newBuilder());
                }
            }
            return this.currencyBuilder;
        }

        public Builder setCurrencyBuilder(ISOCurrency.Builder value) {
            this.clearCurrency();
            this.currencyBuilder = value;
            return this;
        }

        public boolean hasCurrencyBuilder() {
            return this.currencyBuilder != null;
        }

        public Builder clearCurrency() {
            this.currency = null;
            this.currencyBuilder = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Allocation build() {
            try {
                Allocation record = new Allocation();
                Direction direction = record.direction = this.fieldSetFlags()[0] ? this.direction : (Direction)((Object)this.defaultValue(this.fields()[0]));
                if (this.sizeBuilder != null) {
                    record.size = this.sizeBuilder.build();
                } else {
                    Size size = record.size = this.fieldSetFlags()[1] ? this.size : (Size)((Object)this.defaultValue(this.fields()[1]));
                }
                record.displaySize = this.displaySizeBuilder != null ? this.displaySizeBuilder.build() : (this.fieldSetFlags()[2] ? this.displaySize : (Size)((Object)this.defaultValue(this.fields()[2])));
                record.displaySizeUnit = this.fieldSetFlags()[3] ? this.displaySizeUnit : (DisplaySizeUnit)((Object)this.defaultValue(this.fields()[3]));
                double d = record.lotSize = this.fieldSetFlags()[4] ? this.lotSize : (Double)this.defaultValue(this.fields()[4]);
                record.currency = this.currencyBuilder != null ? this.currencyBuilder.build() : (this.fieldSetFlags()[5] ? this.currency : (ISOCurrency)((Object)this.defaultValue(this.fields()[5])));
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

